/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.helper.SalesPointHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.Objects;
import java.util.Optional;

public class StandardSalesContextHandler
extends SalesContextHandler {
    @Override
    public EntityReference<Organization> getAgency(SalesContext salesContext) {
        return salesContext.getAgency();
    }

    @Override
    public EntityReference<Organization> getClient(SalesContext salesContext) {
        return salesContext.getClient();
    }

    @Override
    public EntityReference<Organization> getAllClients() {
        return ProfileDao.findAllClientsProfile();
    }

    @Override
    public RuleSet getRules(SalesContext salesContext) throws Exception {
        SalesPoint salesPoint = Optional.of(salesContext).map(SalesContext::getSalesPoint).map(EntityStorageHelper::resolve).map(EntityContainer::getEntity).orElseThrow(() -> new Exception("can't resolve reference to sales point " + salesContext.getSalesPoint()));
        return SalesPointHelper.getRules(salesPoint);
    }

    @Override
    public void enforceSalesContext(SalesContext ctx, Reservation reservation) {
        if (reservation.getBookingAgent() == null) {
            reservation.setBookingAgent(ctx.getAgent());
        }
        if (reservation.getSalesPoint() == null) {
            reservation.setSalesPoint(ctx.getSalesPoint());
        }
        if (reservation.getSubagency() == null) {
            reservation.setSubagency(ctx.getSubagency());
            if (reservation.getSubagency() == null) {
                if (ctx.getAgency() != null) {
                    reservation.setSubagency(ctx.getAgency());
                } else if (ctx.getSalesPoint() != null) {
                    try {
                        EntityContainer spCtr = EntityStorage.get().resolve(ctx.getSalesPoint());
                        if (spCtr != null) {
                            reservation.setSubagency(((SalesPoint)spCtr.getEntity()).getAgency());
                        }
                    }
                    catch (Exception e) {
                        this.log.error("failed loading agency", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public SalesContext createSalesContext(Reservation reservation) {
        SalesContext salesContext = new SalesContext();
        salesContext.setSubagency(reservation.getSubagency());
        salesContext.setAgent(reservation.getBookingAgent());
        salesContext.setSalesPoint(reservation.getSalesPoint());
        BookingFile bookingFile = reservation.getBookingFile();
        if (Objects.isNull(bookingFile)) {
            return salesContext;
        }
        salesContext.setAgency(bookingFile.getAgency());
        salesContext.setClient(bookingFile.getCustomerProfile());
        Customer customer = bookingFile.getCustomer();
        if (Objects.nonNull(customer)) {
            salesContext.setCustomer(customer.getProfile());
        }
        return salesContext;
    }

    @Override
    public EntityReference<Organization> getOnlineAgency(SalesPoint salesPoint) {
        EntityReference result = null;
        result = salesPoint.getOnlineAgency();
        if (result != null) {
            return result;
        }
        result = salesPoint.getAgency();
        return result;
    }
}

