/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.rules;

import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SalesContextProperties
implements SalesContextPropertiesProvider {
    private final String agencyCode;
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private final Set<String> profileGroups = new HashSet<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();

    public SalesContextProperties(BookingFile booking) {
        this.agencyCode = RulesHelper.getOrganizationCode((EntityReference)booking.getAgency());
        booking.getReservations().forEach(res -> RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)res.getSubagency()));
        this.client = booking.getCustomerProfile();
        this.agent = booking.getReservations().stream().map(Reservation::getBookingAgent).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SalesContextProperties(SalesContext salesContext) {
        this.agent = salesContext.getAgent();
        this.client = salesContext.getClient();
        this.agencyCode = CommonHelper.getAgencyCode(salesContext);
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)salesContext.getSubagency());
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }
}

