/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public class ReferenceList<E extends BaseEntity, I extends EntityIndex<E>>
extends AbstractList<EntityReference<E>> {
    private final List<I> idxs;
    private final List<EntityContainer<E>> ctrs;

    private ReferenceList(List<I> idxs, List<EntityContainer<E>> ctrs) {
        if (idxs == null && ctrs == null) {
            this.idxs = Collections.emptyList();
            this.ctrs = Collections.emptyList();
        } else {
            this.idxs = idxs;
            this.ctrs = ctrs;
        }
    }

    @Override
    public EntityReference<E> get(int index) {
        if (this.idxs != null) {
            EntityIndex idx = (EntityIndex)this.idxs.get(index);
            return idx == null ? null : idx.getSource();
        }
        EntityContainer<E> ctr = this.ctrs.get(index);
        return ctr == null ? null : ctr.toReference();
    }

    @Override
    public int size() {
        return this.idxs != null ? this.idxs.size() : this.ctrs.size();
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> ReferenceList<E, I> fromIdxs(List<I> idxs) {
        return new ReferenceList<E, I>(idxs, null);
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> ReferenceList<E, I> fromCtrs(List<EntityContainer<E>> ctrs) {
        return new ReferenceList<E, I>(null, ctrs);
    }
}

