/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.insurance;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public final class InsuranceAccidentHelper {
    public static String getLocalizedRouteLine(InsuranceAccident product) {
        return InsuranceAccidentHelper.getRouteLine(product, LocaleManager.get().getCurrentLocale(), false, CodeSystem.IATA);
    }

    public static String getRouteLine(InsuranceAccident product) {
        return InsuranceAccidentHelper.getRouteLine(product, null, true, CodeSystem.IATA);
    }

    public static String getRouteLine(InsuranceAccident product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        if (product.getDepartureLocationName() != null && product.getArrivalLocationName() != null) {
            return String.format("%s - %s", product.getDepartureLocationName(), product.getArrivalLocationName());
        }
        return "";
    }

    public static void removeProduct(InsuranceAccident product, boolean removeEmptyReservations) {
        for (Reservation res : new ArrayList(product.getReservation().getBookingFile().getReservations())) {
            if (res.getProducts().contains(product)) {
                res.getProducts().remove(product);
            }
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof InsuranceAccident)) continue;
                InsuranceAccident prod = (InsuranceAccident)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            product.getReservation().getBookingFile().getReservations().remove(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InsuranceAccident createRefundProduct(InsuranceAccident model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            InsuranceAccident refund = (InsuranceAccident)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setPreviousProduct(model);
            model.setNextProduct(refund);
            refund.setCancellationDetails(null);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            refund.getShipments().clear();
            refund.getPrepaymentDocuments().clear();
            refund.getFopDetalizations().clear();
            InsuranceAccident insuranceAccident = refund;
            return insuranceAccident;
        }
        finally {
            model.setReservation(res);
        }
    }

    public static BigDecimal getEquivalentFeeAmount(InsuranceAccident prod) {
        BigDecimal fe = BigDecimal.ZERO;
        for (GeneralProductCommission c : InsuranceAccidentHelper.getUnmodifiableCommissions(prod, null)) {
            BigDecimal value;
            if (c.getCommissionProperties() == null || !FeeProperties.class.getName().equals(c.getCommissionProperties().getType().getName()) || (value = c.getEquivalentAmount()) == null) continue;
            fe = fe.add(value);
        }
        return fe;
    }

    public static InsuranceAccident clone(InsuranceAccident product) throws Exception {
        return InsuranceAccidentHelper.clone(product, true);
    }

    public static InsuranceAccident clone(InsuranceAccident product, boolean keepReservation) throws Exception {
        InsuranceAccident newProduct = new InsuranceAccident();
        InsuranceAccidentHelper.copy(product, newProduct, keepReservation);
        return newProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InsuranceAccident source, InsuranceAccident target, boolean keepReservation) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        InsuranceAccident sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        InsuranceAccident sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        InsuranceAccident targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        InsuranceAccident targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            if (keepReservation && source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
                source.getReservation().getProducts().add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InsuranceAccident source, InsuranceAccident target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        InsuranceAccident sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        InsuranceAccident sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        InsuranceAccident targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        InsuranceAccident targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static SalesChain getSalesChain(InsuranceAccident product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(InsuranceAccident item) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)item);
    }

    public static GeneralProductContractRelationData getClientContractRelation(InsuranceAccident prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(InsuranceAccident product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(InsuranceAccident prod) {
        return GeneralProductHelper.getContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(InsuranceAccident prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(InsuranceAccident prod) {
        return GeneralProductHelper.getContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(InsuranceAccident prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(InsuranceAccident prod) {
        return GeneralProductHelper.getContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(InsuranceAccident prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(InsuranceAccidentHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(InsuranceAccident prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(InsuranceAccident prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static List<GeneralProductFop> getVendorFops(InsuranceAccident prod) {
        return InsuranceAccidentHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(InsuranceAccident prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = InsuranceAccidentHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? new ArrayList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(InsuranceAccident prod) {
        return InsuranceAccidentHelper.getClientContractRelation(prod).getFops();
    }

    public static boolean removeProduct(InsuranceAccident product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(InsuranceAccident product, BaseProduct relatedProduct) {
        if (TextUtil.isSame((String)product.getRelatedProductUid(), (String)relatedProduct.getUid())) {
            product.setRelatedProductUid(null);
        }
        return true;
    }

    public static String getCities(InsuranceAccident product, Locale locale) {
        StringBuilder locations = new StringBuilder();
        locations.append(product.getDepartureLocationName() != null ? product.getDepartureLocationName() : "?");
        locations.append(" - ");
        locations.append(product.getArrivalLocationName() != null ? product.getDepartureLocationName() : "?");
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static InsuranceAccident findProduct(String systemNumber, ProductStatus status) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.ticketNumber.name(), (Object)systemNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.status.name(), (Object)status));
        List data = EntityStorage.get().search(InsuranceAccidentIndex.class, query).getData();
        if (data.isEmpty()) {
            return null;
        }
        if (data.size() > 1) {
            throw new IllegalStateException(String.format("%s products found, number = %s, status =%s ", Integer.toString(data.size()), systemNumber, status));
        }
        EntityContainer ctr = EntityStorage.get().resolve(((InsuranceAccidentIndex)data.get(0)).getSource());
        return (InsuranceAccident)BookingHelper.findProductByUid(((InsuranceAccidentIndex)data.get(0)).getNavigationKey(), (BookingFile)ctr.getEntity());
    }
}

