/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.insurance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class InsuranceWrapper<E extends BaseProduct> {
    private InsuranceAccident accident = null;
    private InsuranceTouristic touristic = null;

    public boolean isInsuranceAccident() {
        return this.accident != null;
    }

    public BaseProduct getProduct() {
        if (this.accident != null) {
            return this.accident;
        }
        return this.touristic;
    }

    public boolean isBusiness() {
        if (this.accident != null) {
            return this.accident.isBusiness();
        }
        return this.touristic.isBusiness();
    }

    public InsuranceWrapper(E product) {
        if (product instanceof InsuranceAccident) {
            this.accident = (InsuranceAccident)product;
        }
        if (product instanceof InsuranceTouristic) {
            this.touristic = (InsuranceTouristic)product;
        }
    }

    public EntityReference<Organization> getSupplier() {
        if (this.accident != null) {
            return InsuranceAccidentHelper.getSupplier(this.accident);
        }
        return InsuranceTouristicHelper.getSupplier(this.touristic);
    }

    public Date getIssueDate() {
        if (this.accident != null) {
            return this.accident.getIssueDate();
        }
        return this.touristic.getIssueDate();
    }

    public String getRelatedProductUid() {
        if (this.accident != null) {
            return this.accident.getRelatedProductUid();
        }
        return null;
    }

    public EntityReference<Person> getAgent() {
        if (this.accident != null) {
            return this.accident.getAgent();
        }
        return this.touristic.getAgent();
    }

    public String getTravellerUid() {
        if (this.accident != null) {
            return this.accident.getTravellerUid();
        }
        return this.touristic.getPolicyHolderUid();
    }

    public ProductStatus getStatus() {
        if (this.accident != null) {
            return this.accident.getStatus();
        }
        return this.touristic.getStatus();
    }

    public void setStatus(ProductStatus status) {
        if (this.accident != null) {
            this.accident.setStatus(status);
        } else {
            this.touristic.setStatus(status);
        }
    }

    public String getSystemNumber() {
        if (this.accident != null) {
            return this.accident.getSystemNumber();
        }
        return this.touristic.getSystemNumber();
    }

    public BaseProduct getNextProduct() {
        if (this.accident != null) {
            return this.accident.getNextProduct();
        }
        return this.touristic.getNextProduct();
    }

    public Date getInsuranceBeginDate() {
        if (this.accident != null) {
            return this.accident.getDepartureDate();
        }
        return this.touristic.getStartDate();
    }

    public Date getInsuranceEndDate() {
        if (this.accident != null) {
            return this.accident.getDepartureDate();
        }
        return this.touristic.getEndDate();
    }

    public BigDecimal getEquivalentSum() {
        if (this.accident != null) {
            return this.accident.getEquivalentSum();
        }
        return this.touristic.getEquivalentSum();
    }

    public Reservation getReservation() {
        if (this.accident != null) {
            return this.accident.getReservation();
        }
        return this.touristic.getReservation();
    }

    public String getUid() {
        if (this.accident != null) {
            return this.accident.getUid();
        }
        return this.touristic.getUid();
    }

    public List<GeneralProductFop> getClientFops() {
        if (this.accident != null) {
            return InsuranceAccidentHelper.getClientFops(this.accident);
        }
        return InsuranceTouristicHelper.getClientFops(this.touristic);
    }

    public List<GeneralProductFop> getVendorFops() {
        if (this.accident != null) {
            return InsuranceAccidentHelper.getVendorFops(this.accident);
        }
        return InsuranceTouristicHelper.getVendorFops(this.touristic);
    }

    public List<GeneralProductFop> getSubagentFops() {
        if (this.accident != null) {
            return InsuranceAccidentHelper.getSubagentFops(this.accident, false);
        }
        return InsuranceTouristicHelper.getSubagentFops(this.touristic, false);
    }

    public StatisticalData getStatisticalData() {
        if (this.accident != null) {
            return this.accident.getStatisticalData();
        }
        return this.touristic.getStatisticalData();
    }
}

