/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dbf;

import com.gridnine.xtrip.common.model.dbf.DbfFile;
import com.gridnine.xtrip.common.model.dbf.DbfRow;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class DbfUtil {
    public static void write(DbfFile dbfFile, OutputStream os) throws Exception {
        if (dbfFile == null) {
            return;
        }
        List<DBFField> fieldsList = dbfFile.getFields();
        DBFField[] fields = fieldsList.toArray(new DBFField[fieldsList.size()]);
        DBFWriter writer = new DBFWriter();
        writer.setCharactersetName("cp866");
        writer.setFields(fields);
        for (DbfRow row : dbfFile.getRows()) {
            Object[] rowData = new Object[fields.length];
            for (int n = 0; n < fieldsList.size(); ++n) {
                DBFField field = fieldsList.get(n);
                if (field == null) continue;
                rowData[n] = row.getValue(field);
            }
            writer.addRecord(rowData);
        }
        writer.write(os);
    }

    public static void write(DbfFile dbfFile, File outputFile) throws Exception {
        if (outputFile == null || outputFile.exists()) {
            throw new Exception("bad output file " + outputFile);
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            DbfUtil.write(dbfFile, fos);
        }
    }

    public static DbfFile read(File inputFile) throws Exception {
        if (inputFile == null || !inputFile.exists() || !inputFile.canRead()) {
            throw new Exception("bad input file " + inputFile);
        }
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            DbfFile dbfFile = DbfUtil.read(inputStream);
            return dbfFile;
        }
    }

    public static DbfFile read(InputStream is) throws Exception {
        Object[] rowObjects;
        DBFReader reader = new DBFReader(is);
        reader.setCharactersetName("cp866");
        ArrayList<DBFField> lst = new ArrayList<DBFField>();
        for (int i = 0; i < reader.getFieldCount(); ++i) {
            lst.add(reader.getField(i));
        }
        DbfFile result = new DbfFile(lst);
        while ((rowObjects = reader.nextRecord()) != null) {
            DbfRow row = new DbfRow();
            result.getRows().add(row);
            for (int i = 0; i < rowObjects.length; ++i) {
                row.setValue(result.getField(i), rowObjects[i]);
            }
        }
        return result;
    }

    public static DBFField createField(String name, byte dataType, int fieldLength, int decimalCount) {
        DBFField field = new DBFField();
        field.setName(name);
        field.setDataType(dataType);
        if (dataType != 68) {
            field.setFieldLength(fieldLength);
            field.setDecimalCount(decimalCount);
        }
        return field;
    }

    private DbfUtil() {
    }
}

