/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dbf.util;

import com.gridnine.xtrip.common.model.dbf.DbfFile;
import com.gridnine.xtrip.common.model.dbf.DbfRow;
import com.gridnine.xtrip.common.model.dbf.DbfUtil;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.linuxense.javadbf.DBFField;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBFDicts
extends TestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void produceDataXml() throws Exception {
        DbfFile file;
        DbfFile file2;
        DbfFile file3;
        ArrayList<String> msgs = new ArrayList<String>();
        LinkedHashMap<String, CityRow> cityRows = new LinkedHashMap<String, CityRow>();
        long timing = System.currentTimeMillis();
        msgs.add("INFO: reading data from CITY.DBF");
        try (InputStream strm = ((Object)((Object)this)).getClass().getResourceAsStream("CITY.DBF");){
            file3 = DbfUtil.read(strm);
        }
        DBFField codeField = file3.getField(0);
        for (DbfRow row : file3.getRows()) {
            String code = DBFDicts.getValue(row, codeField);
            if (cityRows.containsKey(code)) {
                msgs.add("WARN: duplicate city with code " + code);
                continue;
            }
            cityRows.put(code, new CityRow(file3, row));
        }
        msgs.add("INFO: CITY data loaded");
        MiscUtil.logTiming((long)timing, (String)("loaded CITY data, size=" + cityRows.size()));
        LinkedHashMap<String, LinkedHashSet<String>> city2ap = new LinkedHashMap<String, LinkedHashSet<String>>();
        HashSet<String> apCodes = new HashSet<String>();
        long timing2 = System.currentTimeMillis();
        msgs.add("INFO: reading data from CITY_AP.DBF");
        try (InputStream strm = ((Object)((Object)this)).getClass().getResourceAsStream("CITY_AP.DBF");){
            file2 = DbfUtil.read(strm);
        }
        DBFField cityField = file2.getField(0);
        DBFField apField = file2.getField(1);
        for (DbfRow row : file2.getRows()) {
            String city = DBFDicts.getValue(row, cityField);
            String ap = DBFDicts.getValue(row, apField);
            if (apCodes.contains(ap)) {
                msgs.add("WARN: duplicate airport with code " + ap);
                continue;
            }
            if (!cityRows.containsKey(city)) {
                msgs.add("WARN: unknown city code " + city);
                continue;
            }
            LinkedHashSet<String> set = (LinkedHashSet<String>)city2ap.get(city);
            if (set == null) {
                set = new LinkedHashSet<String>();
                city2ap.put(city, set);
            }
            set.add(ap);
            apCodes.add(ap);
        }
        msgs.add("INFO: CITY_AP data loaded");
        MiscUtil.logTiming((long)timing2, (String)("loaded CITY_AP data, size=" + file2.getRows().size()));
        LinkedHashMap<String, ApRow> apRows = new LinkedHashMap<String, ApRow>();
        long timing3 = System.currentTimeMillis();
        msgs.add("INFO: reading data from AP.DBF");
        try (InputStream strm = ((Object)((Object)this)).getClass().getResourceAsStream("AP.DBF");){
            file = DbfUtil.read(strm);
        }
        DBFField codeField2 = file.getField(0);
        for (DbfRow row : file.getRows()) {
            String code = DBFDicts.getValue(row, codeField2);
            if (apRows.containsKey(code)) {
                msgs.add("WARN: duplicate airport with code " + code);
                continue;
            }
            if (!apCodes.contains(code)) {
                msgs.add("WARN: unknown city for airport with code " + code);
                continue;
            }
            apRows.put(code, new ApRow(file, row));
        }
        msgs.add("INFO: AP data loaded");
        MiscUtil.logTiming((long)timing3, (String)("loaded AP data, size=" + apRows.size()));
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("dicts");
        doc.appendChild(root);
        long timing4 = System.currentTimeMillis();
        StringBuilder buf = new StringBuilder();
        for (String msg : msgs) {
            buf.append(msg).append("\r\n");
        }
        if (buf.length() > 0) {
            root.appendChild(root.getOwnerDocument().createComment("\r\n" + buf));
        }
        for (CityRow row : cityRows.values()) {
            Element cityElm = (Element)root.appendChild(root.getOwnerDocument().createElement("city"));
            row.toXML(cityElm);
            Set set = (Set)city2ap.get(row.code);
            if (set == null) continue;
            for (String apCode : set) {
                ((ApRow)apRows.get(apCode)).toXML((Element)cityElm.appendChild(cityElm.getOwnerDocument().createElement("airport")));
            }
        }
        MiscUtil.logTiming((long)timing4, (String)"generated XML");
        timing4 = System.currentTimeMillis();
        File file4 = new File("./test/dicts-update.xml");
        FileOutputStream out = new FileOutputStream(file4);
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        ((OutputStream)out).close();
        MiscUtil.logTiming((long)timing4, (String)("result written to file " + file4.getCanonicalPath()));
    }

    static String getValue(DbfRow row, DBFField field) {
        Object value = row.getValue(field);
        if (value == null) {
            return null;
        }
        String result = value.toString();
        return TextUtil.isBlank((String)result) ? null : result.trim();
    }

    static final class ApRow {
        private final String code;
        private final String name;
        private final String nameRu;
        private final String nameEn;
        private final String codeCRT;
        private final String codeIATA;

        ApRow(DbfFile file, DbfRow row) {
            this.code = DBFDicts.getValue(row, file.getField(0));
            this.name = DBFDicts.getValue(row, file.getField(4));
            this.nameRu = DBFDicts.getValue(row, file.getField(5));
            this.nameEn = DBFDicts.getValue(row, file.getField(6));
            this.codeCRT = this.code;
            this.codeIATA = DBFDicts.getValue(row, file.getField(7));
        }

        void toXML(Element elm) {
            XmlUtil.addElement((Element)elm, (String)"code", (String)this.code);
            if (this.name != null) {
                XmlUtil.addElement((Element)elm, (String)"name", (String)this.name);
            }
            if (this.nameEn != null) {
                XmlUtil.addElement((Element)elm, (String)"name-en", (String)this.nameEn);
            }
            if (this.nameRu != null) {
                XmlUtil.addElement((Element)elm, (String)"name-ru", (String)this.nameRu);
            }
            if (this.codeIATA != null) {
                XmlUtil.addElement((Element)elm, (String)"code-IATA", (String)this.codeIATA);
            }
            if (this.codeCRT != null) {
                XmlUtil.addElement((Element)elm, (String)"code-CRT", (String)this.codeCRT);
            }
        }
    }

    static final class CityRow {
        final String code;
        private final String name;
        private final String nameRu;
        private final String nameEn;
        private final String codeCRT;
        private final String codeIATA;
        private final String country;

        CityRow(DbfFile file, DbfRow row) {
            this.code = DBFDicts.getValue(row, file.getField(0));
            this.name = DBFDicts.getValue(row, file.getField(1));
            this.nameRu = DBFDicts.getValue(row, file.getField(2));
            this.nameEn = DBFDicts.getValue(row, file.getField(3));
            this.codeCRT = this.code;
            this.codeIATA = DBFDicts.getValue(row, file.getField(4));
            this.country = DBFDicts.getValue(row, file.getField(7));
        }

        void toXML(Element elm) {
            XmlUtil.addElement((Element)elm, (String)"code", (String)this.code);
            if (this.name != null) {
                XmlUtil.addElement((Element)elm, (String)"name", (String)this.name);
            }
            if (this.nameEn != null) {
                XmlUtil.addElement((Element)elm, (String)"name-en", (String)this.nameEn);
            }
            if (this.nameRu != null) {
                XmlUtil.addElement((Element)elm, (String)"name-ru", (String)this.nameRu);
            }
            if (this.codeIATA != null) {
                XmlUtil.addElement((Element)elm, (String)"code-IATA", (String)this.codeIATA);
            }
            if (this.codeCRT != null) {
                XmlUtil.addElement((Element)elm, (String)"code-CRT", (String)this.codeCRT);
            }
            if (this.country != null) {
                XmlUtil.addElement((Element)elm, (String)"country", (String)this.country);
            }
        }
    }
}

