/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.duplicates;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductGuestIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DupesHelper {
    private static final Set<HotelProvider> FORBIDDEN_CREATE_DUPES_PROVIDER = new HashSet<HotelProvider>();

    public static SearchQuery createSearchQuery(Product product, SearchCriterion ... addCriterions) {
        return DupesHelper.createSearchQuery(product, new HashSet<ProductStatus>(), addCriterions);
    }

    public static SearchQuery createSearchQuery(Product product, Set<ProductStatus> statuses, SearchCriterion ... addCriterions) {
        SearchQuery searchQuery = new SearchQuery();
        List searchQueryCriterions = searchQuery.getCriteria().getCriterions();
        if (statuses.isEmpty()) {
            searchQueryCriterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.ne((String)ProductIndex.Property.operationBatch.name(), (Object)OperationBatch.EXCHANGE)})}));
        } else {
            ArrayList<SearchCriterion> statusCriterions = new ArrayList<SearchCriterion>();
            if (statuses.remove(ProductStatus.SELL)) {
                statusCriterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.ne((String)ProductIndex.Property.operationBatch.name(), (Object)OperationBatch.EXCHANGE)}));
            }
            for (ProductStatus status : statuses) {
                statusCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)status));
            }
            searchQueryCriterions.add(SearchCriterion.or((SearchCriterion[])statusCriterions.toArray(new SearchCriterion[0])));
        }
        Segment firstSegment = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
        searchQueryCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.firstFlightDate.name(), (Object)firstSegment.getStartDate()));
        product.getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).map(segment -> SearchCriterion.contains((String)ProductIndex.Property.flightNos.name(), (Object)segment.getFlightNo())).forEach(searchQueryCriterions::add);
        Traveller traveller = product.getTraveller();
        Passport passport = traveller.getPassport();
        searchQueryCriterions.add(SearchCriterion.contains((String)ProductIndex.Property.passengerPassportNumbers.name(), (Object)passport.getNumber()));
        searchQueryCriterions.addAll(Arrays.asList(addCriterions));
        return searchQuery;
    }

    public static SearchQuery createSearchQuery(EntityReference<Person> person, EntityReference<Organization> clientRef, Date checkIn, Date checkOut, DictionaryReference<GeoLocation> location, SearchCriterion ... addCriterions) {
        return DupesHelper.createSearchQuery(person, null, null, clientRef, checkIn, checkOut, location, addCriterions);
    }

    public static SearchQuery createSearchQuery(String firstName, String lastName, EntityReference<Organization> clientRef, Date checkIn, Date checkOut, DictionaryReference<GeoLocation> location, SearchCriterion ... addCriterions) {
        return DupesHelper.createSearchQuery(null, firstName, lastName, clientRef, checkIn, checkOut, location, addCriterions);
    }

    private static SearchQuery createSearchQuery(EntityReference<Person> person, String firstName, String lastName, EntityReference<Organization> clientRef, Date checkIn, Date checkOut, DictionaryReference<GeoLocation> location, SearchCriterion ... addCriterions) {
        SearchQuery searchQuery = new SearchQuery();
        List criterions = searchQuery.getCriteria().getCriterions();
        if (person != null) {
            criterions.add(SearchCriterion.eq((String)MainHotelProductGuestIndex.Property.passenger.name(), person));
        } else {
            criterions.add(SearchCriterion.eq((String)MainHotelProductGuestIndex.Property.firstName.name(), (Object)StringUtils.lowerCase((String)firstName)));
            criterions.add(SearchCriterion.eq((String)MainHotelProductGuestIndex.Property.lastName.name(), (Object)StringUtils.lowerCase((String)lastName)));
        }
        criterions.add(SearchCriterion.eq((String)MainHotelProductGuestIndex.Property.client.name(), clientRef));
        criterions.add(SearchCriterion.eq((String)MainHotelProductGuestIndex.Property.hotelLocation.name(), location));
        criterions.add(SearchCriterion.ge((String)MainHotelProductGuestIndex.Property.checkInDate.name(), (Object)MiscUtil.clearTime((Date)new Date())));
        criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{DupesHelper.nonInclusiveBetween(MainHotelProductGuestIndex.Property.checkInDate.name(), checkIn, checkOut), DupesHelper.nonInclusiveBetween(MainHotelProductGuestIndex.Property.checkOutDate.name(), checkIn, checkOut), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)MainHotelProductGuestIndex.Property.checkInDate.name(), (Object)checkIn), SearchCriterion.ge((String)MainHotelProductGuestIndex.Property.checkOutDate.name(), (Object)checkOut)})}));
        criterions.addAll(Arrays.asList(addCriterions));
        return searchQuery;
    }

    private static SearchCriterion nonInclusiveBetween(String propertyName, Object lo, Object hi) {
        return SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.gt((String)propertyName, (Object)lo), SearchCriterion.lt((String)propertyName, (Object)hi)});
    }

    public static boolean isProductsDupe(Product product1, Product product2) {
        if (product1.getSegmentTariffs().size() != product2.getSegmentTariffs().size()) {
            return false;
        }
        for (int i = 0; i < product1.getSegmentTariffs().size(); ++i) {
            SegmentTariff st1 = (SegmentTariff)product1.getSegmentTariffs().get(i);
            SegmentTariff st2 = (SegmentTariff)product2.getSegmentTariffs().get(i);
            if (st1.getSegments().size() != st2.getSegments().size()) {
                return false;
            }
            for (int j = 0; j < st1.getSegments().size(); ++j) {
                Segment s1 = (Segment)st1.getSegments().get(j);
                Segment s2 = (Segment)st2.getSegments().get(j);
                if (!s1.getStartDate().equals(s2.getStartDate())) {
                    return false;
                }
                if (!s1.getDepartureLocation().equals((Object)s2.getDepartureLocation())) {
                    return false;
                }
                if (!s1.getArriveLocation().equals((Object)s2.getArriveLocation())) {
                    return false;
                }
                if (!s1.getAirline().equals((Object)s2.getAirline())) {
                    return false;
                }
                if (s1.getFlightNo().equals(s2.getFlightNo())) continue;
                return false;
            }
        }
        return DupesHelper.isPassportDupe(product1.getTraveller().getPassport(), product2.getTraveller().getPassport());
    }

    public static boolean isPassportDupe(Passport passport1, Passport passport2) {
        if (!passport1.getFirstName().equalsIgnoreCase(passport2.getFirstName())) {
            return false;
        }
        if (!passport1.getLastName().equalsIgnoreCase(passport2.getLastName())) {
            return false;
        }
        return passport1.getNumber().equalsIgnoreCase(passport2.getNumber());
    }

    public static boolean canCreateHotelDuplicates(HotelProvider reqProvider, Collection<BookingFile> dupeBookings) {
        boolean canCreateDuplicates = true;
        if (FORBIDDEN_CREATE_DUPES_PROVIDER.contains(reqProvider)) {
            canCreateDuplicates = dupeBookings.stream().flatMap(bf -> bf.getReservations().stream()).flatMap(res -> BookingStreamHelper.getProductsStream(res, HotelProduct.class)).map(HotelProduct::getProvider).noneMatch(prov -> prov == reqProvider);
        }
        return canCreateDuplicates;
    }

    static {
        FORBIDDEN_CREATE_DUPES_PROVIDER.add(HotelProvider.ACADEMSERVICE);
        FORBIDDEN_CREATE_DUPES_PROVIDER.add(HotelProvider.HOTELBOOK);
    }
}

