/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.v2;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedCustomEntityDescriptor;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescriptionIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.export.v2.ExportUniversalProductCollectionExtender;
import com.gridnine.xtrip.common.model.export.v2.ExportUniversalProductCustomEntityDescriptor;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.Objects;

public class ExportUniversalProductEntityPublisher
implements Publisher {
    public void publish() throws Exception {
        if (!Environment.isPublished(ExportMetaRegistry.class)) {
            return;
        }
        if (!Environment.isPublished(EntityStorage.class)) {
            return;
        }
        final ExportMetaRegistry reg = (ExportMetaRegistry)ExportMetadataProvider.get();
        this.putAllDescriptors(reg);
        ((EntityCacheManager)Environment.getPublished(EntityCacheManager.class)).registerCacheListener(new EntityCacheListener(){

            public void onReset() {
                reg.getCustomEntityDescriptors().clear();
                ExportUniversalProductEntityPublisher.this.putAllDescriptors(reg);
                ExportUniversalProductCollectionExtender.resetCachedValue();
            }

            public void onInvalidate(EntityReference<?> ref) {
                if (UniversalProductDescription.class.equals((Object)ref.getType())) {
                    reg.getCustomEntityDescriptors().remove(ref.getUid());
                    EntityContainer ctr = EntityStorage.get().resolve(ref);
                    if (ctr != null) {
                        reg.getCustomEntityDescriptors().put(ref.getUid(), new ExportUniversalProductCustomEntityDescriptor((EntityContainer<UniversalProductDescription>)ctr));
                    }
                    ExportUniversalProductCollectionExtender.resetCachedValue();
                }
            }
        });
    }

    private void putAllDescriptors(ExportMetaRegistry reg) {
        EntityStorage.get().search(UniversalProductDescriptionIndex.class, new SearchQuery()).getData().stream().map(idx -> EntityStorage.get().resolve(idx.getSource())).filter(Objects::nonNull).forEach(ctr -> {
            ExportedCustomEntityDescriptor cfr_ignored_0 = reg.getCustomEntityDescriptors().put(ctr.getUid(), new ExportUniversalProductCustomEntityDescriptor((EntityContainer<UniversalProductDescription>)ctr));
        });
    }
}

