/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionType;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.meta.export.ExportedRootEntityType;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.CustomEntityExport;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.time.FastDateFormat;

public final class MetadataBasedExportObjectsXmlHelper {
    private static final String XSD_PREFIX = "xsd";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String EXPORT_NAMESPACE = "http://www.gridnine.com/export/xml";
    private static final String EXPORT_PREFIX = "x";
    private static final String VERSION = "1.0";

    public static ObjectReferenceExport toReference(EntityReference<Person> ref) {
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (ctr == null) {
            return null;
        }
        ObjectReferenceExport result = new ObjectReferenceExport();
        result.setCaption(((Person)ctr.getEntity()).toString());
        if (!TextUtil.isBlank((String)((Person)ctr.getEntity()).getCode())) {
            result.setCode(((Person)ctr.getEntity()).getCode());
        } else if (!TextUtil.isBlank((String)((Person)ctr.getEntity()).getLoginName())) {
            result.setCode(((Person)ctr.getEntity()).getLoginName());
        } else {
            result.setCode(ctr.getUid());
        }
        return result;
    }

    public static <E extends BaseEntityExport> String generateXml(E obj, ElementExportSettings exportSettings) throws XMLStreamException, IOException {
        return MetadataBasedExportObjectsXmlHelper.generateXml(obj, exportSettings, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends BaseEntityExport> String generateXml(E obj, ElementExportSettings exportSettings, Date date) throws XMLStreamException, IOException {
        ExportedEntityType ett = ((ExportMetadataProvider)Environment.getPublished(ExportMetadataProvider.class)).getEntity(obj.getClass().getName());
        if (ett == null) {
            throw Xeption.forDeveloper((String)"export entity {0} is not registered", (Object[])new Object[]{obj.getClass().getName()});
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            XMLOutputFactory factory = XSUtil.getXMLOutputFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, "UTF-8");
            try {
                writer.writeStartDocument("UTF-8", VERSION);
                if (ett instanceof ExportedRootEntityType) {
                    MetadataBasedExportObjectsXmlHelper.exportXml(obj, ett, writer, exportSettings, ((ExportedRootEntityType)ett).getRootTagName(), "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", true, date);
                } else {
                    MetadataBasedExportObjectsXmlHelper.exportXml(obj, ett, writer, exportSettings, exportSettings.getName(), "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", true, date);
                }
                writer.writeEndDocument();
                writer.flush();
                string = out.toString("UTF-8");
            }
            catch (Throwable throwable) {
                writer.close();
                throw throwable;
            }
            writer.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateXsd(ExportedRootEntityType ett, ElementExportSettings elementExportSettings) throws XMLStreamException, IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            XMLOutputFactory factory = XSUtil.getXMLOutputFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, "UTF-8");
            try {
                writer.writeStartDocument("UTF-8", VERSION);
                MetadataBasedExportObjectsXmlHelper.exportXsd((ExportedEntityType)ett, ett.getRootTagName(), writer, elementExportSettings, null, null, true);
                writer.writeEndDocument();
                writer.flush();
                string = out.toString("UTF-8");
            }
            catch (Throwable throwable) {
                writer.close();
                throw throwable;
            }
            writer.close();
            return string;
        }
    }

    private static void exportXsd(ExportedEntityType ett, String elementName, XMLStreamWriter writer, ElementExportSettings settings, String parentDateFormat, String parentDateTimeFormat, boolean isRoot) throws XMLStreamException {
        ElementExportSettings collSettings;
        String dateTimeFormat;
        if (settings == null || !settings.isExported()) {
            return;
        }
        if (isRoot) {
            writer.setPrefix(XSD_PREFIX, XSD_NAMESPACE);
            writer.writeStartElement(XSD_NAMESPACE, "schema");
            writer.writeNamespace(XSD_PREFIX, XSD_NAMESPACE);
            writer.writeAttribute("targetNamespace", EXPORT_NAMESPACE);
            writer.writeAttribute("elementFormDefault", "qualified");
            writer.writeAttribute("attributeFormDefault", "unqualified");
        }
        writer.writeStartElement(XSD_NAMESPACE, "element");
        writer.writeAttribute("name", elementName);
        if (!isRoot) {
            writer.writeAttribute("maxOccurs", "1");
            writer.writeAttribute("minOccurs", "0");
        }
        MetadataBasedExportObjectsXmlHelper.addDocumentation(writer, (BaseExportedElementType)ett, null);
        writer.writeStartElement(XSD_NAMESPACE, "complexType");
        String dateFormat = ett.getDateFormat();
        if (TextUtil.isBlank((String)dateFormat)) {
            dateFormat = parentDateFormat;
        }
        if (TextUtil.isBlank((String)(dateTimeFormat = ett.getDateTimeFormat()))) {
            dateTimeFormat = parentDateTimeFormat;
        }
        LinkedHashMap<ExportedPropertyType, ElementExportSettings> attributes = new LinkedHashMap<ExportedPropertyType, ElementExportSettings>();
        new ArrayList();
        LinkedHashMap<ExportedPropertyType, ElementExportSettings> properties = new LinkedHashMap<ExportedPropertyType, ElementExportSettings>();
        LinkedHashMap<ExportedPropertyType, ElementExportSettings> entities = new LinkedHashMap<ExportedPropertyType, ElementExportSettings>();
        LinkedHashMap<ExportedCollectionType, ElementExportSettings> collections = new LinkedHashMap<ExportedCollectionType, ElementExportSettings>();
        boolean hasElements = false;
        block16: for (ExportedPropertyType item : ExportedObjectsMetadataHelper.getAllProperties((ExportedEntityType)ett).values()) {
            ElementExportSettings itemSettings = MetadataBasedExportObjectsXmlHelper.find(settings.getChildren(), item.getId());
            if (itemSettings == null || !itemSettings.isExported()) continue;
            hasElements = true;
            switch (item.getType()) {
                case ENTITY: {
                    entities.put(item, itemSettings);
                    continue block16;
                }
                case REFERENCE: {
                    properties.put(item, itemSettings);
                    continue block16;
                }
                case STRING: 
                case DATE: 
                case DATETIME: 
                case BOOLEAN: 
                case INTEGER: 
                case BIGDECIMAL: {
                    attributes.put(item, itemSettings);
                    continue block16;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{item.getType()});
        }
        for (ExportedCollectionType coll : ExportedObjectsMetadataHelper.getAllCollections((ExportedEntityType)ett).values()) {
            collSettings = MetadataBasedExportObjectsXmlHelper.find(settings.getChildren(), coll.getId());
            if (collSettings == null || !collSettings.isExported()) continue;
            hasElements = true;
            collections.put(coll, collSettings);
        }
        if (hasElements) {
            writer.writeStartElement(XSD_NAMESPACE, "all");
            writer.writeAttribute("maxOccurs", "1");
            writer.writeAttribute("minOccurs", "0");
            for (ExportedPropertyType etts : entities.keySet()) {
                ExportedEntityType ett2 = ExportedObjectsMetadataHelper.getEntityType((String)etts.getEntityId());
                MetadataBasedExportObjectsXmlHelper.exportXsd(ett2, etts.getId(), writer, (ElementExportSettings)entities.get(etts), dateFormat, dateTimeFormat, false);
            }
            block19: for (ExportedPropertyType prop : properties.keySet()) {
                switch (prop.getType()) {
                    case REFERENCE: {
                        writer.writeStartElement(XSD_NAMESPACE, "element");
                        writer.writeAttribute("name", prop.getId());
                        writer.writeAttribute("maxOccurs", "1");
                        writer.writeAttribute("minOccurs", "0");
                        MetadataBasedExportObjectsXmlHelper.addDocumentation(writer, (BaseExportedElementType)prop, ett);
                        writer.writeStartElement(XSD_NAMESPACE, "complexType");
                        MetadataBasedExportObjectsXmlHelper.addAttribute(writer, "code", "string", "\u041a\u043e\u0434", true);
                        MetadataBasedExportObjectsXmlHelper.addAttribute(writer, "caption", "string", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", false);
                        writer.writeEndElement();
                        writer.writeEndElement();
                        continue block19;
                    }
                }
                throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{prop.getType()});
            }
            for (ExportedCollectionType coll : collections.keySet()) {
                ElementExportSettings itemSettings;
                collSettings = (ElementExportSettings)collections.get(coll);
                writer.writeStartElement(XSD_NAMESPACE, "element");
                writer.writeAttribute("maxOccurs", "1");
                writer.writeAttribute("minOccurs", "0");
                writer.writeAttribute("name", coll.getId());
                writer.writeStartElement(XSD_NAMESPACE, "complexType");
                writer.writeStartElement(XSD_NAMESPACE, "sequence");
                writer.writeAttribute("maxOccurs", "unbounded");
                writer.writeAttribute("minOccurs", "0");
                int possibleElementsCount = 0;
                for (Map.Entry elm : ExportedObjectsMetadataHelper.getAllPossibleElements((ExportedCollectionType)coll).entrySet()) {
                    itemSettings = MetadataBasedExportObjectsXmlHelper.find(collSettings.getChildren(), (String)elm.getKey());
                    if (itemSettings == null || !itemSettings.isExported()) continue;
                    ++possibleElementsCount;
                }
                if (possibleElementsCount > 1) {
                    writer.writeStartElement(XSD_NAMESPACE, "choice");
                    for (Map.Entry ettId : ExportedObjectsMetadataHelper.getAllPossibleElements((ExportedCollectionType)coll).entrySet()) {
                        itemSettings = MetadataBasedExportObjectsXmlHelper.find(collSettings.getChildren(), (String)ettId.getKey());
                        MetadataBasedExportObjectsXmlHelper.exportXsd(ExportedObjectsMetadataHelper.getEntityType((String)((String)ettId.getValue())), (String)ettId.getKey(), writer, itemSettings, dateFormat, dateTimeFormat, false);
                    }
                    writer.writeEndElement();
                } else {
                    Map.Entry elm2 = null;
                    ElementExportSettings itemSettings2 = null;
                    for (Map.Entry elm : ExportedObjectsMetadataHelper.getAllPossibleElements((ExportedCollectionType)coll).entrySet()) {
                        ElementExportSettings itemSettings3 = MetadataBasedExportObjectsXmlHelper.find(collSettings.getChildren(), (String)elm.getKey());
                        if (itemSettings3 == null || !itemSettings3.isExported()) continue;
                        elm2 = elm;
                        itemSettings2 = itemSettings3;
                        break;
                    }
                    if (elm2 != null) {
                        MetadataBasedExportObjectsXmlHelper.exportXsd(ExportedObjectsMetadataHelper.getEntityType((String)((String)elm2.getValue())), (String)elm2.getKey(), writer, itemSettings2, dateFormat, dateTimeFormat, false);
                    }
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (isRoot) {
            MetadataBasedExportObjectsXmlHelper.addAttribute(writer, "version", "string", "\u0412\u0435\u0440\u0441\u0438\u044f", true);
            MetadataBasedExportObjectsXmlHelper.addAttribute(writer, "time", "dateTime", "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", true);
        }
        for (ExportedPropertyType attr : attributes.keySet()) {
            String type;
            switch (attr.getType()) {
                case STRING: {
                    type = "string";
                    break;
                }
                case DATE: {
                    type = null == dateFormat ? "date" : "string";
                    break;
                }
                case DATETIME: {
                    type = null == dateFormat ? "dateTime" : "string";
                    break;
                }
                case BOOLEAN: {
                    type = "boolean";
                    break;
                }
                case INTEGER: {
                    type = "integer";
                    break;
                }
                case BIGDECIMAL: {
                    type = "decimal";
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{attr.getType()});
                }
            }
            MetadataBasedExportObjectsXmlHelper.addAttribute(writer, attr.getId(), type, ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)attr, (ExportedEntityType)ett), false);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        if (isRoot) {
            writer.writeEndElement();
        }
    }

    private static void addAttribute(XMLStreamWriter writer, String tagName, String type, String description, boolean required) throws XMLStreamException {
        writer.writeStartElement(XSD_NAMESPACE, "attribute");
        writer.writeAttribute("name", tagName);
        writer.writeAttribute("type", "xsd:" + type);
        writer.writeAttribute("use", required ? "required" : "optional");
        MetadataBasedExportObjectsXmlHelper.addDocumentation(writer, description);
        writer.writeEndElement();
    }

    private static void addDocumentation(XMLStreamWriter writer, String doc) throws XMLStreamException {
        writer.writeStartElement(XSD_NAMESPACE, "annotation");
        writer.writeStartElement(XSD_NAMESPACE, "documentation");
        writer.writeCData(doc);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static void addDocumentation(XMLStreamWriter writer, BaseExportedElementType ett, ExportedEntityType parent) throws XMLStreamException {
        MetadataBasedExportObjectsXmlHelper.addDocumentation(writer, ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)ett, null));
    }

    private static <E extends BaseEntityExport> void exportXml(E obj, ExportedEntityType ett, XMLStreamWriter writer, ElementExportSettings settings, String entityTagName, String parentDateFormat, String parentDateTimeFormat, boolean isRoot, Date date) throws XMLStreamException {
        ExportedPropertyType item;
        String dateTimeFormat;
        ArrayList<Object> attributes = new ArrayList<Object>();
        LinkedHashMap<Object, ElementExportSettings> otherElements = new LinkedHashMap<Object, ElementExportSettings>();
        block14: for (Object item2 : ExportedObjectsMetadataHelper.getAllProperties((ExportedEntityType)ett).values()) {
            Object value;
            ElementExportSettings elementSettings = MetadataBasedExportObjectsXmlHelper.find(settings.getChildren(), item2.getId());
            if (elementSettings == null || !elementSettings.isExported() || (value = obj.getValue(item2.getId())) == null) continue;
            switch (item2.getType()) {
                case ENTITY: 
                case REFERENCE: {
                    otherElements.put(item2, elementSettings);
                    continue block14;
                }
                case STRING: 
                case DATE: 
                case DATETIME: 
                case BOOLEAN: 
                case INTEGER: 
                case BIGDECIMAL: {
                    attributes.add(item2);
                    continue block14;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{item2.getType()});
        }
        LinkedHashMap<ExportedCollectionType, ElementExportSettings> collections = new LinkedHashMap<ExportedCollectionType, ElementExportSettings>();
        for (ExportedCollectionType item3 : ExportedObjectsMetadataHelper.getAllCollections((ExportedEntityType)ett).values()) {
            ElementExportSettings collSettings = MetadataBasedExportObjectsXmlHelper.find(settings.getChildren(), item3.getId());
            if (collSettings == null || !collSettings.isExported()) continue;
            collections.put(item3, collSettings);
        }
        String dateFormat = ett.getDateFormat();
        if (TextUtil.isBlank((String)dateFormat)) {
            dateFormat = parentDateFormat;
        }
        if (TextUtil.isBlank((String)(dateTimeFormat = ett.getDateTimeFormat()))) {
            dateTimeFormat = parentDateTimeFormat;
        }
        if (isRoot) {
            writer.setPrefix(EXPORT_PREFIX, EXPORT_NAMESPACE);
        }
        writer.writeStartElement(EXPORT_NAMESPACE, entityTagName);
        if (isRoot) {
            writer.writeNamespace(EXPORT_PREFIX, EXPORT_NAMESPACE);
            writer.writeAttribute("version", VERSION);
            writer.writeAttribute("time", MetadataBasedExportObjectsXmlHelper.formatDate("yyyy-MM-dd'T'HH:mm:ss", date));
        }
        block16: for (ExportedPropertyType exportedPropertyType : attributes) {
            Object value = obj.getValue(exportedPropertyType.getId());
            switch (exportedPropertyType.getType()) {
                case STRING: 
                case BOOLEAN: 
                case INTEGER: {
                    writer.writeAttribute(exportedPropertyType.getId(), value.toString());
                    continue block16;
                }
                case DATE: {
                    writer.writeAttribute(exportedPropertyType.getId(), MetadataBasedExportObjectsXmlHelper.formatDate(dateFormat, (Date)value));
                    continue block16;
                }
                case DATETIME: {
                    writer.writeAttribute(exportedPropertyType.getId(), MetadataBasedExportObjectsXmlHelper.formatDate(dateTimeFormat, (Date)value));
                    continue block16;
                }
                case BIGDECIMAL: {
                    writer.writeAttribute(exportedPropertyType.getId(), ((BigDecimal)value).toPlainString());
                    continue block16;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{exportedPropertyType.getType()});
        }
        block17: for (Map.Entry entry : otherElements.entrySet()) {
            item = (ExportedPropertyType)entry.getKey();
            Object value = obj.getValue(item.getId());
            switch (item.getType()) {
                case REFERENCE: {
                    ObjectReferenceExport ref = (ObjectReferenceExport)value;
                    if (ref.getCode() == null) {
                        throw Xeption.forDeveloper((String)"unassigned code for reference {0}.{1}", (Object[])new Object[]{ett.getId(), item.getId()});
                    }
                    writer.writeStartElement(EXPORT_NAMESPACE, item.getId());
                    if (ref.getCode() != null) {
                        writer.writeAttribute("code", ref.getCode());
                    }
                    if (ref.getCaption() != null) {
                        writer.writeAttribute("caption", ref.getCaption());
                    }
                    writer.writeEndElement();
                    continue block17;
                }
                case ENTITY: {
                    MetadataBasedExportObjectsXmlHelper.exportXml((BaseEntityExport)value, ((ExportMetadataProvider)Environment.getPublished(ExportMetadataProvider.class)).getEntity(item.getEntityId()), writer, (ElementExportSettings)entry.getValue(), item.getId(), dateFormat, dateTimeFormat, false, date);
                    continue block17;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported property type {0}", (Object[])new Object[]{item.getType()});
        }
        for (Map.Entry entry : collections.entrySet()) {
            String valueClassName;
            item = (ExportedCollectionType)entry.getKey();
            LinkedHashMap<BaseEntityExport, ElementExportSettings> elementsMap = new LinkedHashMap<BaseEntityExport, ElementExportSettings>();
            List values = (List)obj.getValue(item.getId());
            for (BaseEntityExport baseEntityExport : values) {
                ElementExportSettings elementSettings;
                String tagId = null;
                valueClassName = baseEntityExport.getClass().getName();
                if (baseEntityExport instanceof CustomEntityExport) {
                    valueClassName = ((CustomEntityExport)baseEntityExport).getVirtualClass();
                }
                for (Map.Entry posElm : ExportedObjectsMetadataHelper.getAllPossibleElements((ExportedCollectionType)item).entrySet()) {
                    if (!((String)posElm.getValue()).equals(valueClassName)) continue;
                    tagId = (String)posElm.getKey();
                    break;
                }
                if (tagId == null || (elementSettings = MetadataBasedExportObjectsXmlHelper.find(((ElementExportSettings)entry.getValue()).getChildren(), tagId)) == null || !elementSettings.isExported()) continue;
                elementsMap.put(baseEntityExport, elementSettings);
            }
            if (elementsMap.isEmpty()) continue;
            writer.writeStartElement(EXPORT_NAMESPACE, item.getId());
            for (Map.Entry entry2 : elementsMap.entrySet()) {
                BaseEntityExport value = (BaseEntityExport)entry2.getKey();
                valueClassName = value.getClass().getName();
                if (value instanceof CustomEntityExport) {
                    valueClassName = ((CustomEntityExport)value).getVirtualClass();
                }
                ElementExportSettings valueSettigns = (ElementExportSettings)entry2.getValue();
                MetadataBasedExportObjectsXmlHelper.exportXml(value, ExportedObjectsMetadataHelper.getEntityType((String)valueClassName), writer, valueSettigns, ((ElementExportSettings)entry2.getValue()).getName(), dateFormat, dateTimeFormat, false, date);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static String formatDate(String format, Date value) {
        return FastDateFormat.getInstance((String)format).format(value);
    }

    private static ElementExportSettings find(Collection<ElementExportSettings> coll, String name) {
        if (name == null) {
            return null;
        }
        for (ElementExportSettings item : coll) {
            if (!name.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    private MetadataBasedExportObjectsXmlHelper() {
    }
}

