/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.XMLExportHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StandardXMLExportHandler
implements XMLExportHandler {
    private static final Logger log = LoggerFactory.getLogger(StandardXMLExportHandler.class);
    private static final String ENTITY_ELEMENT_NAME = "entity";
    private static final String UID_ATTRIBUTE_NAME = "uid";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String EQUIVALENT_FARE_ELEMENT_NAME = "equivalentFare";
    private static final String TOTAL_EQUIVALENT_FARE_ELEMENT_NAME = "totalEquivalentFare";
    private static final String SUPPLIER_ELEMENT_NAME = "supplier";
    private static final String AGENCY_ELEMENT_NAME = "agency";
    private static final String SUBAGENCY_ELEMENT_NAME = "subagency";
    private static final String VENDOR_FOPS_ELEMENT_NAME = "vendorFops";
    private static final String SUBAGENT_FOPS_ELEMENT_NAME = "subagentFops";
    private static final String CLIENT_FOPS_ELEMENT_NAME = "clientFops";
    private static final String COMMISSIONS_ELEMENT_NAME = "commissions";
    private static final String CURRENCY_RATE_ELEMENT_NAME = "currencyRate";
    private static final String TEXT_ELEMENT_NAME = "text";
    private static final String ITEM_ELEMENT_NAME = "item";

    @Override
    public String getId() {
        return "standardXmlExportHandler";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends BaseEntity> void updateDocument(List<T> entities, Document document) throws Exception {
        Element element;
        Node node;
        String uid;
        String type;
        int i;
        ArrayList<String> productTypesAttributeValues = new ArrayList<String>();
        HashMap<String, String> productFopElementTypes = new HashMap<String, String>();
        HashMap<String, String> commissionElementTypes = new HashMap<String, String>();
        HashSet<String> commissionTypes = new HashSet<String>();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (ProductHandler<?> handler : HandlersRegistry.get().getAllProductHandlers()) {
            EntityCollection commissionsCollection;
            String productClassName = handler.getProductClass().getName();
            productTypesAttributeValues.add(productClassName);
            EntityType entityType = (EntityType)metaRegistry.getEntities().get(productClassName);
            if (entityType == null) continue;
            for (String fopElementName : Arrays.asList(VENDOR_FOPS_ELEMENT_NAME, SUBAGENT_FOPS_ELEMENT_NAME, CLIENT_FOPS_ELEMENT_NAME)) {
                EntityCollection fopsCollection = (EntityCollection)entityType.getCollections().get(fopElementName);
                if (fopsCollection == null || fopsCollection.getElementType() == null) continue;
                productFopElementTypes.put(productClassName, fopsCollection.getElementType());
                break;
            }
            if ((commissionsCollection = (EntityCollection)entityType.getCollections().get(COMMISSIONS_ELEMENT_NAME)) == null || commissionsCollection.getElementType() == null) continue;
            commissionElementTypes.put(productClassName, commissionsCollection.getElementType());
        }
        commissionTypes.add(Commission.class.getName());
        commissionTypes.add(GeneralProductCommission.class.getName());
        NodeList nodes = document.getElementsByTagName(ENTITY_ELEMENT_NAME);
        HashMap<String, void> commissionRates = new HashMap<String, void>();
        for (i = 0; i < nodes.getLength(); ++i) {
            ValidationMessage validationMessage;
            BaseProduct product;
            type = null;
            uid = null;
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute(UID_ATTRIBUTE_NAME);
            if (TextUtil.isBlank((String)type) || TextUtil.isBlank((String)uid)) continue;
            if (productTypesAttributeValues.contains(type)) {
                String commissionType;
                String productFopType;
                EntityContainer subagencyContainer;
                EntityContainer agencyContainer;
                product = StandardXMLExportHandler.findProductByUid(entities, XHelper.getClass((String)type), uid);
                if (product == null) {
                    log.error(String.format("product with type %s and uid %s not found!", type, uid));
                    try {
                        log.error(XUtil.toString((Document)document));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NodeList children = node.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 1 || !SUPPLIER_ELEMENT_NAME.equals(child.getNodeName()) && !AGENCY_ELEMENT_NAME.equals(child.getNodeName()) && !SUBAGENCY_ELEMENT_NAME.equals(child.getNodeName()) && !VENDOR_FOPS_ELEMENT_NAME.equals(child.getNodeName()) && !SUBAGENT_FOPS_ELEMENT_NAME.equals(child.getNodeName()) && !CLIENT_FOPS_ELEMENT_NAME.equals(child.getNodeName())) continue;
                    node.removeChild(child);
                    --j;
                }
                LinkedHashMap<String, BaseEntity> organizations = new LinkedHashMap<String, BaseEntity>();
                EntityContainer supplierContainer = EntityStorage.get().resolve(GeneralProductHelper.getSupplier(product));
                if (supplierContainer != null) {
                    organizations.put(SUPPLIER_ELEMENT_NAME, supplierContainer.getEntity());
                }
                if ((agencyContainer = EntityStorage.get().resolve(GeneralProductHelper.getAgency(product))) != null) {
                    organizations.put(AGENCY_ELEMENT_NAME, agencyContainer.getEntity());
                }
                if ((subagencyContainer = EntityStorage.get().resolve(GeneralProductHelper.getSubagency(product))) != null) {
                    organizations.put(SUBAGENCY_ELEMENT_NAME, subagencyContainer.getEntity());
                }
                for (Map.Entry entry : organizations.entrySet()) {
                    String organizationElementName = (String)entry.getKey();
                    Organization organization = (Organization)entry.getValue();
                    Element organizationElement = node.getOwnerDocument().createElement(organizationElementName);
                    organizationElement.setAttribute(TYPE_ATTRIBUTE_NAME, Organization.class.getName());
                    organizationElement.setAttribute(UID_ATTRIBUTE_NAME, organization.getUid());
                    node.appendChild(organizationElement);
                }
                LinkedHashMap fops = new LinkedHashMap();
                ArrayList commissions = new ArrayList();
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
                Date issueDate = null;
                if (handler != null) {
                    HashMap<ContractType, String> fopsElementNames = new HashMap<ContractType, String>();
                    fopsElementNames.put(ContractType.VENDOR, VENDOR_FOPS_ELEMENT_NAME);
                    fopsElementNames.put(ContractType.SUBAGENCY, SUBAGENT_FOPS_ELEMENT_NAME);
                    fopsElementNames.put(ContractType.CLIENT, CLIENT_FOPS_ELEMENT_NAME);
                    for (GeneralProductContractRelationData generalProductContractRelationData : handler.getUnmodifiableContractRelations(product)) {
                        ContractType contractType;
                        String fopsElementName;
                        if (generalProductContractRelationData.getDescription() != null && (fopsElementName = (String)fopsElementNames.get(contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)generalProductContractRelationData.getDescription()))) != null) {
                            ArrayList contractTypeFops = (ArrayList)fops.get(fopsElementName);
                            if (contractTypeFops == null) {
                                contractTypeFops = new ArrayList();
                                fops.put(fopsElementName, contractTypeFops);
                            }
                            contractTypeFops.addAll(generalProductContractRelationData.getFops());
                        }
                        commissions.addAll(generalProductContractRelationData.getCommissions());
                    }
                    issueDate = handler.findIssueDate(product);
                }
                if (fops.size() > 0 && (productFopType = (String)productFopElementTypes.get(product.getClass().getName())) != null) {
                    for (Map.Entry entry : fops.entrySet()) {
                        String fopsElementName = (String)entry.getKey();
                        List productFops = (List)entry.getValue();
                        if (productFops.size() <= 0) continue;
                        Element fopsElement = node.getOwnerDocument().createElement(fopsElementName);
                        for (GeneralProductFop productFop : productFops) {
                            Element itemElement = node.getOwnerDocument().createElement(ITEM_ELEMENT_NAME);
                            itemElement.setAttribute(TYPE_ATTRIBUTE_NAME, productFopType);
                            itemElement.setAttribute(UID_ATTRIBUTE_NAME, productFop.getUid());
                            fopsElement.appendChild(itemElement);
                        }
                        node.appendChild(fopsElement);
                    }
                }
                if (commissions.size() > 0 && (commissionType = (String)commissionElementTypes.get(product.getClass().getName())) != null && commissions.size() > 0) {
                    Element commissionsElement = node.getOwnerDocument().createElement(COMMISSIONS_ELEMENT_NAME);
                    for (GeneralProductCommission commission : commissions) {
                        Element itemElement = node.getOwnerDocument().createElement(ITEM_ELEMENT_NAME);
                        itemElement.setAttribute(TYPE_ATTRIBUTE_NAME, commissionType);
                        itemElement.setAttribute(UID_ATTRIBUTE_NAME, commission.getUid());
                        commissionsElement.appendChild(itemElement);
                    }
                    node.appendChild(commissionsElement);
                }
                for (GeneralProductCommission commission : commissions) {
                    void var27_37;
                    if (commission.getAmount() == null || commission.getAmount().getCurrency() == null) continue;
                    Object var27_34 = null;
                    if (type.equals(Product.class.getName())) {
                        BigDecimal bigDecimal = RateHelper.getCurrencyRate(null, commission.getAmount().getCurrency(), (Product)product, RulesHelper.isFeeForRefund((EntityReference<BaseCommissionProperties>)commission.getCommissionProperties()), new ArrayList<ValidationMessage>());
                    } else {
                        BigDecimal bigDecimal = RateHelper.getCurrencyRate(commission.getAmount().getCurrency(), issueDate, new ArrayList<ValidationMessage>());
                    }
                    commissionRates.put(commission.getUid(), var27_37);
                }
            }
            if (type.equals(Product.class.getName())) {
                product = (Product)StandardXMLExportHandler.findProductByUid(entities, Product.class, uid);
                BigDecimal equivalentFare = product != null ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO;
                Text equivalentFareTextNode = node.getOwnerDocument().createTextNode(equivalentFare != null ? equivalentFare.toString() : BigDecimal.ZERO.toString());
                Element equivalentFareElement = node.getOwnerDocument().createElement(EQUIVALENT_FARE_ELEMENT_NAME);
                equivalentFareElement.appendChild(equivalentFareTextNode);
                node.appendChild(equivalentFareElement);
                BigDecimal totalEquivalentFare = product != null ? AirProductHelper.getTotalEquivalentFare((Product)product) : BigDecimal.ZERO;
                Text totalEquivalentFareTextNode = node.getOwnerDocument().createTextNode(totalEquivalentFare != null ? totalEquivalentFare.toString() : BigDecimal.ZERO.toString());
                Element totalEquivalentFareElement = node.getOwnerDocument().createElement(TOTAL_EQUIVALENT_FARE_ELEMENT_NAME);
                totalEquivalentFareElement.appendChild(totalEquivalentFareTextNode);
                node.appendChild(totalEquivalentFareElement);
            }
            if (!type.equals(ValidationMessage.class.getName()) || (validationMessage = StandardXMLExportHandler.findEntityByUid(entities, ValidationMessage.class, uid)) == null || validationMessage.getMessage() == null) continue;
            Text textTextNode = node.getOwnerDocument().createTextNode(validationMessage.getMessage().toString());
            Element textElement = node.getOwnerDocument().createElement(TEXT_ELEMENT_NAME);
            textElement.appendChild(textTextNode);
            node.appendChild(textElement);
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            BigDecimal rate;
            type = null;
            uid = null;
            node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute(UID_ATTRIBUTE_NAME);
            if (TextUtil.isBlank((String)type) || TextUtil.isBlank((String)uid) || !commissionTypes.contains(type) || (rate = (BigDecimal)commissionRates.get(uid)) == null) continue;
            Text rateTextNode = node.getOwnerDocument().createTextNode(rate.toString());
            Element rateElement = node.getOwnerDocument().createElement(CURRENCY_RATE_ELEMENT_NAME);
            rateElement.appendChild(rateTextNode);
            node.appendChild(rateElement);
        }
    }

    private static <T extends BaseEntity, C extends BaseEntity> C findEntityByUid(List<T> entities, Class<C> type, String uid) {
        for (BaseEntity entity : entities) {
            BaseEntity object = EntityStorageHelper.findNestedEntity((BaseEntity)entity, (String)uid, type, new HashSet());
            if (object == null) continue;
            return (C)object;
        }
        return null;
    }

    private static <T extends BaseEntity, C extends BaseProduct> BaseProduct findProductByUid(List<T> entities, Class<C> type, String uid) {
        BaseProduct product = (BaseProduct)StandardXMLExportHandler.findEntityByUid(entities, type, uid);
        if (product != null) {
            return product;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)uid));
        EntityContainer bookingFileContainer = EntityStorage.get().find(CommonProductIndex.class, "navigationKey", (Object)uid);
        if (bookingFileContainer != null) {
            return BookingHelper.findProductByUid(uid, (BookingFile)bookingFileContainer.getEntity());
        }
        return null;
    }
}

