/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.xml.XMLExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.XMLExportHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public final class XMLEntityExportHelper {
    private static <T extends BaseEntity> T resolveEntityReference(EntityReference<T> entityReference) throws Exception {
        EntityContainer entityContainer = EntityStorage.get().resolve(entityReference);
        if (entityContainer != null) {
            return (T)entityContainer.getEntity();
        }
        return null;
    }

    public static <T extends BaseEntity> Document exportEntityReference(EntityReference<T> entityReference, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<EntityReference<T>> entityReferences = new ArrayList<EntityReference<T>>();
        entityReferences.add(entityReference);
        return XMLEntityExportHelper.exportEntityReferences(entityReferences, filters, messages);
    }

    public static <T extends BaseEntity> Document exportEntityReferences(List<EntityReference<T>> entityReferences, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> entities = new ArrayList<T>();
        for (EntityReference<T> entityReference : entityReferences) {
            T entity = XMLEntityExportHelper.resolveEntityReference(entityReference);
            if (entity != null) {
                entities.add(entity);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 %s (%s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", entityReference.getCaption(), entityReference.getType().getName()), new Object[0]));
        }
        return XMLEntityExportHelper.export(entities, filters, messages);
    }

    public static <T extends BaseEntity> Document export(T entity, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> entities = new ArrayList<T>();
        entities.add(entity);
        return XMLEntityExportHelper.export(entities, filters, messages);
    }

    public static <T extends BaseEntity> Document export(List<T> entities, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        Document document = XMLExportHelper.export(entities, filters, messages);
        for (XMLExportHandler handler : HandlersRegistry.get().getAllExportHandlers()) {
            handler.updateDocument(entities, document);
        }
        return document;
    }
}

