/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.export.xml;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.export.ExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLExportHelper {
    private static final Logger log = LoggerFactory.getLogger(XMLExportHelper.class);
    public static final String BOOKINGS_ENCODING = "UTF-8";
    public static final String NAME_SPACE = "http://www.gridnine.com/mom/ns/bookings/";
    private static final String ROOT_ELEMENT_NAME = "export";
    private static final String ENTITIES_ELEMENT_NAME = "entities";
    private static final String ENTITY_ELEMENT_NAME = "entity";
    private static final String DICTIONARIES_ELEMENT_NAME = "dictionaries";
    private static final String DICTIONARY_ELEMENT_NAME = "dictionary";
    private static final String UID_ATTRIBUTE_NAME = "uid";
    private static final String TYPE_ATTRIBUTE_NAME = "class";
    private static final String CAPTION_ATTRIBUTE_NAME = "caption";
    private static final String CAPTION_ATTRIBUTE_CODE = "code";
    private static final String UID_ELEMENT_NAME = "uid";
    private static final String TYPE_ELEMENT_NAME = "type";
    private static final String CAPTION_ELEMENT_NAME = "caption";
    private static final String NESTED_UID_ELEMENT_NAME = "nestedEntityUid";
    private static final String NESTED_TYPE_ELEMENT_NAME = "nestedEntityType";
    private static final String LINK_UID_ATTRIBUTE_NAME = "uid";
    private static final String LINK_CTR_UID_ATTRIBUTE_NAME = "ctrUid";
    private static final String LINK_TYPE_ATTRIBUTE_NAME = "type";
    private static final String LINK_NESTED_UID_ATTRIBUTE_NAME = "ctrUid";
    private static final String LINK_NESTED_TYPE_ATTRIBUTE_NAME = "ctrType";
    private static final String TARGET_UID_ATTRIBUTE_NAME = "uid";
    private static final String TARGET_TYPE_ATTRIBUTE_NAME = "type";
    private static final boolean debug = false;
    private static ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return -1;
        }
    };

    private static boolean accept(List<XMLFilterHelper.XMLFilter> filters, String path) {
        if (filters == null || TextUtil.isBlank((String)path)) {
            return true;
        }
        for (XMLFilterHelper.XMLFilter filter : filters) {
            if (filter.accept(path)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean processEntityReferenceNode(BaseEntity rootEntity, BaseEntity parentEntity, Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, String path, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        String uid = null;
        String type = null;
        String caption = null;
        String nestedUid = null;
        String nestedType = null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Node valueNode;
                if ("uid".equals(child.getNodeName())) {
                    valueNode = child.getFirstChild();
                    if (valueNode != null && valueNode.getNodeType() == 3) {
                        uid = valueNode.getNodeValue();
                    }
                } else if ("type".equals(child.getNodeName())) {
                    valueNode = child.getFirstChild();
                    if (valueNode != null && valueNode.getNodeType() == 3) {
                        type = valueNode.getNodeValue();
                    }
                } else if ("caption".equals(child.getNodeName())) {
                    valueNode = child.getFirstChild();
                    if (valueNode != null && valueNode.getNodeType() == 4) {
                        caption = valueNode.getNodeValue();
                    }
                } else if (NESTED_UID_ELEMENT_NAME.equals(child.getNodeName())) {
                    valueNode = child.getFirstChild();
                    if (valueNode != null && valueNode.getNodeType() == 3) {
                        nestedUid = valueNode.getNodeValue();
                    }
                } else if (NESTED_TYPE_ELEMENT_NAME.equals(child.getNodeName()) && (valueNode = child.getFirstChild()) != null && valueNode.getNodeType() == 3) {
                    nestedType = valueNode.getNodeValue();
                }
            }
            if (!TextUtil.isBlank(uid) && !TextUtil.isBlank(type) && !TextUtil.isBlank(caption) && !TextUtil.isBlank(nestedUid) && !TextUtil.isBlank(nestedType)) break;
        }
        if (TextUtil.isBlank(uid)) return true;
        if (TextUtil.isBlank(type)) return true;
        if (!XMLExportHelper.accept(filters, path)) {
            node.getParentNode().removeChild(node);
            return false;
        }
        EntityReference entityReference = new EntityReference(uid, XHelper.getClass(type), caption);
        Object entity = resolver.resolve(entityReference);
        if (entity == null) {
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s (\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s, \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", entityReference.getCaption(), entityReference.getType().getName(), rootEntity, rootEntity.getClass().getName(), parentEntity, parentEntity.getClass().getName()), new Object[0]));
            node.getParentNode().removeChild(node);
            return false;
        }
        String ctrUid = uid;
        uid = entity.getUid();
        if (rootUids.get(type) == null || !rootUids.get(type).contains(uid)) {
            Map<String, NodeInfo> nodeInfos = entityNodeInfos.get(type);
            if (nodeInfos == null) {
                nodeInfos = new HashMap<String, NodeInfo>();
                entityNodeInfos.put(type, nodeInfos);
            }
            if (!nodeInfos.keySet().contains(uid)) {
                Element element = node.getOwnerDocument().createElement(ENTITY_ELEMENT_NAME);
                element.setAttribute("type", type);
                element.setAttribute("uid", uid);
                NodeInfo nodeInfo = new NodeInfo();
                nodeInfo.setJunk(true);
                nodeInfo.setNode(element);
                nodeInfos.put(uid, nodeInfo);
                entity.toXML(element);
                XMLExportHelper.processNode(rootEntity, entity, element, rootUids, entityNodeInfos, dictionaryNodeInfos, type, filters, true, resolver, messages);
            }
        }
        Element element = node.getOwnerDocument().createElement(node.getNodeName());
        if (TextUtil.isBlank((String)nestedType)) {
            element.setAttribute("type", type);
            element.setAttribute("uid", uid);
            element.setAttribute("ctrUid", ctrUid);
        } else {
            element.setAttribute(LINK_NESTED_TYPE_ATTRIBUTE_NAME, type);
            element.setAttribute("ctrUid", ctrUid);
            element.setAttribute("type", nestedType);
            element.setAttribute("uid", nestedUid);
        }
        node.getParentNode().replaceChild(element, node);
        return true;
    }

    private static boolean processEntityNode(BaseEntity rootEntity, BaseEntity parentEntity, Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, String path, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        boolean embedded;
        String type = null;
        String uid = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute("uid");
        }
        if (embedded = TextUtil.isBlank(uid)) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node valueNode;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !"uid".equals(child.getNodeName()) || (valueNode = child.getFirstChild()) == null || valueNode.getNodeType() != 3) continue;
                uid = valueNode.getNodeValue();
                break;
            }
        }
        if (!TextUtil.isBlank(uid) && !TextUtil.isBlank((String)type)) {
            if (rootUids.get(type) == null || !rootUids.get(type).contains(uid)) {
                Map<String, NodeInfo> nodeInfos = entityNodeInfos.get(type);
                if (nodeInfos == null) {
                    nodeInfos = new HashMap<String, NodeInfo>();
                    entityNodeInfos.put(type, nodeInfos);
                }
                if (embedded && !nodeInfos.keySet().contains(uid)) {
                    Element element = node.getOwnerDocument().createElement(ENTITY_ELEMENT_NAME);
                    element.setAttribute("type", type);
                    element.setAttribute("uid", uid);
                    NodeInfo nodeInfo = new NodeInfo();
                    nodeInfo.setJunk(true);
                    nodeInfo.setNode(element);
                    nodeInfos.put(uid, nodeInfo);
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        element.appendChild(children.item(i).cloneNode(true));
                    }
                    XMLExportHelper.processNode(rootEntity, parentEntity, element, rootUids, entityNodeInfos, dictionaryNodeInfos, type, filters, true, resolver, messages);
                }
            }
            if (XMLExportHelper.accept(filters, path)) {
                Element element = node.getOwnerDocument().createElement(node.getNodeName());
                element.setAttribute("type", type);
                element.setAttribute("uid", uid);
                node.getParentNode().replaceChild(element, node);
            } else {
                node.getParentNode().removeChild(node);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean processDictionaryReferenceNode(BaseEntity rootEntity, BaseEntity parentEntity, Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, String path, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        Node valueNode;
        String uid = null;
        String type = null;
        String caption = null;
        String code = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            caption = element.getAttribute("caption");
            code = element.getAttribute(CAPTION_ATTRIBUTE_CODE);
        }
        if ((valueNode = node.getFirstChild()) != null && valueNode.getNodeType() == 3) {
            uid = valueNode.getNodeValue();
        }
        if (uid == null && code != null) {
            uid = code;
        }
        if (TextUtil.isBlank(uid)) return true;
        if (TextUtil.isBlank((String)type)) return true;
        if (!XMLExportHelper.accept(filters, path)) {
            node.getParentNode().removeChild(node);
            return false;
        }
        DictionaryReference dictionaryReference = (DictionaryReference)XHelper.getClass((String)type).newInstance();
        dictionaryReference.setCode(uid);
        dictionaryReference.setCaption(caption);
        Object dictionary = resolver.resolve(dictionaryReference);
        if (dictionary == null) {
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \"%s\" \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0442\u0438\u043f\u0430 %s (\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s, \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", dictionaryReference.getCaption(), dictionaryReference.getCode(), dictionaryReference.getType().getName(), rootEntity, rootEntity.getClass().getName(), parentEntity, parentEntity.getClass().getName()), new Object[0]));
            node.getParentNode().removeChild(node);
            return false;
        }
        type = dictionary.getClass().getName();
        uid = dictionary.getUid();
        if (rootUids.get(type) == null || !rootUids.get(type).contains(uid)) {
            Map<String, NodeInfo> nodeInfos = dictionaryNodeInfos.get(type);
            if (nodeInfos == null) {
                nodeInfos = new HashMap<String, NodeInfo>();
                dictionaryNodeInfos.put(type, nodeInfos);
            }
            if (!nodeInfos.keySet().contains(uid)) {
                Element element = node.getOwnerDocument().createElement(DICTIONARY_ELEMENT_NAME);
                element.setAttribute("type", type);
                element.setAttribute("uid", uid);
                NodeInfo nodeInfo = new NodeInfo();
                nodeInfo.setJunk(true);
                nodeInfo.setNode(element);
                nodeInfos.put(uid, nodeInfo);
                dictionary.toXML(element);
                XMLExportHelper.processNode(rootEntity, dictionary, element, rootUids, entityNodeInfos, dictionaryNodeInfos, type, filters, true, resolver, messages);
            }
        }
        Element element = node.getOwnerDocument().createElement(node.getNodeName());
        element.setAttribute("type", type);
        element.setAttribute("uid", uid);
        node.getParentNode().replaceChild(element, node);
        return true;
    }

    private static boolean processProperty(BaseEntity rootEntity, BaseEntity parentEntity, Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, String path, List<XMLFilterHelper.XMLFilter> filters, boolean root, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            boolean success = XMLExportHelper.processNode(rootEntity, parentEntity, children.item(i), rootUids, entityNodeInfos, dictionaryNodeInfos, XMLFilterHelper.buildPath(path, children.item(i).getNodeName()), filters, false, resolver, messages);
            if (success) continue;
            --i;
        }
        if (!root && !XMLExportHelper.accept(filters, path)) {
            node.getParentNode().removeChild(node);
            return false;
        }
        return true;
    }

    private static boolean processNode(BaseEntity rootEntity, BaseEntity parentEntity, Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, String path, List<XMLFilterHelper.XMLFilter> filters, boolean root, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        boolean success = true;
        if (node.getNodeType() == 1) {
            Class clazz;
            Element element = (Element)node;
            String typeString = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            success = !root && !TextUtil.isBlank((String)typeString) ? (EntityReference.class.isAssignableFrom(clazz = XHelper.getClass((String)typeString)) ? XMLExportHelper.processEntityReferenceNode(rootEntity, parentEntity, element, rootUids, entityNodeInfos, dictionaryNodeInfos, path, filters, resolver, messages) : (BaseEntity.class.isAssignableFrom(clazz) ? XMLExportHelper.processEntityNode(rootEntity, parentEntity, element, rootUids, entityNodeInfos, dictionaryNodeInfos, path, filters, resolver, messages) : (DictionaryReference.class.isAssignableFrom(clazz) ? XMLExportHelper.processDictionaryReferenceNode(rootEntity, parentEntity, element, rootUids, entityNodeInfos, dictionaryNodeInfos, path, filters, resolver, messages) : XMLExportHelper.processProperty(rootEntity, parentEntity, node, rootUids, entityNodeInfos, dictionaryNodeInfos, path, filters, root, resolver, messages)))) : XMLExportHelper.processProperty(rootEntity, parentEntity, node, rootUids, entityNodeInfos, dictionaryNodeInfos, path, filters, root, resolver, messages);
        }
        return success;
    }

    private static boolean validateDictionaryNode(Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, List<Message> messages) throws Exception {
        NodeInfo nodeInfo;
        Map<String, NodeInfo> nodeInfos;
        String type = null;
        String uid = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            type = element.getAttribute("type");
            uid = element.getAttribute("uid");
        }
        if (!(TextUtil.isBlank(uid) || TextUtil.isBlank(type) || rootUids.get(type) != null && rootUids.get(type).contains(uid) || (nodeInfos = dictionaryNodeInfos.get(type)) == null || !nodeInfos.keySet().contains(uid) || !(nodeInfo = nodeInfos.get(uid)).isJunk())) {
            nodeInfo.setJunk(false);
            XMLExportHelper.validateNode(nodeInfo.getNode(), rootUids, entityNodeInfos, dictionaryNodeInfos, true, messages);
        }
        return true;
    }

    private static boolean validateEntityNode(Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, List<Message> messages) throws Exception {
        NodeInfo nodeInfo;
        Map<String, NodeInfo> nodeInfos;
        String type = null;
        String uid = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            type = element.getAttribute("type");
            uid = element.getAttribute("uid");
        }
        if (!(TextUtil.isBlank(uid) || TextUtil.isBlank(type) || rootUids.get(type) != null && rootUids.get(type).contains(uid) || (nodeInfos = entityNodeInfos.get(type)) == null || !nodeInfos.keySet().contains(uid) || !(nodeInfo = nodeInfos.get(uid)).isJunk())) {
            nodeInfo.setJunk(false);
            XMLExportHelper.validateNode(nodeInfo.getNode(), rootUids, entityNodeInfos, dictionaryNodeInfos, true, messages);
        }
        return true;
    }

    private static boolean validatePropertyNode(Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, List<Message> messages) throws Exception {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XMLExportHelper.validateNode(children.item(i), rootUids, entityNodeInfos, dictionaryNodeInfos, false, messages);
        }
        return true;
    }

    private static boolean validateNode(Node node, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos, boolean root, List<Message> messages) throws Exception {
        boolean success = true;
        if (node.getNodeType() == 1) {
            Class clazz;
            Element element = (Element)node;
            String typeString = element.getAttribute("type");
            success = !root && !TextUtil.isBlank((String)typeString) ? (BaseDictionary.class.isAssignableFrom(clazz = XHelper.getClass((String)typeString)) ? XMLExportHelper.validateDictionaryNode(element, rootUids, entityNodeInfos, dictionaryNodeInfos, messages) : (BaseEntity.class.isAssignableFrom(clazz) ? XMLExportHelper.validateEntityNode(element, rootUids, entityNodeInfos, dictionaryNodeInfos, messages) : XMLExportHelper.validatePropertyNode(node, rootUids, entityNodeInfos, dictionaryNodeInfos, messages))) : XMLExportHelper.validatePropertyNode(node, rootUids, entityNodeInfos, dictionaryNodeInfos, messages);
        }
        return success;
    }

    public static <T extends BaseEntity> Document exportEntityReference(BaseEntity rootEntity, BaseEntity parentEntity, EntityReference<T> entityReference, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<EntityReference<T>> entityReferences = new ArrayList<EntityReference<T>>();
        entityReferences.add(entityReference);
        return XMLExportHelper.exportEntityReferences(rootEntity, parentEntity, entityReferences, filters, messages);
    }

    public static <T extends BaseEntity> Document exportEntityReferences(BaseEntity rootEntity, BaseEntity parentEntity, List<EntityReference<T>> entityReferences, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> entities = new ArrayList<T>();
        for (EntityReference<T> entityReference : entityReferences) {
            T entity = ExportHelper.standardResolver.resolve(entityReference);
            if (entity != null) {
                entities.add(entity);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442", String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s (\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s, \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", entityReference.getCaption(), entityReference.getType().getName(), rootEntity, rootEntity.getClass().getName(), parentEntity, parentEntity.getClass().getName()), new Object[0]));
        }
        return XMLExportHelper.export(entities, filters, messages);
    }

    public static <T extends BaseDictionary> Document exportDictionaryReference(BaseEntity rootEntity, BaseEntity parentEntity, DictionaryReference<T> dictionaryReference, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<DictionaryReference<T>> dictionaryReferences = new ArrayList<DictionaryReference<T>>();
        dictionaryReferences.add(dictionaryReference);
        return XMLExportHelper.exportDictionaryReferences(rootEntity, parentEntity, dictionaryReferences, filters, messages);
    }

    public static <T extends BaseDictionary> Document exportDictionaryReferences(BaseEntity rootEntity, BaseEntity parentEntity, List<DictionaryReference<T>> dictionaryReferences, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> dictionaries = new ArrayList<T>();
        for (DictionaryReference<T> dictionaryReference : dictionaryReferences) {
            T dictionary = ExportHelper.standardResolver.resolve(dictionaryReference);
            if (dictionary != null) {
                dictionaries.add(dictionary);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \"%s\" \u0441 \u043a\u043e\u0434\u043e\u043c %s \u0442\u0438\u043f\u0430 %s (\u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s, \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \"%s\" \u0442\u0438\u043f\u0430 %s) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", dictionaryReference.getCaption(), dictionaryReference.getCode(), dictionaryReference.getType().getName(), rootEntity, rootEntity.getClass().getName(), parentEntity, parentEntity.getClass().getName()), new Object[0]));
        }
        return XMLExportHelper.export(dictionaries, filters, messages);
    }

    public static <T extends BaseEntity> Document export(T entity, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        ArrayList<T> entites = new ArrayList<T>();
        entites.add(entity);
        return XMLExportHelper.export(entites, filters, messages);
    }

    public static <T extends BaseEntity> Document export(List<T> entities, List<XMLFilterHelper.XMLFilter> filters, List<Message> messages) throws Exception {
        return XMLExportHelper.export(entities, filters, ExportHelper.standardResolver, messages);
    }

    public static <T extends BaseEntity> Document export(List<T> entities, List<XMLFilterHelper.XMLFilter> filters, ExportHelper.ObjectResolver resolver, List<Message> messages) throws Exception {
        Document document = DocumentBuilderHelper.newDocument();
        Element rootElement = document.createElementNS(null, ROOT_ELEMENT_NAME);
        document.appendChild(rootElement);
        HashMap<String, List<String>> rootUids = new HashMap<String, List<String>>();
        TreeMap<String, Map<String, NodeInfo>> entityNodeInfos = new TreeMap<String, Map<String, NodeInfo>>();
        TreeMap<String, Map<String, NodeInfo>> dictionaryNodeInfos = new TreeMap<String, Map<String, NodeInfo>>();
        TreeMap<String, Object> groupElements = new TreeMap<String, Object>();
        for (BaseEntity entity : entities) {
            if (entity == null) continue;
            String entityElementName = TextUtil.decapitalize((String)MiscUtil.getSimpleClassName(entity.getClass()));
            Object groupElement = (Node)groupElements.get(entityElementName);
            if (groupElement == null) {
                groupElement = rootElement.getOwnerDocument().createElementNS(null, String.format("%ss", entityElementName));
                groupElements.put(entityElementName, groupElement);
            }
            Element itemElement = groupElement.getOwnerDocument().createElementNS(null, entityElementName);
            String type = entity.getClass().getName();
            String uid = entity.getUid();
            XMLExportHelper.addRootUid(type, uid, rootUids, entityNodeInfos, dictionaryNodeInfos);
            itemElement.setAttribute("type", type);
            itemElement.setAttribute("uid", uid);
            groupElement.appendChild(itemElement);
            entity.toXML(itemElement);
            XMLExportHelper.processNode(entity, entity, itemElement, rootUids, entityNodeInfos, dictionaryNodeInfos, type, filters, true, resolver, messages);
            XMLExportHelper.validateNode(itemElement, rootUids, entityNodeInfos, dictionaryNodeInfos, true, messages);
        }
        for (Object groupElement : groupElements.values()) {
            rootElement.appendChild((Node)groupElement);
        }
        Element entitiesElement = rootElement.getOwnerDocument().createElementNS(null, ENTITIES_ELEMENT_NAME);
        rootElement.appendChild(entitiesElement);
        for (Map nodeInfos : entityNodeInfos.values()) {
            for (NodeInfo nodeInfo : nodeInfos.values()) {
                if (nodeInfo.isJunk()) continue;
                entitiesElement.appendChild(nodeInfo.getNode());
            }
        }
        Element dictionariesElement = rootElement.getOwnerDocument().createElementNS(null, DICTIONARIES_ELEMENT_NAME);
        rootElement.appendChild(dictionariesElement);
        for (Map nodeInfos : dictionaryNodeInfos.values()) {
            for (NodeInfo nodeInfo : nodeInfos.values()) {
                if (nodeInfo.isJunk()) continue;
                dictionariesElement.appendChild(nodeInfo.getNode());
            }
        }
        return document;
    }

    private static void addRootUid(String type, String uid, Map<String, List<String>> rootUids, Map<String, Map<String, NodeInfo>> entityNodeInfos, Map<String, Map<String, NodeInfo>> dictionaryNodeInfos) {
        List<String> uids = rootUids.get(type);
        if (uids == null) {
            uids = new ArrayList<String>();
            rootUids.put(type, uids);
        }
        if (!uids.contains(uid)) {
            NodeInfo nodeInfo;
            Map<String, NodeInfo> dictionaryNodes;
            NodeInfo nodeInfo2;
            uids.add(uid);
            Map<String, NodeInfo> entityNodes = entityNodeInfos.get(type);
            if (entityNodes != null && (nodeInfo2 = entityNodes.get(uid)) != null) {
                nodeInfo2.setJunk(true);
            }
            if ((dictionaryNodes = dictionaryNodeInfos.get(type)) != null && (nodeInfo = dictionaryNodes.get(uid)) != null) {
                nodeInfo.setJunk(true);
            }
        }
    }

    private static void resetDepth() {
        depth.set(-1);
    }

    private static void incrementDepth() {
        depth.set(depth.get() + 1);
    }

    private static void decrementDepth() {
        depth.set(depth.get() - 1);
    }

    private static void debug(String str, Object ... arg) {
        System.out.format(TextUtil.repeat((String)"\t", (int)depth.get()) + str + "\n", arg);
    }

    private static class NodeInfo {
        private boolean junk;
        private Node node;

        private NodeInfo() {
        }

        public void setJunk(boolean junk) {
            this.junk = junk;
        }

        public boolean isJunk() {
            return this.junk;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

