/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationActions;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractSynchronizationUtil {
    private static final Logger log = LoggerFactory.getLogger(ContractSynchronizationUtil.class);

    public static Map<String, List<String>> createContractList(EntityReference<Organization> orgRef, List<MiscUtil.Pair<RuleTarget, String>> transactionFeesForGeneralInfoSection) {
        List<EntityContainer<Contract>> contracts;
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        res.put("TRANSACTION FEES", new ArrayList());
        res.put("PAYMENT", new ArrayList());
        Date now = new Date();
        try {
            contracts = ContractSynchronizationUtil.findNewClientContracts(orgRef, now);
            if (contracts.isEmpty()) {
                contracts = ContractSynchronizationUtil.findOldClientContracts(orgRef, now);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return res;
        }
        block2: for (EntityContainer<Contract> contract : contracts) {
            List<String> remarks = ContractSynchronizationUtil.getFeesRemarks(ProfileHelper.getRuleContainers(contract, now).stream().map(c -> ((BaseRulesContainer)c.getEntity()).getRuleSet()).filter(Objects::nonNull).collect(Collectors.toList()), "", "", transactionFeesForGeneralInfoSection);
            List ruleRemarks = (List)res.get("TRANSACTION FEES");
            ruleRemarks.addAll(ProfileSynchronizationUtil.prepareRemarkListForSabre(remarks, ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.F)));
            res.put("TRANSACTION FEES", ruleRemarks);
            if (((Contract)contract.getEntity()).isNewModel()) {
                List detailRemarks = (List)res.get("PAYMENT");
                List<String> remarks2 = ContractSynchronizationUtil.getNewPaymentConditionsRemarks((Contract)contract.getEntity());
                detailRemarks.addAll(ProfileSynchronizationUtil.prepareRemarkListForSabre(remarks2, ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.P)));
                res.put("PAYMENT", detailRemarks);
                continue;
            }
            for (ContractCustomerInfo cci : ((Contract)contract.getEntity()).getCustomers()) {
                if (cci == null || cci.getCustomer() == null || !cci.getCustomer().getUid().equals(orgRef.getUid())) continue;
                List detailRemarks = (List)res.get("PAYMENT");
                List<String> remarks2 = ContractSynchronizationUtil.getOldPaymentConditionsRemarks(cci);
                detailRemarks.addAll(ProfileSynchronizationUtil.prepareRemarkListForSabre(remarks2, ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.P)));
                res.put("PAYMENT", detailRemarks);
                continue block2;
            }
        }
        return res;
    }

    public static List<EntityContainer<Contract>> findOldClientContracts(EntityReference<Organization> orgRef, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), orgRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.disabled.name(), (Object)false));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)date)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)date)}));
        List indexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        return indexes.stream().map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<EntityContainer<Contract>> findNewClientContracts(EntityReference<Organization> orgRef, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), orgRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)false));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)date)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)date)}));
        List indexes = EntityStorage.get().search(ContractIndex.class, query).getData();
        return indexes.stream().map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<String> getFeesRemarks(List<RuleSet> rules, String serviceLineType, String subsectionLineType, List<MiscUtil.Pair<RuleTarget, String>> transactionFeesForGeneralInfoSection) {
        ArrayList<String> result = new ArrayList<String>();
        for (RuleSet ruleSet : rules) {
            for (RuleSettings rs : ruleSet.getRules()) {
                if (rs.getTarget() == null || !MiscUtil.isBetween((Date)rs.getPeriodBegin(), (Date)rs.getPeriodEnd(), (Date)new Date())) continue;
                for (RuleResult rr : rs.getResults()) {
                    String remark;
                    String val2;
                    String val1;
                    String template;
                    SabreRemarkResult res;
                    if (SabreSynchronizationActions.ADD_REMARK2 == rr.getAction()) {
                        res = (SabreRemarkResult)rr.getValue();
                        template = res.getTemplate();
                        val1 = "";
                        String string = val2 = res.getCurrencyCode() != null ? res.getCurrencyCode() : "";
                        if (res.getValue() != null) {
                            if (res.getValue().intValue() == 0) {
                                val1 = "FREE";
                                val2 = "";
                            } else {
                                val1 = res.getValue().toString();
                            }
                        }
                        if (TextUtil.isBlank((String)template)) continue;
                        String templateWithPrefix = "TR.FEE." + template;
                        String remarkForRemarksSection = RulesHelper.buildContractRemarkByTemplate(templateWithPrefix, val1, val2, true, true);
                        String remarkForGeneralInfoSection = RulesHelper.buildContractRemarkByTemplate(template, val1, val2, false, false);
                        if (!TextUtil.isBlank((String)remarkForRemarksSection)) {
                            result.add(remarkForRemarksSection);
                        }
                        if (TextUtil.isBlank((String)remarkForGeneralInfoSection)) continue;
                        transactionFeesForGeneralInfoSection.add((MiscUtil.Pair<RuleTarget, String>)new MiscUtil.Pair((Object)rs.getTarget(), (Object)remarkForGeneralInfoSection));
                        continue;
                    }
                    if (AviaTripartiteContractActions.AVIA_TEMPLATE_REMARK != rr.getAction() && HotelTripartiteContractActions.HOTEL_TEMPLATE_REMARK != rr.getAction() && CarTripartiteContractActions.CAR_TEMPLATE_REMARK != rr.getAction()) continue;
                    res = (SabreRemarkResult)rr.getValue();
                    template = res.getTemplate();
                    val1 = "";
                    String string = val2 = res.getCurrencyCode() != null ? res.getCurrencyCode() : "";
                    if (res.getValue() != null) {
                        if (res.getValue().intValue() == 0) {
                            val1 = "FREE";
                            val2 = "";
                        } else {
                            val1 = res.getValue().toString();
                        }
                    }
                    if (TextUtil.isBlank((String)template) || TextUtil.isBlank((String)(remark = RulesHelper.buildContractRemarkByTemplate(template = serviceLineType + " " + subsectionLineType + " / " + template, val1, val2, false, true)))) continue;
                    result.add(remark);
                }
            }
        }
        return result;
    }

    private static List<String> getOldPaymentConditionsRemarks(ContractCustomerInfo customer) {
        ArrayList<String> result = new ArrayList<String>();
        for (PaymentConditionItem item : customer.getPaymentConditions().getPaymentItems()) {
            if (TextUtil.isBlank((String)item.getSabreRemark())) continue;
            result.add(item.getSabreRemark().trim());
        }
        return result;
    }

    private static List<String> getNewPaymentConditionsRemarks(Contract contract) {
        ArrayList<String> result = new ArrayList<String>();
        for (PaymentConditionItem item : contract.getPaymentConditions().getPaymentItems()) {
            if (TextUtil.isBlank((String)item.getSabreRemark())) continue;
            result.add(item.getSabreRemark().trim());
        }
        return result;
    }
}

