/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeConcurType;
import com.gridnine.xtrip.common.model.dict.CostCodeConnectProfileType;
import com.gridnine.xtrip.common.model.dict.CostCodeExternalType;
import com.gridnine.xtrip.common.model.dict.CostCodeKdsType;
import com.gridnine.xtrip.common.model.dict.CostCodeRaketaType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.l10n.Messages;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.ISuiteCostCodesSyncSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.SabreProfilesCostCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CostCodesHelper {
    private static final String OTH = "OTH";
    public static final List<String> UNSUPPORTED_SYMBOLS = Arrays.asList("'");

    public static boolean isCostCodeContainsUnsupportedSymbols(String costCodeValue) {
        return UNSUPPORTED_SYMBOLS.stream().anyMatch(costCodeValue::contains);
    }

    static CostCodeInfo createCostCodeInfo(PersonCostCode costCode, CostCodeProperties costCodeProperties, ExternalSystem externalSystem) {
        return CostCodesHelper.createProcessor(externalSystem).create(costCode, costCodeProperties);
    }

    public static PersonCostCode createPersonCostCode(CostCodeInfo costCodeInfo, EntityContainer<Organization> orgContainer, List<Message> messages) {
        BaseCostCodeInfoProcessor processor = CostCodesHelper.createProcessor(((Organization)orgContainer.getEntity()).getExternalSystem());
        if (costCodeInfo.getType() == null) {
            return null;
        }
        if (costCodeInfo.getType() == SabreProfilesCostCodeType.REFERENCE_INFORMATION && TextUtil.isBlank((String)costCodeInfo.getField())) {
            return null;
        }
        String udidValue = processor.getValue(costCodeInfo);
        if (TextUtil.isBlank((String)udidValue)) {
            return null;
        }
        CostCodeProperties costCodeProperties = processor.searchCostCodeProperties(costCodeInfo, (EntityReference<Organization>)orgContainer.toReference(), messages);
        if (costCodeProperties == null) {
            return null;
        }
        PersonCostCode costCode = new PersonCostCode();
        costCode.setOrganization(orgContainer.toReference());
        costCode.setValue(udidValue);
        costCode.setCostCodeProperties(costCodeProperties);
        return costCode;
    }

    public static void addEmptyCostCodesIfNecessary(EntityContainer<Organization> orgContainer, List<CostCodeInfo> costCodes) {
        CostCodesHelper.createProcessor(((Organization)orgContainer.getEntity()).getExternalSystem()).addEmptyCostCodesIfNecessary(orgContainer, costCodes);
    }

    public static boolean isRemainCostCode(EntityContainer<Organization> orgContainer, PersonCostCode costCode) {
        if (!orgContainer.toReference().equals((Object)costCode.getOrganization())) {
            return true;
        }
        if (costCode.getCostCodeProperties() == null) {
            return true;
        }
        CostCodeProperties costCodeProperties = ProfileSynchronizationUtil.getCostCodePropertiesFromOrganization(costCode, (Organization)orgContainer.getEntity());
        return CostCodesHelper.createProcessor(((Organization)orgContainer.getEntity()).getExternalSystem()).create(costCode, costCodeProperties) == null;
    }

    private static BaseCostCodeInfoProcessor createProcessor(ExternalSystem externalSystem) {
        switch (externalSystem) {
            case KDS: {
                return new KdsCostCodeInfoProcessor();
            }
            case ION: {
                return new IonCostCodeInfoProcessor();
            }
            case CONCUR: {
                return new ConcurCostCodeInfoProcessor();
            }
            case ISUITE: {
                return new ISuiteCostCodeInfoProcessor();
            }
            case CONNECT_PROFILE: {
                return new ConnectProfileCostCodeInfoProcessor();
            }
            case GET_THERE: {
                return new GetThereCostCodeInfoProcessor();
            }
            case RAKETA: {
                return new RaketaCostCodeInfoProcessor();
            }
        }
        throw Xeption.forDeveloper((String)("unsupported external system: " + externalSystem), (Object[])new Object[0]);
    }

    private static String getShortName(CostCodeProperties costCodeProperties) {
        CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
        return costCodeCategory != null ? costCodeCategory.getExternalSystemName() : null;
    }

    private static class RaketaCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private RaketaCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            CostCodeRaketaType raketaType = this.getRaketaType(costCodeProperties);
            if (raketaType == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            switch (raketaType) {
                case CUSTOM_FIELDS: {
                    String shortName = CostCodesHelper.getShortName(costCodeProperties);
                    if (TextUtil.isBlank((String)shortName)) {
                        return null;
                    }
                    result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
                    result.setField(CostCodesHelper.OTH);
                    result.setValue(costCode.getValue());
                    result.setAdditionalInformation(shortName);
                    break;
                }
                default: {
                    result.setType(this.getType(raketaType));
                    result.setValue(costCode.getValue());
                }
            }
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            CostCodeRaketaType raketaType;
            String shortName;
            if (costCodeInfo.getType() == null) {
                return null;
            }
            switch (costCodeInfo.getType()) {
                case REFERENCE_INFORMATION: {
                    if (!CostCodesHelper.OTH.equals(costCodeInfo.getField())) {
                        return null;
                    }
                    shortName = costCodeInfo.getAdditionalInformation();
                    raketaType = CostCodeRaketaType.CUSTOM_FIELDS;
                    break;
                }
                default: {
                    shortName = null;
                    raketaType = this.getType(costCodeInfo.getType());
                }
            }
            if (raketaType == null) {
                return null;
            }
            List costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, null, shortName, costCodeInfo.getValue(), CostCodeCategory::getExternalSystemName).stream().filter(prop -> this.getRaketaType((CostCodeProperties)prop) == raketaType).collect(Collectors.toList());
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.costCodePropertiesNotFoundRaketa), (Object[])new Object[]{organization, raketaType, costCodeInfo.getValue()}));
                return null;
            }
            return (CostCodeProperties)costCodeProperties.get(0);
        }

        private CostCodeRaketaType getRaketaType(CostCodeProperties costCodeProperties) {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            return costCodeCategory != null ? costCodeCategory.getRaketaType() : null;
        }

        private SabreProfilesCostCodeType getType(CostCodeRaketaType raketaType) {
            switch (raketaType) {
                case EMPLOYEE_ID: {
                    return SabreProfilesCostCodeType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return SabreProfilesCostCodeType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return SabreProfilesCostCodeType.COST_CENTER;
                }
                case DIVISION: {
                    return SabreProfilesCostCodeType.DIVISION;
                }
                case COMPANY_NAME: {
                    return SabreProfilesCostCodeType.COMPANY;
                }
            }
            throw Xeption.forDeveloper((String)("unsupported udid type: " + raketaType), (Object[])new Object[0]);
        }

        private CostCodeRaketaType getType(SabreProfilesCostCodeType costCodeType) {
            switch (costCodeType) {
                case EMPLOYEE_ID: {
                    return CostCodeRaketaType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return CostCodeRaketaType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return CostCodeRaketaType.COST_CENTER;
                }
                case DIVISION: {
                    return CostCodeRaketaType.DIVISION;
                }
                case COMPANY: {
                    return CostCodeRaketaType.COMPANY_NAME;
                }
            }
            return null;
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getValue();
        }
    }

    private static class GetThereCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private static final String EMP_NO = "emp_no";
        private static final String COST_CTR = "cost_ctr";
        private static final String DIVISION = "division";
        private static final String DEPARTMENT = "department";
        private static final String COMPANY = "company";
        private static final String CORP_ID = "corp_ID";
        private static final String PROJECT_CODE = "project_code";
        private static final String EXPENSE_CODE = "expense_code";

        private GetThereCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            String getThereType = this.getGetThereType(costCodeProperties);
            if (getThereType == null) {
                return null;
            }
            SabreProfilesCostCodeType costCodeType = this.getType(getThereType);
            CostCodeInfo result = new CostCodeInfo();
            result.setType(costCodeType);
            if (costCodeType == SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE) {
                result.setName(getThereType);
            }
            result.setValue(costCode.getValue());
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            if (costCodeInfo.getType() == null) {
                return null;
            }
            String getThereType = this.getType(costCodeInfo);
            if (getThereType == null) {
                return null;
            }
            List costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, null, null, costCodeInfo.getValue(), CostCodeCategory::getExternalSystemName).stream().filter(prop -> TextUtil.isSame((String)getThereType, (String)this.getGetThereType((CostCodeProperties)prop), (boolean)true)).collect(Collectors.toList());
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.costCodePropertiesNotFoundGetThere), (Object[])new Object[]{organization, getThereType, costCodeInfo.getValue()}));
                return null;
            }
            return (CostCodeProperties)costCodeProperties.get(0);
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getValue();
        }

        @Override
        void addEmptyCostCodesIfNecessary(EntityContainer<Organization> orgContainer, List<CostCodeInfo> costCodes) {
            for (CostCodeProperties costCodeProperties : ((Organization)orgContainer.getEntity()).getCostCodeProperties()) {
                String getThereType = this.getGetThereType(costCodeProperties);
                if (getThereType == null || this.getType(getThereType) != SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE || !costCodes.stream().noneMatch(costCode -> costCode.getType() == SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE && TextUtil.isSame((String)getThereType, (String)costCode.getName()))) continue;
                CostCodeInfo result = new CostCodeInfo();
                result.setType(SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE);
                result.setName(getThereType);
                costCodes.add(result);
            }
        }

        private String getGetThereType(CostCodeProperties costCodeProperties) {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            if (costCodeCategory == null) {
                return null;
            }
            CostCodeExternalType costCodeExternalType = (CostCodeExternalType)DictionaryCache.get().resolveReference(costCodeCategory.getExternalCategoryType());
            return costCodeExternalType != null ? costCodeExternalType.getCode() : null;
        }

        private SabreProfilesCostCodeType getType(String getThereType) {
            switch (getThereType) {
                case "emp_no": {
                    return SabreProfilesCostCodeType.EMPLOYEE_ID;
                }
                case "cost_ctr": {
                    return SabreProfilesCostCodeType.COST_CENTER;
                }
                case "division": {
                    return SabreProfilesCostCodeType.DIVISION;
                }
                case "department": {
                    return SabreProfilesCostCodeType.DEPARTMENT;
                }
                case "company": {
                    return SabreProfilesCostCodeType.COMPANY;
                }
                case "corp_ID": {
                    return SabreProfilesCostCodeType.BUSUNESS_UNIT;
                }
                case "project_code": {
                    return SabreProfilesCostCodeType.PROJECT_ID;
                }
                case "expense_code": {
                    return SabreProfilesCostCodeType.ACCOUNTING_CD;
                }
            }
            return SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE;
        }

        private String getType(CostCodeInfo costCodeInfo) {
            switch (costCodeInfo.getType()) {
                case CUSTOM_DEFINED_VALUE: {
                    return costCodeInfo.getName();
                }
                case EMPLOYEE_ID: {
                    return EMP_NO;
                }
                case COST_CENTER: {
                    return COST_CTR;
                }
                case DIVISION: {
                    return DIVISION;
                }
                case DEPARTMENT: {
                    return DEPARTMENT;
                }
                case COMPANY: {
                    return COMPANY;
                }
                case BUSUNESS_UNIT: {
                    return CORP_ID;
                }
                case PROJECT_ID: {
                    return PROJECT_CODE;
                }
                case ACCOUNTING_CD: {
                    return EXPENSE_CODE;
                }
            }
            return null;
        }
    }

    private static class ConnectProfileCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private ConnectProfileCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            CostCodeConnectProfileType connectProfileType = this.getConnectProfileType(costCodeProperties);
            if (connectProfileType == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            switch (connectProfileType) {
                case REFERENCE_INFORMATION: {
                    String shortName = CostCodesHelper.getShortName(costCodeProperties);
                    if (TextUtil.isBlank((String)shortName)) {
                        return null;
                    }
                    result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
                    result.setField(CostCodesHelper.OTH);
                    result.setValue(costCode.getValue());
                    result.setAdditionalInformation(shortName);
                    break;
                }
                default: {
                    result.setType(this.getType(connectProfileType));
                    result.setValue(costCode.getValue());
                }
            }
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            CostCodeConnectProfileType connectProfileType;
            String shortName;
            if (costCodeInfo.getType() == null) {
                return null;
            }
            switch (costCodeInfo.getType()) {
                case REFERENCE_INFORMATION: {
                    if (!CostCodesHelper.OTH.equals(costCodeInfo.getField())) {
                        return null;
                    }
                    shortName = costCodeInfo.getAdditionalInformation();
                    connectProfileType = CostCodeConnectProfileType.REFERENCE_INFORMATION;
                    break;
                }
                default: {
                    shortName = null;
                    connectProfileType = this.getType(costCodeInfo.getType());
                }
            }
            if (connectProfileType == null) {
                return null;
            }
            List costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, null, shortName, costCodeInfo.getValue(), CostCodeCategory::getExternalSystemName).stream().filter(prop -> this.getConnectProfileType((CostCodeProperties)prop) == connectProfileType).collect(Collectors.toList());
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.costCodePropertiesNotFoundConnectProfile), (Object[])new Object[]{organization, connectProfileType, costCodeInfo.getValue()}));
                return null;
            }
            return (CostCodeProperties)costCodeProperties.get(0);
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getValue();
        }

        private CostCodeConnectProfileType getConnectProfileType(CostCodeProperties costCodeProperties) {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            return costCodeCategory != null ? costCodeCategory.getConnectProfileType() : null;
        }

        private SabreProfilesCostCodeType getType(CostCodeConnectProfileType connectProfileType) {
            switch (connectProfileType) {
                case EMPLOYEE_ID: {
                    return SabreProfilesCostCodeType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return SabreProfilesCostCodeType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return SabreProfilesCostCodeType.COST_CENTER;
                }
                case DIVISION: {
                    return SabreProfilesCostCodeType.DIVISION;
                }
                case COMPANY: {
                    return SabreProfilesCostCodeType.COMPANY;
                }
                case INFORMATION_TEXT: {
                    return SabreProfilesCostCodeType.INFORMATION_TEXT;
                }
                case INDUSTRY_TYPE_CODE: {
                    return SabreProfilesCostCodeType.INDUSTRY_TYPE_CODE;
                }
                case DEPARTMENT: {
                    return SabreProfilesCostCodeType.DEPARTMENT;
                }
                case EMPLOYEE_NAME: {
                    return SabreProfilesCostCodeType.EMPLOYEE_NAME;
                }
                case SUBSIDIARY: {
                    return SabreProfilesCostCodeType.SUBSIDIARY;
                }
                case BUSUNESS_UNIT: {
                    return SabreProfilesCostCodeType.BUSUNESS_UNIT;
                }
                case OPERATING_UNIT: {
                    return SabreProfilesCostCodeType.OPERATING_UNIT;
                }
                case PROJECT_ID: {
                    return SabreProfilesCostCodeType.PROJECT_ID;
                }
                case ACCOUNTING_CD: {
                    return SabreProfilesCostCodeType.ACCOUNTING_CD;
                }
                case LOCATION_CD: {
                    return SabreProfilesCostCodeType.LOCATION_CD;
                }
                case REGION_CD: {
                    return SabreProfilesCostCodeType.REGION_CD;
                }
                case BRANCH_ID: {
                    return SabreProfilesCostCodeType.BRANCH_ID;
                }
                case GENERAL_LEDGER_CD: {
                    return SabreProfilesCostCodeType.GENERAL_LEDGER_CD;
                }
                case HIRE_DATE: {
                    return SabreProfilesCostCodeType.HIRE_DATE;
                }
                case COUNTRY_CODE: {
                    return SabreProfilesCostCodeType.COUNTRY_CODE;
                }
                case FORM_OF_EMPLOYMENT: {
                    return SabreProfilesCostCodeType.FORM_OF_EMPLOYMENT;
                }
                case EMPLOYEE_RANK_CD: {
                    return SabreProfilesCostCodeType.EMPLOYEE_RANK_CD;
                }
                case NETWORK_ID: {
                    return SabreProfilesCostCodeType.NETWORK_ID;
                }
                case BADGE_NO: {
                    return SabreProfilesCostCodeType.BADGE_NO;
                }
                case ALTERNATE_EMPLOYEE_ID: {
                    return SabreProfilesCostCodeType.ALTERNATE_EMPLOYEE_ID;
                }
                case PAYROLL_CD: {
                    return SabreProfilesCostCodeType.PAYROLL_CD;
                }
                case ORGANIZATION: {
                    return SabreProfilesCostCodeType.ORGANIZATION;
                }
                case POSITION_CD: {
                    return SabreProfilesCostCodeType.POSITION_CD;
                }
                case EMPLOYEE_GRADE_LEVEL: {
                    return SabreProfilesCostCodeType.EMPLOYEE_GRADE_LEVEL;
                }
                case MARKETING_UNIT: {
                    return SabreProfilesCostCodeType.MARKETING_UNIT;
                }
                case ENTITY: {
                    return SabreProfilesCostCodeType.ENTITY;
                }
                case PERSON_TYPE: {
                    return SabreProfilesCostCodeType.PERSON_TYPE;
                }
            }
            throw Xeption.forDeveloper((String)("unsupported udid type: " + connectProfileType), (Object[])new Object[0]);
        }

        private CostCodeConnectProfileType getType(SabreProfilesCostCodeType costCodeType) {
            switch (costCodeType) {
                case EMPLOYEE_ID: {
                    return CostCodeConnectProfileType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return CostCodeConnectProfileType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return CostCodeConnectProfileType.COST_CENTER;
                }
                case DIVISION: {
                    return CostCodeConnectProfileType.DIVISION;
                }
                case COMPANY: {
                    return CostCodeConnectProfileType.COMPANY;
                }
                case INFORMATION_TEXT: {
                    return CostCodeConnectProfileType.INFORMATION_TEXT;
                }
                case INDUSTRY_TYPE_CODE: {
                    return CostCodeConnectProfileType.INDUSTRY_TYPE_CODE;
                }
                case DEPARTMENT: {
                    return CostCodeConnectProfileType.DEPARTMENT;
                }
                case EMPLOYEE_NAME: {
                    return CostCodeConnectProfileType.EMPLOYEE_NAME;
                }
                case SUBSIDIARY: {
                    return CostCodeConnectProfileType.SUBSIDIARY;
                }
                case BUSUNESS_UNIT: {
                    return CostCodeConnectProfileType.BUSUNESS_UNIT;
                }
                case OPERATING_UNIT: {
                    return CostCodeConnectProfileType.OPERATING_UNIT;
                }
                case PROJECT_ID: {
                    return CostCodeConnectProfileType.PROJECT_ID;
                }
                case ACCOUNTING_CD: {
                    return CostCodeConnectProfileType.ACCOUNTING_CD;
                }
                case LOCATION_CD: {
                    return CostCodeConnectProfileType.LOCATION_CD;
                }
                case REGION_CD: {
                    return CostCodeConnectProfileType.REGION_CD;
                }
                case BRANCH_ID: {
                    return CostCodeConnectProfileType.BRANCH_ID;
                }
                case GENERAL_LEDGER_CD: {
                    return CostCodeConnectProfileType.GENERAL_LEDGER_CD;
                }
                case HIRE_DATE: {
                    return CostCodeConnectProfileType.HIRE_DATE;
                }
                case COUNTRY_CODE: {
                    return CostCodeConnectProfileType.COUNTRY_CODE;
                }
                case FORM_OF_EMPLOYMENT: {
                    return CostCodeConnectProfileType.FORM_OF_EMPLOYMENT;
                }
                case EMPLOYEE_RANK_CD: {
                    return CostCodeConnectProfileType.EMPLOYEE_RANK_CD;
                }
                case NETWORK_ID: {
                    return CostCodeConnectProfileType.NETWORK_ID;
                }
                case BADGE_NO: {
                    return CostCodeConnectProfileType.BADGE_NO;
                }
                case ALTERNATE_EMPLOYEE_ID: {
                    return CostCodeConnectProfileType.ALTERNATE_EMPLOYEE_ID;
                }
                case PAYROLL_CD: {
                    return CostCodeConnectProfileType.PAYROLL_CD;
                }
                case ORGANIZATION: {
                    return CostCodeConnectProfileType.ORGANIZATION;
                }
                case POSITION_CD: {
                    return CostCodeConnectProfileType.POSITION_CD;
                }
                case EMPLOYEE_GRADE_LEVEL: {
                    return CostCodeConnectProfileType.EMPLOYEE_GRADE_LEVEL;
                }
                case MARKETING_UNIT: {
                    return CostCodeConnectProfileType.MARKETING_UNIT;
                }
                case ENTITY: {
                    return CostCodeConnectProfileType.ENTITY;
                }
                case PERSON_TYPE: {
                    return CostCodeConnectProfileType.PERSON_TYPE;
                }
            }
            return null;
        }
    }

    private static class KdsCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private KdsCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            Integer udidNumber = ProfileSynchronizationUtil.getUdidNumber(costCodeProperties.getType());
            if (udidNumber == null) {
                return null;
            }
            CostCodeKdsType kdsType = this.getKdsType(costCodeProperties);
            if (kdsType == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
            result.setField(CostCodesHelper.OTH);
            result.setValue(kdsType.name() + udidNumber);
            result.setAdditionalInformation(costCode.getValue());
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            if (costCodeInfo.getType() != SabreProfilesCostCodeType.REFERENCE_INFORMATION) {
                return null;
            }
            if (!CostCodesHelper.OTH.equals(costCodeInfo.getField())) {
                return null;
            }
            if (TextUtil.isBlank((String)costCodeInfo.getValue())) {
                return null;
            }
            MiscUtil.Pair<CostCodeKdsType, CostCodeType> parsedCostCode = this.parseCostCodeNumber(costCodeInfo.getValue());
            if (parsedCostCode == null) {
                return null;
            }
            CostCodeKdsType kdsType = (CostCodeKdsType)parsedCostCode.getFirst();
            CostCodeType costCodeType = (CostCodeType)parsedCostCode.getSecond();
            List costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, costCodeType, null, costCodeInfo.getAdditionalInformation(), CostCodeCategory::getExternalSystemName).stream().filter(prop -> this.getKdsType((CostCodeProperties)prop) == kdsType).collect(Collectors.toList());
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.costCodePropertiesNotFoundKds, (Object[])new Object[]{organization, costCodeType, kdsType, costCodeInfo.getAdditionalInformation()}));
                return null;
            }
            return (CostCodeProperties)costCodeProperties.get(0);
        }

        private CostCodeKdsType getKdsType(CostCodeProperties costCodeProperties) {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            return costCodeCategory != null ? costCodeCategory.getKdsType() : null;
        }

        private MiscUtil.Pair<CostCodeKdsType, CostCodeType> parseCostCodeNumber(String costCodeNumber) {
            for (CostCodeKdsType kdsType : CostCodeKdsType.values()) {
                Matcher matcher = Pattern.compile(kdsType.name() + "(\\d+)").matcher(costCodeNumber);
                if (!matcher.find()) continue;
                int udidNumber = Integer.parseInt(matcher.group(1));
                CostCodeType costCodeType = ProfileHelper.getCostCodeTypeByNumber(udidNumber - 1);
                if (costCodeType == null) {
                    return null;
                }
                return new MiscUtil.Pair((Object)kdsType, (Object)costCodeType);
            }
            return null;
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getAdditionalInformation();
        }
    }

    private static class ISuiteCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private ISuiteCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            String field = this.getField(costCodeProperties);
            if (field == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
            result.setField(field);
            result.setValue(costCode.getValue());
            result.setAdditionalInformation(null);
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            if (costCodeInfo.getType() != SabreProfilesCostCodeType.REFERENCE_INFORMATION) {
                return null;
            }
            CostCodeType costCodeType = this.getTypeByField(costCodeInfo.getField());
            if (costCodeType == null) {
                return null;
            }
            List<CostCodeProperties> costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, costCodeType, null, costCodeInfo.getValue(), CostCodeCategory::getExternalSystemName);
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"SabreProfiles_CostCodePropertiesNotFound", (Object[])new Object[]{organization, costCodeType, costCodeInfo.getValue()}));
                return null;
            }
            return costCodeProperties.get(0);
        }

        private CostCodeType getTypeByField(String field) {
            SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
            if (settings == null) {
                return null;
            }
            return settings.getISuiteCostCodesSettings().stream().filter(s -> TextUtil.isSame((String)field, (String)s.getField())).map(ISuiteCostCodesSyncSettings::getCostCodeType).filter(Objects::nonNull).findFirst().orElse(null);
        }

        private String getField(CostCodeProperties costCodeProperties) {
            SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
            if (settings == null) {
                return null;
            }
            return settings.getISuiteCostCodesSettings().stream().filter(s -> s.getCostCodeType() == costCodeProperties.getType()).map(ISuiteCostCodesSyncSettings::getField).filter(TextUtil::nonBlank).findFirst().orElse(null);
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getValue();
        }
    }

    private static class IonCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private IonCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            Integer udidNumber = ProfileSynchronizationUtil.getUdidNumber(costCodeProperties.getType());
            if (udidNumber == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
            result.setField(CostCodesHelper.OTH);
            result.setValue(udidNumber > 9 ? udidNumber.toString() : "0" + udidNumber);
            result.setAdditionalInformation(costCode.getValue());
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            int udidNumber;
            if (costCodeInfo.getType() != SabreProfilesCostCodeType.REFERENCE_INFORMATION) {
                return null;
            }
            if (!CostCodesHelper.OTH.equals(costCodeInfo.getField())) {
                return null;
            }
            if (TextUtil.isBlank((String)costCodeInfo.getValue())) {
                return null;
            }
            try {
                udidNumber = Integer.parseInt(costCodeInfo.getValue());
            }
            catch (Exception e) {
                return null;
            }
            CostCodeType costCodeType = ProfileHelper.getCostCodeTypeByNumber(udidNumber - 1);
            if (costCodeType == null) {
                return null;
            }
            List<CostCodeProperties> costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, costCodeType, null, costCodeInfo.getAdditionalInformation(), CostCodeCategory::getExternalSystemName);
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"SabreProfiles_CostCodePropertiesNotFound", (Object[])new Object[]{organization, costCodeType, costCodeInfo.getAdditionalInformation()}));
                return null;
            }
            return costCodeProperties.get(0);
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getAdditionalInformation();
        }
    }

    private static class ConcurCostCodeInfoProcessor
    extends BaseCostCodeInfoProcessor {
        private ConcurCostCodeInfoProcessor() {
        }

        @Override
        CostCodeInfo create(PersonCostCode costCode, CostCodeProperties costCodeProperties) {
            CostCodeConcurType concurType = this.getConcurType(costCodeProperties);
            if (concurType == null) {
                return null;
            }
            CostCodeInfo result = new CostCodeInfo();
            switch (concurType) {
                case CUSTOM_FIELDS: {
                    String shortName = CostCodesHelper.getShortName(costCodeProperties);
                    if (TextUtil.isBlank((String)shortName)) {
                        return null;
                    }
                    result.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
                    result.setField(CostCodesHelper.OTH);
                    result.setValue(costCode.getValue());
                    result.setAdditionalInformation(shortName);
                    break;
                }
                default: {
                    result.setType(this.getType(concurType));
                    result.setValue(costCode.getValue());
                }
            }
            return result;
        }

        @Override
        CostCodeProperties searchCostCodeProperties(CostCodeInfo costCodeInfo, EntityReference<Organization> organization, List<Message> messages) {
            CostCodeConcurType concurType;
            String shortName;
            if (costCodeInfo.getType() == null) {
                return null;
            }
            switch (costCodeInfo.getType()) {
                case REFERENCE_INFORMATION: {
                    if (!CostCodesHelper.OTH.equals(costCodeInfo.getField())) {
                        return null;
                    }
                    shortName = costCodeInfo.getAdditionalInformation();
                    concurType = CostCodeConcurType.CUSTOM_FIELDS;
                    break;
                }
                default: {
                    shortName = null;
                    concurType = this.getType(costCodeInfo.getType());
                }
            }
            if (concurType == null) {
                return null;
            }
            List costCodeProperties = ProfileHelper.getCostCodePropertiesForOrganization(organization, null, shortName, costCodeInfo.getValue(), CostCodeCategory::getExternalSystemName).stream().filter(prop -> this.getConcurType((CostCodeProperties)prop) == concurType).collect(Collectors.toList());
            if (costCodeProperties.isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10n.get((String)Messages.costCodePropertiesNotFoundConcur), (Object[])new Object[]{organization, concurType, costCodeInfo.getValue()}));
                return null;
            }
            return (CostCodeProperties)costCodeProperties.get(0);
        }

        private CostCodeConcurType getConcurType(CostCodeProperties costCodeProperties) {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            return costCodeCategory != null ? costCodeCategory.getConcurType() : null;
        }

        private SabreProfilesCostCodeType getType(CostCodeConcurType concurType) {
            switch (concurType) {
                case EMPLOYEE_ID: {
                    return SabreProfilesCostCodeType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return SabreProfilesCostCodeType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return SabreProfilesCostCodeType.COST_CENTER;
                }
                case DIVISION: {
                    return SabreProfilesCostCodeType.DIVISION;
                }
                case COMPANY_NAME: {
                    return SabreProfilesCostCodeType.COMPANY;
                }
            }
            throw Xeption.forDeveloper((String)("unsupported udid type: " + concurType), (Object[])new Object[0]);
        }

        private CostCodeConcurType getType(SabreProfilesCostCodeType costCodeType) {
            switch (costCodeType) {
                case EMPLOYEE_ID: {
                    return CostCodeConcurType.EMPLOYEE_ID;
                }
                case EMPLOYEE_TITLE: {
                    return CostCodeConcurType.EMPLOYEE_TITLE;
                }
                case COST_CENTER: {
                    return CostCodeConcurType.COST_CENTER;
                }
                case DIVISION: {
                    return CostCodeConcurType.DIVISION;
                }
                case COMPANY: {
                    return CostCodeConcurType.COMPANY_NAME;
                }
            }
            return null;
        }

        @Override
        String getValue(CostCodeInfo costCodeInfo) {
            return costCodeInfo.getValue();
        }
    }

    private static abstract class BaseCostCodeInfoProcessor {
        private BaseCostCodeInfoProcessor() {
        }

        abstract CostCodeInfo create(PersonCostCode var1, CostCodeProperties var2);

        abstract CostCodeProperties searchCostCodeProperties(CostCodeInfo var1, EntityReference<Organization> var2, List<Message> var3);

        abstract String getValue(CostCodeInfo var1);

        void addEmptyCostCodesIfNecessary(EntityContainer<Organization> orgContainer, List<CostCodeInfo> costCodes) {
        }
    }
}

