/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.GetThereSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GetThereHelper {
    public static GetThereSettings getGetThereSettings() {
        GetThereSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)"com.gridnine.xtrip.common.model.profile.GetThereSettings"));
        EntityStorage es = EntityStorage.get();
        List indices = es.search(BasicSystemSettingsIndex.class, query).getData();
        EntityContainer cont = null;
        if (indices.size() > 0) {
            for (BasicSystemSettingsIndex index : indices) {
                if (!TextUtil.isSame((String)index.getUid(), (String)"get-there-exchange-setting-uid")) continue;
                cont = es.resolve(index.getSource());
            }
            if (cont == null) {
                cont = es.resolve(((BasicSystemSettingsIndex)indices.get(0)).getSource());
            }
        }
        if (cont != null) {
            res = (GetThereSettings)cont.getEntity();
        }
        return res;
    }

    public static Map<String, Object> getOrganizationDetailsForGetThereSync(EntityReference<Person> personRef) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("ORGANIZATION_FOUND", Boolean.FALSE);
        EntityContainer perCont = EntityStorage.get().resolve(personRef);
        if (perCont == null || perCont.getEntity() == null) {
            return res;
        }
        Person per = (Person)perCont.getEntity();
        for (PersonEmployment pe : per.getEmployments()) {
            if (pe.getOrganization() == null) continue;
            EntityContainer orgCont = EntityStorage.get().resolve(pe.getOrganization());
            boolean orgFound = false;
            if (orgCont == null || orgCont.getEntity() == null) continue;
            Organization org = (Organization)orgCont.getEntity();
            for (Metadata meta : org.getMetadata()) {
                PersonPosition pos;
                if (meta.getKey() == null || !MetadataKey.KEY_ORGANIZATION_GET_THERE_SYNC.name().equals(meta.getKey().getCode()) || !Boolean.TRUE.equals(meta.getValue())) continue;
                orgFound = true;
                res.put("ORGANIZATION_FOUND", Boolean.TRUE);
                res.put("ORGANIZATION_CODE", org.getCode());
                res.put("ORGANIZATION_SHORT_NAME", L10nStringHelper.getValue((L10nString)org.getShortName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)false));
                if (pe.getPosition() == null || (pos = (PersonPosition)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(pe.getPosition())) == null) continue;
                res.put("PERSON_POSITION", pos.getTranslations().get(LocaleUtil.LOCALE_EN));
            }
            if (!orgFound) continue;
            for (Metadata meta : org.getMetadata()) {
                if (meta.getKey() == null || !MetadataKey.KEY_ORGANIZATION_GET_THERE_SETTINGS.name().equals(meta.getKey().getCode())) continue;
                res.put("ORGANIZATION_GET_THERE_SETTINGS", meta.getValue());
            }
            return res;
        }
        return res;
    }
}

