/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonCsvCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MaskFormatter;

public class SabreProfileHelper {
    public static final Locale LOCALE_RU = new Locale("ru");
    public static final Locale LOCALE_EN = new Locale("en");
    private static final Locale LOCALE_UK = new Locale("uk");
    private static final String IMPORTER = "importer";

    public static SabreProfileLine createRemarkLine(SabreProfileLineType lineType, SabreProfileLineServiceType serviceType, String subsection, boolean needParse, String str) {
        SabreProfileLine line = new SabreProfileLine();
        line.setUid(UUIDGenerator.generate().toString());
        line.setLineType(lineType);
        line.setLineServiceType(serviceType);
        line.setLineSubsection(subsection != null ? subsection : "");
        if (!needParse) {
            line.setLineBody(str);
            line.setLineFlag(null);
        } else {
            Pattern p0 = Pattern.compile("(YES|NO|GDS|NON GDS) - (.*)");
            Pattern p1 = Pattern.compile("(YES|NO|GDS|NON GDS) \\((.*)\\)");
            Pattern p2 = Pattern.compile("(YES|NO|GDS|NON GDS)");
            Matcher m0 = p0.matcher(str);
            Matcher m1 = p1.matcher(str);
            Matcher m2 = p2.matcher(str);
            if (m0.matches()) {
                String flag = m0.group(1);
                String body = m0.group(2);
                if (flag.equals("YES") || flag.equals("GDS")) {
                    line.setLineFlag(Boolean.TRUE);
                } else {
                    line.setLineFlag(Boolean.FALSE);
                }
                line.setLineBody(body);
            } else if (m1.matches()) {
                String flag = m1.group(1);
                String body = m1.group(2);
                if (flag.equals("YES") || flag.equals("GDS")) {
                    line.setLineFlag(Boolean.TRUE);
                } else {
                    line.setLineFlag(Boolean.FALSE);
                }
                line.setLineBody(body);
            } else if (m2.matches()) {
                String flag = m2.group(1);
                if (flag.equals("YES") || flag.equals("GDS")) {
                    line.setLineFlag(Boolean.TRUE);
                } else {
                    line.setLineFlag(Boolean.FALSE);
                }
            } else {
                line.setLineBody(str);
            }
        }
        return line;
    }

    public static final <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    public static PersonPosition parsePersonPosition(Person per, EntityReference<Organization> orgRef, String value, String fullName, List<Message> messages) {
        per.getEmployments().clear();
        PersonEmployment pe = new PersonEmployment();
        pe.setOrganization(orgRef);
        PersonPosition newPosition = SabreProfileHelper.getOrCreatePersonPosition(value, true);
        if (newPosition != null) {
            pe.setPosition((DictionaryReference)newPosition.toReference());
        }
        pe.setMainEmployment(true);
        per.getEmployments().add(pe);
        Iterator addressIterator = per.getAddresses().iterator();
        while (addressIterator.hasNext()) {
            PersonAddress address = (PersonAddress)addressIterator.next();
            if (address.getOrganization() == null || address.getOrganization().equals(orgRef)) continue;
            addressIterator.remove();
        }
        Iterator communicationIterator = per.getCommunications().iterator();
        while (communicationIterator.hasNext()) {
            PersonCommunication communication = (PersonCommunication)communicationIterator.next();
            if (communication.getOrganization() == null || communication.getOrganization().equals(orgRef)) continue;
            communicationIterator.remove();
        }
        Iterator metadataIterator = per.getMetadata().iterator();
        while (metadataIterator.hasNext()) {
            PersonMetadata metadata = (PersonMetadata)metadataIterator.next();
            if (metadata.getOrganization() == null || metadata.getOrganization().equals(orgRef)) continue;
            metadataIterator.remove();
        }
        return newPosition;
    }

    public static PersonPosition getOrCreatePersonPosition(String positionName, boolean needToBeSaved) {
        PersonPosition newPosition = null;
        Map positionsMap = DictionaryCache.get().getAll(PersonPosition.class);
        for (Map.Entry entry : positionsMap.entrySet()) {
            PersonPosition pos = (PersonPosition)entry.getValue();
            if (pos == null || !pos.getTranslations().containsKey(LOCALE_EN) || !((String)pos.getTranslations().get(LOCALE_EN)).equals(positionName)) continue;
            newPosition = pos;
            break;
        }
        if (newPosition == null) {
            try {
                newPosition = SabreProfileHelper.createDictionaryContainer(PersonPosition.class, UUIDGenerator.generate().toString());
                newPosition.getTranslations().put(LOCALE_EN, positionName);
                newPosition.getTranslations().put(LOCALE_RU, positionName);
            }
            catch (Exception e) {
                e.printStackTrace();
                newPosition = null;
            }
        }
        return newPosition;
    }

    public static PersonCommunication parsePhoneBase(String str, EntityReference<Organization> orgRef, CommunicationType type) {
        PersonCommunication pc = new PersonCommunication();
        if (type != null) {
            pc.setType(type);
            if (type == CommunicationType.WEB || type == CommunicationType.EMAIL) {
                pc.setSense(str);
            } else {
                Pattern p1 = Pattern.compile("(\\d+)[\\s-]+(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Pattern p2 = Pattern.compile("(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Pattern p3 = Pattern.compile("(\\d+)X?(\\d*)");
                Matcher m1 = p1.matcher(str);
                Matcher m2 = p2.matcher(str);
                Matcher m3 = p3.matcher(str);
                if (m1.matches()) {
                    pc.setCountryCode(m1.group(1));
                    pc.setCityCode(m1.group(2));
                    pc.setSense(m1.group(3));
                    if (m1.groupCount() == 4) {
                        String internal = m1.group(4);
                        pc.setInternalNumber(internal);
                    }
                } else if (m2.matches()) {
                    pc.setCityCode(m2.group(1));
                    pc.setSense(m2.group(2));
                    if (m2.groupCount() == 3) {
                        String internal = m2.group(3);
                        pc.setInternalNumber(internal);
                    }
                } else if (m3.matches()) {
                    pc.setSense(m3.group(1));
                    if (m3.groupCount() == 2) {
                        String internal = m3.group(2);
                        pc.setInternalNumber(internal);
                    }
                } else {
                    pc.setSense(str);
                }
            }
        } else {
            pc.setSense(str);
        }
        if (orgRef != null) {
            pc.setOrganization(orgRef);
        }
        return pc;
    }

    public static SabreContactPhone parseSabreContactPhoneBase(String str, CommunicationType type) {
        SabreContactPhone pc = new SabreContactPhone();
        if (type != null) {
            pc.setType(type);
            if (type == CommunicationType.WEB || type == CommunicationType.EMAIL) {
                pc.setSense(str);
            } else {
                Pattern p1 = Pattern.compile("(\\d+)[\\s-]+(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Pattern p2 = Pattern.compile("(\\d+)[\\s-]+([\\d\\s-]+)X?(\\d*)");
                Matcher m1 = p1.matcher(str);
                Matcher m2 = p2.matcher(str);
                if (m1.matches()) {
                    pc.setCountryCode(m1.group(1));
                    pc.setCityCode(m1.group(2));
                    pc.setSense(m1.group(3));
                    if (m1.groupCount() == 4) {
                        String internal = m1.group(4);
                        pc.setInternalNumber(internal);
                    }
                } else if (m2.matches()) {
                    pc.setCityCode(m2.group(1));
                    pc.setSense(m2.group(2));
                    if (m2.groupCount() == 3) {
                        String internal = m2.group(3);
                        pc.setInternalNumber(internal);
                    }
                } else {
                    pc.setSense(str);
                }
            }
        } else {
            pc.setSense(str);
        }
        return pc;
    }

    public static Visa parseVisa(String str, String fullName, List<Message> messages) {
        Visa res = null;
        str = str.toUpperCase();
        Pattern p1 = Pattern.compile("([A-Z]+)/([A-Z])/(\\w+)/([A-Z]+) ([A-Z]+)/(\\w+)/([A-Z]+)\\-(\\w+)/([\\w ]+)");
        Pattern p2 = Pattern.compile("([A-Z]+)/([A-Z])/(\\w+)/([A-Z]+)/([A-Z]+)/(\\w+)/([A-Z]+)\\-(\\w+)/([\\w ]+)");
        Matcher m1 = p1.matcher(str);
        Matcher m2 = p2.matcher(str);
        if (m1.matches() || m2.matches()) {
            String issueYearStr;
            String issueDateStr;
            String birthCountryStr = m1.matches() ? m1.group(1) : m2.group(1);
            String docNumber = m1.matches() ? m1.group(3) : m2.group(3);
            String issueCityStr = m1.matches() ? m1.group(4) : m2.group(4);
            String issueCountryStr = m1.matches() ? m1.group(5) : m2.group(5);
            String string = issueDateStr = m1.matches() ? m1.group(6) : m2.group(6);
            if (issueDateStr.length() > 5 && (issueYearStr = issueDateStr.substring(5)).length() == 2) {
                try {
                    Integer issueYear = Integer.valueOf(issueYearStr);
                    issueYearStr = issueYear != null && issueYear > 11 ? "19" + issueYearStr : "20" + issueYearStr;
                    issueDateStr = issueDateStr.substring(0, 5) + issueYearStr;
                }
                catch (Exception issueYear) {
                    // empty catch block
                }
            }
            String targetCountryStr = m1.matches() ? m1.group(7) : m2.group(7);
            boolean hasError = false;
            Country birthCountry = null;
            GeoLocation issueCity = null;
            Country issueCountry = null;
            Date issueDate = null;
            Country targetCountry = null;
            Set<Country> birthCountries = DictHelper.findCountryByCode(birthCountryStr);
            if (birthCountries.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: " + issueCountryStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (birthCountries.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: " + issueCountryStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439", (Object[])null));
                birthCountry = birthCountries.iterator().next();
            } else {
                birthCountry = birthCountries.iterator().next();
            }
            Set<Country> issueCountries = DictHelper.findCountryByCode(issueCountryStr);
            if (issueCountries.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044b\u0434\u0430\u0447\u0438: " + issueCountryStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (issueCountries.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044b\u0434\u0430\u0447\u0438: " + issueCountryStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439", (Object[])null));
                issueCountry = issueCountries.iterator().next();
            } else {
                issueCountry = issueCountries.iterator().next();
            }
            Set<Country> targetCountries = DictHelper.findCountryByCode(targetCountryStr);
            if (targetCountries.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044a\u0435\u0437\u0434\u0430: " + issueCountryStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (targetCountries.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044a\u0435\u0437\u0434\u0430: " + issueCountryStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439", (Object[])null));
                targetCountry = targetCountries.iterator().next();
            } else {
                targetCountry = targetCountries.iterator().next();
            }
            try {
                issueDate = new SimpleDateFormat("ddMMMyyyy", LOCALE_EN).parse(issueDateStr);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0434\u0430\u0442\u043e\u0439 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: " + issueDateStr, (Object[])null));
                hasError = true;
            }
            Set<GeoLocation> issueCities = DictHelper.findCity(issueCityStr);
            if (issueCities.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0433\u043e\u0440\u043e\u0434\u043e\u043c \u0432\u044b\u043f\u0443\u0441\u043a\u0430: " + issueCountryStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (issueCities.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u0432\u0438\u0437\u044b \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0433\u043e\u0440\u043e\u0434\u043e\u043c \u0432\u044b\u043f\u0443\u0441\u043a\u0430: " + issueCountryStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e", (Object[])null));
                issueCity = issueCities.iterator().next();
            } else {
                issueCity = issueCities.iterator().next();
            }
            if (!hasError) {
                res = new Visa();
                res.setBirthPlace((DictionaryReference)(birthCountry != null ? birthCountry.toReference() : null));
                res.setCountry((DictionaryReference)(targetCountry != null ? targetCountry.toReference() : null));
                res.setIssueCity((DictionaryReference)(issueCity != null ? issueCity.toReference() : null));
                res.setIssueCountry((DictionaryReference)(issueCountry != null ? issueCountry.toReference() : null));
                res.setIssueDate(issueDate);
                res.setNumber(docNumber);
            }
        } else {
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u0432\u0438\u0437\u0443: " + str + " \u0434\u043b\u044f: " + fullName, (Object[])null));
        }
        return res;
    }

    public static Passport parsePassport(String str, String fullName, String genderFromTitle, List<Message> messages) {
        Passport res = null;
        str = str.replaceAll("'", "");
        Pattern p = Pattern.compile("([A-Z])/([A-Z]+)/([\\w\\s]+)/([A-Z]+)/(\\w+)/(M|F|U)/(\\w+)/([\\w ]+)/([\\w ]+)/*([\\w\\.\\-/ ]*)");
        Pattern p2 = Pattern.compile("([A-Z])/([A-Z]+)/([\\w\\s]+)/([A-Z]+)/(\\w+)/(M|F|U)/(\\w+)/([\\w ]+)/([\\w ]+)/([\\w ]+)/*([\\w\\.\\-/ ]*)");
        Matcher m = p.matcher(str);
        Matcher m2 = p2.matcher(str);
        if (m.matches() || m2.matches()) {
            String middleName;
            String expYearStr;
            String validityDateStr;
            String birthYearStr;
            String birthDateStr;
            String typeStr = m.matches() ? m.group(1) : m2.group(1);
            String issueCountryStr = m.matches() ? m.group(2) : m2.group(2);
            String docNumber = m.matches() ? m.group(3) : m2.group(3);
            String nationalityStr = m.matches() ? m.group(4) : m2.group(4);
            String string = birthDateStr = m.matches() ? m.group(5) : m2.group(5);
            if (birthDateStr.length() > 5 && (birthYearStr = birthDateStr.substring(5)).length() == 2) {
                try {
                    Integer birthYear = Integer.valueOf(birthYearStr);
                    birthYearStr = birthYear != null && birthYear > 11 ? "19" + birthYearStr : "20" + birthYearStr;
                    birthDateStr = birthDateStr.substring(0, 5) + birthYearStr;
                }
                catch (Exception birthYear) {
                    // empty catch block
                }
            }
            String genderStr = m.matches() ? m.group(6) : m2.group(6);
            String string2 = validityDateStr = m.matches() ? m.group(7) : m2.group(7);
            if (validityDateStr.length() > 5 && (expYearStr = validityDateStr.substring(5)).length() == 2) {
                expYearStr = "20" + expYearStr;
                validityDateStr = validityDateStr.substring(0, 5) + expYearStr;
            }
            String lastName = m.matches() ? m.group(8) : m2.group(8);
            String firstName = m.matches() ? m.group(9) : m2.group(9);
            String string3 = middleName = m2.matches() ? m2.group(10) : "";
            if (middleName.length() < 2) {
                middleName = null;
            }
            PassportType type = null;
            Country issueCountry = null;
            Country citizenship = null;
            Date birthDate = null;
            Date validityDate = null;
            Gender gender = null;
            boolean hasError = false;
            if (typeStr.equals("P")) {
                type = validityDateStr.endsWith("99") ? PassportType.INTERNAL : PassportType.FOREIGN;
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + typeStr, (Object[])null));
                hasError = true;
            }
            Set<Country> issueCountries = DictHelper.findCountryByCode(issueCountryStr);
            if (issueCountries.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044b\u0434\u0430\u0447\u0438: " + issueCountryStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (issueCountries.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u0440\u0430\u043d\u043e\u0439 \u0432\u044b\u0434\u0430\u0447\u0438: " + issueCountryStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439", (Object[])null));
                issueCountry = issueCountries.iterator().next();
            } else {
                issueCountry = issueCountries.iterator().next();
            }
            Set<Country> nationalityCountries = DictHelper.findCountryByCode(nationalityStr);
            if (nationalityCountries.size() == 0) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e\u043c: " + nationalityStr + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", (Object[])null));
                hasError = true;
            } else if (nationalityCountries.size() > 1) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e\u043c: " + nationalityStr + " \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e", (Object[])null));
                citizenship = nationalityCountries.iterator().next();
            } else {
                citizenship = nationalityCountries.iterator().next();
            }
            try {
                birthDate = new SimpleDateFormat("ddMMMyyyy", LOCALE_EN).parse(birthDateStr);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0434\u0430\u0442\u043e\u0439 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: " + birthDateStr, (Object[])null));
                hasError = true;
            }
            try {
                validityDate = new SimpleDateFormat("ddMMMyyyy", LOCALE_EN).parse(validityDateStr);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0434\u0430\u0442\u043e\u0439 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: " + validityDateStr, (Object[])null));
                hasError = true;
            }
            if (genderStr.equals("M") || genderStr.equals("U")) {
                gender = Gender.MALE;
            } else if (genderStr.equals("F")) {
                gender = Gender.FEMALE;
            } else {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u043f\u043e\u043b\u043e\u043c: " + genderStr, (Object[])null));
                hasError = true;
            }
            if (genderFromTitle == null) {
                genderFromTitle = "";
            }
            if (genderStr.equals("M") && !genderFromTitle.equals("MR") || genderStr.equals("F") && !genderFromTitle.equals("MRS") && !genderFromTitle.equals("MS")) {
                messages.add(MessageHelper.createWarningMessage("\u0420\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0434\u043b\u044f " + fullName + " - \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u043f\u043e\u043b\u043e\u043c (\u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0442\u0438\u0442\u0443\u043b\u0443): " + genderStr + " \u0438 " + genderFromTitle, (Object[])null));
            }
            if (!hasError) {
                res = new Passport();
                res.setBirthday(birthDate);
                res.setCitizenship((DictionaryReference)(citizenship != null ? citizenship.toReference() : null));
                res.setExpired(validityDate);
                res.setFirstName(firstName);
                res.setMiddleName(middleName);
                res.setGender(gender);
                res.setLastName(lastName);
                res.setNumber(docNumber);
                res.setOriginCountry((DictionaryReference)(issueCountry != null ? issueCountry.toReference() : null));
                res.setType(type);
            }
        } else {
            messages.add(MessageHelper.createWarningMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u0442\u044c \u043f\u0430\u0441\u043f\u043e\u0440\u0442: " + str + " \u0434\u043b\u044f: " + fullName, (Object[])null));
        }
        return res;
    }

    public static PersonCsvCostCode parsePersonCostCode(String value, String fullName, Organization org, EntityReference<Organization> orgRef, EntityReference<Person> per, List<Message> messages) {
        Pattern p = Pattern.compile("(U\\d\\d)\\*([^\\*]*)\\*(.*)");
        Matcher m = p.matcher(value);
        PersonCsvCostCode costCode = null;
        if (m.matches()) {
            CostCodeCategory cat;
            CostCodeType cct;
            String udidNumber = m.group(1);
            String udidName = m.group(2);
            udidName = TextUtil.trim((String)udidName, (String)"\\.");
            String udidValuesStr = m.group(3);
            if (udidValuesStr.endsWith("*")) {
                udidValuesStr = udidValuesStr.substring(0, udidValuesStr.length() - 1);
            }
            if ((cct = ProfileSynchronizationUtil.getCostCodeTypeForNumber(udidNumber)) == null) {
                messages.add(MessageHelper.createWarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044e\u0434\u0438\u0434\u0430 - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 UDID: " + value + " \u0434\u043b\u044f " + fullName, (Object[])null));
            }
            ArrayList<CostCodeProperties> props = new ArrayList<CostCodeProperties>();
            CostCodeProperties prop = null;
            for (CostCodeProperties ccp : org.getCostCodeProperties()) {
                cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory());
                if (ccp.getType() == null || !ccp.getType().equals((Object)cct) || cat.getShortName() == null || !cat.getShortName().equals(udidName) && !cat.getShortName().equals(udidName + ".")) continue;
                prop = ccp;
                break;
            }
            for (CostCodeProperties ccp : org.getCostCodeProperties()) {
                cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory());
                if (ccp.getType() == null || !ccp.getType().equals((Object)cct)) continue;
                if (cat.getShortName() != null && (cat.getShortName().equals(udidName) || cat.getShortName().equals(udidName + "."))) {
                    props.add(0, ccp);
                    continue;
                }
                if (prop == null) continue;
                props.add(ccp);
            }
            if (props.size() > 0) {
                String[] udidValues;
                for (String udidValue : udidValues = udidValuesStr.split(",")) {
                    PersonCostCode cc;
                    boolean maskChecked = false;
                    boolean hasNotNullMask = false;
                    prop = (CostCodeProperties)props.get(0);
                    for (CostCodeProperties ccp : props) {
                        if (!TextUtil.isBlank((String)ccp.getMask())) {
                            hasNotNullMask = true;
                        }
                        if (TextUtil.isBlank((String)ccp.getMask()) || !SabreProfileHelper.checkMask(ccp.getMask(), udidValue)) continue;
                        prop = ccp;
                        maskChecked = true;
                        break;
                    }
                    if (!maskChecked && hasNotNullMask) {
                        messages.add(MessageHelper.createWarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044e\u0434\u0438\u0434\u0430 - \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0430\u0441\u043a\u0435: " + udidValue + " \u0434\u043b\u044f \u043c\u0430\u0441\u043a\u0438 " + prop.getMask() + " \u0434\u043b\u044f " + fullName + " \u0438\u0437 " + org.getShortName(), (Object[])null));
                        costCode = new PersonCsvCostCode();
                        cc = new PersonCostCode();
                        cc.setOrganization(orgRef);
                        cc.setValue(udidValue);
                        cc.setCostCodeProperties(prop);
                        costCode.setPersonCostCode(cc);
                        costCode.setPerson(per);
                        costCode.setOrganization(orgRef);
                        costCode.setCorrect(false);
                        continue;
                    }
                    costCode = new PersonCsvCostCode();
                    cc = new PersonCostCode();
                    cc.setOrganization(orgRef);
                    cc.setValue(udidValue);
                    cc.setCostCodeProperties(prop);
                    costCode.setPersonCostCode(cc);
                    costCode.setPerson(per);
                    costCode.setOrganization(orgRef);
                    costCode.setCorrect(true);
                }
            } else {
                messages.add(MessageHelper.createWarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044e\u0434\u0438\u0434\u0430 - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f UDID \u0432 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438: " + value + " \u0434\u043b\u044f " + fullName + " \u0438\u0437 " + org.getShortName(), (Object[])null));
            }
        } else {
            messages.add(MessageHelper.createWarningMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u044e\u0434\u0438\u0434\u0430: " + value + " \u0434\u043b\u044f " + fullName, (Object[])null));
        }
        return costCode;
    }

    public static boolean checkMask(String mask, String value) {
        if (!TextUtil.isBlank((String)mask)) {
            try {
                MaskFormatter formatter = new MaskFormatter(mask);
                formatter.stringToValue(value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    public static final <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }
}

