/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre.calcfee;

import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionFullNameDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionNameDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionPQDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionSegmentDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ParsingUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ComissionCommandParser {
    private static final Pattern PQ_DATE_PATTERN = Pattern.compile(".*(\\d{4}/(\\d{1,2})(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)\\d{2}).*");
    private static final ThreadLocal<SimpleDateFormat> PQ_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            return (SimpleDateFormat)super.get();
        }

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("hhmm/ddMMMyy", LocaleUtil.LOCALE_EN);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(SimpleDateFormat value) {
            super.set(value);
        }
    };
    public static final String STR_RECEIVED_FROM = "RECEIVED FROM - ";
    public static final String REMARK_CUSTOMER_NUMBER = "CUSTOMER NUMBER - ";
    public static final String REMARK_VALIDATING_CARRIER = "VALIDATING CARRIER ";
    public static final String STR_PRINTER_SUFFIX = "T-*ETKT*";
    public static final String REMARK_PQ_REMARK = "X*PQ";
    public static final String REMARK_BASE_FARE = "BASE FARE ";
    public static final String REMARK_EQUIV_FARE = "EQUIV FARE ";
    public static final String REMARK_TOTAL_TAX = "TOTAL TAX ";
    public static final String REMARK_TOTAL_FARE = "TOTAL FARE ";
    public static final String REMARK_TAXES = "TAXES ";
    public static final String REMARK_PASSENGER_TYPE = "PASSENGER TYPE ";
    public static final String REMARK_PASSENGER_NUMBER = "PASSENGER NUMBER ";
    public static final String REMARK_FARE_COMPONENT = "FARE COMPONENT ";
    public static final String REMARK_FARE_COMPONENT_NUC = "FARE COMPONENT NUC";
    public static final String STR_SIGN_IN = "SIGN IN";
    public static final String PQ_TITLE_BASE_FARE = "BASE";
    public static final String PQ_TITLE_EQUIV_FARE = "EQUIV";
    public static final String PQ_TITLE_TOTAL_TAX = "TAXES";
    public static final String PQ_TITLE_TOTAL_FARE = "TOTAL";
    public static final String SEGMENT_OPERATED_BY = "OPERATED BY";
    private static final String amountPatternPart = "[0-9]+\\.?[0-9]*";
    private static final String cityPatternPart = "[A-Z]{3}";
    private static final String notPreceededByLetter = "(?<![A-Z])";
    private static final String notFollowedByLetter = "(?![A-Z])";
    private static final Pattern fareDataComponentPattern = Pattern.compile("(([0-9]+\\.?[0-9]*)\\s*(RUB|EUR|USD)?)|((?<![A-Z])[A-Z]{3}(?![A-Z]))|([A-Z]{2})|((?://)|(?:/-))");
    public static final Map<String, String> Printer2Owner = new HashMap<String, String>(){
        private static final long serialVersionUID = -3497011746166149719L;
        {
            this.put("RU", "BSP");
            this.put("UA", "BSP");
            this.put("AT", "BSP");
            this.put("1R", "SU");
            this.put("1Y", "S7");
            this.put("1T", "\u04281");
        }
    };
    public static final Map<String, String> Printer2Blank = new HashMap<String, String>(){
        private static final long serialVersionUID = -3647150946626831143L;
        {
            this.put("RU", "BSP ETKT");
            this.put("UA", "BSP ETKT");
            this.put("AT", "BSP ETKT");
            this.put("1R", "555 ETKT");
            this.put("1Y", "421 ETKT");
            this.put("1T", "99A \u042d61");
        }
    };

    private static DateFormat createSegmentDateFormat() {
        return new SimpleDateFormat("ddMMM", LocaleUtil.LOCALE_EN);
    }

    public static boolean parseResponse(int currentCommand, String response, ComissionDataProxy dataProxy, Logger log, boolean ditkMode, List<Integer> pqNumbers, List<String> messages) {
        boolean success = true;
        if (response == null || response.startsWith(STR_SIGN_IN)) {
            return false;
        }
        switch (currentCommand) {
            case 0: {
                success = ComissionCommandParser.parseResponseReceivedFrom(response, dataProxy, messages);
                break;
            }
            case 1: {
                success = ComissionCommandParser.parseResponseSegments(response, dataProxy, log, messages);
                break;
            }
            case 2: {
                success = ComissionCommandParser.parseResponseNames(response, dataProxy, log, messages);
                break;
            }
            case 3: {
                success = ComissionCommandParser.parseResponsePrinters(response, dataProxy, messages);
                break;
            }
            case 4: {
                success = ComissionCommandParser.parseResponseRemarks(response, dataProxy, messages);
                break;
            }
            case 5: {
                success = ComissionCommandParser.parseResponseDK(response, dataProxy, messages);
                break;
            }
            case 6: {
                success = ComissionCommandParser.parsePQS(response, dataProxy, pqNumbers, messages);
                break;
            }
            default: {
                success = ComissionCommandParser.parsePQ(response, dataProxy, ditkMode, messages);
            }
        }
        return success;
    }

    public static boolean parsePQS(String response, ComissionDataProxy dataProxy, List<Integer> pqNumbers, List<String> messages) {
        boolean result = false;
        boolean atLeastOneNotManualPQ = false;
        String[] rows = ParsingUtils.getLines(response);
        boolean isInTable = false;
        for (String row : rows) {
            String[] cols;
            String pqNumber;
            if (row.contains("NAME") && row.contains("PQ") && row.contains("TYPE")) {
                isInTable = true;
                continue;
            }
            if (TextUtil.isBlank((String)row)) {
                isInTable = false;
            }
            if (!isInTable || TextUtil.isBlank((String)(pqNumber = ComissionCommandParser.checkForPqString(cols = row.trim().split("\\s+")))) || !pqNumbers.contains(Integer.valueOf(pqNumber))) continue;
            ComissionPQDataProxy pq = ComissionCommandParser.checkForPQ(pqNumber, dataProxy);
            ComissionNameDataProxy passenger = new ComissionNameDataProxy(cols[0], pq);
            dataProxy.getNames().add(passenger);
            pq.setManual(ComissionCommandParser.checkForManualPQType(cols));
            if (!pq.isManual()) {
                atLeastOneNotManualPQ = true;
            }
            dataProxy.getPqMap().put(pqNumber, pq);
            result = true;
        }
        if (!result) {
            messages.add("PQ NOT FOUND");
        }
        if (!atLeastOneNotManualPQ) {
            messages.add("SYSTEM PQ NOT FOUND");
            result = false;
        }
        return result;
    }

    private static boolean checkForManualPQType(String[] cols) {
        for (String col : cols) {
            if (!"M".equals(col)) continue;
            return true;
        }
        return false;
    }

    public static String checkForPqString(String[] cols) {
        String res = "";
        if (cols.length < 2) {
            return res;
        }
        String passNum = cols[0];
        Pattern p1 = Pattern.compile("\\d+\\.\\d+");
        Matcher m1 = p1.matcher(passNum);
        Pattern p2 = Pattern.compile("\\d+");
        boolean m2matches = false;
        for (int i = 1; i < cols.length; ++i) {
            Matcher m2 = p2.matcher(cols[i]);
            if (!m2.matches()) continue;
            m2matches = true;
            res = cols[i];
            break;
        }
        return m1.matches() && m2matches ? res : "";
    }

    public static boolean parsePQ(String response, ComissionDataProxy dataProxy, boolean ditkMode, List<String> messages) {
        boolean result = true;
        String[] rows = ParsingUtils.getLines(response.trim());
        String pqNumber = "";
        List<String> baseFare = null;
        List<String> equivFare = null;
        MiscUtil.Pair<BigDecimal, String> totalTax = null;
        List<String> totalFare = null;
        List<String> baseNumberTitles = null;
        String passengerType = "";
        ArrayList<String> fareBasisList = new ArrayList<String>();
        ArrayList<String> componentsList = new ArrayList<String>();
        String validatingCarrier = "";
        String tourCodeFromQualifier = null;
        String tourCodeFromPqBody = null;
        boolean isStringBaseNumbers = false;
        Date pqCreationDate = null;
        boolean isInTaxes = false;
        boolean isInComponents = false;
        boolean wasXTrow = false;
        HashMap<String, BigDecimal> taxesMap = new HashMap<String, BigDecimal>();
        ComissionPQDataProxy pq = null;
        List<Object> segmentsRestriction = new ArrayList();
        ArrayList<String> tailParts = new ArrayList<String>();
        StringBuilder componentsString = new StringBuilder();
        ArrayList<String> segmentLines = new ArrayList<String>();
        for (String row : rows) {
            if (TextUtil.isBlank((String)row)) continue;
            String[] cols = row.trim().split("\\s+");
            if (TextUtil.isBlank((String)pqNumber)) {
                String[] m1 = Pattern.compile("^PQ").matcher(cols.length > 0 ? cols[0] : "");
                Matcher m2 = Pattern.compile("\\d+").matcher(cols.length > 1 ? cols[1] : "");
                if (m1.matches() && m2.matches()) {
                    pqNumber = m2.group();
                    if (dataProxy.getPqMap().get(pqNumber) != null && dataProxy.getPqMap().get(pqNumber).isManual()) {
                        return false;
                    }
                    String tail = "";
                    for (int i = 2; i < cols.length; ++i) {
                        tail = tail + (tail.length() > 0 ? " " + cols[i] : cols[i]);
                    }
                    Pattern qPattern = Pattern.compile("[A-Za-z0-9/\\.\\-\\* ]+");
                    Matcher qualifier = qPattern.matcher(tail);
                    while (qualifier.find()) {
                        String q = qualifier.group();
                        if (!ComissionCommandParser.isValidQualificator(q, ditkMode)) continue;
                        tailParts.add(q);
                    }
                    for (String part : tailParts) {
                        Pattern p;
                        Matcher m;
                        if ((part = part.trim()).startsWith("S")) {
                            segmentsRestriction = ParsingUtils.parseNumberIntervals(part.trim().substring(1));
                        }
                        if (!(m = (p = Pattern.compile("UI\\*([A-Za-z0-9]+).*")).matcher(part)).matches()) continue;
                        tourCodeFromQualifier = m.group(1);
                    }
                }
            }
            if (isStringBaseNumbers) {
                if (cols.length == 4) {
                    baseFare = ComissionCommandParser.parseMoneyValue(cols[0]);
                    equivFare = ComissionCommandParser.parseMoneyValue(cols[1]);
                    totalTax = ComissionCommandParser.parseNumWordValue(cols[2]);
                    totalFare = ComissionCommandParser.parseMoneyValue(cols[3]);
                } else if (cols.length == 3) {
                    baseFare = ComissionCommandParser.parseMoneyValue(cols[0]);
                    equivFare = ComissionCommandParser.parseMoneyValue(cols[1]);
                    totalTax = ComissionCommandParser.parseNumWordValue(cols[1]);
                    if (!TextUtil.isBlank((String)((String)totalTax.getSecond()))) {
                        equivFare = null;
                    } else {
                        totalTax = null;
                    }
                    totalFare = ComissionCommandParser.parseMoneyValue(cols[2]);
                } else if (cols.length == 2) {
                    baseFare = ComissionCommandParser.parseMoneyValue(cols[0]);
                    totalFare = ComissionCommandParser.parseMoneyValue(cols[1]);
                } else {
                    totalFare = ComissionCommandParser.parseMoneyValue(cols[0]);
                }
                passengerType = totalFare.get(2);
                isStringBaseNumbers = false;
            }
            if (!(TextUtil.isBlank((String)pqNumber) || baseNumberTitles != null && baseNumberTitles.size() != 0 || (baseNumberTitles = ComissionCommandParser.checkForBaseNumbersTitle(cols)).size() <= 1)) {
                isStringBaseNumbers = true;
                continue;
            }
            if (!isInTaxes && taxesMap.keySet().size() == 0 && cols.length > 0 && cols[0].equals("XT")) {
                isInTaxes = true;
            }
            if (isInTaxes) {
                wasXTrow = true;
                for (String col : cols) {
                    MiscUtil.Pair<BigDecimal, String> tax = ComissionCommandParser.parseNumWordValue(col);
                    if (BigDecimal.ZERO.compareTo((BigDecimal)tax.getFirst()) != 0 && !TextUtil.isBlank((String)((String)tax.getSecond()))) {
                        BigDecimal taxValue = (BigDecimal)tax.getFirst();
                        String taxCode = (String)tax.getSecond();
                        if (taxesMap.containsKey(taxCode)) {
                            taxesMap.put(taxCode, ((BigDecimal)taxesMap.get(taxCode)).add(taxValue));
                            continue;
                        }
                        taxesMap.put(taxCode, taxValue);
                        continue;
                    }
                    if (col.equals("XT") || col.equals("BREAKDOWN")) continue;
                    isInTaxes = false;
                    break;
                }
            }
            if (isInComponents) {
                if (row.startsWith("LAST DAY")) continue;
                if (!row.startsWith("VALIDATING")) {
                    componentsString.append(row);
                } else {
                    isInComponents = false;
                }
            }
            if (!TextUtil.isBlank((String)passengerType) && cols.length > 1 && cols[0].startsWith(passengerType)) {
                for (int i = 1; i < cols.length; ++i) {
                    fareBasisList.add(cols[i]);
                }
                isInComponents = true;
            }
            if (TextUtil.isBlank((String)validatingCarrier) && cols.length > 3 && cols[0].equals("VALIDATING") && cols[1].equals("CARRIER")) {
                for (int i = 2; i < cols.length; ++i) {
                    if (cols[i].length() != 2) continue;
                    validatingCarrier = cols[i];
                    break;
                }
            }
            if (TextUtil.isBlank(tourCodeFromPqBody) && cols[0].equals("TOUR") && cols[1].startsWith("CODE")) {
                if (cols[1].length() > 5 && cols[1].indexOf(45) > 0) {
                    tourCodeFromPqBody = cols[1].substring(cols[1].indexOf(45) + 1);
                } else if (cols.length > 2) {
                    tourCodeFromPqBody = cols[2];
                }
            }
            if (cols.length <= 7 || !cols[0].trim().matches("\\d\\d") || fareBasisList.isEmpty()) continue;
            segmentLines.add(row);
        }
        if (rows.length > 4) {
            String lastRow = rows[rows.length - 1];
            Matcher m = PQ_DATE_PATTERN.matcher(lastRow);
            if (m.matches()) {
                try {
                    pqCreationDate = PQ_DATE_FORMAT.get().parse(m.group(1));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (lastRow.contains("ITIN CHG")) {
                dataProxy.getPqMap().get(pqNumber).setOldPQ(true);
                return false;
            }
        }
        if (!wasXTrow && totalTax != null && BigDecimal.ZERO.compareTo((BigDecimal)totalTax.getFirst()) != 0 && !TextUtil.isBlank((String)((String)totalTax.getSecond()))) {
            taxesMap.put((String)totalTax.getSecond(), (BigDecimal)totalTax.getFirst());
        }
        if (!TextUtil.isBlank((String)componentsString.toString())) {
            ComissionCommandParser.composeSegmentsToSegmentTariffs(componentsString.toString(), dataProxy, pqNumber);
            ArrayList<Integer> positions = new ArrayList<Integer>();
            positions.add(0);
            String component = componentsString.toString();
            int maxPos = -1;
            for (String fareBasis : fareBasisList) {
                int from = 0;
                while (component.indexOf(fareBasis, from) >= 0) {
                    int pos = component.indexOf(fareBasis, from) + fareBasis.length();
                    if (pos > maxPos) {
                        maxPos = pos;
                    }
                    positions.add(pos);
                    from = pos;
                }
            }
            if (positions.size() == 1) {
                if (component.contains("END")) {
                    component = component.substring(0, component.indexOf("END"));
                }
                Matcher m = Pattern.compile("(\\s[A-Z]{3,6}|NUC){1}(\\sQ(\\s[A-Z]+)?([0-9]+(\\.[0-9]+)?)+\\s)?([0-9]+(\\.[0-9]+){1})+").matcher(component);
                int start = 0;
                while (m.find(start)) {
                    if (!m.group().trim().startsWith("ROE")) {
                        positions.add(m.end());
                    }
                    start = m.end();
                }
            } else {
                int pos = component.indexOf("END", maxPos) + "END".length();
                positions.add(pos);
            }
            Collections.sort(positions);
            for (int i = 0; i < positions.size() - 1; ++i) {
                String str = component.substring((Integer)positions.get(i), (Integer)positions.get(i + 1));
                if (TextUtil.isBlank((String)str)) continue;
                Matcher mNuc = Pattern.compile("([A-Z]{3})").matcher(str);
                int count = 0;
                String first = null;
                while (mNuc.find()) {
                    ++count;
                    if (first != null) continue;
                    first = mNuc.group();
                }
                if (count <= 1 && "NUC".equals(first)) continue;
                componentsList.add(str.trim());
            }
        }
        if (fareBasisList.size() < componentsList.size()) {
            ComissionCommandParser.updateFareBasisList(fareBasisList, segmentLines);
        }
        if (dataProxy.getPqMap().keySet().contains(pqNumber)) {
            pq = dataProxy.getPqMap().get(pqNumber);
            if (baseFare != null) {
                pq.setBaseFareMoney(baseFare.get(0));
                pq.setBaseFareValue(baseFare.get(1));
            }
            if (equivFare != null) {
                pq.setEqFareMoney(equivFare.get(0));
                pq.setEqFareValue(equivFare.get(1));
            }
            if (totalTax != null && totalTax.getFirst() != null) {
                pq.setTotalTaxMoney("");
                pq.setTotalTaxValue(((BigDecimal)totalTax.getFirst()).toString());
            }
            if (totalFare != null) {
                pq.setTotalFareMoney(totalFare.get(0));
                pq.setTotalFareValue(totalFare.get(1));
                pq.setPassengerType(passengerType);
            }
            pq.setValidatingCarrier(validatingCarrier);
            pq.setTourCode(!TextUtil.isBlank(tourCodeFromQualifier) ? tourCodeFromQualifier : tourCodeFromPqBody);
            pq.setTaxes(taxesMap);
            pq.getFareBasisList().addAll(fareBasisList);
            for (ComissionSegmentDataProxy seg : dataProxy.getSegments()) {
                seg.setFareBasis(fareBasisList.size() > 0 ? (String)fareBasisList.get(0) : "");
            }
            pq.setNuc(null);
            pq.setQualificators(tailParts);
            pq.getFareComponentStringList().addAll(componentsList);
            pq.setCreationDate(pqCreationDate);
        }
        HashMap<String, ComissionSegmentDataProxy> segMap = new HashMap<String, ComissionSegmentDataProxy>();
        for (ComissionSegmentDataProxy seg : dataProxy.getSegments()) {
            segMap.put(seg.getRownum(), seg);
        }
        for (Integer segNum : segmentsRestriction) {
            if (!segMap.containsKey(segNum.toString())) continue;
            ((ComissionSegmentDataProxy)segMap.get(segNum.toString())).getPqNumbers().add(pqNumber);
        }
        return result;
    }

    private static void updateFareBasisList(List<String> fareBasisList, List<String> segmentLines) {
        ListIterator<String> iter = fareBasisList.listIterator();
        while (iter.hasNext()) {
            String fareBasis = iter.next();
            int amountInSegments = ComissionCommandParser.countFareBasisInSegments(segmentLines, fareBasis);
            while (Collections.frequency(fareBasisList, fareBasis) < amountInSegments) {
                iter.add(fareBasis);
            }
        }
    }

    private static int countFareBasisInSegments(List<String> segments, String fareBasis) {
        return (int)segments.stream().filter(s -> s.contains(fareBasis)).count();
    }

    private static boolean isValidQualificator(String str, boolean ditkMode) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        String trimmedStr = str.trim();
        if (trimmedStr.equals("PADT") || trimmedStr.equals("PCNN") || trimmedStr.equals("PINF") || trimmedStr.equals("RQ") || str.equals("RQA")) {
            return false;
        }
        Matcher matcherKP = Pattern.compile("^KP\\d").matcher(str);
        Matcher matcherK = Pattern.compile("^K\\d").matcher(str);
        if (!ditkMode && (matcherKP.find() || matcherK.find())) {
            return false;
        }
        Matcher matcherS = Pattern.compile("^S[0-9]+[0-9\\-/]*(\\*[A-Z0-9]+)*").matcher(str);
        if (str.startsWith("S") && !matcherS.matches()) {
            return false;
        }
        Matcher matcherN = Pattern.compile("^N[0-9]+\\.[0-9]+").matcher(str);
        if (matcherN.find()) {
            return false;
        }
        return !str.equals("NC") && !str.equals("NCB") && !str.startsWith("TC-");
    }

    private static List<String> checkForBaseNumbersTitle(String[] cols) {
        ArrayList<String> res = new ArrayList<String>();
        for (String col : cols) {
            if (col.equals(PQ_TITLE_BASE_FARE)) {
                res.add(PQ_TITLE_BASE_FARE);
            }
            if (col.equals(PQ_TITLE_EQUIV_FARE)) {
                res.add(PQ_TITLE_EQUIV_FARE);
            }
            if (col.equals(PQ_TITLE_TOTAL_FARE) || col.contains("CHARGESTOTAL")) {
                res.add(PQ_TITLE_TOTAL_FARE);
            }
            if (!col.equals(PQ_TITLE_TOTAL_TAX)) continue;
            res.add(PQ_TITLE_TOTAL_TAX);
        }
        return res;
    }

    public static boolean parseResponseSegments(String response, ComissionDataProxy dataProxy, Logger log, List<String> messages) {
        boolean result = true;
        String[] rows = ParsingUtils.getLines(response.trim());
        boolean segmentsFound = false;
        for (String row : rows) {
            if (row.trim().length() < 10) continue;
            if (row.startsWith(SEGMENT_OPERATED_BY) && row.length() > SEGMENT_OPERATED_BY.length() && dataProxy.getSegments().size() > 0) {
                ComissionSegmentDataProxy seg = dataProxy.getSegments().get(dataProxy.getSegments().size() - 1);
                seg.setOperatingCarrier(row.substring(SEGMENT_OPERATED_BY.length()).trim());
                continue;
            }
            while (row.indexOf(45) > -1) {
                row = row.replace('-', ' ');
            }
            while (row.indexOf(42) > -1) {
                row = row.replace('*', ' ');
            }
            String[] cols = row.trim().split("[\\s]+");
            if (cols.length > 1 && cols[1].length() > 3) {
                int airlineStop = row.indexOf(cols[1]) + 2;
                StringBuilder sb = new StringBuilder(row);
                sb.insert(airlineStop, " ");
                row = sb.toString();
                cols = row.trim().split("[\\s]+");
            }
            if (cols.length < 9 || cols.length > 13 || cols[0].length() > 2 || cols[3].length() != 5 || cols[5].length() != 6 || cols[1].equals("OTH") || cols[1].equals("CAR") || cols[1].equals("HHL")) {
                if (log == null) continue;
                log.debug("=== WARN: line ignored while parsing segments: " + row);
                continue;
            }
            ComissionSegmentDataProxy segment = new ComissionSegmentDataProxy();
            segment.setRownum(ComissionCommandParser.getRownum(cols));
            segment.setAirline(ComissionCommandParser.getAirline(cols));
            segment.setArriveLocation(ComissionCommandParser.getArriveLocation(cols));
            segment.setDepartureLocation(ComissionCommandParser.getDepartureLocation(cols));
            segment.setClassOfSvcCode(ComissionCommandParser.getClassOfSvcCode(cols));
            segment.setFlightNo(ComissionCommandParser.getFlightNo(cols));
            segment.setStartDate(ComissionCommandParser.getStartDate(cols));
            segment.setEndDate(ComissionCommandParser.getEndDate(cols));
            dataProxy.getSegments().add(segment);
            segmentsFound = true;
        }
        if (!segmentsFound) {
            result = false;
            messages.add("ITINERARY NOT FOUND");
        }
        return result;
    }

    public static boolean parseResponseRemarks(String response, ComissionDataProxy dataProxy, List<String> messages) {
        boolean result = true;
        dataProxy.setRemark(response);
        String[] rows = ParsingUtils.getLines(response);
        dataProxy.setNotApplyTripartiteContracts(false);
        for (String tempRow : rows) {
            String row = tempRow.trim();
            if (!TextUtil.isBlank((String)dataProxy.getCustomerNumber())) continue;
            ComissionCommandParser.checkForCustomerNumber(row, dataProxy);
        }
        return result;
    }

    public static boolean parseResponseDK(String response, ComissionDataProxy dataProxy, List<String> messages) {
        boolean result = true;
        String[] rows = ParsingUtils.getLines(response);
        if (rows.length > 0) {
            result = ComissionCommandParser.checkForCustomerNumber(rows[0], dataProxy);
        }
        if (!result) {
            messages.add("CUSTOMER NUMBER (DK) NOT FOUND");
        }
        return true;
    }

    private static ComissionPQDataProxy checkForPQ(String pqNumber, ComissionDataProxy dataProxy) {
        if (dataProxy.getPqMap().containsKey(pqNumber)) {
            return dataProxy.getPqMap().get(pqNumber);
        }
        return new ComissionPQDataProxy(pqNumber);
    }

    public static List<String> parseMoneyValue(String str) {
        ArrayList<String> res = new ArrayList<String>();
        Matcher m1 = Pattern.compile("^[a-zA-Z]+").matcher(str);
        res.add(m1.find() ? m1.group() : "");
        Matcher m2 = Pattern.compile("\\d+\\.?\\d+|\\d+").matcher(str);
        res.add(m2.find() ? m2.group() : "");
        if (str.length() > 3) {
            String last3 = str.substring(str.length() - 3);
            if (Character.isDigit(str.charAt(str.length() - 4)) && Character.isLetter(last3.charAt(0))) {
                res.add(last3);
            } else {
                res.add("");
            }
        }
        return res;
    }

    private static MiscUtil.Pair<BigDecimal, String> parseNumWordValue(String str) {
        MiscUtil.Pair res = new MiscUtil.Pair((Object)BigDecimal.ZERO, (Object)"");
        Matcher m = Pattern.compile("^(\\d+\\.?\\d+|\\d+)([a-zA-Z]{1}[a-zA-Z0-9]{1})$").matcher(str);
        if (m.matches()) {
            res.setFirst((Object)ParsingUtils.getBigDecimalFromString(m.group(1)));
            res.setSecond((Object)m.group(2));
        }
        return res;
    }

    public static List<String> getFareComponentValues(String row, String field) {
        int k;
        int j;
        int i;
        ArrayList<String> res = new ArrayList<String>();
        String value = "";
        String fareBasis = "";
        String s = row.substring(row.indexOf(field) + field.length());
        for (i = 0; i < s.length() && !Character.isDigit(s.charAt(i)); ++i) {
        }
        for (j = i; j < s.length() && (Character.isDigit(s.charAt(j)) || s.charAt(j) == '.'); ++j) {
        }
        value = s.substring(i, j);
        for (k = j; k < s.length(); ++k) {
        }
        fareBasis = s.substring(j, k);
        res.add(value);
        res.add(fareBasis);
        return res;
    }

    public static boolean parseResponseReceivedFrom(String response, ComissionDataProxy dataProxy, List<String> messages) {
        String row1;
        boolean result = true;
        String receivedFrom = null;
        String cashierCode = null;
        String recordLocator = null;
        String[] rows = ParsingUtils.getLines(response);
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : rows) {
            if (s.length() <= 3) continue;
            lines.add(s);
        }
        if (lines.size() >= 2) {
            row1 = ((String)lines.get(0)).trim();
            String row2 = ((String)lines.get(1)).trim();
            receivedFrom = ComissionCommandParser.getReceivedFrom(row1);
            cashierCode = ComissionCommandParser.getCashierCode(row2);
            recordLocator = ComissionCommandParser.getRecordLocator(row2);
        } else if (lines.size() == 1) {
            row1 = ((String)lines.get(0)).trim();
            cashierCode = ComissionCommandParser.getCashierCode(row1);
            recordLocator = ComissionCommandParser.getRecordLocator(row1);
        }
        dataProxy.setRecordLocator(recordLocator);
        dataProxy.setCashierCode(cashierCode);
        dataProxy.setReceivedFrom(receivedFrom);
        return result;
    }

    public static boolean parseResponseNames(String response, ComissionDataProxy dataProxy, Logger log, List<String> messages) {
        String[] rows;
        boolean result = true;
        for (String tempRow : rows = ParsingUtils.getLines(response)) {
            String row;
            boolean res;
            if (TextUtil.isBlank((String)tempRow) || tempRow.length() < 3 || (res = ComissionCommandParser.parseResponseNames(row = tempRow.trim() + " ", dataProxy)) || log == null) continue;
            log.error("Unknown format for passenger names: " + row);
            result = false;
            messages.add("PASSENGER NAMES NOT FOUND");
        }
        return result;
    }

    private static boolean parseResponseNames(String row, ComissionDataProxy dataProxy) {
        if (TextUtil.isBlank((String)row)) {
            return false;
        }
        Pattern p = Pattern.compile("\\s*(\\d+)\\.(\\d+|I\\s*/\\d)([A-Z /\\-]+)");
        Matcher m = p.matcher(row);
        boolean somethingFound = false;
        while (m.find()) {
            String[] parts;
            String numberPrefix = m.group(1);
            String numberSuffix = m.group(2);
            String names = m.group(3);
            if (names == null || (parts = (names = names.trim()).split("/")).length <= 1) continue;
            String lastName = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String firstName = parts[i];
                String title = "";
                if (parts[i] != null && (parts[i].endsWith(" MR") || parts[i].endsWith(" MRS") || parts[i].endsWith(" MS") || parts[i].endsWith(" MSTR"))) {
                    firstName = parts[i].substring(0, parts[i].lastIndexOf(" "));
                    title = parts[i].substring(parts[i].lastIndexOf(" "));
                    if (firstName != null) {
                        firstName = firstName.trim();
                    }
                    if (title != null) {
                        title = title.trim();
                    }
                }
                ComissionFullNameDataProxy curName = new ComissionFullNameDataProxy();
                curName.setLastName(lastName);
                curName.setFirstName(firstName);
                curName.setTitle(title);
                curName.setNumber(numberPrefix + "." + String.valueOf(i));
                if (numberSuffix.contains("I")) {
                    curName.setInfant(true);
                }
                ComissionCommandParser.addName(curName, dataProxy);
                somethingFound = true;
            }
        }
        return somethingFound;
    }

    public static boolean parseResponsePrinters(String response, ComissionDataProxy dataProxy, List<String> messages) {
        String[] rows = ParsingUtils.getLines(response);
        boolean result = true;
        if (rows.length < 3) {
            return false;
        }
        if (rows[2].length() < 13) {
            return false;
        }
        String printer = rows[2].substring(11, 13);
        dataProxy.setPcc(ComissionCommandParser.getPcc(rows[0]));
        dataProxy.setTicketingCashierCode(ComissionCommandParser.getCashierCode(rows[0]));
        dataProxy.setPrinter(printer);
        dataProxy.setBlankOwnerCode(Printer2Owner.get(printer));
        dataProxy.setBlankTypeCode(Printer2Blank.get(printer));
        if (dataProxy.getBlankOwnerCode() == null || dataProxy.getBlankTypeCode() == null) {
            result = false;
            messages.add("PRINTER NOT ASSIGNED");
        }
        return result;
    }

    private static void addName(ComissionFullNameDataProxy curName, ComissionDataProxy dataProxy) {
        dataProxy.getFullNames().add(new ComissionFullNameDataProxy(curName.getNumber(), curName.getFirstName(), curName.getLastName(), curName.getTitle(), curName.isInfant()));
    }

    private static String getReceivedFrom(String str) {
        String res = "";
        if (str.contains(STR_RECEIVED_FROM)) {
            res = new StringBuilder(str).substring(str.indexOf(STR_RECEIVED_FROM) + STR_RECEIVED_FROM.length()).trim();
        }
        return res;
    }

    private static String getPcc(String str) {
        return str.length() > 3 ? str.substring(0, 4) : str;
    }

    private static String getCashierCode(String str) {
        int ast = str.indexOf("*A");
        int space = str.indexOf(" ", ast);
        return str.substring(ast + 2, space);
    }

    private static String getRecordLocator(String str) {
        String res = "";
        String[] tokensRow2 = str.split("[\\s\\.]+");
        for (int i = tokensRow2.length - 1; i >= 0; --i) {
            if (tokensRow2[i].length() != 6) continue;
            res = tokensRow2[i];
            break;
        }
        return res;
    }

    private static String getStartDate(String[] cols) {
        String res = cols.length >= 4 ? cols[3] : "";
        return res;
    }

    private static String getEndDate(String[] cols) {
        String res = cols.length >= 10 ? cols[9] : "";
        try {
            ComissionCommandParser.createSegmentDateFormat().parse(res);
        }
        catch (ParseException e) {
            res = cols.length >= 4 ? cols[3] : "";
        }
        return res;
    }

    private static String getFlightNo(String[] cols) {
        String res;
        String string = res = cols.length >= 3 ? cols[2] : "";
        if (!res.equals("") && !Character.isDigit(res.charAt(res.length() - 1))) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    private static String getClassOfSvcCode(String[] cols) {
        String res;
        String string = res = cols.length >= 3 ? cols[2] : "";
        res = !res.equals("") && !Character.isDigit(res.charAt(res.length() - 1)) ? res.substring(res.length() - 1) : (cols.length >= 4 ? cols[3] : "");
        return res;
    }

    private static String getDepartureLocation(String[] cols) {
        String res = cols.length >= 6 ? cols[5] : "";
        return res.length() > 3 ? res.substring(0, 3) : res;
    }

    private static String getArriveLocation(String[] cols) {
        String res = cols.length >= 6 ? cols[5] : "";
        return res.length() > 3 ? res.substring(3, res.length()) : res;
    }

    private static String getAirline(String[] cols) {
        String res = cols.length >= 2 ? cols[1] : "";
        return res;
    }

    private static String getRownum(String[] cols) {
        String res = cols.length >= 1 ? cols[0] : "";
        return res;
    }

    private static boolean checkForCustomerNumber(String str, ComissionDataProxy dataProxy) {
        if (str.contains(REMARK_CUSTOMER_NUMBER)) {
            String res = null;
            int indexOfSpaceAfterNumber = str.indexOf(" ", str.indexOf(REMARK_CUSTOMER_NUMBER) + REMARK_CUSTOMER_NUMBER.length());
            res = new StringBuilder(str).substring(str.indexOf(REMARK_CUSTOMER_NUMBER) + REMARK_CUSTOMER_NUMBER.length(), indexOfSpaceAfterNumber != -1 ? indexOfSpaceAfterNumber : str.length()).trim();
            dataProxy.setCustomerNumber(res);
            return true;
        }
        return false;
    }

    public static void checkForValidatingCarrier(String row, ComissionDataProxy dataProxy) {
        if (row.contains(REMARK_VALIDATING_CARRIER)) {
            dataProxy.setValidatingCarrier(row.substring(row.indexOf(REMARK_VALIDATING_CARRIER) + REMARK_VALIDATING_CARRIER.length()));
        }
    }

    private static void composeSegmentsToSegmentTariffs(String fareData, ComissionDataProxy dataProxy, String pqNumber) {
        Matcher fareDataComponentMatcher = fareDataComponentPattern.matcher(fareData);
        BigDecimal amountAccumulator = BigDecimal.ZERO;
        String arrivalCity = null;
        String carrierCode = null;
        if (TextUtil.isBlank((String)pqNumber)) {
            pqNumber = "1";
        }
        ArrayList<ComissionSegmentDataProxy> lineSegments = new ArrayList<ComissionSegmentDataProxy>();
        while (fareDataComponentMatcher.find()) {
            String carrier;
            if (fareDataComponentMatcher.group(6) != null) {
                arrivalCity = null;
                continue;
            }
            String city = fareDataComponentMatcher.group(4);
            if (city != null) {
                if (arrivalCity == null) {
                    arrivalCity = city;
                    continue;
                }
                if (carrierCode != null) {
                    String departureCity = arrivalCity;
                    arrivalCity = city;
                    ComissionSegmentDataProxy segment = ComissionCommandParser.getSegmentByCodes(dataProxy.getSegments(), departureCity, arrivalCity, carrierCode);
                    if (segment != null) {
                        lineSegments.add(segment);
                    }
                    carrierCode = null;
                    continue;
                }
            }
            if ((carrier = fareDataComponentMatcher.group(5)) != null) {
                carrierCode = carrier;
                continue;
            }
            int amountStart = fareDataComponentMatcher.start(2);
            String possibleCarrier = ComissionCommandParser.isPartOfAirlineCode(fareData, amountStart);
            if (possibleCarrier != null) {
                carrierCode = possibleCarrier;
                continue;
            }
            if (fareDataComponentMatcher.group(2) == null) continue;
            amountAccumulator = amountAccumulator.add(new BigDecimal(fareDataComponentMatcher.group(2)));
            if (ComissionCommandParser.checkAllMarks(fareData, amountStart)) continue;
            if (!lineSegments.isEmpty()) {
                ArrayList<ComissionSegmentDataProxy> segments = new ArrayList<ComissionSegmentDataProxy>();
                segments.addAll(lineSegments);
                if (!dataProxy.getSegmentTariffs().containsKey(pqNumber)) {
                    dataProxy.getSegmentTariffs().put(pqNumber, new ArrayList());
                }
                dataProxy.getSegmentTariffs().get(pqNumber).add(segments);
            }
            amountAccumulator = BigDecimal.ZERO;
            lineSegments.clear();
        }
        if (!lineSegments.isEmpty()) {
            ArrayList<ComissionSegmentDataProxy> segments = new ArrayList<ComissionSegmentDataProxy>();
            segments.addAll(lineSegments);
            if (!dataProxy.getSegmentTariffs().containsKey(pqNumber)) {
                dataProxy.getSegmentTariffs().put(pqNumber, new ArrayList());
            }
            dataProxy.getSegmentTariffs().get(pqNumber).add(segments);
        }
    }

    private static ComissionSegmentDataProxy getSegmentByCodes(List<ComissionSegmentDataProxy> segments, String departureCity, String arrivalCity, String carrierCode) {
        for (ComissionSegmentDataProxy seg : segments) {
            if (!TextUtil.isSame((String)seg.getAirline(), (String)carrierCode)) continue;
            if (TextUtil.isSame((String)seg.getDepartureLocation(), (String)departureCity) && TextUtil.isSame((String)seg.getArriveLocation(), (String)arrivalCity)) {
                return seg;
            }
            Set<String> departureAirportCodes = DictHelper.findAirportCodesByCode(departureCity);
            Set<String> arrivalAirportCodes = DictHelper.findAirportCodesByCode(arrivalCity);
            if (!departureAirportCodes.contains(seg.getDepartureLocation()) || !arrivalAirportCodes.contains(seg.getArriveLocation())) continue;
            return seg;
        }
        return null;
    }

    private static boolean checkAllMarks(String fareData, int amountStart) {
        return ComissionCommandParser.checkFuelTaxMarkAtIndex(fareData, amountStart, 1) || ComissionCommandParser.checkFuelTaxMarkAtIndex(fareData, amountStart, 2) || ComissionCommandParser.checkTaxMarkInTheEnd(fareData, amountStart);
    }

    private static boolean checkFuelTaxMarkAtIndex(String fareData, int amountStart, int i) {
        return ComissionCommandParser.checkTaxMarkAtIndex(fareData, amountStart, i, 'Q');
    }

    private static boolean checkTaxMarkInTheEnd(String fareData, int amountStart) {
        return ComissionCommandParser.checkTaxMarkAtIndex(fareData, amountStart, 2, 'P') || ComissionCommandParser.checkTaxMarkAtIndex(fareData, amountStart, 2, 'D');
    }

    private static boolean checkTaxMarkAtIndex(String fareData, int amountStart, int i, char mark) {
        int pos1 = amountStart - i;
        int pos2 = pos1 - 1;
        if (pos2 < 0) {
            return false;
        }
        return fareData.charAt(pos1) == mark && (fareData.charAt(pos2) == ' ' || fareData.charAt(pos2) >= '0' && fareData.charAt(pos2) <= '9');
    }

    protected static String isPartOfAirlineCode(String fareData, int amountStart) {
        if (amountStart + 1 >= fareData.length() || amountStart < 2) {
            return null;
        }
        char firstCharOnTheLeft = fareData.charAt(amountStart - 1);
        char secondCharOnTheLeft = fareData.charAt(amountStart - 2);
        char firstCharOnTheRight = fareData.charAt(amountStart + 1);
        char secondCharOnTheRight = fareData.charAt(amountStart + 2);
        char currentChar = fareData.charAt(amountStart);
        if (ComissionCommandParser.checkOneSideOfCarrier(firstCharOnTheLeft, secondCharOnTheLeft, firstCharOnTheRight)) {
            return firstCharOnTheLeft + "" + currentChar;
        }
        if (ComissionCommandParser.checkOneSideOfCarrier(firstCharOnTheRight, secondCharOnTheRight, firstCharOnTheLeft)) {
            return currentChar + "" + firstCharOnTheRight;
        }
        return null;
    }

    private static boolean checkOneSideOfCarrier(char firstChar, char secondChar, char firstCharOnTheOtherSide) {
        return firstChar >= 'A' && firstChar <= 'Z' && ComissionCommandParser.isSpaceOrDigitOrStar(secondChar) && ComissionCommandParser.isSpaceOrStar(firstCharOnTheOtherSide);
    }

    private static boolean isSpaceOrDigitOrStar(char c) {
        return ComissionCommandParser.isSpaceOrStar(c) || c >= '0' && c <= '9';
    }

    private static boolean isSpaceOrStar(char c) {
        return c == ' ' || c == '*';
    }

    static enum NameParsingState {
        number,
        lastName,
        name,
        title;

    }
}

