/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre.calcfee;

import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionFullNameDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionNameDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionPQDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ComissionSegmentDataProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ComissionDataProxy {
    private String customerNumber;
    private String recordLocator;
    private String receivedFrom;
    private String cashierCode;
    private String ticketingCashierCode;
    private String pcc;
    private String validatingCarrier;
    private String printer;
    private String blankOwnerCode;
    private String blankTypeCode;
    private String remark;
    private boolean notApplyTripartiteContracts = false;
    private final List<ComissionNameDataProxy> names = new ArrayList<ComissionNameDataProxy>();
    private final List<ComissionFullNameDataProxy> fullNames = new ArrayList<ComissionFullNameDataProxy>();
    private final LinkedHashMap<String, ComissionPQDataProxy> pqMap = new LinkedHashMap();
    private final List<ComissionSegmentDataProxy> segments = new ArrayList<ComissionSegmentDataProxy>();
    private final Map<String, List<List<ComissionSegmentDataProxy>>> segmentTariffs = new HashMap<String, List<List<ComissionSegmentDataProxy>>>();

    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    public String getRecordLocator() {
        return this.recordLocator;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setReceivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    public String getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setCashierCode(String cashierCode) {
        this.cashierCode = cashierCode;
    }

    public String getCashierCode() {
        return this.cashierCode;
    }

    public String getTicketingCashierCode() {
        return this.ticketingCashierCode;
    }

    public void setTicketingCashierCode(String ticketingCashierCode) {
        this.ticketingCashierCode = ticketingCashierCode;
    }

    public void setPcc(String pcc) {
        this.pcc = pcc;
    }

    public String getPcc() {
        return this.pcc;
    }

    public List<ComissionSegmentDataProxy> getSegments() {
        return this.segments;
    }

    public Map<String, List<List<ComissionSegmentDataProxy>>> getSegmentTariffs() {
        return this.segmentTariffs;
    }

    public void testPrint() {
        System.out.println("===== Comission Data Proxy ======");
        System.out.println("recordLocator = " + this.getRecordLocator());
        System.out.println("receivedFrom = " + this.getReceivedFrom());
        System.out.println("pcc = " + this.getPcc());
        System.out.println("cashierCode = " + this.getCashierCode());
        System.out.println("ValidatingCarrier = " + this.getValidatingCarrier());
        System.out.println("Printer = " + this.getPrinter());
        System.out.println("NAMES");
        for (ComissionNameDataProxy name : this.names) {
            System.out.println("------------------");
            System.out.println("Number - " + name.getNumber());
            System.out.println("PQ - " + name.getPqData().getNumber());
        }
        System.out.println("SEGMENTS: ");
        for (ComissionSegmentDataProxy seg : this.segments) {
            System.out.println("------------------");
            System.out.println("rownum " + seg.getRownum());
            System.out.println("airline " + seg.getAirline());
            System.out.println("flightNo " + seg.getFlightNo());
            System.out.println("classOfSvcCode " + seg.getClassOfSvcCode());
            System.out.println("arriveLocation " + seg.getArriveLocation());
            System.out.println("departureLocation " + seg.getDepartureLocation());
            System.out.println("startDate " + seg.getStartDate());
        }
        System.out.println("PQS: ");
        for (String key : this.getPqMap().keySet()) {
            ComissionPQDataProxy pq = this.getPqMap().get(key);
            System.out.println("Number - " + pq.getNumber());
            System.out.println("Base Fare Money - " + pq.getBaseFareValue() + pq.getBaseFareMoney());
            System.out.println("EQ Fare money - " + pq.getEqFareValue() + pq.getEqFareMoney());
            System.out.println("Total Fare - " + pq.getTotalFareValue() + pq.getTotalFareMoney());
            System.out.println("Total Tax - " + pq.getTotalTaxValue() + pq.getTotalTaxMoney());
            System.out.println("Passenger Type - " + pq.getPassengerType());
            for (String key2 : pq.getTaxes().keySet()) {
                System.out.println("Tax - code = " + key2 + " value = " + pq.getTaxes().get(key2));
            }
            String fareBasises = "";
            StringBuilder sb = new StringBuilder();
            for (String item : pq.getFareBasisList()) {
                sb.append(" " + item);
            }
            fareBasises = sb.toString();
            System.out.println("Fare Basis: " + fareBasises);
            System.out.println("ValidatingCarrier - " + pq.getValidatingCarrier());
        }
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public List<ComissionNameDataProxy> getNames() {
        return this.names;
    }

    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    public String getValidatingCarrier() {
        return this.validatingCarrier;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setBlankOwnerCode(String blankOwnerCode) {
        this.blankOwnerCode = blankOwnerCode;
    }

    public String getBlankOwnerCode() {
        return this.blankOwnerCode;
    }

    public void setBlankTypeCode(String blankTypeCode) {
        this.blankTypeCode = blankTypeCode;
    }

    public String getBlankTypeCode() {
        return this.blankTypeCode;
    }

    public Map<String, ComissionPQDataProxy> getPqMap() {
        return this.pqMap;
    }

    public List<ComissionFullNameDataProxy> getFullNames() {
        return this.fullNames;
    }

    public boolean isNotApplyTripartiteContracts() {
        return this.notApplyTripartiteContracts;
    }

    public void setNotApplyTripartiteContracts(boolean notApplyTripartiteContracts) {
        this.notApplyTripartiteContracts = notApplyTripartiteContracts;
    }
}

