/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre.calcfee;

import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ParsingUtils {
    public static final char SABRE_CROSS_OF_LORRAINE_CHARACTER = '\u0081';
    public static final char SABRE_CHANGE = '\u00a4';
    public static final char SABRE_CROSS_OF_LORRAINE = '\u00a5';
    public static final Pattern PQ_PATTERN = Pattern.compile("^PQ([1-9]{1}[0-9]{0,1}(-[1-9]{1}[0-9]{0,1})?((/[1-9]{1}[0-9]{0,1})+(-[1-9]{1}[0-9]{0,1})?)*)");

    public static String[] getLines(String str) {
        String[] lines;
        ArrayList<String> res = new ArrayList<String>();
        for (String line : lines = str.split("[\\n\\r]+")) {
            if (TextUtil.isBlank((String)line)) continue;
            res.add(line);
        }
        return res.toArray(new String[0]);
    }

    public static String[] getLinesByCaretAndSpaces(String str) {
        return str.split("[\\n\\r]+|\\s\u0081|\\s\u00a5|\\s\\s\\?");
    }

    public static BigDecimal getBigDecimalFromString(String str) {
        BigDecimal res;
        try {
            res = new BigDecimal(str);
        }
        catch (Exception e) {
            res = BigDecimal.ZERO;
        }
        return res;
    }

    public static List<Integer> parseNumberIntervals(String str) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        return ParsingUtils.parseNumberIntervals(numbers, str);
    }

    public static List<Integer> parseNumberIntervals(List<Integer> numbers, String str) {
        if (str != null) {
            for (String item : str.trim().split("/")) {
                if (TextUtil.isBlank((String)item)) continue;
                int minNumber = 0;
                int maxNumber = -1;
                try {
                    if (item.contains("-")) {
                        minNumber = Integer.parseInt(item.substring(0, item.indexOf("-")));
                        maxNumber = Integer.parseInt(item.substring(item.indexOf("-") + 1));
                    } else {
                        maxNumber = minNumber = Integer.parseInt(item);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int n = minNumber; n <= maxNumber; ++n) {
                    numbers.add(n);
                }
            }
        }
        return numbers;
    }
}

