/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DictSyncHelper {
    public static <T extends BaseDictionary> Collection<T> searchByCodeVariants(T dictToSearch, Class<T> clazz, Matcher<T> matcher, CodeSystem ... codeSystems) {
        LinkedHashSet<BaseDictionary> result = new LinkedHashSet<BaseDictionary>();
        for (CodeSystem codeSystem : codeSystems) {
            String code = (String)dictToSearch.getCodeVariants().get(codeSystem.name());
            if (TextUtil.isBlank((String)code)) continue;
            for (BaseDictionary foundDict : DictionaryCache.get().lookup(clazz, code, new String[]{codeSystem.name()})) {
                if (!matcher.match(foundDict, dictToSearch)) continue;
                result.add(foundDict);
            }
        }
        return result;
    }

    public static <T extends BaseDictionary> T search(DictionaryReference<T> ref, Collection<? extends BaseDictionary> dictionaries, Class<T> clazz) {
        if (ref == null || TextUtil.isBlank((String)ref.getCode())) {
            return null;
        }
        BaseDictionary dictionary = null;
        for (BaseDictionary baseDictionary : dictionaries) {
            BaseDictionary dict;
            if (!clazz.isInstance(baseDictionary) || !TextUtil.isSame((String)(dict = (BaseDictionary)clazz.cast(baseDictionary)).getCode(), (String)ref.getCode())) continue;
            dictionary = dict;
            break;
        }
        if (dictionary == null) {
            return null;
        }
        Object result = DictSyncHelper.loadByUid(clazz, dictionary.getRemoteUid());
        if (result == null) {
            result = DictSyncHelper.loadByUid(clazz, dictionary.getUid());
        }
        if (result == null) {
            result = DictionaryCache.get().findByRemoteUid(clazz, dictionary.getUid());
        }
        if (result == null) {
            result = HandlersRegistry.get().findDictionaryHandler(clazz).search(dictionary);
        }
        return result;
    }

    public static <T extends BaseDictionary> T loadByUid(Class<T> cls, String uid) {
        if (TextUtil.isBlank((String)uid)) {
            return null;
        }
        EntityContainer container = EntityStorage.get().load(cls, uid);
        return (T)(container != null ? (BaseDictionary)container.getEntity() : null);
    }

    public static void replaceDuplicateLocales(Map<Locale, String> map) {
        Set wrongRuLocales = map.keySet().stream().filter(Objects::nonNull).filter(locale -> TextUtil.isSame((String)locale.getLanguage(), (String)"ru", (boolean)true) && TextUtil.nonBlank((String)locale.getCountry())).collect(Collectors.toSet());
        for (Locale locale2 : wrongRuLocales) {
            String value = map.remove(locale2);
            map.put(LocaleHelper.RU_LOCALE, value);
        }
    }

    public static Collection<String> filterCodeSystems(Collection<String> gdsNames) {
        List codeSystemNames = Arrays.stream(CodeSystem.values()).map(Enum::name).collect(Collectors.toList());
        return gdsNames.stream().filter(codeSystemNames::contains).collect(Collectors.toList());
    }

    public static <T extends BaseDictionary> boolean compareByNames(T first, T second) {
        Collection firstNames = CollectionUtil.union(first.getTranslations().values(), (Collection)first.getSpellVariants());
        Collection secondNames = CollectionUtil.union(second.getTranslations().values(), (Collection)second.getSpellVariants());
        for (String firstName : firstNames) {
            if (TextUtil.isBlank((String)firstName)) continue;
            for (String secondName : secondNames) {
                if (!TextUtil.isSame((String)firstName, (String)secondName, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface Matcher<T extends BaseDictionary> {
        public boolean match(T var1, T var2);
    }
}

