/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class DictionaryHandler<P extends BaseDictionary> {
    private final Map<Enum, Property<P>> properties = new LinkedHashMap<Enum, Property<P>>();

    public DictionaryHandler() {
        this.registerProperties();
    }

    protected abstract void registerProperties();

    protected void registerCode() {
        this.registerProperty(new Property<P>(){

            @Override
            public boolean match(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getCode()) || TextUtil.isSame((String)dictFrom.getCode(), (String)dictTo.getCode());
            }

            @Override
            public void merge(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setCode(dictFrom.getCode());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"IDENTIFIER", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return BaseDictionary.Property.code;
            }
        });
    }

    protected void registerTranslations() {
        this.registerProperty(new Property<P>(){

            @Override
            public boolean match(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                DictSyncHelper.replaceDuplicateLocales(dictTo.getTranslations());
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getTranslations());
                if (!dictTo.getTranslations().keySet().containsAll(dictFrom.getTranslations().keySet())) {
                    return false;
                }
                for (Map.Entry entry : dictFrom.getTranslations().entrySet()) {
                    if (TextUtil.isSame((String)((String)entry.getValue()), (String)((String)dictTo.getTranslations().get(entry.getKey())))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                DictSyncHelper.replaceDuplicateLocales(dictTo.getTranslations());
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getTranslations());
                dictTo.getTranslations().putAll(dictFrom.getTranslations());
            }

            @Override
            public void fillDiffs(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
                DictSyncHelper.replaceDuplicateLocales(dictTo.getTranslations());
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getTranslations());
                Collection keys = CollectionUtil.union(dictTo.getTranslations().keySet(), dictFrom.getTranslations().keySet());
                for (Locale key : keys) {
                    String newTranslation;
                    String oldTranslation = (String)dictTo.getTranslations().get(key);
                    if (TextUtil.isSame((String)oldTranslation, (String)(newTranslation = (String)dictFrom.getTranslations().get(key)))) continue;
                    diffs.put(String.format("%s: %s", this.getLocalizedName(), key == null ? "" : key.getDisplayName(LocaleHelper.getCurrentLocale())), (MiscUtil.Pair<String, String>)new MiscUtil.Pair((Object)oldTranslation, (Object)newTranslation));
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"NAME", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return BaseDictionary.Property.translations;
            }
        });
    }

    protected void registerSpellVariants() {
        this.registerProperty(new Property<P>(){

            @Override
            public boolean match(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (!dictTo.getSpellVariants().containsAll(dictFrom.getSpellVariants())) {
                    return false;
                }
                for (String newSpellVariant : dictFrom.getSpellVariants()) {
                    if (CollectionUtil.contains((Collection)dictTo.getSpellVariants(), (Object)newSpellVariant, TextUtil::isSame)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                CollectionUtil.merge((Collection)dictTo.getSpellVariants(), (Collection)dictFrom.getSpellVariants(), TextUtil::isSame);
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"SPELL_VARIANTS", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return BaseDictionary.Property.spellVariants;
            }
        });
    }

    protected void registerCodeVariants() {
        this.registerProperty(new Property<P>(){

            @Override
            public boolean match(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                Collection<String> codeSystemsFrom;
                Collection<String> codeSystemsTo = DictSyncHelper.filterCodeSystems(dictTo.getCodeVariants().keySet());
                if (!codeSystemsTo.containsAll(codeSystemsFrom = DictSyncHelper.filterCodeSystems(dictFrom.getCodeVariants().keySet()))) {
                    return false;
                }
                for (String codeSystem : codeSystemsFrom) {
                    if (TextUtil.isSame((String)((String)dictTo.getCodeVariants().get(codeSystem)), (String)((String)dictFrom.getCodeVariants().get(codeSystem)))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                Collection<String> codeSystemsFrom = DictSyncHelper.filterCodeSystems(dictFrom.getCodeVariants().keySet());
                for (String codeSystem : codeSystemsFrom) {
                    dictTo.getCodeVariants().put(codeSystem, dictFrom.getCodeVariants().get(codeSystem));
                }
            }

            @Override
            public void fillDiffs(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
                Collection<String> codeSystemsTo = DictSyncHelper.filterCodeSystems(dictTo.getCodeVariants().keySet());
                Collection<String> codeSystemsFrom = DictSyncHelper.filterCodeSystems(dictFrom.getCodeVariants().keySet());
                Collection keys = CollectionUtil.union(codeSystemsTo, codeSystemsFrom);
                for (String key : keys) {
                    String newCode;
                    String oldCode = (String)dictTo.getCodeVariants().get(key);
                    if (TextUtil.isSame((String)oldCode, (String)(newCode = (String)dictFrom.getCodeVariants().get(key)))) continue;
                    diffs.put(String.format("%s: %s", this.getLocalizedName(), key), (MiscUtil.Pair<String, String>)new MiscUtil.Pair((Object)oldCode, (Object)newCode));
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"CODE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return BaseDictionary.Property.codeVariants;
            }
        });
    }

    public abstract Class<P> getDictionaryClass();

    public boolean match(P dictTo, P dictFrom) {
        return true;
    }

    public boolean isForRemoteUpdate(P dict) {
        return true;
    }

    public void merge(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, List<String> messages) {
        if (dictTo == null) {
            messages.add("old element is null" + dictFrom);
        }
        if (dictFrom == null) {
            messages.add("new element is null");
        }
        boolean foundDiff = false;
        for (Enum property : this.getProperties()) {
            if (this.matchProperty(property, dictTo, dictFrom, relatedDictionaries)) continue;
            if (!foundDiff) {
                messages.add(String.format("merging old element %s and new element %s", dictTo, dictFrom));
            }
            messages.add(String.format("old %s: %s", property, this.getPropertyValue(property, dictTo)));
            messages.add(String.format("remote %s: %s", property, this.getPropertyValue(property, dictFrom)));
            this.mergeProperty(property, dictTo, dictFrom, relatedDictionaries);
            messages.add(String.format("new %s: %s", property, this.getPropertyValue(property, dictTo)));
            foundDiff = true;
        }
    }

    public Map<String, MiscUtil.Pair<String, String>> getDiffData(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) throws Exception {
        if (dictFrom == null && dictTo == null) {
            return Collections.emptyMap();
        }
        dictFrom = dictFrom != null ? dictFrom : (BaseDictionary)this.getDictionaryClass().newInstance();
        dictTo = dictTo != null ? dictTo : (BaseDictionary)this.getDictionaryClass().newInstance();
        LinkedHashMap<String, MiscUtil.Pair<String, String>> diffs = new LinkedHashMap<String, MiscUtil.Pair<String, String>>();
        for (Enum property : this.getProperties()) {
            if (this.matchProperty(property, dictTo, dictFrom, relatedDictionaries)) continue;
            this.fillDiffs(property, dictTo, dictFrom, relatedDictionaries, diffs);
        }
        return diffs;
    }

    public abstract Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(P var1);

    public abstract Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses();

    public boolean isChanged(P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
        return dictTo != null && dictFrom != null && this.getProperties().stream().anyMatch(name -> !this.matchProperty((Enum)name, dictTo, dictFrom, relatedDictionaries));
    }

    public P search(P dict) {
        if (dict == null) {
            return null;
        }
        Object result = null;
        BaseDictionary foundByCode = DictionaryCache.get().findByCode(this.getDictionaryClass(), dict.getCode());
        if (foundByCode != null && this.match(foundByCode, dict) && DictSyncHelper.compareByNames(dict, foundByCode)) {
            return (P)foundByCode;
        }
        Collection<BaseDictionary> foundByCodeVariants = DictSyncHelper.searchByCodeVariants(dict, this.getDictionaryClass(), this::match, new CodeSystem[]{CodeSystem.IATA, CodeSystem.ISO, CodeSystem.ISO_ALPHA3, CodeSystem.ISO_NUMERIC, CodeSystem.CRT, CodeSystem.EXPRESS, CodeSystem.EXPRESS_UZ});
        for (BaseDictionary foundDict : foundByCodeVariants) {
            if (!DictSyncHelper.compareByNames(foundDict, dict)) continue;
            return (P)foundDict;
        }
        if (foundByCode != null && this.match(foundByCode, dict)) {
            return (P)foundByCode;
        }
        return (P)(foundByCodeVariants.isEmpty() ? null : foundByCodeVariants.iterator().next());
    }

    protected Collection<Enum> getProperties() {
        return this.properties.keySet();
    }

    private boolean matchProperty(Enum property, P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
        return this.getProperty(property).match(dictTo, dictFrom, relatedDictionaries);
    }

    protected String getPropertyValue(Enum property, P dict) {
        return this.getProperty(property).toString(dict);
    }

    private void mergeProperty(Enum property, P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
        this.getProperty(property).merge(dictTo, dictFrom, relatedDictionaries);
    }

    private void fillDiffs(Enum property, P dictTo, P dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
        this.getProperty(property).fillDiffs(dictTo, dictFrom, relatedDictionaries, diffs);
    }

    protected void registerProperty(Property<P> property) {
        if (this.properties.containsKey(property.getKey())) {
            throw new IllegalArgumentException(String.format("Property %s already registered for class %s", property.getKey(), this.getDictionaryClass()));
        }
        this.properties.put(property.getKey(), property);
    }

    protected void unregisterProperty(Enum key) {
        this.properties.remove(key);
    }

    private Property<P> getProperty(Enum key) {
        Property<P> propertyInfo = this.properties.get(key);
        if (propertyInfo == null) {
            throw new IllegalArgumentException(String.format("Property %s is not registered for class %s", key, this.getDictionaryClass()));
        }
        return propertyInfo;
    }

    public static interface Property<D extends BaseDictionary> {
        public boolean match(D var1, D var2, Collection<? extends BaseDictionary> var3);

        public void merge(D var1, D var2, Collection<? extends BaseDictionary> var3);

        public String getLocalizedName();

        default public void fillDiffs(D dictTo, D dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
            MiscUtil.Pair oldAndNewValues = new MiscUtil.Pair((Object)this.toString(dictTo), (Object)this.toString(dictFrom));
            diffs.put(this.getLocalizedName(), (MiscUtil.Pair<String, String>)oldAndNewValues);
        }

        public Enum getKey();

        default public String toString(D dict) {
            Object value = dict.getValue(this.getKey().name());
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return ((Collection)value).stream().map(elem -> elem != null ? elem.toString() : (String)null).collect(Collectors.joining(", "));
            }
            if (value instanceof Map) {
                return ((Map)value).entrySet().stream().filter(Objects::nonNull).map(entry -> entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining(", "));
            }
            return value.toString();
        }
    }
}

