/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.handlers.AnonymizationHandler;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.model.handlers.EntitiesGroupHandler;
import com.gridnine.xtrip.common.model.handlers.FinanceDocumentHandler;
import com.gridnine.xtrip.common.model.handlers.ItineraryReceiptHandler;
import com.gridnine.xtrip.common.model.handlers.JoinBookingFileHandler;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.handlers.RailwayReceiptHandler;
import com.gridnine.xtrip.common.model.handlers.RailwayRefundReceiptHandler;
import com.gridnine.xtrip.common.model.handlers.TemplateDescriptor;
import com.gridnine.xtrip.common.model.handlers.XMLExportHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlersRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, XMLExportHandler> exportHandlers = new LinkedHashMap<String, XMLExportHandler>();
    private final Map<String, TemplateDescriptor> templatesHandlers = new HashMap<String, TemplateDescriptor>();
    private final Map<String, EntitiesGroupHandler> entitiesGroupHandlers = new HashMap<String, EntitiesGroupHandler>();
    private final Map<String, ProductHandler<?>> productHandlers = new HashMap();
    private final Map<String, PaymentDocumentHandler<?>> paymentDocumentHandlers = new HashMap();
    private final Map<String, FinanceDocumentHandler> financeDocumentHandlers = new HashMap<String, FinanceDocumentHandler>();
    private final Map<String, DictionaryHandler> dictionaryHandlers = new HashMap<String, DictionaryHandler>();
    private final Map<String, ProductPassiveSegmentsHandler<?>> productPassiveSegmentsHandlers = new HashMap();
    private final Map<String, AnonymizationHandler<?>> anonymizationHandlers = new HashMap();
    private final Map<String, ProductStatusHandler> productStatusHandlers = new HashMap<String, ProductStatusHandler>();
    private final Map<String, RailwayReceiptHandler> railwayReceiptHandlers = new HashMap<String, RailwayReceiptHandler>();
    private final Map<String, RailwayRefundReceiptHandler> railwayRefundReceiptHandlers = new HashMap<String, RailwayRefundReceiptHandler>();
    private final Map<String, ItineraryReceiptHandler> itineraryReceiptHandlers = new HashMap<String, ItineraryReceiptHandler>();
    private final Map<String, JoinBookingFileHandler> joinBookingFileHandlers = new HashMap<String, JoinBookingFileHandler>();

    public static HandlersRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (HandlersRegistry)Environment.getPublished(HandlersRegistry.class);
    }

    public void dispose() {
        this.exportHandlers.clear();
        this.templatesHandlers.clear();
        this.entitiesGroupHandlers.clear();
        this.productHandlers.clear();
        this.paymentDocumentHandlers.clear();
        this.financeDocumentHandlers.clear();
        this.dictionaryHandlers.clear();
        this.productPassiveSegmentsHandlers.clear();
        this.anonymizationHandlers.clear();
        this.productStatusHandlers.clear();
        this.railwayReceiptHandlers.clear();
        this.railwayRefundReceiptHandlers.clear();
        this.itineraryReceiptHandlers.clear();
        this.joinBookingFileHandlers.clear();
    }

    public void register(XMLExportHandler handler) {
        if (this.exportHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.exportHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public Collection<XMLExportHandler> getAllExportHandlers() {
        return Collections.unmodifiableCollection(this.exportHandlers.values());
    }

    public void register(TemplateDescriptor handler) {
        if (this.templatesHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.templatesHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public void unregisterTemplateDescriptor(String id) {
        this.templatesHandlers.remove(id);
        this.log.info(String.format("unregistered tamplate desciptor %s", id));
    }

    public void register(EntitiesGroupHandler handler) {
        if (this.entitiesGroupHandlers.containsKey(handler.getUid())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getUid()));
            return;
        }
        this.entitiesGroupHandlers.put(handler.getUid(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getUid()));
    }

    public void register(ProductHandler<?> handler) {
        if (this.productHandlers.containsKey(handler.getProductClass().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getProductClass().getName()));
            return;
        }
        this.productHandlers.put(handler.getProductClass().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public void unregister(ProductHandler<?> handler) {
        this.productHandlers.remove(handler.getProductClass().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public void register(ProductPassiveSegmentsHandler<?> handler) {
        if (this.productPassiveSegmentsHandlers.containsKey(handler.getProductClass().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getProductClass().getName()));
            return;
        }
        this.productPassiveSegmentsHandlers.put(handler.getProductClass().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public void unregister(ProductPassiveSegmentsHandler<?> handler) {
        this.productPassiveSegmentsHandlers.remove(handler.getProductClass().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getProductClass().getName()));
    }

    public void register(PaymentDocumentHandler<?> handler) {
        if (this.paymentDocumentHandlers.containsKey(handler.getDocumentClass().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getDocumentClass().getName()));
            return;
        }
        this.paymentDocumentHandlers.put(handler.getDocumentClass().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getDocumentClass().getName()));
    }

    public void unregister(PaymentDocumentHandler<?> handler) {
        this.paymentDocumentHandlers.remove(handler.getDocumentClass().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getDocumentClass().getName()));
    }

    public void register(FinanceDocumentHandler handler) {
        if (this.financeDocumentHandlers.containsKey(handler.getFinanceDocumentType().name())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getFinanceDocumentType().name()));
            return;
        }
        this.financeDocumentHandlers.put(handler.getFinanceDocumentType().name(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getFinanceDocumentType().name()));
    }

    public void unregister(FinanceDocumentHandler handler) {
        this.financeDocumentHandlers.remove(handler.getFinanceDocumentType().name());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getFinanceDocumentType().name()));
    }

    public void register(DictionaryHandler<?> handler) {
        if (this.dictionaryHandlers.containsKey(handler.getDictionaryClass().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getDictionaryClass().getName()));
            return;
        }
        this.dictionaryHandlers.put(handler.getDictionaryClass().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getDictionaryClass().getName()));
    }

    public void unregister(DictionaryHandler<?> handler) {
        this.dictionaryHandlers.remove(handler.getDictionaryClass().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getDictionaryClass().getName()));
    }

    public void register(RailwayReceiptHandler handler) {
        if (this.railwayReceiptHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.railwayReceiptHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public void unregister(RailwayReceiptHandler handler) {
        this.railwayReceiptHandlers.remove(handler.getId());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getId()));
    }

    public RailwayReceiptHandler findRailwayReceiptHandler(String id) {
        return this.railwayReceiptHandlers.get(id);
    }

    public void register(RailwayRefundReceiptHandler handler) {
        if (this.railwayRefundReceiptHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.railwayRefundReceiptHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public void unregister(RailwayRefundReceiptHandler handler) {
        this.railwayRefundReceiptHandlers.remove(handler.getId());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getId()));
    }

    public RailwayRefundReceiptHandler findRailwayRefundReceiptHandler(String id) {
        return this.railwayRefundReceiptHandlers.get(id);
    }

    public void register(ItineraryReceiptHandler handler) {
        if (this.itineraryReceiptHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.itineraryReceiptHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public void unregister(ItineraryReceiptHandler handler) {
        this.itineraryReceiptHandlers.remove(handler.getId());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getId()));
    }

    public ItineraryReceiptHandler findItineraryReceiptHandler(String id) {
        return this.itineraryReceiptHandlers.get(id);
    }

    public TemplateDescriptor findTemplateHandler(String id) {
        return this.templatesHandlers.get(id);
    }

    public <P extends BaseDictionary> DictionaryHandler<P> findDictionaryHandler(Class<? extends P> cls) {
        return this.dictionaryHandlers.get(cls.getName());
    }

    public <P extends BaseProduct> ProductHandler<P> findProductHandler(Class<? extends P> cls) {
        return this.productHandlers.get(cls.getName());
    }

    public <P extends BaseProduct> ProductPassiveSegmentsHandler<P> findProductPassiveSegmentsHandler(Class<? extends P> cls) {
        return this.productPassiveSegmentsHandlers.get(cls.getName());
    }

    public <P extends BasePaymentDocument> PaymentDocumentHandler<P> findPaymentDocumentHandler(Class<? extends P> cls) {
        return this.paymentDocumentHandlers.get(cls.getName());
    }

    public void register(AnonymizationHandler<?> handler) {
        if (this.anonymizationHandlers.containsKey(handler.getType().getName())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getType().getName()));
            return;
        }
        this.anonymizationHandlers.put(handler.getType().getName(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getType().getName()));
    }

    public void unregister(AnonymizationHandler<?> handler) {
        this.financeDocumentHandlers.remove(handler.getType().getName());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getType().getName()));
    }

    public <E extends BaseEntity> AnonymizationHandler<E> findAnonimizationHandler(Class<E> type) {
        return this.anonymizationHandlers.get(type.getName());
    }

    public FinanceDocumentHandler findFinanceDocumentHandler(FinanceDocumentType type) {
        return this.financeDocumentHandlers.get(type.name());
    }

    public void register(ProductStatusHandler handler) {
        if (this.productStatusHandlers.containsKey(handler.getUid())) {
            this.log.warn(String.format("handler %s with uid %s already registered", handler, handler.getUid()));
            return;
        }
        this.productStatusHandlers.put(handler.getUid(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getUid()));
    }

    public Collection<TemplateDescriptor> getAllTemplateHandlers() {
        return this.templatesHandlers.values();
    }

    public Collection<ProductHandler<?>> getAllProductHandlers() {
        return this.productHandlers.values();
    }

    public Collection<PaymentDocumentHandler<?>> getAllPaymentDocumentHandlers() {
        return this.paymentDocumentHandlers.values();
    }

    public Collection<EntitiesGroupHandler> getAllEntitiesGroupHandlers() {
        return this.entitiesGroupHandlers.values();
    }

    public Collection<ProductStatusHandler> getAllProductStatusHandlers() {
        return this.productStatusHandlers.values();
    }

    public Collection<RailwayReceiptHandler> getAllRailwayReceiptHandlers() {
        return this.railwayReceiptHandlers.values();
    }

    public Collection<RailwayRefundReceiptHandler> getAllRailwayRefundReceiptHandlers() {
        return this.railwayRefundReceiptHandlers.values();
    }

    public Collection<ItineraryReceiptHandler> getAllItineraryReceiptHandlers() {
        return this.itineraryReceiptHandlers.values();
    }

    public void register(JoinBookingFileHandler handler) {
        if (this.joinBookingFileHandlers.containsKey(handler.getId())) {
            this.log.warn(String.format("handler %s with id %s already registered", handler, handler.getId()));
            return;
        }
        this.joinBookingFileHandlers.put(handler.getId(), handler);
        this.log.info(String.format("registered handler %s with id %s", handler, handler.getId()));
    }

    public void unregister(JoinBookingFileHandler handler) {
        this.joinBookingFileHandlers.remove(handler.getId());
        this.log.info(String.format("unregistered handler %s with id %s", handler, handler.getId()));
    }

    public Collection<JoinBookingFileHandler> getAllJoinBookingFileHandlers() {
        return this.joinBookingFileHandlers.values();
    }

    private static class Holder {
        public static final HandlersRegistry INSTANCE = (HandlersRegistry)Environment.getPublished(HandlersRegistry.class);

        private Holder() {
        }
    }
}

