/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class ProductHelper {
    static boolean hasSameSystemNumbers(BaseProduct product) {
        Date issueDate;
        ProductHandler<BaseProduct> handler = ProductHandler.of(product);
        List<String> productNumbers = handler.getProductNumbers(product);
        if (CollectionUtil.isEmpty(productNumbers)) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"navigationKey", (Object)product.getUid()));
        HashSet<String> systemNumbers = new HashSet<String>(productNumbers);
        systemNumbers.addAll(productNumbers.stream().map(String::trim).collect(Collectors.toSet()));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)CommonProductIndex.Property.systemNumbers.name(), systemNumbers));
        ProductStatus status = handler.getStatus(product);
        if (status == ProductStatus.SELL || status == ProductStatus.VOID) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.status.name(), EnumSet.of(ProductStatus.SELL, ProductStatus.VOID)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)status));
        }
        ProductType productType = handler.getProductType(product);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)productType));
        TicketType ticketType = handler.getTicketType(product);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)CommonProductIndex.Property.ticketType.name(), Arrays.asList(ticketType, null)));
        DictionaryReference<BlankType> blankType = handler.getBlankType(product);
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.blankType.name(), blankType), SearchCriterion.eq((String)CommonProductIndex.Property.blankType.name(), null)}));
        }
        if ((issueDate = handler.findIssueDate(product)) != null) {
            Date issueDateStart = MiscUtil.addYearsToDate((Date)issueDate, (int)-1);
            Date issueDateEnd = MiscUtil.addYearsToDate((Date)issueDate, (int)1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)issueDateStart));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)issueDateEnd));
        }
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(CommonProductIndex.class, query).getTotalCount() > 0;
    }
}

