/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AdditionalServiceProductHandler
implements ProductHandler<AdditionalServiceProduct> {
    @Override
    public Class<AdditionalServiceProduct> getProductClass() {
        return AdditionalServiceProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, AdditionalServiceProduct product) {
        return GeneralProductHelper.calculateProductPrice(relation, this, product);
    }

    @Override
    public VatAmount calculateProductPrice(AdditionalServiceProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(AdditionalServiceProduct product) {
        StringBuilder sb = new StringBuilder();
        if (product.getCategory() != null) {
            sb.append(product.getCategory());
        }
        if (product.getSystemNumber() != null) {
            sb.append(" ").append(product.getSystemNumber());
        }
        if (product.getStatus() != null) {
            sb.append(" ").append(product.getStatus());
        }
        return sb.toString();
    }

    @Override
    public String generateProductName(AdditionalServiceProduct product) {
        StringBuilder sb = new StringBuilder();
        sb.append(ProductType.ADDITIONAL_SERVICE.toString());
        AdditionalServiceCategory category = product.getCategory();
        if (category != null) {
            sb.append(" ").append(category);
        }
        sb.append(" ").append(product.getStatus());
        sb.append(" ").append(product.getSystemNumber());
        Traveller traveller = (Traveller)CollectionUtil.head((Iterable)product.getTravellers());
        if (traveller != null) {
            sb.append(" ").append(traveller.getName());
        }
        return sb.toString();
    }

    @Override
    public List<String> getProductNumbers(AdditionalServiceProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(AdditionalServiceProduct product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(AdditionalServiceProduct product) {
        return TravelSubject.ADDITIONAL_SERVICE;
    }

    @Override
    public Date findIssueDate(AdditionalServiceProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(AdditionalServiceProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(AdditionalServiceProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(AdditionalServiceProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AdditionalServiceProduct)) continue;
            prods.add(this.createFinanceCapableProduct((AdditionalServiceProduct)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AdditionalServiceProduct)) continue;
            prods.add(this.createFinanceCapableProduct((AdditionalServiceProduct)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(AdditionalServiceProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(AdditionalServiceProduct product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(AdditionalServiceProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(AdditionalServiceProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<AdditionalServiceProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(AdditionalServiceProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.getLastArrivalDate(product);
    }

    @Override
    public ProductStatus getStatus(AdditionalServiceProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(AdditionalServiceProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(AdditionalServiceProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(AdditionalServiceProduct product) {
        return ProductType.ADDITIONAL_SERVICE;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return null;
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public EntityReference<Branch> getBranch(AdditionalServiceProduct product) {
        return product.getBranch();
    }

    @Override
    public boolean isCompleted(AdditionalServiceProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(AdditionalServiceProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(AdditionalServiceProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(AdditionalServiceProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(AdditionalServiceProduct product) {
        return Collections.emptyList();
    }

    @Override
    public TransportationType getTransportationType(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public AdditionalServiceProduct getPreviousProduct(AdditionalServiceProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(AdditionalServiceProduct product, AdditionalServiceProduct previousProduct) {
    }

    @Override
    public void setNextProduct(AdditionalServiceProduct product, AdditionalServiceProduct nextProduct) {
    }

    @Override
    public AdditionalServiceProduct getNextProduct(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public void addRelatedProduct(AdditionalServiceProduct product, BaseProduct relatedProduct) {
        product.getRelatedProducts().add(relatedProduct);
    }

    @Override
    public List<BaseProduct> getRelatedProducts(AdditionalServiceProduct product) {
        return product.getRelatedProducts();
    }

    @Override
    public ProductCategory getProductCategory(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(AdditionalServiceProduct product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public BigDecimal getServiceFare(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public int getConjunction(AdditionalServiceProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public Date findFirstTravelDate(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.getFirstDepartureDate(product);
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(AdditionalServiceProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(AdditionalServiceProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(AdditionalServiceProduct product, TicketType ticketType) {
    }

    @Override
    public String getPCC(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(AdditionalServiceProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(AdditionalServiceProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(AdditionalServiceProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(AdditionalServiceProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(AdditionalServiceProduct product) {
        Product relatedProduct = (Product)CollectionUtil.head((Iterable)product.getRelatedProducts());
        return relatedProduct != null ? relatedProduct.getPassengerType() : null;
    }

    @Override
    public StatisticalData getStatisticalData(AdditionalServiceProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(AdditionalServiceProduct product) {
        return false;
    }

    @Override
    public void newStatisticalData(AdditionalServiceProduct product) {
    }

    @Override
    public BigDecimal getAddCollect(AdditionalServiceProduct product) {
        return null;
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final AdditionalServiceProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return AdditionalServiceProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return AdditionalServiceProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return AdditionalServiceProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return AdditionalServiceProductHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return AdditionalServiceProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return AdditionalServiceProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"ADDITIONAL_SERVICE_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"ADDITIONAL_SERVICE_PRODUCT_INFO", (Object[])new Object[0]);
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return (Traveller)CollectionUtil.head((Iterable)product.getTravellers());
            }
        };
    }

    @Override
    public VatDetalization getVendorVatDetalization(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.ADDITIONAL_SERVICE;
    }

    @Override
    public AdditionalServiceProduct newInstance() {
        return new AdditionalServiceProduct();
    }

    @Override
    public String getCarrierNumber(AdditionalServiceProduct product) {
        Product relatedProduct = (Product)CollectionUtil.head((Iterable)product.getRelatedProducts());
        return relatedProduct != null ? relatedProduct.getCarrierNumber() : null;
    }

    @Override
    public void setAgent(AdditionalServiceProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(AdditionalServiceProduct product, String comments) {
    }

    @Override
    public void setAgency(AdditionalServiceProduct product, EntityReference<Organization> agency) {
        AdditionalServiceProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(AdditionalServiceProduct product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(AdditionalServiceProduct product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(AdditionalServiceProduct product, EntityReference<Organization> supplier) {
        AdditionalServiceProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(AdditionalServiceProduct product, EntityReference<Organization> subagency) {
        AdditionalServiceProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(AdditionalServiceProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(AdditionalServiceProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(AdditionalServiceProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(AdditionalServiceProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(AdditionalServiceProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(AdditionalServiceProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(AdditionalServiceProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(AdditionalServiceProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return AdditionalServiceProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return AdditionalServiceProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return AdditionalServiceProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(AdditionalServiceProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(AdditionalServiceProduct product, BaseProduct relatedProduct) {
        return AdditionalServiceProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(AdditionalServiceProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(item -> item.getVat()).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(AdditionalServiceProduct product, Locale locale) {
        return AirProductHelper.getCities(product.getSegments(), locale);
    }

    @Override
    public String getCountries(AdditionalServiceProduct product, Locale locale) {
        return AirProductHelper.getCountries(product.getSegments(), locale);
    }

    @Override
    public Date getFirstStartDate(AdditionalServiceProduct product) {
        List dates = product.getSegments().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getStartDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    @Override
    public Date getLastStartDate(AdditionalServiceProduct product) {
        List dates = product.getSegments().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getStartDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    @Override
    public Date getFirstEndDate(AdditionalServiceProduct product) {
        List dates = product.getSegments().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getEndDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    @Override
    public Date getLastEndDate(AdditionalServiceProduct product) {
        List dates = product.getSegments().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getEndDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    @Override
    public String getDescriptionLine(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(AdditionalServiceProduct product) {
        Product relatedProduct = (Product)CollectionUtil.head((Iterable)product.getRelatedProducts());
        return relatedProduct != null ? relatedProduct.getCarrier() : null;
    }

    @Override
    public boolean isContractRulesApplied(AdditionalServiceProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(AdditionalServiceProduct product) {
        return false;
    }

    @Override
    public String getRfic(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public String getRfisc(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public String getTourCode(AdditionalServiceProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(AdditionalServiceProduct product) {
        return false;
    }

    @Override
    public boolean hasSameSystemNumbers(AdditionalServiceProduct product) {
        return AdditionalServiceProductHelper.hasSameSystemNumbers(product);
    }
}

