/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AgencyMemoProductHandler
implements ProductHandler<AgencyMemoProduct> {
    @Override
    public Class<AgencyMemoProduct> getProductClass() {
        return AgencyMemoProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(AgencyMemoProduct product, ContractType ctype) {
        return this.getUnmodifiableContractRelations(product).stream().filter(item -> GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) == ctype).map(item -> this.calculateProductPrice((GeneralProductContractRelationData)item, product)).findFirst().orElse(this.calculateProductPrice((GeneralProductContractRelationData)null, product));
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, AgencyMemoProduct product) {
        VatAmount result = new VatAmount();
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            result.setTotalVat(totalPrice, 0.0);
            return result;
        }
        BigDecimal total = this.getEquivalentFare(product);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        result.setTotalVat(total, 0.0);
        return result;
    }

    @Override
    public String generateShortProductName(AgencyMemoProduct product) {
        StringBuilder shortName = new StringBuilder();
        shortName.append(L10nResourcesManager.getStr((String)"AGENCY_MEMO_SHORT_PRODUCT_NAME_PRETENSION", (Object[])new Object[0]));
        if (product.getType() != null) {
            if (shortName.length() > 0) {
                shortName.append(" ");
            }
            shortName.append(product.getType());
        }
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            if (shortName.length() > 0) {
                shortName.append(" ");
            }
            shortName.append(product.getSystemNumber().trim());
        }
        return shortName.toString();
    }

    @Override
    public String generateProductName(AgencyMemoProduct product) {
        return this.generateShortProductName(product);
    }

    @Override
    public Date findFirstTravelDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Date findLastTravelDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(AgencyMemoProduct product) {
        return product.getSystemNumber() != null ? Collections.singletonList(product.getSystemNumber()) : Collections.emptyList();
    }

    @Override
    public EntityReference<Person> findIssuingAgent(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public TravelSubject findTravelSubject(AgencyMemoProduct product) {
        return TravelSubject.OTHER;
    }

    @Override
    public Date findIssueDate(AgencyMemoProduct product) {
        return product.getTargetReportDate();
    }

    @Override
    public Date findLocalIssueDate(AgencyMemoProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(AgencyMemoProduct product, Date issueDate) {
        product.setTargetReportDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(AgencyMemoProduct product) {
        return true;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AgencyMemoProduct)) continue;
            prods.add(this.createFinanceCapableProduct((AgencyMemoProduct)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof AgencyMemoProduct)) continue;
            prods.add(this.createFinanceCapableProduct((AgencyMemoProduct)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(AgencyMemoProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final AgencyMemoProduct product) {
        final ContractType type = this.getContractType(product);
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return AgencyMemoProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return type == ContractType.VENDOR ? product.getFops() : Collections.emptyList();
            }

            public List<GeneralProductFop> getSubagentFops() {
                return type == ContractType.SUBAGENCY ? product.getFops() : Collections.emptyList();
            }

            public List<GeneralProductFop> getClientFops() {
                return type == ContractType.CLIENT ? product.getFops() : Collections.emptyList();
            }

            @Override
            public ProductStatus getStatus() {
                return ProductStatus.SELL;
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return Collections.emptyList();
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return AgencyMemoProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                return "";
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return null;
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(AgencyMemoProduct product) {
        return Collections.emptyList();
    }

    @Override
    public boolean isNoTraveller() {
        return true;
    }

    @Override
    public void replaceTraveller(AgencyMemoProduct product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(AgencyMemoProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<AgencyMemoProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public ProductStatus getStatus(AgencyMemoProduct product) {
        return ProductStatus.SELL;
    }

    @Override
    public ProductStatus getBaseStatus(AgencyMemoProduct product) {
        return ProductStatus.SELL;
    }

    @Override
    public void setStatus(AgencyMemoProduct product, ProductStatus productStatus) {
    }

    @Override
    public ProductType getProductType(AgencyMemoProduct product) {
        return ProductType.AGENCY_MEMO_PRODUCT;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.AGENCY_MEMO_PRODUCT).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(AgencyMemoProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(AgencyMemoProduct product) {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompleted(AgencyMemoProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(AgencyMemoProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(AgencyMemoProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(AgencyMemoProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, AgencyMemoProduct product) {
        return null;
    }

    @Override
    public AgencyMemoProduct getPreviousProduct(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public void setPreviousProduct(AgencyMemoProduct product, AgencyMemoProduct previousProduct) {
    }

    @Override
    public void setNextProduct(AgencyMemoProduct product, AgencyMemoProduct nextProduct) {
    }

    @Override
    public AgencyMemoProduct getNextProduct(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public void addRelatedProduct(AgencyMemoProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(AgencyMemoProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(AgencyMemoProduct product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(AgencyMemoProduct product) {
        return product.getItemGroups().stream().filter(Objects::nonNull).map(AgencyMemoProductItemGroup::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    @Override
    public BigDecimal getServiceFare(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public int getConjunction(AgencyMemoProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(AgencyMemoProduct product) {
        return Collections.singletonList(this.createFakeRelation(product));
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelationsForTransactions(AgencyMemoProduct product) {
        GeneralProductContractRelationData relation = this.createFakeRelation(product);
        if (!relation.getFops().isEmpty()) {
            BigDecimal commissionAmount = product.getItemGroups().stream().filter(itemGroup -> itemGroup.getType() == AgencyMemoProductEntryType.COMMISSION || itemGroup.getType() == AgencyMemoProductEntryType.BONUS).map(AgencyMemoProductItemGroup::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
            if (!MiscUtil.isZero((BigDecimal)commissionAmount, (boolean)true)) {
                GeneralProductFop fop2;
                fop2.setEquivalentAmount(MiscUtil.sub((BigDecimal)((fop2 = (GeneralProductFop)relation.getFops().get(0)).getEquivalentAmount() != null ? fop2.getEquivalentAmount() : BigDecimal.ZERO), (BigDecimal[])new BigDecimal[]{commissionAmount}));
                GeneralProductCommission commission2 = new GeneralProductCommission();
                commission2.setContractType(this.getContractType(product));
                commission2.setEquivalentAmount(commissionAmount);
                commission2.setCommissionProperties(new EntityReference("fake_uid", CommissionProperties.class, null));
                relation.getCommissions().add(commission2);
            }
            if (product.getType() == AgencyMemoProductType.ACM) {
                relation.getFops().forEach(fop -> fop.setEquivalentAmount(MiscUtil.negate((BigDecimal)fop.getEquivalentAmount())));
            } else {
                relation.getCommissions().forEach(commission -> commission.setEquivalentAmount(MiscUtil.negate((BigDecimal)commission.getEquivalentAmount())));
            }
        }
        return Collections.singletonList(relation);
    }

    private GeneralProductContractRelationData createFakeRelation(AgencyMemoProduct product) {
        ContractType type = this.getContractType(product);
        String paymentCurrency = product.getPaymentCurrency();
        if (TextUtil.isBlank((String)paymentCurrency)) {
            paymentCurrency = Optional.ofNullable(EntityStorage.get().resolve((EntityReference)product.getContract())).map(item -> ((Contract)item.getEntity()).getPaymentCurrency()).orElse(DictHelper.getLocalCurrency());
        }
        GeneralProductContractRelationData result = new GeneralProductContractRelationData();
        result.getGeneralData().setCurrency((DictionaryReference)new CurrencyInfoReference(paymentCurrency));
        result.getGeneralData().getContractData().setContract((EntityReference)product.getContract());
        result.setUid(product.getUid() + "_fake_contract_relation_data_uid");
        if (type == ContractType.VENDOR) {
            result.setDescription(GeneralProductHelper.findContractRelationRef(PredefinedContractRelationType.SUPPLIER_TO_AGENCY));
        } else if (type == ContractType.SUBAGENCY) {
            result.setDescription(GeneralProductHelper.findContractRelationRef(PredefinedContractRelationType.AGENCY_TO_SUBAGENCY));
        } else if (type == ContractType.CLIENT) {
            result.setDescription(GeneralProductHelper.findContractRelationRef(PredefinedContractRelationType.AGENCY_TO_CLIENT));
        }
        try {
            result.getFops().addAll(XCloneHelper.cloneList((List)product.getFops()));
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone fops", e);
        }
        return result;
    }

    @Override
    public SalesChain getSalesChain(AgencyMemoProduct product) {
        SalesChain result = new SalesChain();
        ContractType type = this.getContractType(product);
        if (type == ContractType.VENDOR) {
            result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.OWN, null));
            GeneralProductHelper.setContractor(result, PredefinedContractorType.SUPPLIER, (EntityReference<Organization>)product.getSupplier());
            GeneralProductHelper.setContractor(result, PredefinedContractorType.AGENCY, (EntityReference<Organization>)product.getAgency());
        } else if (type == ContractType.SUBAGENCY) {
            result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, null));
            GeneralProductHelper.setContractor(result, PredefinedContractorType.AGENCY, (EntityReference<Organization>)product.getSupplier());
            GeneralProductHelper.setContractor(result, PredefinedContractorType.SUBAGENCY, (EntityReference<Organization>)product.getAgency());
        } else if (type == ContractType.CLIENT) {
            result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.OWN, null));
            GeneralProductHelper.setContractor(result, PredefinedContractorType.AGENCY, (EntityReference<Organization>)product.getSupplier());
        }
        return result;
    }

    @Override
    public void updateContractRelations(AgencyMemoProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductContractRelationData clientRelation = relations.get(0);
        product.getFops().clear();
        product.getFops().addAll(clientRelation.getFops());
    }

    @Override
    public TicketType getTicketType(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public void setTicketType(AgencyMemoProduct product, TicketType ticketType) {
    }

    @Override
    public String getPCC(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(AgencyMemoProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(AgencyMemoProduct product, boolean value) {
    }

    @Override
    public List<ValidationMessage> getValidationMessages(AgencyMemoProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(AgencyMemoProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(AgencyMemoProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(AgencyMemoProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(AgencyMemoProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.OTHER;
    }

    @Override
    public AgencyMemoProduct newInstance() {
        return new AgencyMemoProduct();
    }

    @Override
    public String getCarrierNumber(AgencyMemoProduct product) {
        return null;
    }

    private ContractType getContractType(AgencyMemoProduct product) {
        ContractType type = ContractType.CLIENT;
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)product.getContract());
        if (contractContainer != null && ((Contract)contractContainer.getEntity()).getContractType() != null) {
            type = ((Contract)contractContainer.getEntity()).getContractType();
        }
        return type;
    }

    @Override
    public void setAgent(AgencyMemoProduct product, EntityReference<Person> agent) {
    }

    @Override
    public void setComments(AgencyMemoProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(AgencyMemoProduct product, EntityReference<Organization> agency) {
        product.setAgency(agency);
    }

    @Override
    public void setBlankOwner(AgencyMemoProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(AgencyMemoProduct product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(AgencyMemoProduct product, EntityReference<Organization> supplier) {
        product.setSupplier(supplier);
    }

    @Override
    public void setSubagency(AgencyMemoProduct product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(AgencyMemoProduct product, EntityReference<SalesPoint> salesPoint) {
    }

    @Override
    public void changeFopsPaymentTypes(AgencyMemoProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
    }

    @Override
    public void changeFopsAgent(AgencyMemoProduct product, EntityReference<Person> agent, ContractType contractType) {
    }

    @Override
    public List<String> getFopsUids(AgencyMemoProduct product, ContractType contractType) {
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(AgencyMemoProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(AgencyMemoProduct product) {
        return AgencyMemoProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(AgencyMemoProduct product, BaseProduct relatedProduct) {
        return AgencyMemoProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(AgencyMemoProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(AgencyMemoProduct product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(AgencyMemoProduct product, Locale locale) {
        return null;
    }

    @Override
    public Date getFirstStartDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Date getLastStartDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Date getFirstEndDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public Date getLastEndDate(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getDescriptionLine(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(AgencyMemoProduct product) {
        return false;
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(AgencyMemoProduct product) {
        return true;
    }

    @Override
    public String getRfic(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getRfisc(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public String getTourCode(AgencyMemoProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(AgencyMemoProduct product) {
        return false;
    }
}

