/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class AirProductFinanceHelper {
    static Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<Product> products, List<FinanceDocument> availableDocuments) throws Exception {
        boolean hasFees = false;
        boolean hasRefundFees = false;
        boolean hasRefund = false;
        boolean hasSellOrExchange = false;
        boolean hasCashFopInRefund = false;
        block0: for (BaseProduct baseProduct : products) {
            Product product = (Product)baseProduct;
            if (product.getProductCategory() == ProductCategory.AIR) {
                if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.EXCHANGE) {
                    hasSellOrExchange = true;
                }
                if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.VOID) {
                    hasRefund = true;
                    hasCashFopInRefund = AirProductFinanceHelper.hasCashFopInRefund(product);
                }
                if (hasFees && hasRefundFees) continue;
                for (Commission comm : GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, null), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories)) {
                    hasFees = true;
                    if (!BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
                    hasRefundFees = true;
                    continue block0;
                }
                continue;
            }
            if (!MCOCategory.RETURN_FARE_DIFFERENCE.equals((Object)product.getMcoCategory())) continue;
            hasRefund = true;
            hasCashFopInRefund = true;
        }
        HashSet<FinanceDocument> documents = new HashSet<FinanceDocument>();
        for (FinanceDocument finDoc : availableDocuments) {
            FinanceDocumentType financeDocumentType = finDoc.getType();
            if (financeDocumentType == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && (!hasFees || hasRefund && !hasRefundFees) || financeDocumentType == FinanceDocumentType.CASH_ORDER && (!hasRefund || hasSellOrExchange || !hasCashFopInRefund)) continue;
            documents.add(finDoc);
        }
        return documents;
    }

    private static boolean hasCashFopInRefund(Product product) throws Exception {
        boolean hasCashFopInRefund = false;
        for (ProductFop fop : AirProductHelper.getClientContractRelation(product).getFops()) {
            if (fop == null || PaymentType.CASH != fop.getType()) continue;
            boolean isFopForFeeForRefund = false;
            for (Commission comm : GeneralProductHelper.filterCommissions(fop.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories)) {
                if (!BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
                isFopForFeeForRefund = true;
                break;
            }
            if (isFopForFeeForRefund) break;
            hasCashFopInRefund = true;
            break;
        }
        return hasCashFopInRefund;
    }

    static boolean includeInFinanceDocuments(Product product) {
        if (product.getStatus() == ProductStatus.EXCHANGE || ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return false;
        }
        if (product.getProductCategory() == ProductCategory.KRS) {
            return false;
        }
        if (product.getMcoCategory() != null) {
            switch (product.getMcoCategory()) {
                case INFORMATION: {
                    return false;
                }
            }
        }
        return true;
    }

    static Collection<BillingItem> getBillingItems(List<Product> prods, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        HashMap mcos = new HashMap();
        HashMap penalties = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
        for (Product product : prods) {
            BigDecimal bigDecimal;
            String description = AirProductFinanceHelper.getDescription(product);
            if (product.getProductCategory() == ProductCategory.AIR) {
                FinanceDocumentsHelper.updateMap(tickets, description, product);
            } else if (product.getProductCategory() == ProductCategory.MCO) {
                FinanceDocumentsHelper.updateMap(mcos, description, product);
            }
            ArrayList<Commission> commissions = new ArrayList<Commission>();
            commissions.addAll(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), null, null, GeneralProductHelper.standardCommissionCategories));
            for (Commission commission : commissions) {
                CommissionData cData;
                EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (ctr == null) continue;
                if (ctr.getEntity() instanceof FeeProperties) {
                    FeeProperties prop = (FeeProperties)ctr.getEntity();
                    if (commission.getContractType() != ContractType.CLIENT && !prop.isChargeToClientForAllContractTypes()) continue;
                }
                if (FeeProperties.class.equals((Object)ctr.getEntityType()) || PaymentFeeProperties.class.equals((Object)ctr.getEntityType())) {
                    cData = new CommissionData(commission, product);
                    FinanceDocumentsHelper.updateMap(fees, AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(ctr.getEntityType().getName())) continue;
                cData = new CommissionData(commission, product);
                FinanceDocumentsHelper.updateMap(discounts, AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
            }
            Product previousProduct = product.getPreviousProduct();
            if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE) {
                for (Commission comm2 : AirProductHelper.getUnmodifiableCommissions(previousProduct, null)) {
                    EntityContainer ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
                    if (ctr == null || !FeeProperties.class.getName().equals(ctr.getEntityType().getName()) || ((FeeProperties)ctr.getEntity()).getOperation() != Operation.EXCHANGE) continue;
                    CommissionData cData = new CommissionData(comm2, previousProduct);
                    FinanceDocumentsHelper.updateMap(fees, AirProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                }
            }
            if (product.getStatus() != ProductStatus.REFUND && (product.getStatus() != ProductStatus.SELL || product.getPreviousProduct() == null || product.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) || (bigDecimal = product.getPenalty()) == null || BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
            boolean found = false;
            for (Product mco : AirProductHelper.getMcoByRelatedProduct(product.getStatus() == ProductStatus.REFUND ? product : product.getPreviousProduct())) {
                if (mco.getMcoCategory() != MCOCategory.PENALTY) continue;
                found = true;
                break;
            }
            if (found) continue;
            FinanceDocumentsHelper.updateMap(penalties, AirProductFinanceHelper.getDescription(bigDecimal), product);
        }
        AirProductFinanceHelper.updateProductItems(billingItems, tickets.values(), noVat);
        AirProductFinanceHelper.updateProductItems(billingItems, mcos.values(), noVat);
        AirProductFinanceHelper.updateCommissions(billingItems, fees.values(), false, noVat);
        AirProductFinanceHelper.updateCommissions(billingItems, discounts.values(), true, noVat);
        AirProductFinanceHelper.updatePenalties(billingItems, penalties.values(), noVat);
        return billingItems;
    }

    private static String getDescription(Product prod) {
        String result = prod.getProductCategory() + "_" + prod.getStatus() + "_" + prod.getSystemNumber();
        VatAmount money = AirProductFinanceHelper.calculateProductPrice(prod, false);
        return FinanceDocumentsHelper.getDescription(result, money);
    }

    private static VatAmount calculateProductPrice(Product prod, boolean ignoreExchange) {
        BigDecimal value = BigDecimal.ZERO;
        if (prod.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)prod, ContractType.CLIENT);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus())) {
            if (!AirProductHelper.getClientContractRelation(prod).getFops().isEmpty()) {
                for (ProductFop fop : AirProductHelper.getClientContractRelation(prod).getFops()) {
                    if (fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null || !AirProductHelper.isServiceFop(fop)) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            } else {
                for (ProductFop fop : AirProductHelper.getVendorContractRelation(prod).getFops()) {
                    if (fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            }
            if (prod.getPenalty() != null) {
                value = prod.getStatus() == ProductStatus.REFUND || prod.getStatus() == ProductStatus.EXCHANGE ? value.add(prod.getPenalty()) : value.subtract(prod.getPenalty());
            }
            boolean hasRelatedExchange = prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            VatAmount result = new VatAmount();
            if (prod.getTotalVendorEquivalentVatAmount() == null) {
                boolean rpVat = false;
                if (prod.getProductCategory() == ProductCategory.MCO && (prod.getMcoCategory() == MCOCategory.PENALTY || prod.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE) || prod.getProductCategory() == ProductCategory.EXCESS_BAGAGE) {
                    Product rp = AirProductHelper.findRelatedAirProduct(prod, null, false);
                    rpVat = rp == null || AirProductHelper.isHasVat(prod);
                }
                boolean hasVat = (prod.getProductCategory() == ProductCategory.AIR || prod.getMcoCategory() == MCOCategory.PTA) && AirProductHelper.isHasVat(prod) || prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() != MCOCategory.PTA && rpVat;
                result.setTotalVat(value, hasVat ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue() : 0.0);
            } else if (hasRelatedExchange && prod.getPreviousProduct().getTotalVendorEquivalentVatAmount() != null) {
                result.setTotalVatAmount(value, prod.getTotalVendorEquivalentVatAmount().subtract(prod.getPreviousProduct().getTotalVendorEquivalentVatAmount()));
            } else {
                result.setTotalVatAmount(value, prod.getTotalVendorEquivalentVatAmount());
            }
            if (ignoreExchange) {
                return result;
            }
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    public static String getCommonPart(Product prod, String relatedInvoiceNumber) {
        switch (prod.getProductCategory()) {
            case AIR: {
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return String.format("\u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s ($group_info) %s", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod), AirProductFinanceHelper.getExhangeInfo(prod, relatedInvoiceNumber));
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u0430 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s ($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod));
                }
                return "";
            }
            case MCO: {
                String result = null;
                switch (prod.getMcoCategory()) {
                    case EXCESS_LUGGAGE: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0431\u0430\u0433\u0430\u0436";
                        break;
                    }
                    case GROUP_PENALTY: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case GROUP_PREPAYMENT: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case PENALTY: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case PTA: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 PTA %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s, ($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u041c\u0421\u041e) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod));
                        break;
                    }
                    case RETURN_TICKET: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case SEAT_RESERVATION: {
                        result = "\u041c\u0421\u041e \u0437\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435";
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return result;
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 " + result;
                }
                return "";
            }
        }
        return "";
    }

    public static String getExhangeInfo(Product prod, String relatedInvoiceNumber) {
        if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return "";
        }
        Product firstSell = prod.getPreviousProduct().getPreviousProduct();
        return String.format("(\u0421 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0433\u043e \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s%s)", AirProductFinanceHelper.getTicketNumber(firstSell), !TextUtil.isBlank((String)relatedInvoiceNumber) ? String.format(", \u0441\u0447\u0435\u0442 \u2116 %s", relatedInvoiceNumber) : "");
    }

    private static String getCommonPart(Product prod) {
        switch (prod.getProductCategory()) {
            case AIR: {
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return String.format("\u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s ($group_info)%s", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod), AirProductFinanceHelper.getExhangeInfo(prod));
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u0430 %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s ($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod));
                }
                return "";
            }
            case MCO: {
                String result = null;
                switch (prod.getMcoCategory()) {
                    case EXCESS_LUGGAGE: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0431\u0430\u0433\u0430\u0436";
                        break;
                    }
                    case GROUP_PENALTY: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case GROUP_PREPAYMENT: {
                        result = "\u041c\u0421\u041e \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443 \u0437\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u044b";
                        break;
                    }
                    case PENALTY: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case REBOOKING: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043f\u0435\u0440\u0435\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case PTA: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 PTA %s\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s, \u043a\u043b\u0430\u0441\u0441 %s, \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a: %s, %s, ($group_info)", prod.isEticket() ? "(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0435 \u041c\u0421\u041e) " : "", AirProductHelper.getRouteLine(prod, null, false, null), AirProductFinanceHelper.getClassOfService(prod), AirProductFinanceHelper.getCarierCode(prod), AirProductFinanceHelper.getFlightDate(prod));
                        break;
                    }
                    case RETURN_TICKET: {
                        result = String.format("\u041c\u0421\u041e \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u2116 %s", AirProductFinanceHelper.getRelatedTicketNumber(prod));
                        break;
                    }
                    case SEAT_RESERVATION: {
                        result = "\u041c\u0421\u041e \u0437\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435";
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
                    return result;
                }
                if (prod.getStatus() == ProductStatus.REFUND) {
                    return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 " + result;
                }
                return "";
            }
        }
        return "";
    }

    private static String getRelatedTicketNumber(Product prod) {
        Iterator iterator = prod.getRelatedProducts().iterator();
        if (iterator.hasNext()) {
            Product bp = (Product)iterator.next();
            return AirProductFinanceHelper.getTicketNumber(bp);
        }
        return "?";
    }

    private static String getExhangeInfo(Product prod) {
        if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return "";
        }
        return String.format(" (\u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0433\u043e \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u2116%s)", AirProductFinanceHelper.getTicketNumber(prod.getPreviousProduct().getPreviousProduct()));
    }

    private static String getTicketNumber(Product prod) {
        return String.format("%s-%s", !TextUtil.isBlank((String)prod.getCarrierNumber()) ? prod.getCarrierNumber() : "?", !TextUtil.isBlank((String)prod.getSystemNumber()) ? prod.getSystemNumber() : "?");
    }

    private static String getFlightDate(Product product) {
        Date endDate;
        if (product.getSegmentTariffs().isEmpty()) {
            return "?";
        }
        SegmentTariff startSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(0);
        SegmentTariff endSegmentTariff = (SegmentTariff)product.getSegmentTariffs().get(product.getSegmentTariffs().size() - 1);
        Date startDate = startSegmentTariff.getSegments().size() > 0 ? ((Segment)startSegmentTariff.getSegments().get(0)).getStartDate() : null;
        Date date = endDate = endSegmentTariff.getSegments().size() > 0 ? ((Segment)endSegmentTariff.getSegments().get(endSegmentTariff.getSegments().size() - 1)).getEndDate() : null;
        if (startDate != null && endDate != null && MiscUtil.equals((Object)MiscUtil.clearTime((Date)startDate), (Object)MiscUtil.clearTime((Date)endDate))) {
            return LocaleManager.get().getCurrentLocaleData().getDateFormat().format(startDate);
        }
        return String.format("%s - %s", startDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(startDate) : "?", endDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(endDate) : "?");
    }

    private static String getCarierCode(Product prod) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(prod.getCarrier());
        if (airline == null) {
            return "?";
        }
        if (airline.getCodeVariants().isEmpty()) {
            return airline.getCode();
        }
        String res = (String)airline.getCodeVariants().get(CodeSystem.IATA.name());
        if (!TextUtil.isBlank((String)res)) {
            return res;
        }
        return (String)airline.getCodeVariants().values().iterator().next();
    }

    private static String getClassOfService(Product prod) {
        ClassOfService classOfService = AirProductHelper.calculateClassOfService(prod);
        return classOfService != null ? classOfService.toString() : "?";
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<Product>> values, boolean noVat) {
        for (List<Product> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (Product product : lst) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(AirProductFinanceHelper.getCommonPart(lst.get(0)).replace("$group_info", AirProductFinanceHelper.getGroupInfo(lst)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (Product product : lst) {
                VatAmount price = AirProductFinanceHelper.calculateProductPrice(product, false);
                total = total.add(price.getTotal());
                vat = vat.add(price.getVatAmount());
            }
            ProductStatus status = lst.get(0).getStatus();
            if (status == ProductStatus.REFUND) {
                total = total.negate();
                vat = vat.negate();
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static String getGroupInfo(List<Product> lst) {
        StringBuilder sb = new StringBuilder();
        for (Product product : lst) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(product.getTraveller() != null ? product.getTraveller().getName() : "?");
            if (product.getStatus() == ProductStatus.BOOKING) continue;
            sb.append(": \u2116").append(AirProductFinanceHelper.getTicketNumber(product));
        }
        return sb.toString();
    }

    private static String getDescription(EntityContainer<? extends BaseCommissionProperties> ctr, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        return FinanceDocumentsHelper.getDescription(UUIDGenerator.generate((boolean)false).toString(), amount);
    }

    private static String getDescription(BigDecimal penalty) {
        return Double.toString(penalty.doubleValue());
    }

    private static void updateCommissions(List<BillingItem> billingItems, Collection<List<CommissionData>> values, boolean discount, boolean noVat) throws Exception {
        for (List<CommissionData> lst : values) {
            FeeProperties prop;
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (CommissionData data : lst) {
                item.getProductUids().add(data.product.getUid());
            }
            item.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            item.setCommissionType(lst.get((int)0).commission.getCommissionProperties());
            EntityContainer ctr = EntityStorage.get().resolve(lst.get((int)0).commission.getCommissionProperties());
            BigDecimal coef = BigDecimal.ONE;
            if (ctr.getEntityType().getName().equals(FeeProperties.class.getName())) {
                prop = (FeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
                if (lst.get((int)0).product.getStatus() == ProductStatus.EXCHANGE && prop.getOperation() == Operation.EXCHANGE) {
                    coef = coef.negate();
                }
            } else if (ctr.getEntityType().equals(PaymentFeeProperties.class)) {
                prop = (PaymentFeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
            } else {
                item.setName(((DiscountProperties)ctr.getEntity()).getFinanceName());
            }
            if (lst.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coef = coef.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<Product> products = new ArrayList<Product>();
            for (CommissionData cdata : lst) {
                BigDecimal ec = cdata.commission.getEquivalentAmount();
                if (ec != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(ec) : total.add(ec);
                }
                if (cdata.product == null || products.contains(cdata.product)) continue;
                products.add(cdata.product);
            }
            if (!TextUtil.isBlank((String)item.getName())) {
                item.setName(item.getName().replace("${air_tickets_info}", AirProductFinanceHelper.getGroupInfo(products)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coef.multiply(total), noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(lst.get((int)0).product.getIssueDate())).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static void updatePenalties(List<BillingItem> billingItems, Collection<List<Product>> values, boolean noVat) {
        for (List<Product> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            BigDecimal penalty = BigDecimal.ZERO;
            BigDecimal totalVat = BigDecimal.ZERO;
            boolean refund = false;
            boolean exchange = false;
            for (Product product : lst) {
                item.getProductUids().add(product.getUid());
                if (product.getPenalty() != null) {
                    penalty = penalty.add(product.getPenalty());
                    totalVat = totalVat.add(AirProductHelper.getPenaltyVatAmount(product));
                }
                if (refund || exchange) continue;
                refund = product.getStatus() == ProductStatus.REFUND;
                exchange = product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            }
            if (BigDecimal.ZERO.compareTo(penalty) == 0) continue;
            item.setServiceType(ServiceType.PENALTY);
            if (refund) {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 (%s)", AirProductFinanceHelper.getGroupInfo(lst)));
            } else if (exchange) {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 (%s)", AirProductFinanceHelper.getGroupInfo(lst)));
            } else {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 (%s)", AirProductFinanceHelper.getGroupInfo(lst)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(penalty, totalVat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private AirProductFinanceHelper() {
    }

    static final class CommissionData {
        public Product product;
        public Commission commission;

        public CommissionData(Commission aCommission, Product aProduct) {
            this.commission = aCommission;
            this.product = aProduct;
        }
    }
}

