/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

public class AirlineHandler
extends DictionaryHandler<Airline> {
    @Override
    protected void registerProperties() {
        this.registerCodeVariants();
        this.registerTranslations();
        this.registerSpellVariants();
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getAirlineNumber()) || TextUtil.isSame((String)dictFrom.getAirlineNumber(), (String)dictTo.getAirlineNumber());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setAirlineNumber(dictFrom.getAirlineNumber());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"AIRLINE_NUMBER", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.airlineNumber;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getCountry() == null || dictFrom.getCountry().equals((Object)dictTo.getCountry())) {
                    return true;
                }
                if (dictTo.getCountry() == null) {
                    return false;
                }
                Country foundCountry = DictSyncHelper.search(dictFrom.getCountry(), relatedDictionaries, Country.class);
                return foundCountry == null || TextUtil.isSame((String)foundCountry.getCode(), (String)dictTo.getCountry().getCode());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                Country foundCountry = DictSyncHelper.search(dictFrom.getCountry(), relatedDictionaries, Country.class);
                dictTo.setCountry((DictionaryReference)(foundCountry != null ? foundCountry.toReference() : dictFrom.getCountry()));
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"COUNTRY", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.country;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getLegalForm() == null || dictFrom.getLegalForm().equals((Object)dictTo.getLegalForm())) {
                    return true;
                }
                if (dictTo.getLegalForm() == null) {
                    return false;
                }
                LegalForm foundLegalForm = DictSyncHelper.search(dictFrom.getLegalForm(), relatedDictionaries, LegalForm.class);
                return foundLegalForm == null || TextUtil.isSame((String)foundLegalForm.getCode(), (String)dictTo.getLegalForm().getCode());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                LegalForm foundLegalForm = DictSyncHelper.search(dictFrom.getLegalForm(), relatedDictionaries, LegalForm.class);
                dictTo.setLegalForm((DictionaryReference)(foundLegalForm != null ? foundLegalForm.toReference() : dictFrom.getLegalForm()));
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"LEGAL_FORM", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.legalForm;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictFrom.getOpenDate() == null || MiscUtil.isSameDaySafe((Date)dictFrom.getOpenDate(), (Date)dictTo.getOpenDate());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setOpenDate(dictFrom.getOpenDate());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"OPEN_DATE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.openDate;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictFrom.getCloseDate() == null || MiscUtil.isSameDaySafe((Date)dictFrom.getCloseDate(), (Date)dictTo.getCloseDate());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setCloseDate(dictFrom.getCloseDate());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"CLOSE_DATE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.closeDate;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getAlliance() == null || dictFrom.getAlliance().equals((Object)dictTo.getAlliance())) {
                    return true;
                }
                if (dictTo.getAlliance() == null) {
                    return false;
                }
                AirlineAlliance foundAlliance = DictSyncHelper.search(dictFrom.getAlliance(), relatedDictionaries, AirlineAlliance.class);
                return foundAlliance == null || TextUtil.isSame((String)foundAlliance.getCode(), (String)dictTo.getAlliance().getCode());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                AirlineAlliance foundAlliance = DictSyncHelper.search(dictFrom.getAlliance(), relatedDictionaries, AirlineAlliance.class);
                dictTo.setAlliance((DictionaryReference)(foundAlliance != null ? foundAlliance.toReference() : dictFrom.getAlliance()));
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"ALLIANCE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.alliance;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getRegistrationId()) || TextUtil.isSame((String)dictFrom.getRegistrationId(), (String)dictTo.getRegistrationId());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setRegistrationId(dictFrom.getRegistrationId());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"REGISTRATION_ID", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.registrationId;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getKpp()) || TextUtil.isSame((String)dictFrom.getKpp(), (String)dictTo.getKpp());
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setKpp(dictFrom.getKpp());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"KPP", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.kpp;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<Airline>(){

            @Override
            public boolean match(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictTo.getAcceptableCards().equals(dictFrom.getAcceptableCards())) {
                    return true;
                }
                for (AirlineCard card : dictFrom.getAcceptableCards()) {
                    if (CollectionUtil.contains((Collection)dictTo.getAcceptableCards(), (Object)card, (c1, c2) -> TextUtil.isSame((String)c1.getCode(), (String)c2.getCode()) && c1.getVendor() == c2.getVendor())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toString(Airline dict) {
                return dict.getAcceptableCards().stream().map(entry -> entry.getVendor() + " - " + entry.getCode()).collect(Collectors.joining(", "));
            }

            @Override
            public void merge(Airline dictTo, Airline dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                for (AirlineCard card : dictFrom.getAcceptableCards()) {
                    if (CollectionUtil.contains((Collection)dictTo.getAcceptableCards(), (Object)card, (c1, c2) -> TextUtil.isSame((String)c1.getCode(), (String)c2.getCode()) && c1.getVendor() == c2.getVendor())) continue;
                    dictTo.getAcceptableCards().add(card);
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"ACCEPTABLE_CARDS", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return Airline.Property.acceptableCards;
            }
        });
    }

    @Override
    public boolean match(Airline dictTo, Airline dictFrom) {
        return dictTo.getCloseDate() == null || dictTo.getCloseDate().after(new Date());
    }

    @Override
    public boolean isForRemoteUpdate(Airline dict) {
        return dict.getCloseDate() == null || dict.getCloseDate().after(new Date());
    }

    @Override
    public Airline search(Airline dict) {
        if (dict == null) {
            return null;
        }
        Date today = new Date();
        Collection allAirlines = DictionaryCache.get().getAll(this.getDictionaryClass()).values();
        ArrayList<Airline> airlinesWithSameNumber = new ArrayList<Airline>();
        if (TextUtil.nonBlank((String)dict.getAirlineNumber()) && !TextUtil.isSame((String)dict.getAirlineNumber(), (String)"null", (boolean)true) && !TextUtil.isSame((String)dict.getAirlineNumber(), (String)"01B", (boolean)true)) {
            for (Airline airline : allAirlines) {
                if (TextUtil.isBlank((String)airline.getAirlineNumber()) || airline.getCloseDate() != null && airline.getCloseDate().before(today) || !TextUtil.isSame((String)airline.getAirlineNumber(), (String)dict.getAirlineNumber(), (boolean)true)) continue;
                airlinesWithSameNumber.add(airline);
            }
        }
        for (Airline airline : airlinesWithSameNumber) {
            if (!DictSyncHelper.compareByNames(airline, dict)) continue;
            return airline;
        }
        Collection<Airline> airlinesWithSameCodeVariants = DictSyncHelper.searchByCodeVariants(dict, this.getDictionaryClass(), this::match, CodeSystem.IATA, CodeSystem.ISO, CodeSystem.ISO_ALPHA3, CodeSystem.ISO_NUMERIC, CodeSystem.CRT, CodeSystem.EXPRESS);
        for (Airline airline : airlinesWithSameCodeVariants) {
            if (!DictSyncHelper.compareByNames(airline, dict)) continue;
            return airline;
        }
        for (Airline airline : airlinesWithSameCodeVariants) {
            if (!airlinesWithSameNumber.contains(airline)) continue;
            return airline;
        }
        for (Airline airline : airlinesWithSameNumber) {
            if (!TextUtil.isSame((String)airline.getCode(), (String)dict.getCode(), (boolean)true) || !MiscUtil.equals((Object)airline.getCountry(), (Object)dict.getCountry())) continue;
            return airline;
        }
        for (Airline airline : airlinesWithSameCodeVariants) {
            if (!TextUtil.isSame((String)airline.getCode(), (String)dict.getCode(), (boolean)true) || !MiscUtil.equals((Object)airline.getCountry(), (Object)dict.getCountry())) continue;
            return airline;
        }
        for (Airline airline : airlinesWithSameNumber) {
            if (!TextUtil.isSame((String)airline.getCode(), (String)dict.getCode(), (boolean)true)) continue;
            return airline;
        }
        Airline airline = (Airline)DictionaryCache.get().findByCode(this.getDictionaryClass(), dict.getCode());
        if (airline != null && this.match(airline, dict) && (DictSyncHelper.compareByNames(airline, dict) || MiscUtil.equals((Object)airline.getCountry(), (Object)dict.getCountry()))) {
            return airline;
        }
        for (Airline airline2 : airlinesWithSameCodeVariants) {
            if (!TextUtil.isSame((String)airline2.getCode(), (String)dict.getCode(), (boolean)true) || !MiscUtil.equals((Object)airline2.getCountry(), (Object)dict.getCountry())) continue;
            return airline2;
        }
        return null;
    }

    @Override
    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(Airline dict) {
        return Arrays.asList(dict.getCountry(), dict.getLegalForm(), dict.getAlliance());
    }

    @Override
    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Arrays.asList(Country.class, LegalForm.class, AirlineAlliance.class);
    }

    @Override
    public Class<Airline> getDictionaryClass() {
        return Airline.class;
    }
}

