/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryHandler
implements ProductHandler<Delivery> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public VatAmount calculateProductPrice(Delivery product, ContractType ctype) {
        VatAmount vatAmount = new VatAmount();
        vatAmount.setTotalVat(BigDecimal.ZERO, MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue());
        return vatAmount;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, Delivery product) {
        return this.calculateProductPrice(product, (ContractType)null);
    }

    @Override
    public String generateShortProductName(Delivery product) {
        if (product.getStatus() == DeliveryStatus.RETURNED) {
            return L10nResourcesManager.getStr((String)"DELIVERY_SHORT_PRODUCT_NAME_REFUND", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : ""});
        }
        return L10nResourcesManager.getStr((String)"DELIVERY_SHORT_PRODUCT_NAME_DELIVERY", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : ""});
    }

    @Override
    public String generateProductName(Delivery product) {
        String deliveryItems = product.getDeliveryItems().stream().map(BaseEntity::toString).collect(Collectors.joining(", "));
        if (deliveryItems.length() > 30) {
            deliveryItems = deliveryItems.substring(0, 30);
        }
        if (product.getStatus() == DeliveryStatus.RETURNED) {
            return L10nResourcesManager.getStr((String)"DELIVERY_PRODUCT_NAME_REFUND", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", deliveryItems});
        }
        return L10nResourcesManager.getStr((String)"DELIVERY_PRODUCT_NAME_DELIVERY", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", deliveryItems});
    }

    @Override
    public Date findFirstTravelDate(Delivery product) {
        return null;
    }

    @Override
    public Date findLastTravelDate(Delivery product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(Delivery product) {
        return product.getSystemNumber() == null ? Collections.emptyList() : Collections.singletonList(product.getSystemNumber());
    }

    @Override
    public EntityReference<Person> findIssuingAgent(Delivery product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(Delivery product) {
        return null;
    }

    @Override
    public Date findIssueDate(Delivery product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(Delivery product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(Delivery product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(Delivery product) {
        return product.getStatus() != DeliveryStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof Delivery)) continue;
            prods.add(this.createFinanceCapableProduct((Delivery)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof Delivery)) continue;
            prods.add(this.createFinanceCapableProduct((Delivery)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(Delivery product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final Delivery product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return DeliveryHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return Collections.emptyList();
            }

            public List<GeneralProductFop> getSubagentFops() {
                return Collections.emptyList();
            }

            public List<GeneralProductFop> getClientFops() {
                return product.getClientFops();
            }

            @Override
            public ProductStatus getStatus() {
                return DeliveryHelper.getProductStatus(product);
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return product.getCommissions();
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() == null ? null : DeliveryHandler.this.createFinanceCapableProduct(product.getPreviousProduct());
            }

            @Override
            public VatAmount calculateProductPrice() {
                return DeliveryHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                String items = product.getDeliveryItems().stream().map(BaseEntity::toString).collect(Collectors.joining(", "));
                if (product.getStatus() == DeliveryStatus.RETURNED) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 %s (%s)", product.getSystemNumber() != null ? product.getSystemNumber() : "", items);
                }
                return String.format("\u0414\u043e\u0441\u0442\u0430\u0432\u043a\u0430 %s (%s)", product.getSystemNumber() != null ? product.getSystemNumber() : "", items);
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return null;
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(Delivery product) {
        return Collections.emptyList();
    }

    @Override
    public boolean isNoTraveller() {
        return true;
    }

    @Override
    public void replaceTraveller(Delivery product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(Delivery product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<Delivery> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(Delivery product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(Delivery product) {
        return DeliveryHelper.getProductStatus(product);
    }

    @Override
    public ProductStatus getBaseStatus(Delivery product) {
        return DeliveryHelper.getProductStatus(product);
    }

    @Override
    public void setStatus(Delivery product, ProductStatus productStatus) {
        DeliveryHelper.setProductStatus(product, productStatus);
    }

    @Override
    public ProductType getProductType(Delivery product) {
        return ProductType.DELIVERY;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.DELIVERY).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.DELIVERY;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(Delivery product) {
        return null;
    }

    @Override
    public EntityReference<Branch> getBranch(Delivery product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(Delivery product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        for (GeneralProductCommission comm : product.getCommissions()) {
            if (comm.getContractType() != ContractType.CLIENT) continue;
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(DeliveryHelper.getProductStatus(product) == ProductStatus.REFUND || DeliveryHelper.getProductStatus(product) == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(Delivery product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(Delivery product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(Delivery product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(Delivery product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(Delivery product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(Delivery product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, Delivery product) {
        return null;
    }

    @Override
    public Delivery getPreviousProduct(Delivery product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(Delivery product, Delivery previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(Delivery product, Delivery nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public Delivery getNextProduct(Delivery product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(Delivery product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(Delivery product) {
        return DeliveryHelper.getRelatedProducts(product);
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(Delivery product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(Delivery product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(Delivery product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(Delivery product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(Delivery product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(Delivery product) {
        return null;
    }

    @Override
    public BigDecimal getServiceFare(Delivery product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(Delivery product) {
        return null;
    }

    @Override
    public int getConjunction(Delivery product) {
        return 0;
    }

    @Override
    public String getRouteLine(Delivery product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(Delivery product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(Delivery product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(Delivery product) {
        GeneralProductContractRelationData result = new GeneralProductContractRelationData();
        result.setUid(product.getUid() + "_fake_contract_relation_data_uid");
        result.setDescription(GeneralProductHelper.findContractRelationRef(PredefinedContractRelationType.AGENCY_TO_CLIENT));
        result.getCommissions().addAll(product.getCommissions());
        result.getFops().addAll(product.getClientFops());
        return Collections.singletonList(result);
    }

    @Override
    public SalesChain getSalesChain(Delivery product) {
        SalesChain result = new SalesChain();
        result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.OWN, null));
        GeneralProductHelper.setContractor(result, PredefinedContractorType.AGENCY, (EntityReference<Organization>)product.getAgency());
        return result;
    }

    @Override
    public void updateContractRelations(Delivery product, List<GeneralProductContractRelationData> relations) {
        GeneralProductContractRelationData clientRelation = relations.get(0);
        product.getCommissions().clear();
        product.getCommissions().addAll(clientRelation.getCommissions());
        product.getClientFops().clear();
        product.getClientFops().addAll(clientRelation.getFops());
    }

    @Override
    public TicketType getTicketType(Delivery product) {
        return null;
    }

    @Override
    public void setTicketType(Delivery product, TicketType ticketType) {
    }

    @Override
    public String getPCC(Delivery product) {
        return null;
    }

    @Override
    public void updateProductFops(Delivery product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(Delivery product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(Delivery product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(Delivery product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(Delivery product) {
        return null;
    }

    @Override
    public boolean isHoldable(Delivery product) {
        return false;
    }

    @Override
    public Date getUnholdDate(Delivery product) {
        return null;
    }

    @Override
    public String getValidatorNumber(Delivery product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(Delivery product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(Delivery product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(Delivery product) {
        return true;
    }

    @Override
    public void newStatisticalData(Delivery product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(Delivery product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public Delivery newInstance() {
        return new Delivery();
    }

    @Override
    public String getCarrierNumber(Delivery product) {
        return null;
    }

    @Override
    public void setAgent(Delivery product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(Delivery product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(Delivery product, EntityReference<Organization> agency) {
        product.setAgency(agency);
    }

    @Override
    public void setBlankOwner(Delivery product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(Delivery product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(Delivery product, EntityReference<Organization> supplier) {
    }

    @Override
    public void setSubagency(Delivery product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(Delivery product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(Delivery product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        switch (contractType) {
            case CLIENT: {
                GeneralProductHelper.changeFopsPaymentTypes(GeneralProductHelper.getClientFops((BaseProduct)product), paymentType, updateOnlyFeeFops);
                break;
            }
        }
    }

    @Override
    public void changeFopsAgent(Delivery product, EntityReference<Person> agent, ContractType contractType) {
        switch (contractType) {
            case CLIENT: {
                GeneralProductHelper.getClientFops((BaseProduct)product).forEach(fop -> fop.setAgent(agent));
                break;
            }
        }
    }

    @Override
    public List<String> getFopsUids(Delivery product, ContractType contractType) {
        if (contractType == ContractType.CLIENT) {
            return GeneralProductHelper.getClientFops((BaseProduct)product).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(Delivery product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(Delivery product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(Delivery product) {
        return null;
    }

    @Override
    public boolean removeProduct(Delivery product) {
        return DeliveryHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(Delivery product, BaseProduct relatedProduct) {
        return DeliveryHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(Delivery product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(Delivery product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(Delivery product, Locale locale) {
        return null;
    }

    @Override
    public String getAddresses(Delivery product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return DeliveryHelper.getAddresses(product, locale, translitRules);
    }

    @Override
    public Date getFirstStartDate(Delivery product) {
        return product.getStartDate();
    }

    @Override
    public Date getLastStartDate(Delivery product) {
        return product.getStartDate();
    }

    @Override
    public Date getFirstEndDate(Delivery product) {
        return product.getEndDate();
    }

    @Override
    public Date getLastEndDate(Delivery product) {
        return product.getEndDate();
    }

    @Override
    public String getDescriptionLine(Delivery product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(Delivery product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(Delivery product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(Delivery product) {
        return false;
    }

    @Override
    public String getRfic(Delivery product) {
        return null;
    }

    @Override
    public String getRfisc(Delivery product) {
        return null;
    }

    @Override
    public String getTourCode(Delivery product) {
        return null;
    }

    @Override
    public boolean isDuplicate(Delivery product) {
        return false;
    }

    @Override
    public boolean isUseShortName() {
        return true;
    }
}

