/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GeoLocationHandler
extends DictionaryHandler<GeoLocation> {
    @Override
    protected void registerProperties() {
        this.registerCodeVariants();
        this.registerTranslations();
        this.registerSpellVariants();
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictFrom.getType() == null || dictFrom.getType() == dictTo.getType();
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setType(dictFrom.getType());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"TYPE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.type;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getCountry() == null || dictFrom.getCountry().equals((Object)dictTo.getCountry())) {
                    return true;
                }
                if (dictTo.getCountry() == null) {
                    return false;
                }
                Country foundCountry = DictSyncHelper.search(dictFrom.getCountry(), relatedDictionaries, Country.class);
                return foundCountry == null || TextUtil.isSame((String)foundCountry.getCode(), (String)dictTo.getCountry().getCode());
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                Country foundCountry = DictSyncHelper.search(dictFrom.getCountry(), relatedDictionaries, Country.class);
                dictTo.setCountry((DictionaryReference)(foundCountry != null ? foundCountry.toReference() : dictFrom.getCountry()));
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"COUNTRY", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.country;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getParent() == null || dictFrom.getParent().equals((Object)dictTo.getParent())) {
                    return true;
                }
                if (dictTo.getParent() == null) {
                    return false;
                }
                GeoLocation foundParent = DictSyncHelper.search(dictFrom.getParent(), relatedDictionaries, GeoLocation.class);
                return foundParent == null || TextUtil.isSame((String)foundParent.getCode(), (String)dictTo.getParent().getCode());
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                GeoLocation foundParent = DictSyncHelper.search(dictFrom.getParent(), relatedDictionaries, GeoLocation.class);
                dictTo.setParent((DictionaryReference)(foundParent != null ? foundParent.toReference() : dictFrom.getParent()));
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"PARENT", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.parent;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictFrom.getLatitude() == 0.0 || dictFrom.getLatitude() != dictTo.getLatitude();
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setLatitude(dictFrom.getLatitude());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"LATITUDE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.latitude;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return dictFrom.getLongitude() == 0.0 || dictFrom.getLongitude() != dictTo.getLongitude();
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setLongitude(dictFrom.getLongitude());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"LONGITUDE", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.longitude;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                return TextUtil.isBlank((String)dictFrom.getTimeZoneId()) || TextUtil.isSame((String)dictFrom.getTimeZoneId(), (String)dictTo.getTimeZoneId());
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                dictTo.setTimeZoneId(dictFrom.getTimeZoneId());
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"TIME_ZONE_ID", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.timeZoneId;
            }
        });
        this.registerProperty(new DictionaryHandler.Property<GeoLocation>(){

            @Override
            public boolean match(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictTo.getRegions().containsAll(dictFrom.getRegions())) {
                    return true;
                }
                for (DictionaryReference regionRef : dictFrom.getRegions()) {
                    GeoRegion region;
                    if (dictTo.getRegions().contains(regionRef) || (region = DictSyncHelper.search(regionRef, relatedDictionaries, GeoRegion.class)) == null || dictTo.getRegions().contains(region.toReference())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(GeoLocation dictTo, GeoLocation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                for (DictionaryReference regionRef : dictFrom.getRegions()) {
                    GeoRegion region;
                    if (dictTo.getRegions().contains(regionRef) || (region = DictSyncHelper.search(regionRef, relatedDictionaries, GeoRegion.class)) == null) continue;
                    GeoRegionReference regionReference = region.toReference();
                    if (dictTo.getRegions().contains(regionReference)) continue;
                    dictTo.getRegions().add(regionReference);
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"REGIONS", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return GeoLocation.Property.regions;
            }
        });
    }

    @Override
    public boolean match(GeoLocation dictTo, GeoLocation remoteElement) {
        return dictTo.getType() == remoteElement.getType();
    }

    @Override
    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(GeoLocation dict) {
        ArrayList<DictionaryReference<? extends BaseDictionary>> result = new ArrayList<DictionaryReference<? extends BaseDictionary>>(dict.getRegions());
        result.add(dict.getCountry());
        if (dict.getParent() != null && !TextUtil.isSame((String)dict.getParent().getCode(), (String)dict.getCode())) {
            result.add((DictionaryReference<? extends BaseDictionary>)dict.getParent());
        }
        return result;
    }

    @Override
    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Arrays.asList(Country.class, GeoRegion.class, GeoLocation.class);
    }

    @Override
    public Class<GeoLocation> getDictionaryClass() {
        return GeoLocation.class;
    }
}

