/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveProductData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsClientMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSubagencyMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsXIData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.GuaranteeType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.dictionary.HotelsTranslationEntry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassiveSegmentsHotelMeal;
import com.gridnine.xtrip.common.model.dict.PassiveSegmentsHotelRoomType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HotelProductPassiveSegmentsHandler
implements ProductPassiveSegmentsHandler<HotelProduct> {
    private static final String HOTEL_AGGREGATOR_GDS_NAME = "HOTEL_AGGREGATOR";

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public boolean isAcceptableForPassiveSegmentsCreation(HotelProduct product, List<Message> messages) {
        boolean isBookingForAggregator;
        if (product == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyProduct, (Object[])new Object[0]));
            return false;
        }
        if (product.getReservation() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyReservationDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        ProductStatus status = product.getStatus();
        GdsName gds = CommonReservationGdsNameInfoHelper.getDisplayedGdsName(product.getReservation());
        boolean bl = isBookingForAggregator = status == ProductStatus.BOOKING && gds != null && HOTEL_AGGREGATOR_GDS_NAME.equals(gds.name());
        if (status != ProductStatus.SELL && !isBookingForAggregator) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationInvalidProductStatusDetails, (Object[])new Object[]{status.toString()}));
            return false;
        }
        if (gds == GdsName.SABRE) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationSabreGdsDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getProvider() == HotelProvider.SABRE) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentValidationSabreHotelProviderDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getHotelLocation() == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyHotelLocationDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getNextProduct() != null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationHasNextProductDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getTravellers().isEmpty()) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyTravellersDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getRooms().isEmpty()) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyHotelRoomsDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        return true;
    }

    @Override
    public boolean validateProducts(List<HotelProduct> products, List<Message> incomingMessages) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (HotelProduct p : products) {
            for (Room r : p.getRooms()) {
                int checkOutTime;
                int checkInTime;
                if (r.getCheckInDate() == null) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyCheckInDateDetails, (Object[])new Object[]{p.getSystemNumber(), r.getRoomName()}));
                }
                if (r.getCheckOutDate() == null) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationEmptyCheckOutDateDetails, (Object[])new Object[]{p.getSystemNumber(), r.getRoomName()}));
                }
                int n = checkInTime = r.getCheckInTime() != null ? r.getCheckInTime() * 60 * 1000 : 0;
                if (new Date(r.getCheckInDate().getTime() + (long)checkInTime).before(new Date())) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationCheckInDateIsBeforeCurrentDateDetails, (Object[])new Object[]{p.getSystemNumber(), r.getRoomName()}));
                }
                int n2 = checkOutTime = r.getCheckOutTime() != null ? r.getCheckOutTime() * 60 * 1000 : 0;
                if (r.getCheckInDate().getTime() + (long)checkInTime <= r.getCheckOutDate().getTime() + (long)checkOutTime) continue;
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.sabrePassiveSegmentsValidationCheckInDateIsAfterCheckOutDateDetails, (Object[])new Object[]{p.getSystemNumber(), r.getRoomName()}));
            }
        }
        if (!messages.isEmpty()) {
            incomingMessages.addAll(messages);
            return false;
        }
        return true;
    }

    @Override
    public List<SabrePassivePassengerData> getTravellers(List<HotelProduct> products) {
        ArrayList<SabrePassivePassengerData> res = new ArrayList<SabrePassivePassengerData>();
        products.stream().filter(p -> !p.getTravellers().isEmpty()).forEach(p -> {
            p.getTravellersPassengerTypes();
            for (int i = 0; i < p.getTravellers().size(); ++i) {
                Traveller t = (Traveller)p.getTravellers().get(i);
                PassengerTypeReference ptr = i < p.getTravellersPassengerTypes().size() ? (PassengerTypeReference)p.getTravellersPassengerTypes().get(i) : null;
                DictionaryReference type = ptr != null ? ptr.getPassengerType() : null;
                SabrePassivePassengerData trv = new SabrePassivePassengerData();
                trv.setUid(t.getUid());
                String surname = SabrePassiveSegmentsUtil.buildSurname(t);
                if (TextUtil.isBlank((String)surname)) {
                    throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsTravellerSurnameNotFoundErrorDetails, (Object[])new Object[0]);
                }
                trv.setLastName(surname);
                trv.setFirstName(SabrePassiveSegmentsUtil.buildGivenName(t, (DictionaryReference<PassengerType>)type, SabrePassiveSegmentsUtil.getHotelProvider(p, t)));
                trv.setInfant(DictHelper.isInfantPassengerType((DictionaryReference<PassengerType>)type));
                trv.setPassengerType(type == null ? null : DictHelper.getCodeVariant(type, CodeSystem.IATA));
                res.add(trv);
            }
        });
        return res;
    }

    @Override
    public SabrePassiveProductData getSabrePassiveData(List<HotelProduct> originalProducts, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode, List<Message> messages, boolean throwException) {
        EntityReference bookingAgentRef;
        SabrePassiveProductData data = new SabrePassiveProductData();
        List<RoomWrapper> segmentWrappers = this.groupProductsBySegments(originalProducts);
        Map<String, String> product2Num = this.assignProductNumbers(originalProducts);
        HashSet<String> usedProductsUids = new HashSet<String>();
        TranslitUtil.TranslitRules rules = TranslitUtil.TranslitRules.GOST_52535_1_2006;
        ProductHandler<HotelProduct> productHandler = HandlersRegistry.get().findProductHandler(HotelProduct.class);
        for (RoomWrapper rw : segmentWrappers) {
            String hotelLocationStr;
            Room r = rw.getRoom();
            List<HotelProduct> products = rw.getProducts();
            String locator = SabrePassiveSegmentsUtil.getTranslation(rw.getGdsRecloc(), rules);
            SabrePassiveSegmentData seg = new SabrePassiveSegmentData();
            seg.setSegmentType(SabrePassiveSegmentType.HOTEL);
            seg.setHotelCheckInDate(r.getCheckInDate());
            seg.setHotelCheckOutDate(r.getCheckOutDate());
            if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
                DictionaryReference<GeoLocation> hotelLocationRef = rw.getHotelLocation();
                GeoLocation hotelLocation = (GeoLocation)DictionaryCache.get().resolveReference(hotelLocationRef);
                if (hotelLocation == null) {
                    throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsBrokenHotelLocationRefErrorDetails, (Object[])new Object[0]);
                }
                hotelLocationStr = DictHelper.getCodeVariant((BaseDictionary)hotelLocation, CodeSystem.IATA);
                if (TextUtil.isBlank((String)hotelLocationStr)) {
                    hotelLocationStr = SabrePassiveSegmentsUtil.getTranslation(rw.getHotelLocation()).replace("-", " ").replace(".", "");
                }
            } else {
                hotelLocationStr = SabrePassiveSegmentsUtil.getTranslation(rw.getHotelLocation()).replace("-", " ").replace(".", "");
            }
            seg.setHotelCity(hotelLocationStr);
            seg.setHotelName(SabrePassiveSegmentsUtil.replaceSlashInHotelName(rw.getHotelName()));
            seg.setHotelRoomType(r.getRoomSize());
            seg.setId(r.getUid());
            String command = this.getCreationCommand(rw, r, locator, rules, subagencyMode, throwException);
            if (command.length() > 230) {
                throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsHotelSegmentCreationCommandLengthErrorDetails, (Object[])new Object[0]);
            }
            seg.setCommandToCreate(command);
            data.getSegments().add(seg);
            data.getRemarks().addAll(this.createCrossSRemarks(rw, products, r, clientMode, subagencyMode, messages, throwException));
            HotelProduct firstProduct = products.get(0);
            String gdsName = productHandler.getGdsName(firstProduct);
            if (subagencyMode == SabrePassiveSegmentsSubagencyMode.REGULAR && gdsName != null) {
                String text = "SRC-" + gdsName;
                data.getRemarks().addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(r.getUid(), text));
            }
            if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT && !TextUtil.isBlank((String)rw.getHotelPropertyId())) {
                StringBuilder text = new StringBuilder("HOTEL-").append(rw.getHotelPropertyId());
                if (!TextUtil.isBlank((String)firstProduct.getHotelChainCode())) {
                    text.append("/").append(SabrePassiveSegmentsUtil.getTranslation(firstProduct.getHotelChainCode()));
                }
                data.getRemarks().addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(r.getUid(), text.toString()));
            }
            for (HotelProduct product : products) {
                String productNumber = SabrePassiveSegmentsUtil.getTranslation(productHandler.getProductNumberForPassiveSegments(product));
                if (productNumber != null) {
                    this.getPassengerNames(product).forEach(n -> {
                        String text = "CNF-" + productNumber + "/" + n;
                        data.getRemarks().addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(r.getUid(), text));
                    });
                    String vendorCode = this.getVendorCode(CommonReservationGdsNameInfoHelper.getDisplayedGdsName(product.getReservation()));
                    data.getAccountingLines().add(this.createAccountingLine(vendorCode, productNumber, r.getUid()));
                }
                if (!usedProductsUids.contains(product.getUid())) {
                    data.getRemarks().addAll(this.createDotXStarProductRemarks(product, product2Num.get(product.getUid()), productNumber, clientMode, subagencyMode));
                    usedProductsUids.add(product.getUid());
                    data.getRemarks().addAll(this.createDotProductRemarks(product, product2Num.get(product.getUid()), clientMode, subagencyMode));
                }
                if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT) continue;
                data.getRetentionLinesCommands().add(this.getRetentionLineCommand(product));
            }
        }
        HotelProduct veryFirstProduct = originalProducts.get(0);
        if (veryFirstProduct.getReservation() != null && veryFirstProduct.getReservation().getBookingFile() != null && !TextUtil.isBlank((String)veryFirstProduct.getReservation().getBookingFile().getNumber())) {
            String text = "X*BR" + SabrePassiveSegmentsUtil.getTranslation(veryFirstProduct.getReservation().getBookingFile().getNumber());
            data.getRemarks().add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text));
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT && (bookingAgentRef = originalProducts.get(0).getReservation().getBookingAgent()) != null) {
            Person bookingAgent = (Person)EntityStorage.get().resolve(bookingAgentRef).getEntity();
            String personLastName = SabrePassiveSegmentsUtil.getPersonLastName(bookingAgent);
            String personGivenName = SabrePassiveSegmentsUtil.getPersonGivenName(bookingAgent);
            data.getRemarks().add(SabrePassiveSegmentsUtil.prepareHistoricalRemark(personLastName + " " + personGivenName));
        }
        return data;
    }

    private SabrePassiveAccountingLineData createAccountingLine(String vendorCode, String ticketNumber, String segmentUid) {
        SabrePassiveAccountingLineData result = new SabrePassiveAccountingLineData();
        result.setTicketNumber(ticketNumber);
        result.setType(SabrePassiveAccountingLineType.HOTEL);
        result.setRelatedSegmentUid(segmentUid);
        String command = "ACHHT%s/" + vendorCode + "/HTL/0/0/0/C0/PER/CA/1-" + ticketNumber;
        result.setCreationCommand(command);
        return result;
    }

    private String getVendorCode(GdsName supplier) {
        String code = "UNKNWN";
        if (supplier != null) {
            switch (supplier) {
                case ACADEMSERVICE: {
                    code = "ACASER";
                    break;
                }
                case RCR: {
                    code = "RCRTVL";
                    break;
                }
                case HOTELBOOK: {
                    code = "HOTELB";
                    break;
                }
                case BRONEVIK: {
                    code = "BRONEV";
                    break;
                }
                case WEB_SITE: {
                    code = "WEBSRC";
                }
            }
        }
        return code;
    }

    private String getRetentionLineCommand(HotelProduct product) {
        StringBuilder sb = new StringBuilder("0OTHZZGK1MOW");
        Date checkInDate = ((Room)product.getRooms().get(0)).getCheckInDate();
        Date date = new Date(checkInDate.getTime() + TimeUnit.DAYS.toMillis(180L));
        SimpleDateFormat df = new SimpleDateFormat("ddMMM");
        sb.append(df.format(date));
        sb.append("-SAVER LINE");
        return sb.toString();
    }

    @Override
    public SabrePassiveSegmentsClientMode getClientMode(HotelProduct product) {
        return SabrePassiveSegmentsUtil.getClientModeByProductData(HotelProductHelper.getSubagency(product), HotelProductHelper.getAgency(product));
    }

    @Override
    public void setActualPassiveSegmentsXIDataToCurrentProduct(HotelProduct oldProd, HotelProduct prod) {
        SabrePassiveSegmentsResult res;
        if (oldProd == null || prod == null) {
            return;
        }
        HotelProduct oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            oldProduct = oldProduct.getPreviousProduct();
        }
        SabrePassiveSegmentsResult result = oldProduct.getPassiveSegmentsCreationResult();
        String pnr = null;
        Date responseDate = null;
        if (result != null && result.getPassiveSegmentsXIData() != null && !TextUtil.isBlank((String)result.getPassiveSegmentsXIData().getPnr())) {
            pnr = result.getPassiveSegmentsXIData().getPnr();
            responseDate = result.getPassiveSegmentsXIData().getResponseDate();
        }
        while (oldProduct.getNextProduct() != null) {
            res = (oldProduct = oldProduct.getNextProduct()).getPassiveSegmentsCreationResult();
            if (res == null || res.getPassiveSegmentsXIData() == null || TextUtil.isBlank((String)res.getPassiveSegmentsXIData().getPnr())) continue;
            SabrePassiveSegmentsXIData data = res.getPassiveSegmentsXIData();
            if (!TextUtil.isBlank((String)pnr) && !data.getResponseDate().after(responseDate)) continue;
            pnr = data.getPnr();
            responseDate = data.getResponseDate();
        }
        if (!TextUtil.isBlank(pnr)) {
            SabrePassiveSegmentsXIData data;
            if (prod.getPassiveSegmentsCreationResult() == null) {
                res = new SabrePassiveSegmentsResult();
                prod.setPassiveSegmentsCreationResult(res);
            }
            if (prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData() == null) {
                data = new SabrePassiveSegmentsXIData();
                prod.getPassiveSegmentsCreationResult().setPassiveSegmentsXIData(data);
            }
            if (TextUtil.isBlank((String)prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getPnr()) || responseDate.after(prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getResponseDate())) {
                data = prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData();
                data.setPnr(pnr);
                data.setResponseDate(responseDate);
            }
        }
    }

    @Override
    public boolean isRestoreFromRefundOrExchange(HotelProduct oldProd) {
        HotelProduct oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            if ((oldProduct = oldProduct.getPreviousProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        while (oldProduct.getNextProduct() != null) {
            if ((oldProduct = oldProduct.getNextProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptableForPassiveSegmentsSynchronization() {
        return true;
    }

    private Map<String, String> assignProductNumbers(List<HotelProduct> originalProducts) {
        HashMap<String, String> res = new HashMap<String, String>();
        int i = 1;
        for (HotelProduct p : originalProducts) {
            res.put(p.getUid(), String.valueOf(i));
            ++i;
        }
        return res;
    }

    private List<RoomWrapper> groupProductsBySegments(List<HotelProduct> products) {
        ArrayList<RoomWrapper> res = new ArrayList<RoomWrapper>();
        ProductHandler<HotelProduct> productHandler = HandlersRegistry.get().findProductHandler(HotelProduct.class);
        for (HotelProduct product : products) {
            Reservation reservation = product.getReservation();
            GdsName gdsName = reservation != null ? CommonReservationGdsNameInfoHelper.getRulesGdsName(reservation) : null;
            String gdsRecloc = productHandler.getPassiveSegmentRecordLocator(product);
            for (Room room : product.getRooms()) {
                RoomWrapper roomWrapper = new RoomWrapper(product, room, gdsName, gdsRecloc);
                if (!res.contains(roomWrapper)) {
                    res.add(roomWrapper);
                } else {
                    roomWrapper = (RoomWrapper)res.get(res.indexOf(roomWrapper));
                }
                roomWrapper.addProduct(product, String.valueOf(room.getNumberOfPeople()));
            }
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotXStarProductRemarks(HotelProduct product, String productNum, String productNumber, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        this.getPassengerNames(product).forEach(n -> {
            String text = "X*PH" + productNum + "*" + productNumber + "*PAX*" + n;
            res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text));
        });
        String curr = DictHelper.getEquivCurrency();
        boolean isRubCurrency = "RUB".equals(curr);
        product.getRooms().stream().findFirst().ifPresent(r -> {
            BigDecimal rate;
            StringBuilder text = new StringBuilder("X*PH" + productNum + "*");
            text.append(productNumber);
            if (r.getEquivalentRate() != null) {
                text.append("*RATE ");
                if (curr != null) {
                    text.append(curr);
                }
                rate = r.getEquivalentRate();
                if (isRubCurrency) {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                } else {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(rate, true));
                }
            }
            if (r.getEquivalentPrice() != null) {
                text.append("*TOTAL ");
                if (curr != null) {
                    text.append(curr);
                }
                BigDecimal price = r.getEquivalentPrice();
                if (isRubCurrency) {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(price, false));
                } else {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(price, true));
                }
            }
            if (r.getEquivalentRate() != null || r.getEquivalentPrice() != null) {
                res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
            }
            text = new StringBuilder("X*PH" + productNum + "*");
            text.append(productNumber);
            if (r.getEquivalentVatPrice() != null) {
                text.append("*VAT ");
                if (curr != null) {
                    text.append(curr);
                }
                rate = r.getEquivalentVatPrice();
                if (isRubCurrency) {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(rate, true));
                } else {
                    text.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                }
                res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
            }
            String currency = r.getDailyRates().stream().map(DailyRate::getRate).filter(Objects::nonNull).map(Money::getCurrency).filter(Objects::nonNull).findFirst().orElse("");
            int lineNo = 1;
            StringBuilder text2 = new StringBuilder();
            text2.append("X*PH").append(productNum).append("*").append(productNumber).append("*NIGHTS").append(lineNo).append(" ").append(currency);
            ++lineNo;
            List amounts = r.getDailyRates().stream().flatMap(dr -> Stream.iterate(dr.getRate(), UnaryOperator.identity()).limit(this.getNightsCount((DailyRate)dr))).filter(Objects::nonNull).map(Money::getValue).filter(Objects::nonNull).map(BigDecimal::toString).collect(Collectors.toList());
            for (int i = 0; i < amounts.size(); ++i) {
                boolean isLast;
                String amount = (String)amounts.get(i);
                text2.append(amount);
                boolean bl = isLast = i + 1 == amounts.size() || i != 0 && (i + 1) % 4 == 0;
                if (isLast) {
                    res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text2.toString()));
                    text2.setLength(0);
                    text2.append("X*PH").append(productNum).append("*").append(productNumber).append("*NIGHTS").append(lineNo).append(" ").append(currency);
                    ++lineNo;
                    continue;
                }
                text2.append("/");
            }
            if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
                res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark("X*CWTCLIENT"));
            }
        });
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List<CostCode> costCodes = SabrePassiveSegmentsUtil.getCostCodes(product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(SabrePassiveSegmentsUtil.getDotXStarRemarkUDIDText(cc))));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotProductRemarks(HotelProduct product, String productNum, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List<CostCode> costCodes = SabrePassiveSegmentsUtil.getCostCodes(product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotProductRemark(SabrePassiveSegmentsUtil.getDotRemarkUDIDText(cc))));
        }
        return res;
    }

    private long getNightsCount(DailyRate dr) {
        int interval = new DateInterval(dr.getStartDate(), dr.getEndDate()).getDuration(5);
        if (interval <= 0) {
            return 1L;
        }
        return interval;
    }

    private List<String> getPassengerNames(HotelProduct p) {
        return p.getTravellers().stream().map(SabrePassiveSegmentsUtil::getTravelerName).collect(Collectors.toList());
    }

    private List<SabrePassiveRemarkData> createCrossSRemarks(RoomWrapper rw, List<HotelProduct> products, Room r, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode, List<Message> messages, boolean throwException) {
        String text;
        Object d;
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        HotelProduct firstProduct = products.get(0);
        StringBuilder text2 = new StringBuilder();
        if (r.getCheckInDate() != null && r.getCheckInTime() != null) {
            d = r.getCheckInDate();
            d = MiscUtil.setMinutes((Date)d, (int)r.getCheckInTime());
            text2.append("CHECKIN-").append(SabrePassiveSegmentsUtil.formatTime((Date)d));
        }
        if (r.getCheckOutDate() != null && r.getCheckOutTime() != null) {
            if (text2.length() > 0) {
                text2.append("/");
            }
            d = r.getCheckOutDate();
            d = MiscUtil.setMinutes((Date)d, (int)r.getCheckOutTime());
            text2.append("CHECKOUT-").append(SabrePassiveSegmentsUtil.formatTime((Date)d));
        }
        if (text2.length() > 0) {
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text2.toString()));
        }
        if (firstProduct.getGuaranteeType() != null) {
            text2 = new StringBuilder("GUARANTEE-");
            if (firstProduct.getGuaranteeType() == GuaranteeType.CREDIT_CARD) {
                text2.append("CREDIT CARD");
            } else if (firstProduct.getGuaranteeType() == GuaranteeType.IATA) {
                text2.append("IATA");
            }
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text2.toString()));
        }
        if (firstProduct.isCancellable() && !HotelProductHelper.getAvailableCancellationCharges(firstProduct).isEmpty()) {
            SimpleDateFormat formatter = new SimpleDateFormat("hha ddMMMyy", Locale.ENGLISH);
            for (CancellationCharge charge : HotelProductHelper.getAvailableCancellationCharges(firstProduct)) {
                if (!TextUtil.isBlank((String)charge.getPolicyText())) {
                    text = SabrePassiveSegmentsUtil.getTranslation(charge.getPolicyText());
                    res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), "CANCELINFO-", text));
                }
                String prefix = subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT ? "CANCELLATION POLICY " : "CANCEL-";
                StringBuilder text3 = new StringBuilder();
                if (charge.getStartDate() != null) {
                    text3.append("FROM ").append(formatter.format(charge.getStartDate())).append(" ");
                }
                if (charge.getEndDate() != null) {
                    text3.append("TILL ").append(formatter.format(charge.getEndDate())).append(" ");
                }
                if (charge.getPenalty() != null && charge.getPenalty().getMoney() != null) {
                    BigDecimal rate = charge.getPenalty().getMoney().getValue();
                    String curr = charge.getPenalty().getMoney().getCurrency();
                    if (curr != null) {
                        text3.append(curr);
                    }
                    if (rate != null) {
                        if ("RUB".equals(curr)) {
                            text3.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                        } else {
                            text3.append(SabrePassiveSegmentsUtil.formatDecimal(rate, true));
                        }
                    }
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), prefix, text3.toString()));
            }
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            if (TextUtil.isBlank((String)rw.getHotelPhone())) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.sabrePassiveSegmentsHotelEmptyPhoneNumber, (Object[])new Object[]{firstProduct.getSystemNumber()}));
            } else {
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), "PHONE NUMBER ", rw.getHotelPhone()));
            }
        }
        if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
            Date d2;
            Object text4;
            String prefix;
            String providerName;
            String curr;
            BigDecimal rate;
            StringBuilder text5;
            ProductHandler<HotelProduct> productHandler = HandlersRegistry.get().findProductHandler(HotelProduct.class);
            if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT && r.getBaseRate() != null) {
                text5 = new StringBuilder();
                text5.append("URA-");
                rate = r.getBaseRate().getValue();
                curr = r.getBaseRate().getCurrency();
                if (rate != null) {
                    if ("RUB".equals(curr)) {
                        text5.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                    } else {
                        text5.append(SabrePassiveSegmentsUtil.formatDecimal(rate, true));
                    }
                }
                if (curr != null) {
                    text5.append(curr);
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text5.toString()));
            }
            if (r.getBasePrice() != null) {
                text5 = new StringBuilder("TTL-");
                if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
                    rate = this.getTotalPrice(firstProduct);
                    curr = "RUB";
                } else {
                    rate = r.getBasePrice().getValue();
                    curr = r.getBasePrice().getCurrency();
                }
                if (rate != null) {
                    if ("RUB".equals(curr)) {
                        text5.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                    } else {
                        text5.append(SabrePassiveSegmentsUtil.formatDecimal(rate, true));
                    }
                }
                if (curr != null) {
                    text5.append(curr);
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text5.toString()));
            }
            if ((providerName = productHandler.getProviderName(firstProduct)) != null) {
                prefix = subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT ? "SRC-" : "SUN-";
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), prefix, providerName));
            }
            if (!TextUtil.isBlank((String)firstProduct.getHotelChainCode())) {
                text4 = "SUC-" + SabrePassiveSegmentsUtil.getTranslation(firstProduct.getHotelChainCode());
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), (String)text4));
            }
            if (!TextUtil.isBlank((String)rw.getHotelAddress())) {
                prefix = subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT ? "HOTEL ADDRESS " : "SI-STREET ADDRESS ";
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), prefix, SabrePassiveSegmentsUtil.getTranslation(rw.getHotelAddress()), subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT));
            }
            if (r.getCheckInDate() != null && r.getCheckInTime() != null) {
                d2 = r.getCheckInDate();
                d2 = MiscUtil.setMinutes((Date)d2, (int)r.getCheckInTime());
                text = "ST-" + SabrePassiveSegmentsUtil.formatTime(d2);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text));
            }
            if (r.getCheckOutDate() != null && r.getCheckOutTime() != null) {
                d2 = r.getCheckOutDate();
                d2 = MiscUtil.setMinutes((Date)d2, (int)r.getCheckOutTime());
                text = "ET-" + SabrePassiveSegmentsUtil.formatTime(d2);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), text));
            }
            if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT && !TextUtil.isBlank((String)rw.getHotelPropertyId())) {
                text4 = "SI-GSD CODE " + rw.getHotelPropertyId();
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), (String)text4));
            }
            if (firstProduct.getGuaranteeType() != null) {
                text4 = new StringBuilder("SI-GUARANTEED ");
                if (firstProduct.getGuaranteeType() == GuaranteeType.CREDIT_CARD) {
                    ((StringBuilder)text4).append("CREDIT CARD");
                } else if (firstProduct.getGuaranteeType() == GuaranteeType.IATA) {
                    ((StringBuilder)text4).append("IATA");
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), ((StringBuilder)text4).toString()));
            }
            if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT && firstProduct.isCancellable() && !HotelProductHelper.getAvailableCancellationCharges(firstProduct).isEmpty()) {
                for (CancellationCharge charge : HotelProductHelper.getAvailableCancellationCharges(firstProduct)) {
                    String prefix2 = "SI-CANCELLATION POLICY ";
                    StringBuilder text6 = new StringBuilder();
                    if (!TextUtil.isBlank((String)charge.getPolicyText())) {
                        text6.append(SabrePassiveSegmentsUtil.getTranslation(charge.getPolicyText()));
                    }
                    if (charge.getStartDate() != null) {
                        text6.append(" FROM ").append(SabrePassiveSegmentsUtil.formatDate(charge.getStartDate()));
                    }
                    if (charge.getEndDate() != null) {
                        text6.append(" TILL ").append(SabrePassiveSegmentsUtil.formatDate(charge.getEndDate()));
                    }
                    if (charge.getPenalty() != null && charge.getPenalty().getMoney() != null) {
                        text6.append(" PENALTY ");
                        BigDecimal rate2 = charge.getPenalty().getMoney().getValue();
                        String curr2 = charge.getPenalty().getMoney().getCurrency();
                        if (rate2 != null) {
                            if ("RUB".equals(curr2)) {
                                text6.append(SabrePassiveSegmentsUtil.formatDecimal(rate2, false));
                            } else {
                                text6.append(SabrePassiveSegmentsUtil.formatDecimal(rate2, true));
                            }
                        }
                        if (curr2 != null) {
                            text6.append(curr2);
                        }
                    }
                    res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), prefix2, text6.toString()));
                }
            }
            if (subagencyMode != SabrePassiveSegmentsSubagencyMode.CWT && !TextUtil.isBlank((String)rw.getHotelPropertyId())) {
                text4 = "SI-HARP ID " + rw.getHotelPropertyId();
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(r.getUid(), (String)text4));
            }
        }
        return res;
    }

    private String getCreationCommand(RoomWrapper roomWrapper, Room r, String locator, TranslitUtil.TranslitRules rules, SabrePassiveSegmentsSubagencyMode subagencyMode, boolean throwException) {
        StringBuilder res = new StringBuilder("0HHTYYGK1/");
        if (roomWrapper.getHotelLocation() != null) {
            String hotelLocationStr;
            if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
                DictionaryReference<GeoLocation> hotelLocationRef = roomWrapper.getHotelLocation();
                GeoLocation hotelLocation = (GeoLocation)DictionaryCache.get().resolveReference(hotelLocationRef);
                if (hotelLocation == null) {
                    throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsBrokenHotelLocationRefErrorDetails, (Object[])new Object[0]);
                }
                hotelLocationStr = DictHelper.getCodeVariant((BaseDictionary)hotelLocation, CodeSystem.IATA);
                if (TextUtil.isBlank((String)hotelLocationStr)) {
                    hotelLocationStr = SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelLocation()).replace("-", " ").replace(".", "");
                }
            } else {
                hotelLocationStr = SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelLocation()).replace("-", " ").replace(".", "");
            }
            res.append(hotelLocationStr);
        }
        if (r.getCheckInDate() != null) {
            res.append("IN").append(SabrePassiveSegmentsUtil.formatDate(r.getCheckInDate()));
        }
        if (r.getCheckOutDate() != null) {
            res.append("-OUT").append(SabrePassiveSegmentsUtil.formatDate(r.getCheckOutDate()));
        }
        if (!TextUtil.isBlank((String)roomWrapper.getHotelName())) {
            res.append("/").append(SabrePassiveSegmentsUtil.replaceSlashInHotelName(SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelName())));
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.REGULAR && !TextUtil.isBlank((String)r.getRoomSize())) {
            res.append("/").append(SabrePassiveSegmentsUtil.getTranslation(r.getRoomSize()));
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            res.append("/");
            String roomType = this.getSabreRoomType(r);
            if (!TextUtil.isBlank((String)roomType)) {
                res.append(roomType);
            } else if (throwException) {
                throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsHotelRoomTypeNotFoundErrorDetails, (Object[])new Object[]{r.getRoomName()});
            }
        }
        if (r.getBaseRate() != null) {
            String curr;
            BigDecimal rate;
            res.append("/");
            if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
                int nightsCount = HotelProductHelper.calculateNights(r.getCheckInDate(), r.getCheckOutDate());
                if (nightsCount < 1) {
                    nightsCount = 1;
                }
                rate = this.getTotalPrice(roomWrapper.getProducts().get(0)).divide(BigDecimal.valueOf(nightsCount), 2, RoundingMode.HALF_UP);
                curr = "RUB";
            } else {
                rate = r.getBaseRate().getValue();
                curr = r.getBaseRate().getCurrency();
            }
            if (rate != null) {
                if ("RUB".equals(curr)) {
                    res.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                } else {
                    res.append(SabrePassiveSegmentsUtil.formatDecimal(rate, false));
                }
            }
            if (curr != null) {
                res.append(curr);
            }
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            res.append("/G");
        }
        if (!TextUtil.isBlank((String)roomWrapper.getHotelAddress()) || !TextUtil.isBlank((String)roomWrapper.getHotelPhone())) {
            res.append("/SI-\u00a4");
            if (!TextUtil.isBlank((String)roomWrapper.getHotelAddress())) {
                res.append(SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelAddress()));
            }
            if (roomWrapper.getHotelLocation() != null) {
                res.append('\u00a5');
                res.append(SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelLocation()));
            }
            if (roomWrapper.getHotelCountry() != null) {
                res.append('\u00a5');
                res.append(SabrePassiveSegmentsUtil.getTranslation(roomWrapper.getHotelCountry()));
            }
            if (!TextUtil.isBlank((String)roomWrapper.getHotelPhone())) {
                res.append('\u00a5');
                res.append("FONE ");
                res.append(roomWrapper.getHotelPhone());
            }
            res.append('\u00a4');
        }
        if (locator != null) {
            res.append("/CF-");
            res.append(SabrePassiveSegmentsUtil.getTranslation(locator).replaceAll("[^A-Za-z0-9]", ""));
        }
        return res.toString();
    }

    private static boolean roomsEqual(List<Room> list1, List<Room> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (HotelProductPassiveSegmentsHandler.roomsEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean roomsEqual(Room r1, Room r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        if (!MiscUtil.isSameDaySafe((Date)r1.getCheckInDate(), (Date)r2.getCheckInDate())) {
            return false;
        }
        if (!MiscUtil.isSameDaySafe((Date)r1.getCheckOutDate(), (Date)r2.getCheckOutDate())) {
            return false;
        }
        return TextUtil.isSame((String)r1.getRoomSize(), (String)r2.getRoomSize());
    }

    private static int getRoomHashCode(Room room, int result) {
        if (room.getRoomSize() != null) {
            result = 31 * result + room.getRoomSize().hashCode();
        }
        if (room.getCheckInDate() != null) {
            result = 31 * result + room.getCheckInDate().hashCode();
        }
        if (room.getCheckOutDate() != null) {
            result = 31 * result + room.getCheckOutDate().hashCode();
        }
        return result;
    }

    private String getSabreRoomType(Room r) {
        String roomName = r.getRoomName();
        if (TextUtil.isBlank((String)roomName)) {
            return "SGL";
        }
        Collection roomTypes = DictionaryCache.get().getAll(PassiveSegmentsHotelRoomType.class).values();
        for (PassiveSegmentsHotelRoomType roomType : roomTypes) {
            if (!roomType.getSpellVariants().contains(roomName)) continue;
            return roomType.getCode();
        }
        return null;
    }

    private boolean isBreakfastIncluded(HotelProduct product, Room room, boolean throwException) {
        String mealCaption = null;
        if (room.getMeal() != null) {
            mealCaption = room.getMeal().getCaption();
        }
        if (TextUtil.isBlank(mealCaption)) {
            return false;
        }
        Collection hotelMealCollection = DictionaryCache.get().getAll(PassiveSegmentsHotelMeal.class).values();
        for (PassiveSegmentsHotelMeal hotelMeal : hotelMealCollection) {
            if (!hotelMeal.getSpellVariants().contains(mealCaption)) continue;
            return hotelMeal.getCode().equals("mealIncluded");
        }
        if (throwException) {
            throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentsHotelMealNotFoundErrorDetails, (Object[])new Object[]{mealCaption});
        }
        return false;
    }

    private BigDecimal getTotalPrice(HotelProduct product) {
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        BigDecimal total = BigDecimal.ZERO;
        ContractRelationServiceData serviceData = clientContractRelation.getServiceData();
        if (serviceData != null && serviceData.getTotalPrice() != null) {
            total = total.add(serviceData.getTotalPrice());
        }
        if (total.equals(BigDecimal.ZERO)) {
            throw Xeption.forAdmin((String)Messages.sabrePassiveSegmentHotelProductZeroTotalPriceDetails, (Object[])new Object[]{product.getSystemNumber()});
        }
        return total;
    }

    private static class RoomWrapper {
        private final Room room;
        private final String hotelPropertyId;
        private final DictionaryReference<GeoLocation> hotelLocation;
        private final DictionaryReference<Country> hotelCountry;
        private final String hotelName;
        private final String hotelAddress;
        private final String hotelPhone;
        private final GdsName gdsName;
        private final String gdsRecloc;
        private final List<HotelProduct> products = new ArrayList<HotelProduct>();
        private final Map<String, String> product2numberOfPeople = new HashMap<String, String>();

        RoomWrapper(HotelProduct product, Room r, GdsName gdsName, String gdsRecloc) {
            this.room = r;
            this.gdsRecloc = gdsRecloc;
            this.gdsName = gdsName;
            this.hotelPropertyId = product.getHotelPropertyId();
            this.hotelLocation = product.getHotelLocation();
            this.hotelCountry = product.getHotelCountry();
            Optional<HotelsTranslationEntry> optional = product.getHotelNames().stream().filter(hte -> "en".equals(hte.getLanguage())).findFirst();
            this.hotelName = optional.isPresent() ? optional.get().getText() : product.getHotelName();
            this.hotelAddress = product.getHotelAddress();
            this.hotelPhone = product.getHotelPhone();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomWrapper)) {
                return false;
            }
            RoomWrapper r = (RoomWrapper)o;
            if (this.gdsName != r.getGdsName()) {
                return false;
            }
            if (!TextUtil.isSame((String)this.gdsRecloc, (String)r.getGdsRecloc())) {
                return false;
            }
            if (!TextUtil.isSame((String)this.hotelPropertyId, (String)r.getHotelPropertyId())) {
                return false;
            }
            if (!TextUtil.isSame((String)this.hotelName, (String)r.getHotelName())) {
                return false;
            }
            if (!TextUtil.isSame((String)this.hotelAddress, (String)r.getHotelAddress())) {
                return false;
            }
            if (!TextUtil.isSame((String)this.hotelPhone, (String)r.getHotelPhone())) {
                return false;
            }
            if (!DictHelper.equals(this.hotelLocation, r.getHotelLocation())) {
                return false;
            }
            return HotelProductPassiveSegmentsHandler.roomsEqual(this.room, r.getRoom());
        }

        public int hashCode() {
            int result = 17;
            if (this.gdsName != null) {
                result = 31 * result + this.gdsName.hashCode();
            }
            if (this.gdsRecloc != null) {
                result = 31 * result + this.gdsRecloc.hashCode();
            }
            if (this.hotelPropertyId != null) {
                result = 31 * result + this.hotelPropertyId.hashCode();
            }
            if (this.hotelName != null) {
                result = 31 * result + this.hotelName.hashCode();
            }
            if (this.hotelAddress != null) {
                result = 31 * result + this.hotelAddress.hashCode();
            }
            if (this.hotelPhone != null) {
                result = 31 * result + this.hotelPhone.hashCode();
            }
            if (this.hotelLocation != null && this.hotelLocation.getCode() != null) {
                result = 31 * result + this.hotelLocation.getCode().hashCode();
            }
            return HotelProductPassiveSegmentsHandler.getRoomHashCode(this.room, result);
        }

        public Room getRoom() {
            return this.room;
        }

        public GdsName getGdsName() {
            return this.gdsName;
        }

        public String getGdsRecloc() {
            return this.gdsRecloc;
        }

        public String getHotelPropertyId() {
            return this.hotelPropertyId;
        }

        public String getHotelAddress() {
            return this.hotelAddress;
        }

        public String getHotelPhone() {
            return this.hotelPhone;
        }

        public String getHotelName() {
            return this.hotelName;
        }

        public DictionaryReference<GeoLocation> getHotelLocation() {
            return this.hotelLocation;
        }

        public List<HotelProduct> getProducts() {
            return Collections.unmodifiableList(this.products);
        }

        public void addProduct(HotelProduct product, String numberOfPeople) {
            this.products.add(product);
            if (!TextUtil.isBlank((String)numberOfPeople)) {
                this.product2numberOfPeople.put(product.getUid(), numberOfPeople);
            }
        }

        public String getNumberOfPeople(String productUid) {
            return this.product2numberOfPeople.get(productUid);
        }

        public DictionaryReference<Country> getHotelCountry() {
            return this.hotelCountry;
        }
    }
}

