/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceAccidentHandler
implements ProductHandler<InsuranceAccident> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, InsuranceAccident product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            result.setTotalVat(totalPrice, 0.0);
            return result;
        }
        BigDecimal total = BigDecimal.ZERO;
        if (product.getEquivalentSum() != null) {
            total = total.add(product.getEquivalentSum());
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            total = total.negate();
        }
        result.setTotalVat(total, 0.0);
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(InsuranceAccident product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(InsuranceAccident product) {
        return L10nResourcesManager.getStr((String)"INSURANCE_ACCIDENT_SHORT_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getSystemNumber()), GeneralProductHelper.getNonNullString(product.getStatus())});
    }

    @Override
    public String generateProductName(InsuranceAccident product) {
        Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
        return L10nResourcesManager.getStr((String)"INSURANCE_ACCIDENT_PRODUCT_NAME", (Object[])new Object[]{GeneralProductHelper.getNonNullString(product.getStatus()), GeneralProductHelper.getNonNullString(product.getSystemNumber()), InsuranceAccidentHelper.getRouteLine(product), traveller != null ? " " + traveller.getName() : ""});
    }

    @Override
    public Date findFirstTravelDate(InsuranceAccident product) {
        return product.getDepartureDate();
    }

    @Override
    public Date findLastTravelDate(InsuranceAccident product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(InsuranceAccident product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(InsuranceAccident product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(InsuranceAccident product) {
        return TravelSubject.INSURANCE_ACCIDENT;
    }

    @Override
    public Date findIssueDate(InsuranceAccident product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(InsuranceAccident product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(InsuranceAccident product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(InsuranceAccident product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof InsuranceAccident)) continue;
            prods.add(this.createFinanceCapableProduct((InsuranceAccident)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof InsuranceAccident)) continue;
            prods.add(this.createFinanceCapableProduct((InsuranceAccident)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(InsuranceAccident product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final InsuranceAccident product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return InsuranceAccidentHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return InsuranceAccidentHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return InsuranceAccidentHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return InsuranceAccidentHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return InsuranceAccidentHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? InsuranceAccidentHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return InsuranceAccidentHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0421\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0438 ($group_info)";
                }
                return "\u0421\u0442\u0440\u0430\u0445\u043e\u0432\u043a\u0430 \u043e\u0442 \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0447\u0430\u044f ($group_info)";
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                return BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(InsuranceAccident product) {
        Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
        return traveller == null ? new ArrayList() : Collections.singletonList(traveller);
    }

    @Override
    public void replaceTraveller(InsuranceAccident product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller.getUid().equals(product.getTravellerUid())) {
            product.setTravellerUid(newTraveller.getUid());
        }
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(InsuranceAccident product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.setTravellerUid(newTraveller.getUid());
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void setOrReplaceTraveller(InsuranceAccident product, Traveller newTraveller) {
        Collection<Traveller> travellers = this.getTravellers(product);
        this.setOrReplaceTraveller(product, travellers.isEmpty() ? null : (Traveller)travellers.stream().findFirst().orElse(null), newTraveller);
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<InsuranceAccident> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(InsuranceAccident product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(InsuranceAccident product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(InsuranceAccident product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(InsuranceAccident product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(InsuranceAccident product) {
        return ProductType.INSURANCE_ACCIDENT;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.INSURANCE_ACCIDENT).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.INSURANCE_ACCIDENT_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(InsuranceAccident product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(InsuranceAccident product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(InsuranceAccident product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = product.getEquivalentSum();
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : InsuranceAccidentHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(InsuranceAccident product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(InsuranceAccident product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(InsuranceAccident product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(InsuranceAccident product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(InsuranceAccident product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(InsuranceAccident product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, InsuranceAccident product) {
        if (momentOfTime.compareTo(product.getDepartureDate()) > 0) {
            return null;
        }
        return product.getDepartureDate();
    }

    @Override
    public InsuranceAccident getPreviousProduct(InsuranceAccident product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(InsuranceAccident product, InsuranceAccident previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(InsuranceAccident product, InsuranceAccident nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public InsuranceAccident getNextProduct(InsuranceAccident product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(InsuranceAccident product, BaseProduct relatedProduct) {
        product.setRelatedProductUid(relatedProduct.getUid());
    }

    @Override
    public List<BaseProduct> getRelatedProducts(InsuranceAccident product) {
        Object relatedProduct = product.getRelatedProductUid() != null ? (Object)BookingHelper.findProductByUid(product.getRelatedProductUid(), product.getReservation().getBookingFile()) : null;
        return relatedProduct != null ? Collections.singletonList(relatedProduct) : Collections.emptyList();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(InsuranceAccident product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(InsuranceAccident product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(InsuranceAccident product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(InsuranceAccident product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(InsuranceAccident product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(InsuranceAccident product) {
        return product.getEquivalentSum();
    }

    @Override
    public BigDecimal getServiceFare(InsuranceAccident product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(InsuranceAccident product) {
        return null;
    }

    @Override
    public int getConjunction(InsuranceAccident product) {
        return 0;
    }

    @Override
    public String getRouteLine(InsuranceAccident product) {
        return InsuranceAccidentHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(InsuranceAccident product) {
        return InsuranceAccidentHelper.getLocalizedRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(InsuranceAccident product) {
        if (product == null || product.getReservation() == null || product.getReservation().getBookingFile() == null) {
            return null;
        }
        BaseProduct related = BookingHelper.findProduct(product.getReservation().getBookingFile(), product.getRelatedProductUid());
        if (related == null) {
            return null;
        }
        ProductHandler<?> relatedHandler = HandlersRegistry.get().findProductHandler(related.getClass());
        return relatedHandler == null ? null : relatedHandler.getCodeRouteLine(related);
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(InsuranceAccident product) {
        return InsuranceAccidentHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(InsuranceAccident product) {
        return InsuranceAccidentHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(InsuranceAccident product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(InsuranceAccident product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(InsuranceAccident product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(InsuranceAccident product) {
        return product.getPcc();
    }

    @Override
    public void updateProductFops(InsuranceAccident product) {
    }

    @Override
    public void setContractRulesApplied(InsuranceAccident product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(InsuranceAccident product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(InsuranceAccident product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(InsuranceAccident product) {
        return null;
    }

    @Override
    public boolean isHoldable(InsuranceAccident product) {
        return false;
    }

    @Override
    public Date getUnholdDate(InsuranceAccident product) {
        return null;
    }

    @Override
    public String getValidatorNumber(InsuranceAccident product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(InsuranceAccident product) {
        return product.getPassengerType();
    }

    @Override
    public StatisticalData getStatisticalData(InsuranceAccident product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(InsuranceAccident product) {
        return true;
    }

    @Override
    public void newStatisticalData(InsuranceAccident product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(InsuranceAccident product) {
        return null;
    }

    @Override
    public VatDetalization getVendorVatDetalization(InsuranceAccident product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentSum(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        result.setDetalized(true);
        return result;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.INSURANCE_ACCIDENT;
    }

    @Override
    public InsuranceAccident newInstance() {
        return new InsuranceAccident();
    }

    @Override
    public String getCarrierNumber(InsuranceAccident product) {
        return null;
    }

    @Override
    public void setAgent(InsuranceAccident product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(InsuranceAccident product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(InsuranceAccident product, EntityReference<Organization> agency) {
        InsuranceAccidentHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(InsuranceAccident product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(InsuranceAccident product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(InsuranceAccident product, EntityReference<Organization> supplier) {
        InsuranceAccidentHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(InsuranceAccident product, EntityReference<Organization> subagency) {
        InsuranceAccidentHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(InsuranceAccident product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(InsuranceAccident product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(InsuranceAccidentHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(InsuranceAccidentHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(InsuranceAccidentHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(InsuranceAccident product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(InsuranceAccident product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(InsuranceAccident product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return InsuranceAccidentHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return InsuranceAccidentHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return InsuranceAccidentHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(InsuranceAccident product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(InsuranceAccident product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(InsuranceAccident product) {
        return null;
    }

    @Override
    public boolean removeProduct(InsuranceAccident product) {
        return InsuranceAccidentHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(InsuranceAccident product, BaseProduct relatedProduct) {
        return InsuranceAccidentHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(InsuranceAccident product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(InsuranceAccident product, Locale locale) {
        return InsuranceAccidentHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(InsuranceAccident product, Locale locale) {
        return null;
    }

    @Override
    public Date getFirstStartDate(InsuranceAccident product) {
        return product.getDepartureDate();
    }

    @Override
    public Date getLastStartDate(InsuranceAccident product) {
        return product.getDepartureDate();
    }

    @Override
    public Date getFirstEndDate(InsuranceAccident product) {
        return null;
    }

    @Override
    public Date getLastEndDate(InsuranceAccident product) {
        return null;
    }

    @Override
    public String getDescriptionLine(InsuranceAccident product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(InsuranceAccident product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(InsuranceAccident product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(InsuranceAccident product) {
        return false;
    }

    @Override
    public String getRfic(InsuranceAccident product) {
        return null;
    }

    @Override
    public String getRfisc(InsuranceAccident product) {
        return null;
    }

    @Override
    public String getTourCode(InsuranceAccident product) {
        return null;
    }

    @Override
    public boolean isDuplicate(InsuranceAccident product) {
        return false;
    }
}

