/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BaseLegalForm;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class LegalFormHandler
extends DictionaryHandler<LegalForm> {
    @Override
    protected void registerProperties() {
        this.registerTranslations();
        this.registerProperty(new DictionaryHandler.Property<LegalForm>(){

            @Override
            public boolean match(LegalForm dictTo, LegalForm dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getAbbreviations());
                DictSyncHelper.replaceDuplicateLocales(dictTo.getAbbreviations());
                if (!dictTo.getAbbreviations().keySet().containsAll(dictFrom.getAbbreviations().keySet())) {
                    return false;
                }
                for (Map.Entry entry : dictFrom.getAbbreviations().entrySet()) {
                    if (TextUtil.isSame((String)((String)entry.getValue()), (String)((String)dictTo.getAbbreviations().get(entry.getKey())))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void merge(LegalForm dictTo, LegalForm dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getAbbreviations());
                DictSyncHelper.replaceDuplicateLocales(dictTo.getAbbreviations());
                dictTo.getAbbreviations().putAll(dictFrom.getAbbreviations());
            }

            @Override
            public void fillDiffs(LegalForm dictTo, LegalForm dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
                DictSyncHelper.replaceDuplicateLocales(dictFrom.getAbbreviations());
                DictSyncHelper.replaceDuplicateLocales(dictTo.getAbbreviations());
                Collection keys = CollectionUtil.union(dictTo.getAbbreviations().keySet(), dictFrom.getAbbreviations().keySet());
                for (Locale key : keys) {
                    String newAbbr;
                    String oldAbbr = (String)dictTo.getAbbreviations().get(key);
                    if (TextUtil.isSame((String)oldAbbr, (String)(newAbbr = (String)dictFrom.getAbbreviations().get(key)))) continue;
                    diffs.put(String.format("%s: %s", this.getLocalizedName(), key == null ? "" : key.getDisplayName(LocaleHelper.getCurrentLocale())), (MiscUtil.Pair<String, String>)new MiscUtil.Pair((Object)oldAbbr, (Object)newAbbr));
                }
            }

            @Override
            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"ABBREVIATIONS", (Object[])new Object[0]);
            }

            @Override
            public Enum getKey() {
                return BaseLegalForm.Property.abbreviations;
            }
        });
    }

    @Override
    public LegalForm search(LegalForm dict) {
        if (dict == null) {
            return null;
        }
        Collection allLegalForms = DictionaryCache.get().getAll(this.getDictionaryClass()).values();
        for (LegalForm legalForm : allLegalForms) {
            if (DictSyncHelper.compareByNames(dict, legalForm)) {
                return legalForm;
            }
            for (String abbr : legalForm.getAbbreviations().values()) {
                if (TextUtil.isBlank((String)abbr)) continue;
                for (String dictAbbr : dict.getAbbreviations().values()) {
                    if (!TextUtil.isSame((String)abbr, (String)dictAbbr, (boolean)true)) continue;
                    return legalForm;
                }
            }
        }
        return null;
    }

    @Override
    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(LegalForm dict) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Collections.emptyList();
    }

    @Override
    public Class<LegalForm> getDictionaryClass() {
        return LegalForm.class;
    }
}

