/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProductVoidingHandler
implements ProductHandler<ProductVoiding> {
    @Override
    public Class<ProductVoiding> getProductClass() {
        return ProductVoiding.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, ProductVoiding product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(ProductVoiding product, ContractType ctype) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    @Override
    public String generateShortProductName(ProductVoiding product) {
        return L10n.replace((String)L10n.get((String)Messages.ProductVoiding_ShortProductName), (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getProductNumbers(rp)), (String)",", (boolean)false)});
    }

    @Override
    public String generateProductName(ProductVoiding product) {
        return this.generateShortProductName(product);
    }

    @Override
    public Date findFirstTravelDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findFirstTravelDate(rp));
    }

    @Override
    public Date findLastTravelDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findLastTravelDate(rp));
    }

    @Override
    public List<String> getProductNumbers(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getProductNumbers(rp));
    }

    @Override
    public EntityReference<Person> findIssuingAgent(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findIssuingAgent(rp));
    }

    @Override
    public TravelSubject findTravelSubject(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findTravelSubject(rp));
    }

    @Override
    public Date findIssueDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findIssueDate(rp));
    }

    @Override
    public Date findLocalIssueDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findLocalIssueDate(rp));
    }

    @Override
    public void setIssueDate(ProductVoiding product, Date issueDate) {
    }

    @Override
    public boolean includeInFinanceDocuments(ProductVoiding product) {
        return true;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof ProductVoiding)) continue;
            prods.add(this.createFinanceCapableProduct((ProductVoiding)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof ProductVoiding)) continue;
            prods.add(this.createFinanceCapableProduct((ProductVoiding)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(ProductVoiding product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final ProductVoiding product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return ProductVoidingHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return ProductVoidingHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return ProductVoidingHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return ProductVoidingHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return ProductStatus.SELL;
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return ProductVoidingHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return ProductVoidingHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                return ProductVoidingHandler.this.generateShortProductName(product);
            }

            @Override
            public BigDecimal getPenalty() {
                return null;
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getProductNumbers(rp).stream().findFirst().orElse(null));
            }

            @Override
            public Traveller getTraveller() {
                return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getTravellers(rp).stream().findFirst().orElse(null));
            }
        };
    }

    @Override
    public Collection<Traveller> getTravellers(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getTravellers(rp));
    }

    @Override
    public void replaceTraveller(ProductVoiding product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(ProductVoiding product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<ProductVoiding> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (bp, handler) -> handler.findSalesPoint(bp));
    }

    @Override
    public ProductStatus getStatus(ProductVoiding product) {
        return ProductStatus.SELL;
    }

    @Override
    public ProductStatus getBaseStatus(ProductVoiding product) {
        return ProductStatus.SELL;
    }

    @Override
    public void setStatus(ProductVoiding product, ProductStatus productStatus) {
    }

    @Override
    public ProductType getProductType(ProductVoiding product) {
        return ProductType.PRODUCT_VOIDING;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.PRODUCT_VOIDING).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getBlankOwner(rp));
    }

    @Override
    public EntityReference<Branch> getBranch(ProductVoiding product) {
        return null;
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(ProductVoiding product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        for (GeneralProductCommission comm : ProductVoidingHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber((String)this.getProductNumbers(product).stream().findFirst().orElse(null));
            Money fareComm = new Money();
            fareComm.setValue(comm.getEquivalentAmount());
            fareComm.setCurrency(DictHelper.getEquivCurrency());
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(ProductVoiding product) {
        return false;
    }

    @Override
    public void setCompleted(ProductVoiding product, boolean completed) {
    }

    @Override
    public boolean isChecked(ProductVoiding product) {
        return Boolean.TRUE.equals(ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.isChecked(rp)));
    }

    @Override
    public void setChecked(ProductVoiding product, boolean checked) {
    }

    @Override
    public TransportationType getTransportationType(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getTransportationType(rp));
    }

    @Override
    public ServiceLocationType getServiceLocationType(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getServiceLocationType(rp));
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.findNearestTravelDate(momentOfTime, rp));
    }

    @Override
    public ProductVoiding getPreviousProduct(ProductVoiding product) {
        return null;
    }

    @Override
    public void setPreviousProduct(ProductVoiding product, ProductVoiding previousProduct) {
    }

    @Override
    public void setNextProduct(ProductVoiding product, ProductVoiding nextProduct) {
    }

    @Override
    public ProductVoiding getNextProduct(ProductVoiding product) {
        return null;
    }

    @Override
    public void addRelatedProduct(ProductVoiding product, BaseProduct relatedProduct) {
        product.setRelatedProduct(relatedProduct);
    }

    @Override
    public List<BaseProduct> getRelatedProducts(ProductVoiding product) {
        return product.getRelatedProduct() == null ? Collections.emptyList() : Collections.singletonList(product.getRelatedProduct());
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(ProductVoiding product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(ProductVoiding product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(ProductVoiding product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(ProductVoiding product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getBlankType(rp));
    }

    @Override
    public BigDecimal getEquivalentFare(ProductVoiding product) {
        return null;
    }

    @Override
    public BigDecimal getServiceFare(ProductVoiding product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(ProductVoiding product) {
        return null;
    }

    @Override
    public int getConjunction(ProductVoiding product) {
        return 0;
    }

    @Override
    public String getRouteLine(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getRouteLine(rp));
    }

    @Override
    public String getLocalizedRouteLine(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getLocalizedRouteLine(rp));
    }

    @Override
    public String getCodeRouteLine(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getCodeRouteLine(rp));
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(ProductVoiding product) {
        return product.getContractRelations().stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getSalesChain(rp));
    }

    @Override
    public void updateContractRelations(ProductVoiding product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelations(product.getContractRelations(), relations);
    }

    @Override
    public TicketType getTicketType(ProductVoiding product) {
        return TicketType.OWN;
    }

    @Override
    public void setTicketType(ProductVoiding product, TicketType ticketType) {
    }

    @Override
    public String getPCC(ProductVoiding product) {
        return null;
    }

    @Override
    public void updateProductFops(ProductVoiding product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(ProductVoiding product, boolean value) {
    }

    @Override
    public List<ValidationMessage> getValidationMessages(ProductVoiding product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getProvider(rp));
    }

    @Override
    public PassengerStatus getPassengerStatus(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getPassengerStatus(rp));
    }

    @Override
    public boolean isHoldable(ProductVoiding product) {
        return false;
    }

    @Override
    public Date getUnholdDate(ProductVoiding product) {
        return null;
    }

    @Override
    public String getValidatorNumber(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getValidatorNumber(rp));
    }

    @Override
    @Deprecated
    public DictionaryReference<PassengerType> getPassengerType(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getPassengerType(rp));
    }

    @Override
    public StatisticalData getStatisticalData(ProductVoiding product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(ProductVoiding product) {
        return false;
    }

    @Override
    public void newStatisticalData(ProductVoiding product) {
    }

    @Override
    public BigDecimal getAddCollect(ProductVoiding product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public ProductVoiding newInstance() {
        return new ProductVoiding();
    }

    @Override
    public String getCarrierNumber(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getCarrierNumber(rp));
    }

    @Override
    public void setAgent(ProductVoiding product, EntityReference<Person> agent) {
    }

    @Override
    public void setComments(ProductVoiding product, String comments) {
    }

    @Override
    public void setAgency(ProductVoiding product, EntityReference<Organization> agency) {
    }

    @Override
    public void setBlankOwner(ProductVoiding product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(ProductVoiding product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(ProductVoiding product, EntityReference<Organization> supplier) {
    }

    @Override
    public void setSubagency(ProductVoiding product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(ProductVoiding product, EntityReference<SalesPoint> salesPoint) {
    }

    @Override
    public void changeFopsPaymentTypes(ProductVoiding product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(ProductVoidingHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(ProductVoidingHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(ProductVoidingHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(ProductVoiding product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(ProductVoiding product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(ProductVoiding product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return ProductVoidingHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return ProductVoidingHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return ProductVoidingHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(ProductVoiding product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(ProductVoiding product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(ProductVoiding product) {
        return null;
    }

    @Override
    public boolean removeProduct(ProductVoiding product) {
        return ProductVoidingHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(ProductVoiding product, BaseProduct relatedProduct) {
        return ProductVoidingHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(ProductVoiding product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if (product.getRelatedProduct() == null) {
            return false;
        }
        return Boolean.TRUE.equals(ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.isAppropriateBillingItem(product.getRelatedProduct(), type, universalDocumentStatus, mode, billingItem, billingItems, prepaymentBillingItems)));
    }

    @Override
    public boolean isVatIncludeBillingItem(ProductVoiding product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        if (product.getRelatedProduct() == null) {
            return false;
        }
        return Boolean.TRUE.equals(ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.isVatIncludeBillingItem(product.getRelatedProduct(), mode, billingItem)));
    }

    @Override
    public String getCities(ProductVoiding product, Locale locale) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getCities(rp, locale));
    }

    @Override
    public String getCountries(ProductVoiding product, Locale locale) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getCountries(rp, locale));
    }

    @Override
    public String getAddresses(ProductVoiding product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getAddresses(rp, locale, translitRules));
    }

    @Override
    public Date getFirstStartDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getFirstStartDate(rp));
    }

    @Override
    public Date getLastStartDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getLastStartDate(rp));
    }

    @Override
    public Date getFirstEndDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getFirstEndDate(rp));
    }

    @Override
    public Date getLastEndDate(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getLastEndDate(rp));
    }

    @Override
    public String getDescriptionLine(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getDescriptionLine(rp));
    }

    @Override
    public DictionaryReference<Airline> getCarrier(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getCarrier(rp));
    }

    @Override
    public String getTrain(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getTrain(rp));
    }

    @Override
    public String getHotel(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getHotel(rp));
    }

    @Override
    public String getRoom(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getRoom(rp));
    }

    @Override
    public boolean isContractRulesApplied(ProductVoiding product) {
        return false;
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(ProductVoiding product) {
        return Boolean.TRUE.equals(ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.isSystemNumberDuplicateAllowed(rp)));
    }

    @Override
    public String getRfic(ProductVoiding product) {
        return null;
    }

    @Override
    public String getRfisc(ProductVoiding product) {
        return null;
    }

    @Override
    public String getTourCode(ProductVoiding product) {
        return ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.getTourCode(rp));
    }

    @Override
    public boolean isDuplicate(ProductVoiding product) {
        return Boolean.TRUE.equals(ProductVoidingHelper.getRelatedProductValue(product, (rp, handler) -> handler.isDuplicate(rp)));
    }
}

