/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.AccountingEntryIndex;
import com.gridnine.xtrip.common.model.system.AccountingEntryType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccountingEntryHelper {
    private static final Logger log = LoggerFactory.getLogger(AccountingEntryHelper.class);

    public static BigDecimal calculateAccountingEntriesAmount(EntityReference<? extends BaseProfile> contractor, EntityReference<CashRegister> cashRegister, EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, EntityReference<Person> employee, Set<AccountingEntryType> types, Date startDate, Date endDate) throws Exception {
        BigDecimal amount = null;
        ProjectionQuery debitQuery = new ProjectionQuery();
        if (contractor != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitContractor.name(), contractor));
        }
        if (cashRegister != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitCashRegister.name(), cashRegister));
        }
        if (cashRegisterWorkplace != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitCashRegisterWorkplace.name(), cashRegisterWorkplace));
        }
        if (employee != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitEmployee.name(), employee));
        }
        if (types != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (AccountingEntryType type : types) {
                if (type == null) continue;
                criterions.add(SearchCriterion.eq((String)AccountingEntryIndex.Property.type.name(), (Object)type));
            }
            if (criterions.size() > 0) {
                debitQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            }
        }
        if (startDate != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)AccountingEntryIndex.Property.startDate.name(), (Object)startDate));
        }
        if (endDate != null) {
            debitQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)AccountingEntryIndex.Property.endDate.name(), (Object)endDate));
        }
        debitQuery.getProjections().add(Projection.sum((String)AccountingEntryIndex.Property.amount.name(), (String)"amount"));
        Number debitAmount = (Number)((Map)EntityStorage.get().search(AccountingEntryIndex.class, debitQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().get(0)).get("amount");
        if (debitAmount != null) {
            amount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, BigDecimal.valueOf(debitAmount.doubleValue())});
        }
        ProjectionQuery creditQuery = new ProjectionQuery();
        if (contractor != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditContractor.name(), contractor));
        }
        if (cashRegister != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditCashRegister.name(), cashRegister));
        }
        if (cashRegisterWorkplace != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditCashRegisterWorkplace.name(), cashRegisterWorkplace));
        }
        if (employee != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditEmployee.name(), employee));
        }
        if (types != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (AccountingEntryType type : types) {
                if (type == null) continue;
                criterions.add(SearchCriterion.eq((String)AccountingEntryIndex.Property.type.name(), (Object)type));
            }
            if (criterions.size() > 0) {
                creditQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            }
        }
        if (startDate != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)AccountingEntryIndex.Property.startDate.name(), (Object)startDate));
        }
        if (endDate != null) {
            creditQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)AccountingEntryIndex.Property.endDate.name(), (Object)endDate));
        }
        creditQuery.getProjections().add(Projection.sum((String)AccountingEntryIndex.Property.amount.name(), (String)"amount"));
        Number creditAmount = (Number)((Map)EntityStorage.get().search(AccountingEntryIndex.class, creditQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().get(0)).get("amount");
        if (creditAmount != null) {
            amount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, MiscUtil.negate((BigDecimal)BigDecimal.valueOf(creditAmount.doubleValue()))});
        }
        return amount;
    }
}

