/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public final class AeroexpressTicketHelper {
    public static final String BLANK_TYPE_CODE = "AE_ETKT";

    public static String getLocalizedRouteLine(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getRouteLine(product, LocaleManager.get().getCurrentLocale(), false, CodeSystem.IATA);
    }

    public static String getRouteLine(AeroexpressTicket product) {
        return AeroexpressTicketHelper.getRouteLine(product, null, true, CodeSystem.IATA);
    }

    public static String getRouteLine(AeroexpressTicket product, Locale loc) {
        return AeroexpressTicketHelper.getRouteLine(product, loc, false, CodeSystem.IATA);
    }

    public static String getRouteLine(AeroexpressTicket product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        DictionaryCache cache = DictionaryCache.get();
        return String.format("%s - %s", DictHelper.getCityName((GeoLocation)cache.resolveReference(product.getDepartureLocation()), loc, product.getDepartureLocation() != null ? product.getDepartureLocation().getCode() : null, false, CodeSystem.IATA), DictHelper.getCityName((GeoLocation)cache.resolveReference(product.getArrivalLocation()), loc, product.getArrivalLocation() != null ? product.getArrivalLocation().getCode() : null, false, CodeSystem.IATA));
    }

    public static DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }

    public static void fillTicketType(AeroexpressTicket product) {
        if (product.getBlankType() == null) {
            product.setBlankType(AeroexpressTicketHelper.findBlankType(BLANK_TYPE_CODE));
        }
    }

    public static void removeProduct(AeroexpressTicket product, boolean removeEmptyReservations) {
        for (Reservation res : new ArrayList(product.getReservation().getBookingFile().getReservations())) {
            if (res.getProducts().contains(product)) {
                res.getProducts().remove(product);
            }
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof AeroexpressTicket)) continue;
                AeroexpressTicket prod = (AeroexpressTicket)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            product.getReservation().getBookingFile().getReservations().remove(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AeroexpressTicket createRefund(AeroexpressTicket model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
            modelStatisticalData.getTravellerCostCodes().stream().map(TravellerCostCodes::getTraveller).filter(Objects::nonNull).forEach(traveller -> excludedUids.add(traveller.getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        Traveller trav = model.getTraveller();
        model.setTraveller(null);
        Product rel = model.getRelatedProduct();
        model.setRelatedProduct(null);
        try {
            AeroexpressTicket refund = (AeroexpressTicket)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            Date operationDate = new Date();
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setTraveller(trav);
            refund.setPreviousProduct(model);
            refund.setRelatedProduct(rel);
            model.setNextProduct(refund);
            refund.setCancellationDetails(null);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(operationDate);
            refund.setCompleted(false);
            refund.setChecked(false);
            refund.getShipments().clear();
            refund.getPrepaymentDocuments().clear();
            refund.getFopDetalizations().clear();
            AeroexpressTicketHelper.fillTicketType(refund);
            Optional<EntityReference> newAgentProfileReference = Optional.ofNullable(ProfileHelper.getCurrentUserCtr()).map(c -> c.toReference());
            ContractType[] contractTypes = new ContractType[]{ContractType.CLIENT, ContractType.SUBAGENCY, ContractType.VENDOR};
            Arrays.stream(contractTypes).flatMap(ct -> GeneralProductHelper.getFops((BaseProduct)refund, ct).stream()).forEach(fop -> {
                fop.setOperationDate(operationDate);
                newAgentProfileReference.ifPresent(agentProfile -> fop.setAgent(agentProfile));
            });
            newAgentProfileReference.ifPresent(agentProfile -> refund.setAgent(agentProfile));
            AeroexpressTicket aeroexpressTicket = refund;
            return aeroexpressTicket;
        }
        finally {
            model.setReservation(res);
            model.setTraveller(trav);
            model.setRelatedProduct(rel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AeroexpressTicket createExchange(AeroexpressTicket model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        Traveller trav = model.getTraveller();
        model.setTraveller(null);
        Product rel = model.getRelatedProduct();
        model.setRelatedProduct(null);
        try {
            AeroexpressTicket exchange = (AeroexpressTicket)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            exchange.setReservation(res);
            res.getProducts().add(exchange);
            exchange.setTraveller(trav);
            exchange.setRelatedProduct(rel);
            exchange.setCancellationDetails(null);
            exchange.setContractRulesApplied(false);
            exchange.setStatus(ProductStatus.EXCHANGE);
            exchange.setIssueDate(new Date());
            AeroexpressTicket sell2 = (AeroexpressTicket)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            sell2.setReservation(res);
            res.getProducts().add(sell2);
            sell2.setTraveller(trav);
            sell2.setRelatedProduct(rel);
            model.setNextProduct(exchange);
            exchange.setPreviousProduct(model);
            sell2.setPreviousProduct(exchange);
            exchange.setNextProduct(sell2);
            sell2.setCancellationDetails(null);
            sell2.setContractRulesApplied(false);
            sell2.setStatus(ProductStatus.SELL);
            sell2.setIssueDate(new Date());
            sell2.setSystemNumber(null);
            sell2.setScn(null);
            exchange.setCompleted(false);
            sell2.setCompleted(false);
            sell2.getShipments().clear();
            sell2.getPrepaymentDocuments().clear();
            sell2.getFopDetalizations().clear();
            AeroexpressTicketHelper.fillTicketType(sell2);
            AeroexpressTicketHelper.fillTicketType(exchange);
            AeroexpressTicket aeroexpressTicket = sell2;
            return aeroexpressTicket;
        }
        finally {
            model.setReservation(res);
            model.setTraveller(trav);
            model.setRelatedProduct(rel);
        }
    }

    public static BigDecimal getEquivalentFeeAmount(AeroexpressTicket prod) {
        BigDecimal fe = BigDecimal.ZERO;
        for (GeneralProductCommission c : AeroexpressTicketHelper.getUnmodifiableCommissions(prod, null)) {
            BigDecimal value;
            if (c.getCommissionProperties() == null || !FeeProperties.class.getName().equals(c.getCommissionProperties().getType().getName()) || (value = c.getEquivalentAmount()) == null) continue;
            fe = fe.add(value);
        }
        return fe;
    }

    public static SalesChain getSalesChain(AeroexpressTicket product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(AeroexpressTicket product) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)product);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(AeroexpressTicket prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(AeroexpressTicket prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static GeneralProductContractRelationData getClientContractRelation(AeroexpressTicket prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductFop> getVendorFops(AeroexpressTicket prod) {
        return AeroexpressTicketHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(AeroexpressTicket prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = AeroexpressTicketHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(AeroexpressTicket prod) {
        return AeroexpressTicketHelper.getClientContractRelation(prod).getFops();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(AeroexpressTicket source, AeroexpressTicket target, boolean saveTraveller) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        Traveller sourceTrav = source.getTraveller();
        source.setTraveller(null);
        Product sourceRelatedProduct = source.getRelatedProduct();
        source.setRelatedProduct(null);
        AeroexpressTicket sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        AeroexpressTicket sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        Traveller targetTrav = saveTraveller ? target.getTraveller() : sourceTrav;
        target.setTraveller(null);
        Product targetRelatedProduct = target.getRelatedProduct();
        target.setRelatedProduct(null);
        AeroexpressTicket targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        AeroexpressTicket targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setTraveller(sourceTrav);
            source.setRelatedProduct(sourceRelatedProduct);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setTraveller(targetTrav);
            target.setRelatedProduct(targetRelatedProduct);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            AeroexpressTicketHelper.fillTicketType(target);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(AeroexpressTicket product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static BigDecimal calculateCommissionsEquivalentValue(Collection<GeneralProductCommission> commissions) {
        BigDecimal value = null;
        for (GeneralProductCommission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(commission.getEquivalentAmount()) : commission.getEquivalentAmount();
        }
        return value;
    }

    public static EntityReference<Organization> getSupplier(AeroexpressTicket prod) {
        return GeneralProductHelper.getContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(AeroexpressTicket prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(AeroexpressTicket prod) {
        return GeneralProductHelper.getContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(AeroexpressTicket prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(AeroexpressTicket prod) {
        return GeneralProductHelper.getContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(AeroexpressTicket prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(AeroexpressTicketHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static void updateProductFops(AeroexpressTicket product) {
        AeroexpressTicketHelper.updateProductFops(product, AeroexpressTicketHelper.getVendorContractRelation(product));
        AeroexpressTicketHelper.updateProductFops(product, AeroexpressTicketHelper.getSubagentContractRelation(product, false));
        AeroexpressTicketHelper.updateProductFops(product, AeroexpressTicketHelper.getClientContractRelation(product));
    }

    public static void updateProductFops(AeroexpressTicket product, GeneralProductContractRelationData contractRel) {
        if (contractRel == null) {
            return;
        }
        if (AeroexpressTicketHelper.hasProductFop(contractRel) || !GeneralProductHelper.getHandler(product).isFareFopsRelevant(product)) {
            return;
        }
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRel.getDescription());
        GeneralProductFop fop = new GeneralProductFop();
        fop.setAgent(product.getAgent());
        fop.setEquivalentAmount(BookingHelper.calculateProductPrice((BaseProduct)product, contractType).getTotal());
        fop.setOperationDate(product.getIssueDate());
        fop.setType(PaymentType.INVOICE);
        contractRel.getFops().add(fop);
    }

    public static void createProductFops(AeroexpressTicket product, boolean setEquivalentAmount) {
        AeroexpressTicketHelper.createProductFops(product, AeroexpressTicketHelper.getVendorContractRelation(product), setEquivalentAmount);
        AeroexpressTicketHelper.createProductFops(product, AeroexpressTicketHelper.getSubagentContractRelation(product, false), setEquivalentAmount);
        AeroexpressTicketHelper.createProductFops(product, AeroexpressTicketHelper.getClientContractRelation(product), setEquivalentAmount);
    }

    public static void createProductFops(AeroexpressTicket product, GeneralProductContractRelationData contractRel, boolean setEquivalentAmount) {
        if (contractRel == null) {
            return;
        }
        if (AeroexpressTicketHelper.hasProductFop(contractRel) || !GeneralProductHelper.getHandler(product).isFareFopsRelevant(product)) {
            return;
        }
        GeneralProductFop fop = new GeneralProductFop();
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRel.getDescription());
        if (setEquivalentAmount) {
            fop.setEquivalentAmount(BookingHelper.calculateProductPrice((BaseProduct)product, contractType).getTotal());
        }
        fop.setType(PaymentType.CASH);
        fop.setOperationDate(new Date());
        if (contractType == ContractType.CLIENT) {
            fop.setAgent(product.getAgent());
        }
        contractRel.getFops().add(fop);
    }

    private static boolean hasProductFop(GeneralProductContractRelationData contractRel) {
        for (GeneralProductFop fop : contractRel.getFops()) {
            if (!GeneralProductHelper.isServiceFop(fop)) continue;
            return true;
        }
        return false;
    }

    public static boolean removeProduct(AeroexpressTicket product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(AeroexpressTicket product, BaseProduct relatedProduct) {
        if (MiscUtil.equals((Object)product.getRelatedProduct(), (Object)relatedProduct)) {
            product.setRelatedProduct(null);
        }
        return true;
    }

    public static String getCities(AeroexpressTicket product, Locale locale) {
        StringBuilder locations = new StringBuilder();
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getDepartureLocation())).map(item -> item.toString(locale)).orElse("?"));
        locations.append(" - ");
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getArrivalLocation())).map(item -> item.toString(locale)).orElse("?"));
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static String getCountries(AeroexpressTicket product, Locale locale) {
        StringBuilder countries = new StringBuilder();
        countries.append(Optional.ofNullable(DictHelper.getCountry((DictionaryReference<GeoLocation>)product.getDepartureLocation())).map(item -> item.toString(locale)).orElse("?"));
        countries.append(" - ");
        countries.append(Optional.ofNullable(DictHelper.getCountry((DictionaryReference<GeoLocation>)product.getArrivalLocation())).map(item -> item.toString(locale)).orElse("?"));
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static boolean isAeroexpressProduct(BaseProduct product) {
        return product instanceof AeroexpressTicket;
    }

    public static EntityContainer<Organization> findAeroexpressContainer() {
        String uid = DictHelper.getPreferenceValue(PreferenceKey.AEROEXPRESS_PROFILE_UID, null);
        if (uid == null) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().load(Organization.class, uid);
        return ctr;
    }

    public static DictionaryReference<BlankType> findAeroexpressBlankType() {
        EntityContainer<Organization> ctr = AeroexpressTicketHelper.findAeroexpressContainer();
        if (ctr == null) {
            return null;
        }
        BlankType blankType = BookingHelper.getBlankType("fakenumber", (EntityReference<Organization>)ctr.toReference(), null, true);
        return blankType == null ? null : blankType.toReference();
    }
}

