/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AirProductTaxHelper {
    private static final Map<DictionaryReference<Airline>, TaxInfo> taxesInfo = new HashMap<DictionaryReference<Airline>, TaxInfo>();
    private static final Logger log = LoggerFactory.getLogger(AirProductTaxHelper.class);

    public static String[] getTaxesForBlankCodes(DictionaryReference<Airline> blankOwner) {
        TaxInfo res;
        return ((res = AirProductTaxHelper.taxesInfo.get(blankOwner)) == null ? AirProductTaxHelper.taxesInfo.get(null) : res).taxesForBlank;
    }

    public static String[] getFuelTaxesCodes(DictionaryReference<Airline> validatingCarrier) {
        TaxInfo res;
        return ((res = AirProductTaxHelper.taxesInfo.get(validatingCarrier)) == null ? AirProductTaxHelper.taxesInfo.get(null) : res).fuelTaxesCodes;
    }

    public static String[] getTaxesForGDSCodes(DictionaryReference<Airline> blankOwner) {
        TaxInfo res;
        return ((res = AirProductTaxHelper.taxesInfo.get(blankOwner)) == null ? AirProductTaxHelper.taxesInfo.get(null) : res).taxesForGDS;
    }

    public static String[] getPenaltyTaxesCodes(DictionaryReference<Airline> blankOwner) {
        TaxInfo res;
        return ((res = AirProductTaxHelper.taxesInfo.get(blankOwner)) == null ? AirProductTaxHelper.taxesInfo.get(null) : res).penaltyTaxes;
    }

    public static Collection<Tax> getTaxesByCodes(Collection<Tax> taxes, boolean include, String ... taxCodes) {
        if (taxes == null) {
            return Collections.emptyList();
        }
        if (taxCodes == null || taxCodes.length == 0) {
            return include ? Collections.emptyList() : taxes;
        }
        ArrayList<Tax> result = new ArrayList<Tax>();
        HashSet<String> codes = new HashSet<String>();
        for (String taxCode : taxCodes) {
            if (taxCode == null) continue;
            codes.add(taxCode.toUpperCase());
        }
        for (Tax tax : taxes) {
            String taxCode = tax.getCode();
            if (TextUtil.isBlank((String)taxCode)) {
                taxCode = "FAKE_TAX_CODE";
            }
            if (codes.contains(taxCode.toUpperCase())) {
                if (!include) continue;
                result.add(tax);
                continue;
            }
            if (include) continue;
            result.add(tax);
        }
        return result;
    }

    public static Collection<Tax> getTaxesByCodes(Product product, String ... codes) {
        return AirProductTaxHelper.getTaxesByCodes(product.getTaxes(), true, codes);
    }

    public static Collection<Tax> getTaxesByCodes(Product product, boolean include, String ... codes) {
        return AirProductTaxHelper.getTaxesByCodes(product.getTaxes(), include, codes);
    }

    public static BigDecimal getEquivalentTaxesAmountByCodes(Collection<Tax> taxes, boolean include, String ... taxCodes) {
        BigDecimal tx = BigDecimal.ZERO;
        for (Tax tax : AirProductTaxHelper.getTaxesByCodes(taxes, include, taxCodes)) {
            BigDecimal value = tax.getEquivalentAmount();
            if (value == null) continue;
            tx = tx.add(value);
        }
        return tx;
    }

    public static BigDecimal getAddCollectTaxesAmountByCodes(Collection<Tax> taxes, boolean include, String ... taxCodes) {
        BigDecimal tx = BigDecimal.ZERO;
        for (Tax tax : AirProductTaxHelper.getTaxesByCodes(taxes, include, taxCodes)) {
            BigDecimal value = tax.getAddCollect();
            if (value == null) continue;
            tx = tx.add(value);
        }
        return tx;
    }

    public static List<SimpleTax> getSimpleTaxes(Product prod) {
        return prod.getTaxes().stream().map(AirProductTaxHelper::toSimpleTax).collect(Collectors.toList());
    }

    public static SimpleTax toSimpleTax(Tax tax) {
        SimpleTax simpleTax = new SimpleTax();
        simpleTax.setCode(tax.getCode());
        simpleTax.setAmount(tax.getEquivalentAmount());
        simpleTax.setSource(tax.getUid());
        return simpleTax;
    }

    public static Tax toProductTax(SimpleTax simpleTax) {
        Tax result = new Tax();
        result.setCode(simpleTax.getCode());
        result.setEquivalentAmount(simpleTax.getAmount());
        return result;
    }

    public static BigDecimal getEquivalentTaxesAmount(Collection<Tax> taxes, String ... codes) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(taxes, true, codes);
    }

    public static BigDecimal getEquivalentTaxesAmount(Collection<Tax> taxes) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(taxes, false, new String[0]);
    }

    public static BigDecimal getEquivalentTaxesAmountByCodes(Product prod, String ... codes) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(prod.getTaxes(), true, codes);
    }

    public static BigDecimal getEquivalentTaxesAmount(Product prod) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(prod.getTaxes(), false, new String[0]);
    }

    public static BigDecimal getTaxesForBlankEquivalentAmount(Product product) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(product, AirProductTaxHelper.getTaxesForBlankCodes(AirProductTaxHelper.getBlankOwner(product)));
    }

    public static BigDecimal getTaxesForGDSEquivalentAmount(Product product) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(product, AirProductTaxHelper.getTaxesForGDSCodes(AirProductTaxHelper.getBlankOwner(product)));
    }

    public static BigDecimal getFuelTaxesEquivalentAmount(Product product) {
        return AirProductTaxHelper.getEquivalentTaxesAmountByCodes(product, AirProductTaxHelper.getFuelTaxesCodes((DictionaryReference<Airline>)product.getCarrier()));
    }

    private static DictionaryReference<Airline> getBlankOwner(Product product) {
        try {
            EntityContainer ctr = EntityStorage.get().resolve(product.getBlankOwnerRef());
            return ctr == null ? null : ((Organization)ctr.getEntity()).getAirline();
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + product.getBlankOwnerRef(), (Throwable)e);
            return null;
        }
    }

    private AirProductTaxHelper() {
    }

    static {
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("SU"), new TaxInfo(new String[]{"RU", "\u0420\u0423"}, new String[]{"YQ", "Q"}, new String[]{"YR"}, new String[0]));
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("S7"), new TaxInfo(new String[]{"RU", "\u0420\u0423"}, new String[]{"YR", "YQ"}, new String[]{"KS"}, new String[0]));
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("UN"), new TaxInfo(new String[]{"RU"}, new String[]{"YQ"}, new String[]{"YR"}, new String[0]));
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("\u04281"), new TaxInfo(new String[]{"ZZ"}, new String[0], new String[0], new String[0]));
        taxesInfo.put(null, new TaxInfo(new String[]{"RU", "\u0420\u0423", "ZZ"}, new String[0], new String[0], new String[0]));
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("U6"), new TaxInfo(new String[0], new String[]{"YQ"}, new String[0], new String[0]));
        taxesInfo.put((DictionaryReference<Airline>)new AirlineReference("5N"), new TaxInfo(new String[0], new String[]{"YQ"}, new String[0], new String[]{"E1", "R1", "P1"}));
    }

    static class TaxInfo {
        final String[] fuelTaxesCodes;
        final String[] taxesForBlank;
        final String[] taxesForGDS;
        final String[] penaltyTaxes;

        TaxInfo(String[] blankTax, String[] fuelTax, String[] gdsTax, String[] penaltyTax) {
            this.fuelTaxesCodes = fuelTax;
            this.taxesForBlank = blankTax;
            this.taxesForGDS = gdsTax;
            this.penaltyTaxes = penaltyTax;
        }
    }
}

