/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingDocumentReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookingHelper {
    public static final String TCH_VIRTUAL_TICKET_PREFFIX = "TCH_VIRTUAL:";
    public static final String JOIN_BOOKING_FILE_TASK_DATA_SOURCE = "fx-join-booking-file-task";
    public static final String TRAVELLER_TO_TRAVELLERS_TASK_DATA_SOURCE = "traveller-to-travellers-task";
    public static final String SHIPMENTS_PRODUCTS_EXCLUDE_TASK_DATA_SOURCE = "shipments:products-exclude";
    public static final String SHIPMENTS_PRODUCTS_DELETE_TASK_DATA_SOURCE = "shipments:delete";
    private static final Logger log = LoggerFactory.getLogger(BookingHelper.class);
    private static final String[][] RU_EN = new String[][]{{"\u0410", "A"}, {"\u0411", "B"}, {"\u0412", "V"}, {"\u0413", "G"}, {"\u0414", "D"}, {"\u0415", "E"}, {"\u0401", "YO"}, {"\u0416", "ZH"}, {"\u0417", "Z"}, {"\u0418", "I"}, {"\u0419", "Y"}, {"\u041a", "K"}, {"\u041b", "L"}, {"\u041c", "M"}, {"\u041d", "N"}, {"\u041e", "O"}, {"\u041f", "P"}, {"\u0420", "R"}, {"\u0421", "S"}, {"\u0422", "T"}, {"\u0423", "U"}, {"\u0424", "F"}, {"\u0425", "KH"}, {"\u0426", "TS"}, {"\u0427", "CH"}, {"\u0428", "SH"}, {"\u0429", "SH"}, {"\u042b", "Y"}, {"\u042d", "E"}, {"\u042e", "YU"}, {"\u042f", "YA"}, {"\u042a", ""}, {"\u042c", ""}};
    private static final String[][] EN_RU = new String[][]{{"ZH", "\u0416"}, {"KH", "\u0425"}, {"TS", "\u0426"}, {"CH", "\u0427"}, {"SH", "\u0428"}, {"SH", "\u0429"}, {"YU", "\u042e"}, {"YA", "\u042f"}, {"YO", "\u0401"}, {"EE", "\u0418"}, {"CK", "\u041a"}, {"TH", "\u0422"}, {"\u041e\u041e", "\u0423"}, {"A", "\u0410"}, {"B", "\u0411"}, {"C", "\u041a"}, {"D", "\u0414"}, {"E", "\u0415"}, {"F", "\u0424"}, {"G", "\u0413"}, {"H", "\u0425"}, {"I", "\u0418"}, {"J", "\u0414\u0416"}, {"K", "\u041a"}, {"L", "\u041b"}, {"M", "\u041c"}, {"N", "\u041d"}, {"O", "\u041e"}, {"P", "\u041f"}, {"Q", "\u041a"}, {"R", "\u0420"}, {"S", "\u0421"}, {"T", "\u0422"}, {"U", "\u0423"}, {"V", "\u0412"}, {"W", "\u0412"}, {"Y", "\u0419"}, {"X", "\u041a\u0421"}, {"Y", "\u042b"}, {"Z", "\u0417"}};
    private static BookingDocumentUrlBuilder BOOKING_DOCUMENT_URL_BUILDER;

    public static OperationBatch getOperationBatch(BaseProduct product) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null) {
            ProductStatus status = productHandler.getBaseStatus(product);
            if (status == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                return OperationBatch.VOID;
            }
            if (status == ProductStatus.SELL) {
                ProductStatus previousProductStatus;
                ProductHandler<?> previousProductHandler;
                BaseProduct previousProduct = productHandler.getPreviousProduct(product);
                if (previousProduct != null && (previousProductHandler = HandlersRegistry.get().findProductHandler(previousProduct.getClass())) != null && (previousProductStatus = previousProductHandler.getStatus(previousProduct)) == ProductStatus.EXCHANGE) {
                    return OperationBatch.EXCHANGE;
                }
                List<BaseProduct> relatedProducts = productHandler.getRelatedProducts(product);
                for (BaseProduct relatedProduct : relatedProducts) {
                    ProductHandler<?> relatedProductHandler = HandlersRegistry.get().findProductHandler(relatedProduct.getClass());
                    if (relatedProductHandler == null) continue;
                    ProductStatus relatedProductStatus = relatedProductHandler.getStatus(relatedProduct);
                    if (relatedProductStatus == ProductStatus.REFUND) {
                        return OperationBatch.REFUND;
                    }
                    if (relatedProductStatus != ProductStatus.EXCHANGE) continue;
                    return OperationBatch.EXCHANGE;
                }
                return OperationBatch.SELL;
            }
            if (status == ProductStatus.REFUND) {
                return OperationBatch.REFUND;
            }
            if (status == ProductStatus.EXCHANGE) {
                return OperationBatch.EXCHANGE;
            }
        }
        return null;
    }

    public static String getSortingTicketNumber(BaseProduct product) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null) {
            ProductStatus status = productHandler.getStatus(product);
            if (status == ProductStatus.BOOKING || ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                return BookingHelper.getSystemNumber(product);
            }
            if (status == ProductStatus.SELL) {
                ProductStatus previousProductStatus;
                BaseProduct previousProduct;
                ProductCategory productCategory = productHandler.getProductCategory(product);
                if (productCategory == ProductCategory.AIR && (previousProduct = productHandler.getPreviousProduct(product)) != null && (previousProductStatus = productHandler.getStatus(previousProduct)) == ProductStatus.EXCHANGE) {
                    return BookingHelper.getSystemNumber(product) + "4";
                }
                if (productCategory == ProductCategory.MCO) {
                    TicketType ticketType;
                    BaseProduct relatedProduct;
                    List<BaseProduct> relatedProducts = productHandler.getRelatedProducts(product);
                    BaseProduct baseProduct = relatedProduct = relatedProducts.size() > 0 ? relatedProducts.get(0) : null;
                    if (relatedProduct != null && (ticketType = productHandler.getTicketType(relatedProduct)) != TicketType.FAKE) {
                        return BookingHelper.getSystemNumber(relatedProduct) + "1";
                    }
                }
                return BookingHelper.getSystemNumber(product);
            }
            if (status == ProductStatus.REFUND) {
                return BookingHelper.getSystemNumber(product) + "3";
            }
            if (status == ProductStatus.EXCHANGE) {
                ProductStatus nextProductStatus;
                BaseProduct nextProduct = productHandler.getNextProduct(product);
                if (nextProduct != null && (nextProductStatus = productHandler.getStatus(nextProduct)) == ProductStatus.SELL) {
                    return BookingHelper.getSystemNumber(nextProduct) + "3";
                }
                return BookingHelper.getSystemNumber(product);
            }
        }
        return null;
    }

    public static String getSystemNumber(BaseProduct product) {
        List<String> systemNumbers;
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null && (systemNumbers = productHandler.getProductNumbers(product)).size() > 0) {
            return systemNumbers.get(0);
        }
        return null;
    }

    public static ProductType getProductType(BaseProduct product) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null) {
            return productHandler.getProductType(product);
        }
        return null;
    }

    public static ProductStatus getProductStatus(BaseProduct product) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null) {
            return productHandler.getStatus(product);
        }
        return null;
    }

    public static Date getProductIssueDate(BaseProduct product) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (productHandler != null) {
            return productHandler.findIssueDate(product);
        }
        return null;
    }

    public static BaseProduct getPreviousProduct(BaseProduct product, ProductStatus status) {
        if (product == null) {
            return null;
        }
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            BaseProduct previousProduct = handler.getPreviousProduct(product);
            while (previousProduct != null) {
                ProductHandler<?> previousProductHandler = HandlersRegistry.get().findProductHandler(previousProduct.getClass());
                if (previousProductHandler != null) {
                    ProductStatus previousProductStatus = previousProductHandler.getStatus(previousProduct);
                    if (previousProductStatus == status) {
                        return previousProduct;
                    }
                    previousProduct = previousProductHandler.getPreviousProduct(previousProduct);
                    continue;
                }
                previousProduct = null;
            }
        }
        return null;
    }

    public static List<BaseProduct> getConnectedProducts(BaseProduct product) {
        ArrayList<BaseProduct> connectedProducts = new ArrayList<BaseProduct>();
        BookingFile bookingFile = product.getReservation().getBookingFile();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                ProductHandler<?> productHandler;
                if (baseProduct.equals((Object)product) || (productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass())) == null) continue;
                for (BaseProduct relatedProduct : productHandler.getRelatedProducts(baseProduct)) {
                    if (!relatedProduct.equals((Object)product)) continue;
                    connectedProducts.add(baseProduct);
                }
            }
        }
        return connectedProducts;
    }

    public static ProductVoiding getProductVoiding(BaseProduct product) {
        return product.getReservation().getProducts().stream().filter(item -> item instanceof ProductVoiding && MiscUtil.equals((Object)((ProductVoiding)item).getRelatedProduct(), (Object)product)).map(item -> (ProductVoiding)item).findFirst().orElse(null);
    }

    public static Collection<BaseProduct> filterProducts(List<BaseProduct> products, Set<ProductType> productTypes) {
        ArrayList<BaseProduct> filteredPtoducts = new ArrayList<BaseProduct>();
        for (BaseProduct product : products) {
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (!productTypes.contains(handler.getProductType(product))) continue;
            filteredPtoducts.add(product);
        }
        return filteredPtoducts;
    }

    public static VatAmount calculateProductPrice(BaseProduct product, ContractType ctype) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler == null) {
            log.error("no product handler is registered for product class " + product.getClass().getName());
            return result;
        }
        return handler.calculateProductPrice(product, ctype);
    }

    public static BigDecimal calculateAgentPenaltyForProduct(BaseProduct product) {
        BigDecimal penalty = null;
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            Collection<GeneralProductFop> fops = GeneralProductHelper.filterFops(GeneralProductHelper.getUnmodifiableFops(product, ContractType.CLIENT), GeneralProductHelper.productFopTypes, null, null);
            BigDecimal fopsAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{GeneralProductHelper.calculateFopsEquivalentValue(fops), MiscUtil.negate((BigDecimal)GeneralProductHelper.calculateFopsHiddenFeesEquivalentValue(fops))});
            if (ProductStatusHelper.get().negatesPrice(handler.getStatus(product))) {
                fopsAmount = MiscUtil.negate((BigDecimal)fopsAmount);
            }
            if (handler.isFareFopsRelevant(product)) {
                VatAmount price = handler.calculateProductPrice(product, ContractType.CLIENT);
                if (price != null) {
                    penalty = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fopsAmount, MiscUtil.negate((BigDecimal)price.getTotal())});
                }
            } else {
                penalty = fopsAmount;
            }
        }
        return penalty;
    }

    public static BigDecimal calculateAgentPenaltyForFees(BaseProduct product) {
        BigDecimal agentPenaltyForFees = null;
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            BigDecimal clientFeeFopsAmount = GeneralProductHelper.calculateFopsEquivalentValue(GeneralProductHelper.filterFops(GeneralProductHelper.getUnmodifiableFops(product, ContractType.CLIENT), GeneralProductHelper.feeFopTypes, null, GeneralProductHelper.feePropertyTypes));
            agentPenaltyForFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{agentPenaltyForFees, clientFeeFopsAmount});
            BigDecimal clientFeesAmount = GeneralProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(GeneralProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories));
            agentPenaltyForFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{agentPenaltyForFees, MiscUtil.negate((BigDecimal)clientFeesAmount)});
        }
        return agentPenaltyForFees;
    }

    public static Traveller findTraveller(BookingFile bookingFile, String travellerUid) {
        if (bookingFile == null || TextUtil.isBlank((String)travellerUid)) {
            return null;
        }
        return bookingFile.getTravellers().stream().filter(Objects::nonNull).filter(traveller -> TextUtil.equals((String)travellerUid, (String)traveller.getUid(), (boolean)false)).findFirst().orElse(null);
    }

    public static String generateShortProductName(BaseProduct baseProduct) {
        return BookingHelper.generateProductName(baseProduct, true);
    }

    public static String generateProductName(BaseProduct baseProduct) {
        return BookingHelper.generateProductName(baseProduct, false);
    }

    private static String generateProductName(BaseProduct baseProduct, boolean shortName) {
        if (baseProduct == null) {
            return null;
        }
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        if (handler == null) {
            log.error("no product handler is registered for product class " + baseProduct.getClass().getName());
            return "?";
        }
        return shortName ? handler.generateShortProductName(baseProduct) : handler.generateProductName(baseProduct);
    }

    public static BaseProduct findProduct(EntityContainer<BookingFile> bookingFile, String productUid) {
        if (EntityStorageHelper.isEmpty(bookingFile) || TextUtil.isBlank((String)productUid)) {
            return null;
        }
        return BookingHelper.findProduct((BookingFile)bookingFile.getEntity(), productUid);
    }

    public static <T extends BaseProduct> T findProduct(BookingFile bookingFile, String productUid, Class<T> productType) {
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(productUid);
        Objects.requireNonNull(productType);
        return (T)((BaseProduct)productType.cast(BookingHelper.findProduct(bookingFile, productUid)));
    }

    public static BaseProduct findProduct(BookingFile bookingFile, String productUid) {
        if (bookingFile == null || TextUtil.isBlank((String)productUid)) {
            return null;
        }
        return bookingFile.getReservations().stream().filter(Objects::nonNull).map(r -> BookingHelper.findProduct(r, productUid)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static BaseProduct findProduct(Reservation reservation, String productUid) {
        if (reservation == null || TextUtil.isBlank((String)productUid)) {
            return null;
        }
        return reservation.getProducts().stream().filter(Objects::nonNull).filter(bp -> TextUtil.equals((String)productUid, (String)bp.getUid(), (boolean)false)).findFirst().orElse(null);
    }

    public static BaseProduct findProduct(BookingFile bookingFile, ProductType productType, ProductStatus productStatus, String systemNumber) {
        if (bookingFile != null) {
            for (Reservation reservation : bookingFile.getReservations()) {
                BaseProduct product = BookingHelper.findProduct(reservation, productType, productStatus, systemNumber);
                if (product == null) continue;
                return product;
            }
        }
        return null;
    }

    public static BaseProduct findProduct(Reservation reservation, ProductType productType, ProductStatus productStatus, String systemNumber) {
        if (reservation != null) {
            for (BaseProduct product : reservation.getProducts()) {
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
                if (handler == null || !MiscUtil.equals((Object)productType, (Object)handler.getProductType(product)) || !MiscUtil.equals((Object)productStatus, (Object)handler.getStatus(product)) || !handler.getProductNumbers(product).contains(systemNumber)) continue;
                return product;
            }
        }
        return null;
    }

    public static Reservation findReservation(BookingFile bookingFile, Predicate<? super Reservation> predicate) {
        if (bookingFile == null || predicate == null) {
            return null;
        }
        return bookingFile.getReservations().stream().filter(Objects::nonNull).filter(predicate).findFirst().orElse(null);
    }

    public static Reservation findReservationByUid(BookingFile bookingFile, String uid) {
        if (TextUtil.isBlank((String)uid)) {
            return null;
        }
        return BookingHelper.findReservation(bookingFile, (? super Reservation reservation) -> TextUtil.equals((String)uid, (String)reservation.getUid(), (boolean)false));
    }

    public static Reservation findReservation(BookingFile bookingFile, String pnr) {
        if (TextUtil.isBlank((String)pnr)) {
            return null;
        }
        return BookingHelper.findReservation(bookingFile, (? super Reservation reservation) -> CommonReservationGdsNameInfoHelper.containsRecordLocator(reservation, pnr.trim()));
    }

    public static boolean hasReservation(BookingFile bookingFile, String pnr) {
        return BookingHelper.findReservation(bookingFile, pnr) != null;
    }

    public static Product findAirProductByTraveller(BookingFile booking, String travellerName) {
        for (Reservation reservation : booking.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                Product product;
                if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getProductCategory() != ProductCategory.AIR || product.getTraveller() == null || product.getTraveller().getName() == null || !product.getTraveller().getName().equals(travellerName)) continue;
                return product;
            }
        }
        return null;
    }

    public static Product findAirProductByTravellerUid(Reservation reservation, String travellerUid) {
        return BookingHelper.findAirProductByTravellerUid(reservation, travellerUid, ProductCategory.AIR);
    }

    public static Product findAirProductByTravellerUid(Reservation reservation, String travellerUid, ProductCategory productCategory) {
        if (TextUtil.isBlank((String)travellerUid)) {
            return null;
        }
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            if (productCategory != null && product.getProductCategory() != productCategory || product.getTraveller() == null || !travellerUid.equals(product.getTraveller().getUid())) continue;
            return product;
        }
        return null;
    }

    public static List<Product> findAirProductsByTraveller(BookingFile booking, String travellerName) {
        ArrayList<Product> res = new ArrayList<Product>();
        for (Reservation reservation : booking.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                Product product;
                if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getProductCategory() != ProductCategory.AIR || product.getTraveller() == null || product.getTraveller().getName() == null || !product.getTraveller().getName().equals(travellerName)) continue;
                res.add(product);
            }
        }
        return res;
    }

    public static List<Product> findAirProductByNumber(String number) {
        ArrayList<Product> res = new ArrayList<Product>();
        if (TextUtil.isBlank((String)number)) {
            return res;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ProductIndex.Property.ticketNumbers.name(), (Object)number));
        List indices = EntityStorage.get().search(ProductIndex.class, query).getData();
        for (ProductIndex pi : indices) {
            EntityContainer bfCont = EntityStorage.get().resolve(pi.getSource());
            if (bfCont == null || bfCont.getEntity() == null) continue;
            Product prod = BookingHelper.findAirProductByNumber((BookingFile)bfCont.getEntity(), number);
            res.add(prod);
        }
        return res;
    }

    public static Product findAirProductByNumber(BookingFile booking, String number) {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        for (Reservation reservation : booking.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                Product product;
                if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getProductCategory() != ProductCategory.AIR || product.getSystemNumber() == null || !product.getSystemNumber().equals(number)) continue;
                return product;
            }
        }
        return null;
    }

    public static List<Product> findAirProductsByNumber(BookingFile booking, String number) {
        ArrayList<Product> res = new ArrayList<Product>();
        if (TextUtil.isBlank((String)number)) {
            return res;
        }
        for (Reservation reservation : booking.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                Product product;
                if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getProductCategory() != ProductCategory.AIR || product.getSystemNumber() == null || !product.getSystemNumber().equals(number)) continue;
                res.add(product);
            }
        }
        return res;
    }

    public static EntityReference<Organization> getAgency(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<Organization> agency;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null || (agency = GeneralProductHelper.getAgency(baseProduct)) == null) continue;
                return agency;
            }
        }
        return null;
    }

    public static EntityReference<Organization> getSubagency(BookingFile bookingFile) {
        if (bookingFile == null) {
            return null;
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<Organization> subagency;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null || (subagency = GeneralProductHelper.getSubagency(baseProduct)) == null) continue;
                return subagency;
            }
        }
        return null;
    }

    public static EntityReference<Organization> getSupplier(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<Organization> supplier;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null || (supplier = GeneralProductHelper.getSupplier(baseProduct)) == null) continue;
                return supplier;
            }
        }
        return null;
    }

    public static EntityReference<Branch> getBranch(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<Branch> branch;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null || (branch = handler.getBranch(baseProduct)) == null) continue;
                return branch;
            }
        }
        return null;
    }

    public static EntityReference<SalesPoint> getSalesPoint(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<SalesPoint> salesPoint;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null || (salesPoint = handler.findSalesPoint(baseProduct)) == null) continue;
                return salesPoint;
            }
        }
        return null;
    }

    public static BigDecimal calculateFee(BaseProduct product, ContractType contractType) {
        if (product == null) {
            return BigDecimal.ZERO;
        }
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler == null) {
            log.error("no product handler is registered for product class " + product.getClass().getName());
            return BigDecimal.ZERO;
        }
        return GeneralProductHelper.calculateFee(product, contractType);
    }

    public static BigDecimal calculateFee(BaseProduct product, ContractType contractType, Class<? extends BaseCommissionProperties> cls) {
        if (product == null) {
            return BigDecimal.ZERO;
        }
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler == null) {
            log.error("no product handler is registered for product class " + product.getClass().getName());
            return BigDecimal.ZERO;
        }
        return GeneralProductHelper.calculateCommissions(product, contractType, Collections.singleton(cls));
    }

    public static boolean isBSPCommission(EntityReference<? extends BaseCommissionProperties> prop) {
        return BookingHelper.getCommissionProperties(prop).map(CommissionProperties::isBspCommission).orElse(false);
    }

    public static boolean isSubagencyCommission(EntityReference<? extends BaseCommissionProperties> prop) {
        return BookingHelper.getCommissionProperties(prop).map(CommissionProperties::isSubagencyCommission).orElse(false);
    }

    private static Optional<CommissionProperties> getCommissionProperties(EntityReference<? extends BaseCommissionProperties> prop) {
        if (prop == null || prop.getType() == null || !CommissionProperties.class.getName().equals(prop.getType().getName())) {
            return Optional.empty();
        }
        EntityContainer ctr = EntityStorage.get().resolve(prop);
        if (ctr == null) {
            return Optional.empty();
        }
        return Optional.of(ctr.getEntity());
    }

    public static BigDecimal getTotalCommission(BookingFile bf, ContractType contractType) {
        BigDecimal result = BigDecimal.ZERO;
        for (Reservation res : bf.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                result = result.add(BookingHelper.calculateFee(bp, contractType, CommissionProperties.class));
            }
        }
        return result;
    }

    public static BigDecimal getTotalFee(BookingFile bf, ContractType contractType) {
        BigDecimal result = BigDecimal.ZERO;
        for (Reservation reservation : bf.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                result = result.add(BookingHelper.calculateFee(product, contractType));
            }
        }
        return result;
    }

    public static BigDecimal getTotalPrice(BookingFile bf, ContractType contractType) {
        return BookingHelper.getTotalPrice(bf, contractType, null, null);
    }

    public static BigDecimal getTotalPrice(Collection<Reservation> reservations, ContractType contractType) {
        return BookingHelper.getTotalPrice(reservations, contractType, null, null);
    }

    public static BigDecimal getTotalPrice(Reservation reservation, ContractType contractType) {
        return BookingHelper.getTotalPrice(reservation, contractType, null, null);
    }

    public static BigDecimal getTotalPrice(BaseProduct baseProduct, ContractType contractType) {
        return BookingHelper.getTotalPrice(baseProduct, contractType, null, null);
    }

    public static BigDecimal calculateEquivalentFare(BaseProduct baseProduct, boolean includeTaxes) {
        BigDecimal result = BigDecimal.ZERO;
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        if (handler == null) {
            log.error("no product handler is registered for product class " + baseProduct.getClass().getName());
            return result;
        }
        result = MiscUtil.guarded((BigDecimal)handler.getEquivalentFare(baseProduct));
        if (includeTaxes) {
            result = result.add(GeneralProductHelper.getEquivalentTaxAmount(handler.getTaxes(baseProduct)));
        }
        return result;
    }

    public static BigDecimal calculateEquivalentFare(BookingFile bf, boolean includeTaxes) {
        BigDecimal result = BigDecimal.ZERO;
        for (Reservation reservation : bf.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                result = result.add(BookingHelper.calculateEquivalentFare(product, includeTaxes));
            }
        }
        return result;
    }

    public static BigDecimal getTotalPrice(BaseProduct baseProduct, ContractType contractType, boolean initialPriceForVoidProduct) {
        ProductHandler<BaseProduct> handler;
        if (initialPriceForVoidProduct && (handler = ProductHandler.of(baseProduct)).getStatus(baseProduct) == ProductStatus.VOID) {
            handler.setStatus(baseProduct, ProductStatus.SELL);
            BigDecimal initialPrice = BookingHelper.getTotalPrice(baseProduct, contractType);
            handler.setStatus(baseProduct, ProductStatus.VOID);
            return initialPrice;
        }
        return BookingHelper.getTotalPrice(baseProduct, contractType);
    }

    public static BigDecimal getTotalPrice(BookingFile bf, ContractType contractType, PaymentType paymentType, ProductTotalPrice productTotalPrice) {
        return BookingHelper.getTotalPrice(bf.getReservations(), contractType, paymentType, productTotalPrice);
    }

    public static BigDecimal getTotalPrice(Collection<Reservation> reservations, ContractType contractType, PaymentType paymentType, ProductTotalPrice productTotalPrice) {
        BigDecimal price = BigDecimal.ZERO;
        for (Reservation reservation : reservations) {
            price = price.add(BookingHelper.getTotalPrice(reservation, contractType, paymentType, productTotalPrice));
        }
        return price;
    }

    public static BigDecimal getTotalPrice(Reservation reservation, ContractType contractType, PaymentType paymentType, ProductTotalPrice productTotalPrice) {
        BigDecimal price = BigDecimal.ZERO;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            price = price.add(BookingHelper.getTotalPrice(baseProduct, contractType, paymentType, productTotalPrice));
        }
        return price;
    }

    public static BigDecimal getTotalPrice(BaseProduct baseProduct, ContractType contractType, PaymentType paymentType, ProductTotalPrice productTotalPrice) {
        BigDecimal price = BookingHelper.calculateProductPrice(baseProduct, contractType).getTotal().add(BookingHelper.calculateFee(baseProduct, contractType));
        if (productTotalPrice != null) {
            productTotalPrice.handle(baseProduct, contractType, paymentType);
        }
        return price;
    }

    public static boolean isCreatedByClient(Reservation reservation) {
        return reservation != null && BookingHelper.isCreatedByClient((EntityReference<Person>)reservation.getBookingAgent());
    }

    public static boolean isCreatedByClient(EntityReference<Person> bookingAgentRef) {
        EntityReference employmentRef;
        EntityContainer bookingAgent = EntityStorage.get().resolve(bookingAgentRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)bookingAgent)) {
            return false;
        }
        List employments = ((Person)bookingAgent.getEntity()).getEmployments().stream().filter(Objects::nonNull).filter(employment -> employment.getOrganization() != null).collect(Collectors.toList());
        if (employments.size() == 1) {
            employmentRef = ((PersonEmployment)employments.get(0)).getOrganization();
        } else {
            List mainEmployments = employments.stream().filter(PersonEmployment::isMainEmployment).map(PersonEmployment::getOrganization).filter(Objects::nonNull).collect(Collectors.toList());
            if (mainEmployments.size() != 1) {
                return false;
            }
            employmentRef = (EntityReference)mainEmployments.get(0);
        }
        EntityContainer employment2 = EntityStorage.get().resolve(employmentRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)employment2)) {
            return false;
        }
        return ((Organization)employment2.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT);
    }

    public static List<EntityReference<Organization>> getEmployersOfBookingAgent(Reservation reservation) {
        return reservation != null ? BookingHelper.getEmployersOfBookingAgent((EntityReference<Person>)reservation.getBookingAgent()) : Collections.emptyList();
    }

    public static List<EntityReference<Organization>> getEmployersOfBookingAgent(EntityReference<Person> bookingAgentRef) {
        EntityContainer bookingAgent = EntityStorage.get().resolve(bookingAgentRef);
        if (EntityStorageHelper.isEmpty((EntityContainer)bookingAgent)) {
            return Collections.emptyList();
        }
        return ((Person)bookingAgent.getEntity()).getEmployments().stream().filter(Objects::nonNull).map(PersonEmployment::getOrganization).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isFeeForRefund(EntityReference<? extends BaseCommissionProperties> commissionType) {
        return BookingHelper.getFeePropertiesOperation(commissionType) == Operation.REFUND;
    }

    public static Operation getFeePropertiesOperation(EntityReference<? extends BaseCommissionProperties> commPropRef) {
        if (commPropRef == null) {
            return null;
        }
        if (FeeProperties.class.isAssignableFrom(commPropRef.getType())) {
            EntityContainer commPropCtr = EntityStorage.get().resolve(commPropRef);
            if (commPropCtr == null) {
                return null;
            }
            FeeProperties commProp = (FeeProperties)commPropCtr.getEntity();
            return commProp.getOperation();
        }
        if (PaymentFeeProperties.class.isAssignableFrom(commPropRef.getType())) {
            EntityContainer commPropCtr = EntityStorage.get().resolve(commPropRef);
            if (commPropCtr == null) {
                return null;
            }
            PaymentFeeProperties commProp = (PaymentFeeProperties)commPropCtr.getEntity();
            return commProp.isChargeOnRefund() ? Operation.REFUND : Operation.SELL;
        }
        return null;
    }

    public static BigDecimal getCommissionValue(BigDecimal value, boolean refund) {
        if (value == null) {
            return null;
        }
        return refund ? value.negate() : value;
    }

    public static CurrencyRate findCurrencyRate(String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner) {
        return BookingHelper.findCurrencyRate(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB"), currencyCode, issueDate, rateType, tariffType, blankOwner, null);
    }

    public static CurrencyRate findCurrencyRate(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return null;
        }
        if (tariffType == TariffType.GROUP) {
            tariffType = TariffType.REGULAR;
        }
        return DictHelper.findCurrencyRate(currencyCode, baseCurrencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
    }

    public static CurrencyRate findCurrencyRateWithIndirectChecking(String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        return BookingHelper.findCurrencyRateWithIndirectChecking(currencyCode, DictHelper.getEquivCurrency(), issueDate, rateType, tariffType, blankOwner, supplier);
    }

    public static CurrencyRate findCurrencyRateWithIndirectChecking(String currencyCode, String baseCurrencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        CurrencyRate currencyRate2;
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        if (null == currencyRate && null != (currencyRate2 = BookingHelper.findCurrencyRate(currencyCode, baseCurrencyCode, issueDate, rateType, tariffType, blankOwner, supplier)) && currencyRate2.getRate() != 0.0) {
            currencyRate = new CurrencyRate();
            currencyRate.setCurrency(currencyRate2.getBaseCurrency());
            currencyRate.setBaseCurrency(currencyRate2.getCurrency());
            currencyRate.setDate(currencyRate2.getDate());
            currencyRate.setRate(1.0 / currencyRate2.getRate());
            currencyRate.setType(currencyRate2.getType());
            currencyRate.setVendor(currencyRate2.getVendor());
            currencyRate.setBlankOwner(currencyRate2.getBlankOwner());
            currencyRate.setTariffType(currencyRate2.getTariffType());
            return currencyRate;
        }
        String eqCur = baseCurrencyCode;
        if (currencyRate == null && eqCur != null) {
            CurrencyRate currencyRate2Eur = DictHelper.findExactCurrencyRate(currencyCode, "EUR", issueDate, rateType, tariffType, supplier);
            CurrencyRate currencyRateEur2Local = DictHelper.findExactCurrencyRate("EUR", eqCur, issueDate, rateType, tariffType, supplier);
            if (currencyRate2Eur != null && currencyRateEur2Local != null) {
                currencyRate = new CurrencyRate();
                currencyRate.setRate(currencyRate2Eur.getRate() * currencyRateEur2Local.getRate());
            }
        }
        return currencyRate;
    }

    public static BlankType getBlankType(String productNumber, EntityReference<Organization> blankOwner, ProductCategory category, boolean eTicket) {
        List<BlankType> blankTypes = BookingHelper.getBlankTypesByVendor(blankOwner);
        for (BlankType type : blankTypes) {
            if (category != null && category != type.getProductCategory() || !(eTicket ? type.getBlankCategory() == BlankCategory.ETICKET : !TextUtil.isBlank((String)type.getName()) && productNumber != null && productNumber.length() > 3 && productNumber.startsWith(type.getName()))) continue;
            return type;
        }
        return null;
    }

    public static BlankType getBlankType(EntityReference<Organization> blankOwner, Product product) {
        List<BlankType> blankTypes = BookingHelper.getBlankTypesByVendor(blankOwner);
        ProductCategory category = product.getProductCategory();
        if (category == null) {
            return null;
        }
        for (BlankType type : blankTypes) {
            if (category != type.getProductCategory() || !product.isEticket() || type.getBlankCategory() != BlankCategory.ETICKET) continue;
            return type;
        }
        return null;
    }

    public static BlankType getBlankTypeMco(EntityReference<Organization> blankOwner, Product product) {
        List<BlankType> blankTypes = BookingHelper.getBlankTypesByVendor(blankOwner);
        ProductCategory category = product.getProductCategory();
        if (category == null) {
            return null;
        }
        BlankType result = null;
        for (BlankType type : blankTypes) {
            if (category != type.getProductCategory()) continue;
            if (type.getBlankCategory() == BlankCategory.ETICKET) {
                return type;
            }
            result = type;
        }
        return result;
    }

    public static List<BlankType> getBlankTypesByVendor(EntityReference<Organization> blankOwner) {
        if (blankOwner == null) {
            return Collections.emptyList();
        }
        ArrayList<BlankType> result = new ArrayList<BlankType>();
        for (Map.Entry entry : DictionaryCache.get().getAll(BlankType.class).entrySet()) {
            BlankType bt = (BlankType)entry.getValue();
            if (bt == null || !blankOwner.equals((Object)bt.getBlankOwner())) continue;
            result.add(bt);
        }
        return result;
    }

    public static List<BlankType> getBlankTypesByProductCategory(ProductCategory productCategory) {
        ArrayList<BlankType> result = new ArrayList<BlankType>();
        for (Map.Entry entry : DictionaryCache.get().getAll(BlankType.class).entrySet()) {
            BlankType bt = (BlankType)entry.getValue();
            if (bt == null || productCategory != null && !productCategory.equals((Object)bt.getProductCategory())) continue;
            result.add(bt);
        }
        return result;
    }

    public static boolean isEticket(DictionaryReference<BlankType> bt) {
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(bt);
        return blankType != null && blankType.getBlankCategory() == BlankCategory.ETICKET;
    }

    public static Commission getTotalBspCommission(Product product) {
        if (!AirProductHelper.isBSPTicket(product)) {
            return null;
        }
        return BookingHelper.getTotalVendorCommission(product, true);
    }

    public static Commission getTotalVendorCommission(Product product) {
        EntityContainer supplierCtr = EntityStorage.get().resolve(product.getBlankOwnerRef());
        if (supplierCtr == null) {
            return null;
        }
        boolean bsp = "BSP".equals(((Organization)supplierCtr.getEntity()).getCode());
        return BookingHelper.getTotalVendorCommission(product, bsp);
    }

    private static Commission getTotalVendorCommission(Product product, boolean bsp) {
        ArrayList<Commission> commissions = new ArrayList<Commission>();
        for (Commission comm : AirProductHelper.getUnmodifiableCommissions(product, ContractType.VENDOR)) {
            if (comm.getCommissionProperties() != null && !CommissionProperties.class.getName().equals(comm.getCommissionProperties().getType().getName())) continue;
            commissions.add(comm);
        }
        EntityContainer supplierCtr = EntityStorage.get().resolve(AirProductHelper.getSupplier(product));
        boolean supplierIsBsp = supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode());
        return BookingHelper.getTotalVendorCommission(commissions, bsp, supplierIsBsp);
    }

    public static Commission getTotalVendorCommission(List<? extends BaseCommission> commissions, boolean bsp, boolean supplierIsBsp) {
        ArrayList<? extends BaseCommission> copy = new ArrayList<BaseCommission>(commissions);
        if (bsp) {
            copy.removeIf(comm -> !BookingHelper.isBSPCommission((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties()));
        } else {
            copy.removeIf(comm -> BookingHelper.isSubagencyCommission((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties()));
        }
        if (copy.isEmpty() && bsp && supplierIsBsp) {
            copy = new ArrayList<BaseCommission>(commissions);
            copy.removeIf(comm -> BookingHelper.isSubagencyCommission((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties()));
        }
        if (copy.isEmpty()) {
            return null;
        }
        BaseCommission commission = (BaseCommission)copy.get(0);
        Commission result = new Commission();
        result.setAmount(commission.getAmount());
        result.setEquivalentAmount(commission.getEquivalentAmount());
        result.setRate(commission.getRate());
        return result;
    }

    public static List<Product> findProductsByScn(String scn, BookingFile booking) {
        ArrayList<Product> result = new ArrayList<Product>();
        if (booking == null || TextUtil.isBlank((String)scn)) {
            return result;
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || !(prod = (Product)bp).getScns().contains(scn)) continue;
                result.add(prod);
            }
        }
        return result;
    }

    public static List<Product> findProductsBySystemNumber(String systemNumber, BookingFile booking) {
        ArrayList<Product> result = new ArrayList<Product>();
        if (booking == null || TextUtil.isBlank((String)systemNumber)) {
            return result;
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || !systemNumber.equals((prod = (Product)bp).getSystemNumber())) continue;
                result.add(prod);
            }
        }
        return result;
    }

    public static List<Product> findProductsByFullSystemNumber(String systemNumber, BookingFile booking) {
        ArrayList<Product> result = new ArrayList<Product>();
        if (booking == null || TextUtil.isBlank((String)systemNumber)) {
            return result;
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                Product prod;
                if (!(bp instanceof Product) || !systemNumber.equals((prod = (Product)bp).getCarrierNumber() + prod.getSystemNumber())) continue;
                result.add(prod);
            }
        }
        return result;
    }

    public static List<BaseProduct> findBaseProductsBySystemNumber(String systemNumber, BookingFile booking) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (booking == null || TextUtil.isBlank((String)systemNumber)) {
            return result;
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                ProductHandler<BaseProduct> productHandler = ProductHandler.of(bp);
                if (!productHandler.getProductNumbers(bp).contains(systemNumber)) continue;
                result.add(bp);
            }
        }
        return result;
    }

    public static <T extends BaseProduct> T findProductByUid(String uid, BookingFile booking) {
        if (booking == null || TextUtil.isBlank((String)uid)) {
            return null;
        }
        for (Reservation res : booking.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!prod.getUid().equals(uid)) continue;
                return (T)prod;
            }
        }
        return null;
    }

    public static <P extends BaseProduct> P findProductByUid(String uid, BookingFile booking, Class<P> type) {
        if (TextUtil.isBlank((String)uid) || booking == null || type == null) {
            return null;
        }
        for (Reservation reservation : booking.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!baseProduct.getUid().equals(uid) || !type.isInstance(baseProduct)) continue;
                return (P)((BaseProduct)type.cast(baseProduct));
            }
        }
        return null;
    }

    public static BookingFile getBookingFile(BaseProduct product) {
        Reservation reservation = product != null ? product.getReservation() : null;
        return reservation != null ? reservation.getBookingFile() : null;
    }

    public static List<BaseProduct> getProducts(BookingFile booking) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        for (Reservation reservation : booking.getReservations()) {
            result.addAll(reservation.getProducts());
        }
        return result;
    }

    public static List<BaseProduct> getExchangeProducts(BookingFile bookingFile) {
        return BookingHelper.getExchangeProducts(BookingStreamHelper.getBaseProductsStream(bookingFile));
    }

    public static List<BaseProduct> getExchangeProducts(Reservation reservation) {
        return BookingHelper.getExchangeProducts(BookingStreamHelper.getBaseProductsStream(reservation));
    }

    private static List<BaseProduct> getExchangeProducts(Stream<BaseProduct> productsStream) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        productsStream.forEach(bp -> {
            BaseProduct previousProduct;
            ProductHandler<BaseProduct> ph = GeneralProductHelper.getHandler(bp);
            if (ph.getNextProduct((BaseProduct)bp) == null && ph.getStatus((BaseProduct)bp) == ProductStatus.SELL && (previousProduct = ph.getPreviousProduct((BaseProduct)bp)) != null && ph.getStatus(previousProduct) == ProductStatus.EXCHANGE) {
                result.add(previousProduct);
                result.add((BaseProduct)bp);
            }
        });
        return result;
    }

    public static Product findRelatedProductForMCO(MCOCategory mcoCategory, List<Product> relatedProducts) {
        if (relatedProducts == null || relatedProducts.size() == 0) {
            return null;
        }
        ProductStatus productStatus = null;
        MCOCategory categoryForGroup = null;
        if (MCOCategory.PENALTY.equals((Object)mcoCategory) || MCOCategory.RETURN_TICKET.equals((Object)mcoCategory)) {
            productStatus = ProductStatus.REFUND;
        } else if (MCOCategory.GROUP_PENALTY.equals((Object)mcoCategory)) {
            categoryForGroup = MCOCategory.GROUP_PREPAYMENT;
        } else if (!MCOCategory.GROUP_PREPAYMENT.equals((Object)mcoCategory)) {
            productStatus = ProductStatus.SELL;
        }
        if (productStatus == null && categoryForGroup == null) {
            return null;
        }
        for (Product p : relatedProducts) {
            if ((categoryForGroup == null || !categoryForGroup.equals((Object)p.getMcoCategory())) && (productStatus == null || !productStatus.equals((Object)p.getStatus()))) continue;
            return p;
        }
        return relatedProducts.get(0);
    }

    static String translit(String text, boolean toEng) {
        if (TextUtil.isBlank((String)text)) {
            return text;
        }
        String result = text.trim().toUpperCase();
        for (String[] element : toEng ? RU_EN : EN_RU) {
            result = result.replace(element[0], element[1]);
        }
        return result;
    }

    public static <E extends BaseEntity> E findEntityByUid(Collection<E> entities, String uid, Class<E> type) {
        for (BaseEntity entity : entities) {
            if (!entity.getUid().equals(uid) || !type.isInstance(entity)) continue;
            return (E)((BaseEntity)type.cast(entity));
        }
        return null;
    }

    public static <E extends BaseEntity> E findEntityByUid(Collection<E> entities, String uid) {
        for (BaseEntity entity : entities) {
            if (!entity.getUid().equals(uid)) continue;
            return (E)entity;
        }
        return null;
    }

    public static Reservation getBaseProductReservation(BookingFile bookingFile) {
        return BookingHelper.getBaseProductReservation(bookingFile, false);
    }

    public static Reservation getBaseProductReservation(BookingFile bookingFile, boolean firstIfNotFound) {
        for (Reservation reservation : bookingFile.getReservations()) {
            BaseProduct bp;
            if (reservation.getProducts().isEmpty() || !((bp = (BaseProduct)reservation.getProducts().get(0)) instanceof BaseTicketProduct)) continue;
            return reservation;
        }
        return firstIfNotFound ? (Reservation)bookingFile.getReservations().get(0) : null;
    }

    public static EntityReference<Organization> loadCompany(String companyUid) {
        EntityReference company = null;
        if (!TextUtil.isBlank((String)companyUid) && !companyUid.equals("-")) {
            company = new EntityReference(companyUid, Organization.class, null);
            EntityStorage.get().actualize(company, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        }
        return company;
    }

    public static void addReservation(BookingFile bf, Reservation res) {
        bf.getReservations().add(res);
        res.setBookingFile(bf);
    }

    public static void addProduct(Reservation res, BaseProduct prod) {
        res.getProducts().add(prod);
        prod.setReservation(res);
    }

    public static void addFutureProduct(Reservation res, BaseProduct futureProd) {
        res.getFutureProducts().add(futureProd);
        futureProd.setReservation(res);
    }

    @SafeVarargs
    public static List<Reservation> getReservationsForProduct(BookingFile bf, Class<? extends BaseProduct> ... productClass) {
        ArrayList<Reservation> result = new ArrayList<Reservation>();
        for (Reservation res : bf.getReservations()) {
            if (!BookingHelper.isReservationForProducts(res, productClass)) continue;
            result.add(res);
        }
        return result;
    }

    @SafeVarargs
    public static boolean isReservationForProducts(Reservation res, Class<? extends BaseProduct> ... productClasses) {
        if (res.getProducts().isEmpty()) {
            return false;
        }
        BaseProduct bp = (BaseProduct)res.getProducts().get(0);
        for (Class<? extends BaseProduct> productClass : productClasses) {
            if (!productClass.isInstance(bp)) continue;
            return true;
        }
        return false;
    }

    public static Reservation getFirstReservationForProduct(BookingFile bf, Class<? extends BaseProduct> productClass) {
        List<Reservation> reservations = BookingHelper.getReservationsForProduct(bf, productClass);
        return reservations.isEmpty() ? null : reservations.get(0);
    }

    public static <P extends BaseProduct> P getFirstProduct(BookingFile bf, Class<P> productClass) {
        return (P)((BaseProduct)bf.getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(productClass::isInstance).map(productClass::cast).findFirst().orElse(null));
    }

    public static <P extends BaseProduct> P getFirstProduct(Reservation reservation, Class<P> productClass, ProductStatus status) {
        for (BaseProduct bp : reservation.getProducts()) {
            if (productClass != null && !productClass.isInstance(bp) || status != null && BookingHelper.getProductStatus(bp) != status) continue;
            return (P)bp;
        }
        return null;
    }

    public static EntityReference<BookingFile> toReference(BookingFile bookingFile) {
        EntityReference bfRef = new EntityReference();
        bfRef.setType(BookingFile.class);
        bfRef.setUid(bookingFile.getUid());
        bfRef.setCaption(bookingFile.toString());
        return bfRef;
    }

    public static Stream<BaseProduct> getBaseProductsStream(BookingFile bookingFile) {
        return BookingStreamHelper.getBaseProductsStream(bookingFile);
    }

    public static Stream<TravelSubject> getTravelSubjects(BookingFile bookingFile) {
        return BookingStreamHelper.getTravelSubjects(bookingFile);
    }

    public static TravelSubject getTravelSubject(Reservation reservation) {
        if (reservation.getProducts().isEmpty()) {
            return null;
        }
        BaseProduct firstProduct = (BaseProduct)reservation.getProducts().get(0);
        return GeneralProductHelper.getHandler(firstProduct).findTravelSubject(firstProduct);
    }

    public static <E extends BaseProduct> List<E> getProductsList(BookingFile bookingFile, Class<E> clazz) {
        return BookingHelper.getProductsStream(bookingFile, clazz).collect(Collectors.toList());
    }

    public static <E extends BaseProduct> Stream<E> getProductsStream(BookingFile bookingFile, Class<E> clazz) {
        return BookingStreamHelper.getProductsStream(bookingFile, clazz);
    }

    public static <T extends BaseProduct> T getProductByFop(NestedEntityReference<BookingFile, Fop> fopRef, EntityStorageContext sc) {
        if (null == fopRef) {
            return null;
        }
        EntityContainer bookingFile = EntityStorageHelper.resolve(fopRef, (EntityStorageContext)sc);
        if (null == bookingFile) {
            return null;
        }
        for (Reservation reservation : ((BookingFile)bookingFile.getEntity()).getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                List<GeneralProductFop> fops = GeneralProductHelper.getUnmodifiableFops(product, ContractType.CLIENT);
                if (CollectionUtil.find(fops, (String)fopRef.getNestedEntityUid()) == null) continue;
                return (T)product;
            }
        }
        return null;
    }

    public static EntityContainer<Organization> getCompany(EntityContainer<BookingFile> bookingFile) {
        if (EntityStorageHelper.isEmpty(bookingFile)) {
            return null;
        }
        return BookingHelper.getCompany((BookingFile)bookingFile.getEntity());
    }

    public static EntityContainer<Organization> getCompany(BookingFile bookingFile) {
        EntityContainer res = EntityStorageHelper.resolve((EntityReference)bookingFile.getCustomerProfile());
        return res == null ? null : (!ProfileHelper.isRetailProfile((EntityContainer<Organization>)res) ? res : EntityStorageHelper.resolve(BookingHelper.getSubagency(bookingFile)));
    }

    public static void updateTicketTypes(BookingFile booking, TicketType ticketType) {
        for (BaseProduct bp : BookingHelper.getProducts(booking)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(bp);
            handler.setTicketType(bp, ticketType);
        }
    }

    public static List<BasicDocumentIndex> findBookingFileDocuments(EntityReference<BookingFile> bfRef, DocumentType documentType) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bfRef));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)BasicDocumentIndex.Property.type.name(), (Object[])new Object[]{documentType}));
        return EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
    }

    public static boolean hasBookingFileDocumentsForProduct(EntityReference<BookingFile> bfRef, DocumentType documentType, String productUid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bfRef));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)BasicDocumentIndex.Property.type.name(), (Object[])new Object[]{documentType}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)productUid));
        query.setLimit(1);
        return !EntityStorage.get().search(BasicDocumentIndex.class, query).getData().isEmpty();
    }

    public static DictionaryReference<BlankType> getBlankType(EntityReference<Organization> blankOwner, boolean isRequired) {
        DictionaryReference result = BookingHelper.getBlankTypesByVendor(blankOwner).stream().filter(blankType -> blankType.getBlankCategory() == BlankCategory.ETICKET && blankType.getProductCategory() == ProductCategory.AIR).findFirst().map(BlankType::toReference).orElse(null);
        if (result == null && isRequired) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 {0}", (Object[])new Object[]{blankOwner});
        }
        return result;
    }

    public static Money getTravelSubjectTotalPrice(BaseProduct product) {
        return null;
    }

    public static String createBookingDocumentUrl(String bookingFileUid, BaseProduct product, DocumentType documentType) throws Exception {
        if (BOOKING_DOCUMENT_URL_BUILDER == null) {
            throw new UnsupportedOperationException();
        }
        BookingDocumentReference ref = new BookingDocumentReference();
        ref.setBookingFileUid(bookingFileUid);
        ref.setProductUid(product.getUid());
        ref.setDocumentType(documentType);
        TemporalObject to = new TemporalObject();
        to.setData(XSUtil.toByteArray((XSSerializable)ref));
        to.setTag("booking-document-reference");
        Date date = ProductHandler.of(product).getLastEndDate(product);
        if (product instanceof Transfer) {
            date = ProductHandler.of(product).getFirstStartDate(product);
        }
        to.setExpired(MiscUtil.addDaysToDate((Date)date, (int)31));
        AssetsStorage.get().save((BaseAsset)to);
        return BOOKING_DOCUMENT_URL_BUILDER.buildUrl(product, to.getUid());
    }

    public static void copyCustomer(Customer target, Customer source) {
        try {
            target.copyFrom((BaseEntity)source, false, new HashMap());
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)"failed to clone customer", (Throwable)e);
        }
    }

    static {
        if (System.getProperties().containsKey("com.gridnine.xtrip.common.model.helpers.BookingHelper.BookingDocumentUrlBuilder.className")) {
            try {
                BOOKING_DOCUMENT_URL_BUILDER = (BookingDocumentUrlBuilder)Class.forName(System.getProperty("com.gridnine.xtrip.common.model.helpers.BookingHelper.BookingDocumentUrlBuilder.className")).newInstance();
            }
            catch (Exception ex) {
                log.error("failed instantiating BookingDocumentUrlBuilder", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public static interface BookingDocumentUrlBuilder {
        public static final String CLASS_NAME_PROPERTY = "com.gridnine.xtrip.common.model.helpers.BookingHelper.BookingDocumentUrlBuilder.className";

        public String buildUrl(BaseProduct var1, String var2);
    }

    public static interface ProductTotalPrice {
        public void handle(BaseProduct var1, ContractType var2, PaymentType var3);
    }
}

