/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.XtripHotelProductHelper;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.HotelsTimeUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class CancellationChargeHelper {
    private static final String SPACE = " ";

    public static List<CancellationCharge> normalize(Date now, List<CancellationCharge> charges, LocalDate checkInDate) {
        ArrayList<CancellationCharge> result = new ArrayList<CancellationCharge>();
        for (CancellationCharge cc : CancellationChargeHelper.sort(charges)) {
            if (cc.getStartDate() != null && checkInDate != null && !cc.getStartDate().before(HotelsTimeUtil.localDateToDate((LocalDate)checkInDate)) || cc.getEndDate() != null && !cc.getEndDate().after(now)) continue;
            result.add(CancellationChargeHelper.fix(now, cc));
        }
        return result;
    }

    public static CancellationCharge fix(Date now, CancellationCharge cc) {
        try {
            Date start;
            CancellationCharge result = (CancellationCharge)XCloneHelper.clone((XCloneable)cc);
            if (!cc.isWithTime()) {
                result.setStartDate(XtripHotelProductHelper.startDate(cc));
                result.setEndDate(XtripHotelProductHelper.endDate(cc));
            }
            if ((start = cc.getStartDate()) != null && start.before(now)) {
                result.setStartDate(null);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionUtil.untaint((Exception)e);
        }
    }

    public static List<CancellationCharge> sort(List<CancellationCharge> cancellationCharges) {
        ArrayList<CancellationCharge> copy = new ArrayList<CancellationCharge>(cancellationCharges);
        copy.sort(HotelProductHelper.CANCELLATION_CHARGES_CMP);
        return copy;
    }

    public static Date endDateTime(CancellationCharge cc, CancellationCharge next) {
        Date end = cc.getEndDate();
        if (cc.isWithTime()) {
            boolean hasClashWithNext = next == null || MiscUtil.equals((Object)end, (Object)next.getStartDate());
            return hasClashWithNext ? MiscUtil.addMinutesToDate((Date)end, (int)-1) : end;
        }
        if (next != null && MiscUtil.equals((Object)end, (Object)next.getStartDate())) {
            return MiscUtil.addMinutesToDate((Date)end, (int)-1);
        }
        return MiscUtil.addMinutesToDate((Date)MiscUtil.addDaysToDate((Date)end, (int)1), (int)-1);
    }

    public static boolean equals(List<CancellationCharge> charges1, List<CancellationCharge> charges2) {
        if (charges1 == null && charges2 == null) {
            return true;
        }
        if (charges1 == null || charges2 == null || charges1.size() != charges2.size()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; result && i < charges1.size(); ++i) {
            result = CancellationChargeHelper.equals(charges1.get(i), charges2.get(i));
        }
        return result;
    }

    public static boolean equals(CancellationCharge charge1, CancellationCharge charge2) {
        if (charge1 == null && charge2 == null) {
            return true;
        }
        if (charge1 == null || charge2 == null) {
            return false;
        }
        return Objects.equals(charge1.getStartDate(), charge2.getStartDate()) && Objects.equals(charge1.getEndDate(), charge2.getEndDate()) && CancellationChargeHelper.equals(charge1.getPenalty(), charge2.getPenalty()) && Objects.equals(charge1.getPenaltyEquivalentAmount(), charge2.getPenaltyEquivalentAmount()) && Objects.equals(charge1.getPenaltyEquivalentVatAmount(), charge2.getPenaltyEquivalentVatAmount()) && Objects.equals(charge1.getPenaltyEquivalentVatRate(), charge2.getPenaltyEquivalentVatRate()) && Objects.equals(charge1.getPenaltyVatAmount(), charge2.getPenaltyVatAmount()) && Objects.equals(charge1.getPolicyText(), charge2.getPolicyText()) && Objects.equals(charge1.getTimeZoneId(), charge2.getTimeZoneId()) && Objects.equals(charge1.getTimeZoneIsUnknown(), charge2.getTimeZoneIsUnknown()) && charge1.isWithTime() == charge2.isWithTime() && BooleanUtil.nullAsFalse((Boolean)charge1.getNotAvailableViaAPI()) == BooleanUtil.nullAsFalse((Boolean)charge2.getNotAvailableViaAPI());
    }

    public static boolean equals(RateMoney o1, RateMoney o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return Objects.equals(o1.getRate(), o2.getRate()) && MoneyHelper.compare(o1.getMoney(), o2.getMoney()) == 0;
    }

    public static void removeVat(CancellationCharge result) {
        result.setPenaltyEquivalentVatRate(null);
        result.setPenaltyVatAmount(null);
        result.setPenaltyEquivalentVatAmount(null);
    }

    public static void fillCancellationCharge(CancellationCharge result, Money money, boolean includeVat) {
        CancellationChargeHelper.fillCancellationCharge(result, money, includeVat, null);
    }

    public static void fillCancellationCharge(CancellationCharge result, Money money, boolean includeVat, BigDecimal vatAmount) {
        CancellationChargeHelper.fillCancellationCharge(result, money, money.getCurrency(), includeVat, vatAmount);
    }

    public static void fillCancellationCharge(CancellationCharge result, Money money, String equivalentCurrency, boolean includeVat) {
        CancellationChargeHelper.fillCancellationCharge(result, money, equivalentCurrency, includeVat, null);
    }

    public static void fillCancellationCharge(CancellationCharge result, Money money, String equivalentCurrency, boolean includeVat, BigDecimal vatAmount) {
        RateMoney rateMoney = new RateMoney();
        rateMoney.setMoney(money);
        CancellationChargeHelper.fillCancellationCharge(result, rateMoney, equivalentCurrency, includeVat, vatAmount);
    }

    public static void fillCancellationCharge(CancellationCharge result, RateMoney rateMoney, String equivalentCurrency, boolean includeVat) {
        CancellationChargeHelper.fillCancellationCharge(result, rateMoney, equivalentCurrency, includeVat, null);
    }

    public static void fillCancellationCharge(CancellationCharge result, RateMoney rateMoney, String equivalentCurrency, boolean includeVat, BigDecimal vatAmount) {
        result.setPenalty(rateMoney);
        Money money = rateMoney.getMoney();
        if (money != null) {
            BigDecimal equivalentAmount = equivalentCurrency.equalsIgnoreCase(money.getCurrency()) ? money.getValue() : MoneyHelper.exchange(money, equivalentCurrency);
            result.setPenaltyEquivalentAmount(equivalentAmount);
            if (includeVat) {
                double rate = vatAmount != null ? VatAmount.of((BigDecimal)equivalentAmount, (BigDecimal)vatAmount).getVat().doubleValue() : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue();
                result.setPenaltyEquivalentVatRate(Double.valueOf(rate));
                VatAmount va = new VatAmount();
                va.setTotalVat(money.getValue(), rate);
                result.setPenaltyVatAmount(va.getVatAmount());
                va = new VatAmount();
                va.setTotalVat(equivalentAmount, rate);
                result.setPenaltyEquivalentVatAmount(va.getVatAmount());
            }
        }
        if (!includeVat) {
            CancellationChargeHelper.removeVat(result);
        }
    }

    public static String buildCancellationPolicy(List<CancellationCharge> charges, Money basePrice, Money hiddenNotRefundedFees, String text, Locale locale) {
        StringBuilder buf = new StringBuilder();
        TimeZone moscowTimeZone = TimeZone.getTimeZone("Europe/Moscow");
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        df.setTimeZone(moscowTimeZone);
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        tf.setTimeZone(moscowTimeZone);
        DecimalFormat nf = new DecimalFormat("#0");
        Date nowDate = new Date();
        for (int i = 0; i < charges.size(); ++i) {
            boolean lastCharge;
            CancellationCharge charge = charges.get(i);
            Date startDate = charge.getStartDate();
            Date endDate = charge.getEndDate();
            boolean noTimeZone = Boolean.TRUE.equals(charge.getTimeZoneIsUnknown());
            if (startDate != null && i == 0 && startDate.after(nowDate)) {
                buf.append(CancellationChargeHelper.freeCancellationBefore(startDate, noTimeZone, locale)).append(SPACE);
            }
            buf.append(L10nResourcesManager.getStr((String)"HOTELS_CANCEL_PRODUCED", (Locale)locale, (Object[])new Object[0]));
            boolean timePrinted = false;
            if (startDate != null && (charges.size() != 1 || startDate.after(nowDate))) {
                timePrinted = !noTimeZone;
                String tpl = noTimeZone ? "HOTELS_FROM_DATE" : "HOTELS_FROM_DATE_TIME";
                buf.append(CancellationChargeHelper.getMessageWithDateAndTime(tpl, df, tf, startDate, locale));
            } else {
                buf.append(L10nResourcesManager.getStr((String)"HOTELS_FROM_NOW_ON", (Locale)locale, (Object[])new Object[0]));
            }
            boolean bl = lastCharge = i == charges.size() - 1;
            if (!lastCharge && endDate != null) {
                CancellationCharge nextCharge = i + 1 < charges.size() ? charges.get(i + 1) : null;
                endDate = CancellationChargeHelper.endDateTime(charge, nextCharge);
                if (noTimeZone) {
                    endDate = MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)endDate), (int)1);
                }
                String tpl = noTimeZone ? "HOTELS_TILL_DATE" : "HOTELS_TILL_DATE_TIME";
                buf.append(SPACE).append(CancellationChargeHelper.getMessageWithDateAndTime(tpl, df, tf, endDate, locale));
                boolean bl2 = timePrinted = !noTimeZone;
            }
            if (timePrinted) {
                buf.append(SPACE).append(L10nResourcesManager.getStr((String)"HOTELS_BY_MOSCOW_TIME", (Locale)locale, (Object[])new Object[0]));
            }
            buf.append(L10nResourcesManager.getStr((String)"HOTELS_ENTAILS_PENALTY", (Locale)locale, (Object[])new Object[0]));
            Money penalty = CancellationChargeHelper.calculatePenalty(charge, basePrice);
            if (penalty != null) {
                if (!MiscUtil.isZero((BigDecimal)hiddenNotRefundedFees.getValue(), (boolean)true) && !"%".equals(penalty.getCurrency())) {
                    if (!MiscUtil.equals((Object)hiddenNotRefundedFees.getCurrency(), (Object)penalty.getCurrency())) {
                        throw Xeption.forDeveloper((String)"gds currency {0} is different from penalty currency {1}", (Object[])new Object[]{hiddenNotRefundedFees.getCurrency(), penalty.getCurrency()});
                    }
                    penalty.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{penalty.getValue(), hiddenNotRefundedFees.getValue()}));
                }
                buf.append(SPACE).append(MessageFormat.format(L10nResourcesManager.getStr((String)"HOTELS_PENALTY_SIZE", (Locale)locale, (Object[])new Object[0]), nf.format(penalty.getValue()), penalty.getCurrency())).append(SPACE);
                continue;
            }
            buf.append(L10nResourcesManager.getStr((String)"HOTELS_SPECIFY_SIZE_OF_PENALTY_FROM_OPERATORS", (Locale)locale, (Object[])new Object[0])).append(SPACE);
        }
        if (TextUtil.nonBlank((String)text)) {
            buf.append(text).append(SPACE);
        }
        buf.append(L10nResourcesManager.getStr((String)"HOTELS_CANCELLATION_AVAILABILITY_AFTER_CHECKIN", (Locale)locale, (Object[])new Object[0]));
        return buf.toString().trim();
    }

    public static String freeCancellationBefore(Date date, boolean noTimeZone, Locale locale) {
        Date beforeChargesDateTime = noTimeZone ? MiscUtil.clearTime((Date)date) : MiscUtil.addMinutesToDate((Date)date, (int)-1);
        TimeZone moscowTimeZone = TimeZone.getTimeZone("Europe/Moscow");
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        df.setTimeZone(moscowTimeZone);
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        tf.setTimeZone(moscowTimeZone);
        String tpl = noTimeZone ? "HOTELS_CANCELLATION_POSSIBLE_TILL_THIS_DATE" : "HOTELS_CANCELLATION_POSSIBLE_TILL_THIS_TIME";
        return CancellationChargeHelper.getMessageWithDateAndTime(tpl, df, tf, beforeChargesDateTime, locale);
    }

    private static String getMessageWithDateAndTime(String message, DateFormat df, DateFormat tf, Date date, Locale locale) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", df.format(date));
        params.put("time", tf.format(date));
        return TextUtil.formatNamed((String)L10nResourcesManager.getStr((String)message, (Locale)locale, (Object[])new Object[0]), params);
    }

    private static Money calculatePenalty(CancellationCharge charge, Money basePrice) {
        if (charge == null || charge.getPenalty() == null) {
            return null;
        }
        if (charge.getPenalty().getMoney() != null) {
            return charge.getPenalty().getMoney();
        }
        if (charge.getPenalty().getRate() == null) {
            return null;
        }
        if (charge.getPenalty().getRate() == 0.0) {
            return MoneyHelper.buildMoney(BigDecimal.ZERO, basePrice.getCurrency());
        }
        BigDecimal amount = basePrice.getValue().multiply(BigDecimal.valueOf(charge.getPenalty().getRate() / 100.0)).divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP);
        return MoneyHelper.buildMoney(amount, basePrice.getCurrency());
    }

    public static Money calcHiddenNotRefundedFeesAmount(List<GeneralProductContractRelationData> contractRelations, String gdsCurrency) {
        BigDecimal clientAmount = CancellationChargeHelper.calcHiddenNotRefundedFeesAmount(contractRelations);
        Double rate = contractRelations.stream().map(BaseContractRelationData::getGeneralData).filter(Objects::nonNull).map(ContractRelationGeneralData::getRate).filter(Objects::nonNull).map(ExchangeRateData::getRateWithCoefficient).reduce(1.0, (d1, d2) -> d1 * d2);
        if (rate != null && rate != 0.0) {
            clientAmount = clientAmount.divide(BigDecimal.valueOf(rate), 2, RoundingMode.HALF_UP);
        }
        return MoneyHelper.buildMoney(clientAmount, gdsCurrency);
    }

    public static BigDecimal calcHiddenNotRefundedFeesAmount(List<GeneralProductContractRelationData> contractRelations) {
        GeneralProductContractRelationData clientCR = GeneralProductHelper.getContractRelation(contractRelations, ContractType.CLIENT);
        return clientCR.getCommissions().stream().filter(GeneralProductHelper::isHiddenFee).filter(CancellationChargeHelper::withNoPenaltiesRefund).map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static boolean withNoPenaltiesRefund(GeneralProductCommission comm) {
        EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
        return ctr != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getReturnCases().contains(ReturnCase.NO_PENALTIES_REFUND);
    }
}

