/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.TextUtil;

public class CommunicationFormat {
    public static final String PHONE = "+C (T) N #I";
    public static final String EMAIL = "N";
    public static final String WEB = "N";
    private final String pattern;

    public CommunicationFormat() {
        this(PHONE);
    }

    public CommunicationFormat(String pattern) {
        this.pattern = pattern;
    }

    public String format(Communication name) {
        return this.format(name, true);
    }

    public String format(Communication communication, boolean removeSeparators) {
        StringBuilder formattedCommunication = new StringBuilder();
        int lastFieldIndex = -1;
        boolean fieldAppended = false;
        for (int i = 0; i < this.pattern.length(); ++i) {
            String field = this.pattern.substring(i, i + 1);
            boolean fieldFound = false;
            String token = null;
            if (field.equals("C")) {
                token = communication.getCountryCode();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                }
                fieldFound = true;
            } else if (field.equals("T")) {
                token = communication.getCityCode();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                }
                fieldFound = true;
            } else if (field.equals("N")) {
                token = communication.getSense();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                }
                fieldFound = true;
            } else if (field.equals("I")) {
                token = communication.getInternalNumber();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                }
                fieldFound = true;
            }
            if (fieldFound) {
                if (lastFieldIndex == -1 || token != null && fieldAppended) {
                    formattedCommunication.append(this.pattern.substring(lastFieldIndex + 1, i));
                }
                if (token != null) {
                    formattedCommunication.append(token);
                    fieldAppended = true;
                }
                lastFieldIndex = i;
                continue;
            }
            if (i != this.pattern.length() - 1) continue;
            formattedCommunication.append(this.pattern.substring(lastFieldIndex + 1));
        }
        return formattedCommunication.toString();
    }
}

