/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.test.TestBase;
import org.junit.Assert;
import org.junit.Test;

public class CommunicationFormatTest
extends TestBase {
    @Test
    public void testFormatter() throws Exception {
        Communication communication = new Communication();
        communication.setCountryCode("7");
        communication.setCityCode("495");
        communication.setSense("1234567");
        communication.setInternalNumber("890");
        Assert.assertEquals((Object)"74951234567890", (Object)new CommunicationFormat("CTNI").format(communication, false));
        Assert.assertEquals((Object)"+7 (495) 1234567 #890", (Object)new CommunicationFormat("+C (T) N #I").format(communication, false));
        Assert.assertEquals((Object)"<7_495_1234567>", (Object)new CommunicationFormat("<C_T_N>").format(communication, false));
        Assert.assertEquals((Object)"7/495/1234567/890>", (Object)new CommunicationFormat("C/T/N/I>").format(communication, false));
        communication = new Communication();
        communication.setSense("info@example.com");
        Assert.assertEquals((Object)"[info@example.com]", (Object)new CommunicationFormat("[N]").format(communication, false));
    }
}

