/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DeliveryHelper {
    public static List<BaseProduct> getRelatedProducts(Delivery product) {
        ArrayList<BaseProduct> relatedProducts = new ArrayList<BaseProduct>();
        for (DeliveryItem item : product.getDeliveryItems()) {
            Object relatedProduct;
            NestedEntityReference itemProductReference;
            if (item.getType() != DeliveryItemType.PRODUCT || (itemProductReference = (NestedEntityReference)item.getObject()) == null || !MiscUtil.equals((Object)product.getReservation().getBookingFile().getUid(), (Object)itemProductReference.getUid()) || (relatedProduct = BookingHelper.findProductByUid(itemProductReference.getNestedEntityUid(), product.getReservation().getBookingFile())) == null) continue;
            relatedProducts.add((BaseProduct)relatedProduct);
        }
        return relatedProducts;
    }

    public static ProductStatus getProductStatus(Delivery delivery) {
        if (delivery.getStatus() == null) {
            return ProductStatus.VOID;
        }
        switch (delivery.getStatus()) {
            case VOID: {
                return ProductStatus.VOID;
            }
            case PLANNED: 
            case COMPLETED: {
                return ProductStatus.SELL;
            }
            case RETURNED: {
                return ProductStatus.REFUND;
            }
        }
        return ProductStatus.VOID;
    }

    public static void setProductStatus(Delivery delivery, ProductStatus status) {
        throw new UnsupportedOperationException();
    }

    public static void recalculate(Delivery product) throws Exception {
        for (DeliveryItem deliveryItem : product.getDeliveryItems()) {
            NestedEntityReference itemProductReference;
            BaseProduct itemProduct;
            Object object;
            DeliveryItemType type = deliveryItem.getType();
            if (type == null || (object = deliveryItem.getObject()) == null || type != DeliveryItemType.PRODUCT || (itemProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)(itemProductReference = (NestedEntityReference)object))) == null) continue;
            BigDecimal itemProductAmount = Optional.ofNullable(ProductHandler.of(itemProduct).calculateProductPrice(itemProduct, ContractType.CLIENT)).map(item -> item.getTotal()).orElse(null);
            BigDecimal itemFeeAmount = GeneralProductHelper.calculateFee(itemProduct, ContractType.CLIENT);
            itemProductReference.setCaption(ProductHandler.of(itemProduct).generateShortProductName(itemProduct));
            deliveryItem.setCost(Optional.ofNullable(MiscUtil.sum((BigDecimal[])new BigDecimal[]{itemProductAmount, itemFeeAmount})).orElse(BigDecimal.ZERO));
            deliveryItem.setPaymentType(Optional.ofNullable(GeneralProductHelper.findFop(itemProduct)).map(item -> item.getType()).orElse(PaymentType.CASH));
        }
    }

    public static void importDataFromProfile(Delivery delivery, EntityReference<? extends BaseProfile> clientReference) {
        OrganizationContactData organizationContactData = Optional.ofNullable(clientReference).filter(item -> Organization.class.isAssignableFrom(clientReference.getType())).map(item -> EntityStorage.get().resolve(clientReference)).map(item -> DeliveryHelper.getOrganizationContactData((Organization)item.getEntity())).orElse(null);
        if (organizationContactData != null) {
            String additionalInfo;
            String additionalInfoPhones = null;
            String additionalInfoPersons = null;
            String additionalInfoAddress = null;
            Address address = organizationContactData.getAddress();
            if (address != null) {
                String addressValue = ProfileHelper.buildFullAddress(address, LocaleHelper.getCurrentLocale(), false);
                addressValue = !TextUtil.isBlank((String)addressValue) ? addressValue.trim() : null;
                delivery.setAddress(addressValue);
                delivery.setDeliveryRegion(address.getDeliveryRegion());
                delivery.setMetroStation(address.getMetroStation());
                if (!TextUtil.isBlank((String)address.getNotes())) {
                    additionalInfoAddress = address.getNotes().trim();
                }
            }
            ArrayList<Communication> communications = new ArrayList<Communication>();
            List personInfos = organizationContactData.getPersonContactDatas().entrySet().stream().map(item -> new MiscUtil.Pair(item.getKey(), item.getValue())).collect(Collectors.toList());
            if (personInfos.size() > 0) {
                MiscUtil.Pair personInfo = (MiscUtil.Pair)personInfos.remove(0);
                EntityReference person = (EntityReference)personInfo.getFirst();
                PersonContactData personContactData = (PersonContactData)personInfo.getSecond();
                delivery.setContactPerson(person);
                if (personContactData != null && personContactData.getCommunications().size() > 0) {
                    communications.add(personContactData.getCommunications().get(0));
                }
            }
            communications.addAll(organizationContactData.getCommunications());
            if (communications.size() > 0) {
                Communication communication = (Communication)communications.remove(0);
                String contactPhone = ProfileHelper.buildFullPhoneNumber(communication);
                contactPhone = !TextUtil.isBlank((String)contactPhone) ? contactPhone.trim() : null;
                delivery.setContactPhone(contactPhone);
            }
            additionalInfoPhones = communications.stream().map(item -> ProfileHelper.buildFullPhoneNumber(item)).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).collect(Collectors.joining(", "));
            additionalInfoPersons = personInfos.stream().map(item -> EntityStorage.get().resolve((EntityReference)item.getFirst())).filter(item -> item != null).map(item -> (Person)item.getEntity()).map(item -> ProfileHelper.getFullName(item, LocaleHelper.getCurrentLocale(), false)).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).collect(Collectors.joining(", "));
            StringBuilder additionalInfoStringBuilder = new StringBuilder();
            if (!TextUtil.isBlank((String)additionalInfoPhones)) {
                if (additionalInfoStringBuilder.length() > 0) {
                    additionalInfoStringBuilder.append("\n");
                }
                additionalInfoStringBuilder.append("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u044b: " + additionalInfoPhones);
            }
            if (!TextUtil.isBlank((String)additionalInfoPersons)) {
                if (additionalInfoStringBuilder.length() > 0) {
                    additionalInfoStringBuilder.append("\n");
                }
                additionalInfoStringBuilder.append("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b: " + additionalInfoPersons);
            }
            if (!TextUtil.isBlank((String)additionalInfoAddress)) {
                if (additionalInfoStringBuilder.length() > 0) {
                    additionalInfoStringBuilder.append("\n");
                }
                additionalInfoStringBuilder.append("\u041f\u043e\u044f\u0441\u043d\u0435\u043d\u0438\u044f \u043a \u0430\u0434\u0440\u0435\u0441\u0443: " + additionalInfoAddress);
            }
            additionalInfo = !TextUtil.isBlank((String)(additionalInfo = additionalInfoStringBuilder.toString())) ? additionalInfo.trim() : null;
            delivery.setAdditionalInfo(additionalInfo);
        }
    }

    public static Delivery createRefund(Delivery model) {
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            Delivery refund = (Delivery)XCloneHelper.clone((XCloneable)model, (boolean)true);
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setPreviousProduct(model);
            model.setNextProduct(refund);
            refund.setCancellationDetails(null);
            refund.setContractRulesApplied(false);
            refund.setChecked(false);
            refund.getValidationMessages().clear();
            refund.getClientFops().clear();
            refund.getCommissions().clear();
            refund.setStatus(DeliveryStatus.RETURNED);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            Delivery delivery = refund;
            return delivery;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            model.setReservation(res);
        }
    }

    public static boolean removeProduct(Delivery product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(Delivery product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getAddresses(Delivery product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        String region = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getDeliveryRegion())).map(item -> item.toString(locale)).orElse(null);
        String street = Optional.ofNullable(product.getAddress()).map(item -> {
            if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null))) {
                item = TranslitUtil.cyr2lat((String)item, (TranslitUtil.TranslitRules)translitRules);
            }
            return region != null ? String.format("%s %s", region, item) : item;
        }).orElse(null);
        RouteHelper.AddressData addressData = RouteHelper.AddressDataBuilder.get().street(street).build();
        return RouteHelper.getRoute(Arrays.asList(addressData));
    }

    public static Address getPrioritizedOrganizationAddress(List<Address> addresses) {
        AddressType[] prioritizedTypes = new AddressType[]{AddressType.DELIVERY, AddressType.CONTACT, AddressType.FACTUAL, AddressType.LEGAL};
        if (addresses != null) {
            Map<AddressType, Address> addressMap = addresses.stream().collect(Collectors.toMap(Address::getAddressType, adr -> adr, (adr1, adr2) -> adr2));
            for (AddressType type : prioritizedTypes) {
                Address result = addressMap.get(type);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static OrganizationContactData getOrganizationContactData(Organization organization) {
        HashMap<AddressType, Integer> addressTypes = new HashMap<AddressType, Integer>();
        addressTypes.put(AddressType.DELIVERY, 0);
        addressTypes.put(AddressType.FACTUAL, 1);
        addressTypes.put(AddressType.CONTACT, 2);
        addressTypes.put(AddressType.LEGAL, 3);
        Address address = ProfileHelper.getOrganizationAddresses(organization).stream().filter(item -> addressTypes.containsKey(item.getAddressType())).sorted(MiscUtil.comparator(item -> (Integer)addressTypes.get(item.getAddressType()))).findFirst().orElse(null);
        List communications = organization.getCommunications().stream().filter(item -> item.getType() == CommunicationType.WORK_PHONE || item.getType() == CommunicationType.MOBILE).collect(Collectors.toList());
        LinkedHashMap<EntityReference, PersonContactData> personContactDatas = new LinkedHashMap<EntityReference, PersonContactData>();
        for (ProfileKeyContactPerson keyContact : organization.getKeyContacts()) {
            Person person = Optional.ofNullable(EntityStorage.get().resolve(keyContact.getPerson())).map(item -> (Person)item.getEntity()).orElse(null);
            if (person == null) continue;
            List personCommunications = person.getCommunications().stream().filter(item -> item.getType() == CommunicationType.WORK_PHONE || item.getType() == CommunicationType.MOBILE).collect(Collectors.toList());
            PersonContactData personContactData = new PersonContactData();
            personContactData.getCommunications().clear();
            personContactData.getCommunications().addAll(personCommunications);
            personContactDatas.put(keyContact.getPerson(), personContactData);
        }
        OrganizationContactData organizationContactData = new OrganizationContactData();
        organizationContactData.setAddress(address);
        organizationContactData.getCommunications().clear();
        organizationContactData.getCommunications().addAll(communications);
        organizationContactData.getPersonContactDatas().clear();
        organizationContactData.getPersonContactDatas().putAll(personContactDatas);
        return organizationContactData;
    }

    public static class PersonContactData
    implements Serializable {
        private static final long serialVersionUID = -5520095335300042344L;
        private final List<Communication> communications = new ArrayList<Communication>();

        public List<Communication> getCommunications() {
            return this.communications;
        }
    }

    public static class OrganizationContactData
    implements Serializable {
        private static final long serialVersionUID = 832999663803437904L;
        private Address address;
        private final List<Communication> communications = new ArrayList<Communication>();
        private final Map<EntityReference<Person>, PersonContactData> personContactDatas = new LinkedHashMap<EntityReference<Person>, PersonContactData>();

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public List<Communication> getCommunications() {
            return this.communications;
        }

        public Map<EntityReference<Person>, PersonContactData> getPersonContactDatas() {
            return this.personContactDatas;
        }
    }
}

