/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.ContentType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DocumentHelper {
    public static List<String> getExtensions(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        switch (contentType) {
            case PDF: 
            case JASPERPRINT: {
                return Collections.singletonList("pdf");
            }
            case EXCEL: {
                return Collections.singletonList("xls");
            }
            case EXCEL_2007: {
                return Collections.singletonList("xlsx");
            }
            case WORD: {
                return Collections.singletonList("doc");
            }
            case WORD_2007: {
                return Collections.singletonList("docx");
            }
            case TEXT: {
                return Collections.singletonList("txt");
            }
            case JPEG: {
                return Arrays.asList("jpg", "jpeg");
            }
            case PNG: {
                return Collections.singletonList("png");
            }
            case GIF: {
                return Collections.singletonList("gif");
            }
            case HTML: {
                return Arrays.asList("html", "htm");
            }
            case XML: {
                return Collections.singletonList("xml");
            }
            case JSON: {
                return Collections.singletonList("json");
            }
        }
        return null;
    }

    public static String getDocNameWithExtension(BaseFileDocument doc) {
        return DocumentHelper.getDocNameWithExtension(doc.getName(), doc.getContentType());
    }

    public static String getDocNameWithExtension(String docName, ContentType contentType) {
        List<String> extensions = DocumentHelper.getExtensions(contentType);
        if (extensions != null && docName != null && extensions.stream().noneMatch(extension -> docName.endsWith("." + extension))) {
            return docName + "." + extensions.get(0);
        }
        return docName;
    }
}

