/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPHelper {
    public static final EnumSet<PassengerStatus> MILITARY_CLAIM_STATUSES = EnumSet.of(PassengerStatus.MCHS, new PassengerStatus[]{PassengerStatus.VS_FSB, PassengerStatus.VS_MO, PassengerStatus.VS_MVD, PassengerStatus.VS_OVD, PassengerStatus.VS_OVD_DEP, PassengerStatus.VS_OVD_KSK, PassengerStatus.VS_VV});
    private static final Logger log = LoggerFactory.getLogger(FOPHelper.class);

    public static void updateProductFops(List<ProductFop> fops, PaymentType pt, BigDecimal totalProductPrice) {
        ProductFop fop = new ProductFop();
        fop.setAmount(SystemHelper.getMoney(totalProductPrice.doubleValue(), DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB")));
        fop.setOperationDate(new Date());
        fop.setType(pt);
        fops.clear();
        fops.add(fop);
    }

    public static void updateGeneralProductFops(List<GeneralProductFop> fops, PaymentType pt, BigDecimal totalProductPrice) {
        FOPHelper.updateGeneralProductFops(GeneralProductFop.class, fops, pt, totalProductPrice);
    }

    public static <PF extends GeneralProductFop> void updateGeneralProductFops(Class<PF> fopClass, List<PF> fops, PaymentType pt, BigDecimal totalProductPrice) {
        try {
            GeneralProductFop fop = (GeneralProductFop)fopClass.newInstance();
            fop.setEquivalentAmount(totalProductPrice);
            fop.setOperationDate(new Date());
            fop.setType(pt);
            fops.clear();
            fops.add(fop);
        }
        catch (Exception e) {
            log.error("updateGeneralProductFops fail", (Throwable)e);
        }
    }

    public static void updateTaxesUids(List<VatComponent> components, Map<String, String> uidsMapping) {
        components.forEach(it -> {
            ArrayList oldTaxesUids = new ArrayList(it.getTaxesUids());
            it.getTaxesUids().clear();
            oldTaxesUids.forEach(oldTaxUid -> {
                String newTaxUid = (String)uidsMapping.get(oldTaxUid);
                if (newTaxUid != null) {
                    it.getTaxesUids().add(newTaxUid);
                }
            });
        });
    }
}

