/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.XSerializable;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class GetCurrencyRateDateTest
extends TestBase {
    public void setUp() throws Exception {
        super.setUp();
        MetaRegistry metaRegistry = MetaRegistry.get();
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-system.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-dict.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-profile.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-booking.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-stockcontrol.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-mco-fees.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-aeroexpress.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-insurance-accident.xml"));
        metaRegistry.register(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/test/model-testing.xml"));
    }

    @Test
    public void testGetCurrencyRateDate() throws Exception {
        EntityContainer bfCtr = new EntityContainer(BookingFile.class);
        this.loadXSerializable("GetCurrencyRateDateTest-data.xml", (XSerializable)bfCtr);
        Product prod = (Product)BookingHelper.findProductByUid("90881161-3dca-11e1-8d4a-0050569b40b9", (BookingFile)bfCtr.getEntity());
        SimpleDateFormat xmlSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT);
        Assert.assertEquals((Object)xmlSdf.parse("2011-12-22 11:26:40.996"), (Object)AirProductHelper.getCurrencyRateDate(prod));
        prod.setPreviousProduct(null);
        Assert.assertEquals((Object)xmlSdf.parse("2012-01-13 13:39:00.000"), (Object)AirProductHelper.getCurrencyRateDate(prod));
    }
}

