/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.com.gridnine.xtrip.common.model.booking.xtriphotels.HotelDepositCard;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.ContractRelationPenaltiesDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.ContractsVatInfo;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.ExtraFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AvailableOption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelBlankOwnerProfile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductSettings;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderProfile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.OfferOptionType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ContractRelationHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.util.DumpUtil;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;

public final class HotelProductHelper {
    private static final long MS_IN_DAY = 86400000L;
    public static final String VENDOR_COMMISSION_PROPERTIES_UID = "VENDOR_COMMISSION_PROPERTIES";
    public static final EntityReference<HotelProductSettings> HOTEL_PRODUCT_SETTINGS_REF = new EntityReference("HOTEL-PRODUCT-SETTINGS", HotelProductSettings.class, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
    private static final EntityReference<CommissionProperties> VENDOR_COMMISSION_PROPERTIES_REF = new EntityReference("VENDOR_COMMISSION_PROPERTIES", CommissionProperties.class, "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043e\u0442\u0435\u043b\u044f (\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f)");
    private static final EntityReference<FeeProperties> VENDOR_FEE_PROPERTIES_REF = new EntityReference("VENDOR_FEE_PROPERTIES", FeeProperties.class, "\u0421\u0431\u043e\u0440 \u043e\u0442\u0435\u043b\u044f");
    public static final Comparator<CancellationCharge> CANCELLATION_CHARGES_CMP = (o1, o2) -> {
        Integer nullCmp = MiscUtil.compareIfNulls((Object)o1, (Object)o2);
        if (nullCmp != null) {
            return nullCmp;
        }
        Date startDate1 = o1.getStartDate();
        Date startDate2 = o2.getStartDate();
        Date endDate1 = o1.getEndDate();
        Date endDate2 = o2.getEndDate();
        if (startDate1 != null && startDate2 != null) {
            return startDate1.compareTo(startDate2);
        }
        if (endDate1 != null && endDate2 != null) {
            return endDate1.compareTo(endDate2);
        }
        if (startDate1 != null && endDate2 != null) {
            int result = startDate1.compareTo(endDate2);
            return result != 0 ? result : 1;
        }
        if (endDate1 != null && startDate2 != null) {
            int result = endDate1.compareTo(startDate2);
            return result != 0 ? result : -1;
        }
        throw new IllegalStateException("not enough info about cancellation charges");
    };
    public static final String WITHOUT_MEAL_BASE_CAPTION = "\u0411\u0435\u0437 \u043f\u0438\u0442\u0430\u043d\u0438\u044f";

    public static WorkflowStatus getWorkflowStatus(BaseProduct product) {
        Reservation reservation = product != null ? product.getReservation() : null;
        BookingFile bookingFile = reservation != null ? reservation.getBookingFile() : null;
        return bookingFile != null ? bookingFile.getWorkflowStatus() : null;
    }

    public static List<CancellationCharge> getAvailableCancellationCharges(HotelProduct hp) {
        return hp.getCancellationCharges().stream().filter(charge -> !BooleanUtil.nullAsFalse((Boolean)charge.getNotAvailableViaAPI())).collect(Collectors.toList());
    }

    public static Money getBasePrice(HotelProduct hp) {
        Money result = null;
        String currency = null;
        for (Room room : hp.getRooms()) {
            Money price = room.getBasePrice();
            if (result == null) {
                currency = price.getCurrency();
                result = MoneyHelper.buildMoney(price.getValue(), currency);
                continue;
            }
            if (currency.equals(price.getCurrency())) {
                result.setValue(result.getValue().add(price.getValue()));
                continue;
            }
            throw new RuntimeException(String.format("different currencies in room prices (%s, %s) of the hotel product %s in the order %s", currency, price.getCurrency(), hp.getSystemNumber(), HotelProductHelper.getBookingFileNumber(hp)));
        }
        return result;
    }

    public static BigDecimal calcPriceFromList(List<PriceWithVat> list) {
        BigDecimal result = BigDecimal.ZERO;
        for (PriceWithVat pwv : list) {
            result = result.add(pwv.getPrice().setScale(2, java.math.RoundingMode.HALF_UP));
        }
        return result;
    }

    private static BigDecimal calcVatFromList(List<PriceWithVat> list) {
        return list.stream().map(PriceWithVat::getVat).filter(Objects::nonNull).map(vat -> vat.setScale(2, java.math.RoundingMode.HALF_UP)).reduce(BigDecimal::add).orElse(null);
    }

    private static Money calcBasePriceFromList(List<PriceWithVat> list) {
        if (!HotelProductHelper.isSameCurrency(list)) {
            return null;
        }
        String baseCurrency = null;
        BigDecimal basePrice = BigDecimal.ZERO;
        for (PriceWithVat pwv : list) {
            if (pwv.getBasePrice() == null) continue;
            if (pwv.getBasePrice().getValue() != null) {
                basePrice = basePrice.add(pwv.getBasePrice().getValue().setScale(2, java.math.RoundingMode.HALF_UP));
            }
            baseCurrency = pwv.getBasePrice().getCurrency();
        }
        Money result = new Money();
        result.setCurrency(baseCurrency);
        result.setValue(basePrice);
        return result;
    }

    private static boolean isSameCurrency(List<PriceWithVat> list) {
        String cur = null;
        for (PriceWithVat pwv : list) {
            if (pwv.getBasePrice() == null) continue;
            if (pwv.getBasePrice().getCurrency() == null) {
                return false;
            }
            if (cur == null) {
                cur = pwv.getBasePrice().getCurrency();
                continue;
            }
            if (cur.equals(pwv.getBasePrice().getCurrency())) continue;
            return false;
        }
        return true;
    }

    private static List<PriceWithVat> getEquivalentFareList(HotelProduct product) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        for (Room room : product.getRooms()) {
            result.add(new PriceWithVat(room.getEquivalentPrice(), room.getEquivalentVatPrice(), room.getBasePrice()));
        }
        return result;
    }

    public static EntityReference<Organization> getConsistentAgencyReference(Stream<HotelProduct> hotelProducts, boolean optional) {
        return HotelProductHelper.getConsistentAgencyReference(hotelProducts, optional, optional, optional);
    }

    public static EntityReference<Organization> getConsistentAgencyReference(Stream<HotelProduct> hotelProducts, boolean allowEmpty, boolean allowNull, boolean allowMultiple) {
        EntityReference result;
        List agencyReferenceList = hotelProducts.map(HotelProductHelper::getAgency).collect(Collectors.toList());
        HashSet agencyReferenceSet = new HashSet(agencyReferenceList);
        if (agencyReferenceSet.isEmpty()) {
            if (!allowEmpty) {
                throw new IllegalArgumentException(agencyReferenceList.toString());
            }
            result = null;
        } else if (agencyReferenceSet.size() > 1) {
            if (!allowMultiple) {
                throw new IllegalArgumentException(agencyReferenceList.toString());
            }
            result = null;
        } else {
            result = (EntityReference)agencyReferenceSet.iterator().next();
            if (result == null && !allowNull) {
                throw new IllegalArgumentException(agencyReferenceList.toString());
            }
        }
        return result;
    }

    public static BigDecimal hiddenFeeToIncludeInPenalty(HotelProduct product) {
        HotelProductContractRelationData crd = HotelProductHelper.getClientContractRelation(product);
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductCommission x : crd.getCommissions()) {
            EntityReference ref;
            FeeProperties feeProperties;
            EntityReference cp = x.getCommissionProperties();
            if (!FeeProperties.class.equals((Object)cp.getType()) || !ExtraFeeProperties.class.isAssignableFrom(cp.getType()) || (feeProperties = (FeeProperties)StorageUtil.getEntity((EntityReference)(ref = cp))) == null || !feeProperties.isHidden() || ((ExtraFeeProperties)feeProperties).getKeepOnReturnWithPenalty() != Boolean.TRUE) continue;
            result = result.add(x.getEquivalentAmount());
        }
        return result;
    }

    public static boolean isValidForCancellation(HotelProduct hp) {
        return HotelProductHelper.isValidForCancellation(hp, true);
    }

    public static boolean isValidForCancellation(HotelProduct hp, boolean considerTimeZone) {
        Date checkInDate;
        Date date = checkInDate = hp != null ? HotelProductHelper.getCheckInDate(hp) : null;
        if (checkInDate == null) {
            return false;
        }
        boolean result = true;
        long now = System.currentTimeMillis();
        long delta = checkInDate.getTime() - now;
        if (Math.abs(delta) > 86400000L) {
            result = delta > 0L;
        } else if (considerTimeZone) {
            DictionaryReference city = hp.getHotelLocation();
            ZoneId tz = DictHelper.getZoneId((DictionaryReference<GeoLocation>)city);
            long startOfDay = MiscUtil.startOfDay((Date)checkInDate, (TimeZone)(tz != null ? TimeZone.getTimeZone(tz) : TimeZone.getDefault()));
            result = now < startOfDay;
        }
        return result;
    }

    public static BigDecimal getEquivalentFare(HotelProduct product) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.getEquivalentFareList(product));
    }

    public static BigDecimal getEquivalentVatFare(HotelProduct product) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.getEquivalentFareList(product));
    }

    public static Money calcBasePrice(HotelProduct product) {
        return HotelProductHelper.calcBasePriceFromList(HotelProductHelper.getEquivalentFareList(product));
    }

    public static Money calcFullBasePrice(HotelProduct product) {
        String localCurrency = product.getRooms().stream().filter(r -> r.getBasePrice() != null).map(r -> r.getBasePrice().getCurrency()).filter(Objects::nonNull).findFirst().orElse(null);
        if (localCurrency == null) {
            return null;
        }
        ArrayList<PriceWithVat> prices = new ArrayList<PriceWithVat>();
        prices.addAll(HotelProductHelper.getEquivalentFareList(product));
        prices.addAll(HotelProductHelper.calculateTaxesEquivalentList(product));
        prices.addAll(HotelProductHelper.calculatePenaltyEquivalentList(product, true));
        prices.addAll(HotelProductHelper.calculateAddServicesList(product));
        return MoneyHelper.buildMoney(prices.stream().filter(price -> price.getBasePrice() != null).filter(price -> localCurrency.equals(price.getBasePrice().getCurrency())).map(price -> price.getBasePrice().getValue()).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), localCurrency);
    }

    private static List<PriceWithVat> calculateTaxesEquivalentList(HotelProduct product) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        for (HotelProductTax tax : product.getTaxes()) {
            result.add(new PriceWithVat(tax.getEquivalentAmount(), tax.getEquivalentVatAmount(), tax.getAmount()));
        }
        return result;
    }

    public static BigDecimal calculateTaxesEquivalentAmount(HotelProduct product) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.calculateTaxesEquivalentList(product));
    }

    public static BigDecimal calculateTaxesEquivalentVatAmount(HotelProduct product) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.calculateTaxesEquivalentList(product));
    }

    private static List<PriceWithVat> calculateAddServicesList(HotelProduct product) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        for (AdditionalService service : product.getAdditionalServices()) {
            result.add(new PriceWithVat(service.getEquivalentAmount(), service.getEquivalentVatAmount(), service.getBaseAmount()));
        }
        return result;
    }

    public static BigDecimal calculateAddServicesEquivalentAmount(HotelProduct product) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.calculateAddServicesList(product));
    }

    public static BigDecimal calculateAddServicesEquivalentVatAmount(HotelProduct product) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.calculateAddServicesList(product));
    }

    public static Money calcAddServicesBasePrice(HotelProduct product) {
        return HotelProductHelper.calcBasePriceFromList(HotelProductHelper.calculateAddServicesList(product));
    }

    private static List<PriceWithVat> calculateFeeEquivalentList(HotelProduct product, ContractType contractType) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        ProductStatus status = product.getStatus();
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            for (HotelProductContractRelationData x : HotelProductHelper.getContractRelations(product)) {
                for (GeneralProductCommission commission : x.getCommissions()) {
                    EntityReference cp;
                    if (commission.getContractType() != contractType || commission.getEquivalentAmount() == null || BigDecimal.ZERO.compareTo(commission.getEquivalentAmount()) == 0 || (cp = commission.getCommissionProperties()) == null || !FeeProperties.class.equals((Object)cp.getType()) && !PaymentFeeProperties.class.equals((Object)cp.getType())) continue;
                    BigDecimal ea = commission.getEquivalentAmount();
                    ea = ProductStatusHelper.get().negatesPrice(status) ? ea.negate() : ea;
                    PriceWithVat pwv = new PriceWithVat(ea, null);
                    result.add(pwv);
                }
            }
        }
        return result;
    }

    public static BigDecimal calculatePenaltyAmount(HotelProduct product) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.actualPenaltyAmountList(product));
    }

    private static List<PriceWithVat> actualPenaltyAmountList(HotelProduct product) {
        Map<Penalty, com.gridnine.xtrip.common.model.booking.Penalty> map = HotelProductHelper.penaltyMap(product);
        if (map == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>(map.size());
        for (Map.Entry<Penalty, com.gridnine.xtrip.common.model.booking.Penalty> en : map.entrySet()) {
            com.gridnine.xtrip.common.model.booking.Penalty penalty = en.getValue();
            BigDecimal amount = penalty.getAmount();
            BigDecimal vatAmount = penalty.getVatAmount();
            if (HotelProductHelper.penaltyShouldBeNegated(product)) {
                result.add(new PriceWithVat(MiscUtil.negate((BigDecimal)amount), MiscUtil.negate((BigDecimal)vatAmount)));
                continue;
            }
            result.add(new PriceWithVat(amount, vatAmount));
        }
        return result;
    }

    private static Map<Penalty, com.gridnine.xtrip.common.model.booking.Penalty> penaltyMap(HotelProduct product) {
        if (product.getPenalties().isEmpty()) {
            return Collections.emptyMap();
        }
        GeneralProductContractRelationData cr = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        ContractRelationPenaltiesDetalization detalization = cr.getServiceData().getDetalization().getPenalties();
        if (detalization == null) {
            return null;
        }
        HashMap<Penalty, com.gridnine.xtrip.common.model.booking.Penalty> result = new HashMap<Penalty, com.gridnine.xtrip.common.model.booking.Penalty>(product.getPenalties().size());
        List penalties = cr.getServiceData().getDetalization().getPenalties().getPenalties();
        for (Penalty k : product.getPenalties()) {
            String uid = k.getUid();
            com.gridnine.xtrip.common.model.booking.Penalty v = null;
            for (com.gridnine.xtrip.common.model.booking.Penalty x : penalties) {
                if (!x.getSource().equals(uid)) continue;
                v = x;
                break;
            }
            if (v == null) {
                result = null;
                break;
            }
            result.put(k, v);
        }
        return result;
    }

    private static List<PriceWithVat> calculatePenaltyEquivalentList(HotelProduct product, boolean negate) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        for (Penalty penalty : product.getPenalties()) {
            BigDecimal amount = penalty.getEquivalentAmount();
            BigDecimal vatAmount = penalty.getEquivalentVatAmount();
            if (negate && HotelProductHelper.penaltyShouldBeNegated(product)) {
                result.add(new PriceWithVat(MiscUtil.negate((BigDecimal)amount), MiscUtil.negate((BigDecimal)vatAmount), MoneyHelper.negate(penalty.getBaseAmount())));
                continue;
            }
            result.add(new PriceWithVat(amount, vatAmount, penalty.getBaseAmount()));
        }
        return result;
    }

    public static boolean penaltyShouldBeConsidered(Penalty penalty, HotelProduct product) {
        boolean result = false;
        BigDecimal amount = penalty.getEquivalentAmount();
        if (amount != null && amount.compareTo(BigDecimal.ZERO) > 0) {
            switch (product.getStatus()) {
                case REFUND: 
                case EXCHANGE: {
                    result = true;
                    break;
                }
                case SELL: {
                    result = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
                    break;
                }
                default: {
                    if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) break;
                    result = true;
                }
            }
        }
        return result;
    }

    public static boolean penaltyShouldBeNegated(HotelProduct product) {
        boolean result = false;
        switch (product.getStatus()) {
            case REFUND: 
            case EXCHANGE: {
                result = true;
                break;
            }
        }
        return result;
    }

    public static BigDecimal calculateFeeEquivalentAmount(HotelProduct product, ContractType contractType) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.calculateFeeEquivalentList(product, contractType));
    }

    public static BigDecimal calculateFeeEquivalentVatAmount(HotelProduct product, ContractType contractType) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.calculateFeeEquivalentList(product, contractType));
    }

    public static BigDecimal calculatePenaltyEquivalentAmount(HotelProduct product, boolean negate) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.calculatePenaltyEquivalentList(product, negate));
    }

    public static BigDecimal calculatePenaltyEquivalentVatAmount(HotelProduct product, boolean negate) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.calculatePenaltyEquivalentList(product, negate));
    }

    private static List<PriceWithVat> calculateTotalEquivalentFareList(HotelProduct product) {
        ArrayList<PriceWithVat> result = new ArrayList<PriceWithVat>();
        result.addAll(HotelProductHelper.getEquivalentFareList(product));
        result.addAll(HotelProductHelper.calculateTaxesEquivalentList(product));
        result.addAll(HotelProductHelper.calculatePenaltyEquivalentList(product, true));
        result.addAll(HotelProductHelper.calculateAddServicesList(product));
        return result;
    }

    public static BigDecimal calculateTotalEquivalentFare(HotelProduct product) {
        return HotelProductHelper.calcPriceFromList(HotelProductHelper.calculateTotalEquivalentFareList(product));
    }

    public static BigDecimal calculateTotalVatAmount(HotelProduct product) {
        return HotelProductHelper.calcVatFromList(HotelProductHelper.calculateTotalEquivalentFareList(product));
    }

    public static HotelProduct clone(HotelProduct product, boolean keepReservation) throws Exception {
        HotelProduct newProduct = new HotelProduct();
        HotelProductHelper.copy(product, newProduct, keepReservation);
        return newProduct;
    }

    public static void copy(HotelProduct source, HotelProduct target, boolean keepReservation) throws Exception {
        if (source == null || target == null) {
            return;
        }
        HotelProduct sourcePrevProduct = source.getPreviousProduct();
        HotelProduct sourceNextProduct = source.getNextProduct();
        HotelProduct targetPrevProduct = target.getPreviousProduct();
        HotelProduct targetNextProduct = target.getNextProduct();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        ArrayList travellers = new ArrayList(source.getTravellers());
        source.setReservation(null);
        source.getTravellers().clear();
        EntityReference cashier = source.getCashier();
        EntityReference salesPoint = source.getSalesPoint();
        EntityReference<Organization> subagency = HotelProductHelper.getSubagency(source);
        EntityReference<Organization> agency = HotelProductHelper.getAgency(source);
        EntityReference<Organization> supplier = HotelProductHelper.getSupplier(source);
        HashSet excludedUids = new HashSet();
        travellers.forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData sourceStatisticalData = source.getStatisticalData();
        if (sourceStatisticalData != null) {
            sourceStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        StatisticalData targetStatisticalData = (StatisticalData)XCloneHelper.clone((XCloneable)source.getStatisticalData(), (boolean)true, excludedUids);
        source.setStatisticalData(null);
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.getTravellers().addAll(travellers);
        source.getTravellers().addAll(travellers);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        source.setStatisticalData(sourceStatisticalData);
        if (keepReservation && source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
            source.getReservation().getProducts().add(target);
        }
        target.setNextProduct(targetNextProduct);
        target.setPreviousProduct(targetPrevProduct);
        target.setStatisticalData(targetStatisticalData);
        target.setIssueDate(source.getIssueDate());
        target.setCurrencyRateDate(source.getCurrencyRateDate());
        target.setSystemNumber(source.getSystemNumber());
        target.setCashier(cashier);
        target.setSalesPoint(salesPoint);
        target.setUsedPcc(source.getUsedPcc());
        target.setProviderProfileId(source.getProviderProfileId());
        HotelProductHelper.setSupplier(target, supplier);
        HotelProductHelper.setAgency(target, agency);
        HotelProductHelper.setSubagency(target, subagency);
        List<HotelProductFop> targetClientFops = HotelProductHelper.getClientFops(target);
        for (int n = 0; n < targetClientFops.size(); ++n) {
            targetClientFops.get(n).setAgent(HotelProductHelper.getClientFops(source).get(n).getAgent());
        }
        List<HotelProductFop> targetSubagentFops = HotelProductHelper.getSubagentFops(target, false);
        for (int n = 0; n < targetSubagentFops.size(); ++n) {
            targetSubagentFops.get(n).setAgent(HotelProductHelper.getSubagentFops(source, false).get(n).getAgent());
        }
        List<HotelProductFop> targetVendorFops = HotelProductHelper.getVendorFops(target);
        for (int n = 0; n < targetVendorFops.size(); ++n) {
            targetVendorFops.get(n).setAgent(HotelProductHelper.getVendorFops(source).get(n).getAgent());
        }
        target.getShipments().clear();
        target.getPrepaymentDocuments().clear();
        target.getFopDetalizations().clear();
    }

    public static void updateFops(HotelProduct product) {
        HotelProductHelper.updateFops(product, false);
    }

    public static void updateFops(HotelProduct product, boolean respectCheckedFlag) {
        if (respectCheckedFlag && product.isChecked()) {
            return;
        }
        HotelProductHelper.updateProductFops(product);
        HotelProductHelper.updateFeeFops(product);
        HotelProductHelper.updateDiscountFops(product);
    }

    public static void updateProductFops(HotelProduct product) {
        boolean isFareFopsRelevant = HotelProductHelper.isFareFopsRelevant(product);
        GeneralProductHelper.RelationData last = new GeneralProductHelper.RelationData(product);
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(product)) {
            boolean exchange;
            GeneralProductHelper.updateServiceData(product, (BaseContractRelationData)relation, last);
            last = new GeneralProductHelper.RelationData((BaseContractRelationData)relation, last);
            if (!isFareFopsRelevant) {
                relation.getFops().removeIf(f -> GeneralProductHelper.productFopTypes.contains(HotelProductHelper.getFopType(f)));
                continue;
            }
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            BigDecimal totalEquivalentFare = relation.getServiceData().getPaymentPrice();
            List fops = relation.getFops();
            for (HotelProductFop fop : HotelProductHelper.filterFopsByFopTypes(fops, GeneralProductHelper.productFopTypes)) {
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(currency);
                    fop.setAmount(money);
                    continue;
                }
                if (fop.getAmount().getValue() == null) {
                    fop.getAmount().setValue(BigDecimal.ZERO);
                }
                if (fop.getAmount().getCurrency() != null) continue;
                fop.getAmount().setCurrency(currency);
            }
            Collection<HotelProductFop> ticketPaymentTypeFops = HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.TICKET), null, null);
            fops.removeAll(ticketPaymentTypeFops);
            HashSet<PaymentType> allPaymentTypesExceptTicket = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
            allPaymentTypesExceptTicket.remove(PaymentType.TICKET);
            boolean bl = exchange = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            if (exchange) {
                HotelProductContractRelationData prevRelation = HotelProductHelper.findContractRelation(HotelProductHelper.getContractRelations(product.getPreviousProduct()), (EntityReference<ContractRelationDescription>)relation.getDescription());
                Collection<HotelProductFop> filteredVendorFops = HotelProductHelper.filterFops(prevRelation != null ? prevRelation.getFops() : null, GeneralProductHelper.productFopTypes, null, null, null);
                Iterator<HotelProductFop> filteredVendorTotalEquivalentFop = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{HotelProductHelper.calculateTotalEquivalentFop(filteredVendorFops, currency, FinanceHelper.getCurrencyRateType(currency), product.getPreviousProduct().currencyRateDate(), GeneralProductHelper.getSupplier((BaseProduct)product.getPreviousProduct())), totalEquivalentFare});
                if (ticketPaymentTypeFops.isEmpty()) {
                    HotelProductFop ticketPaymentTypeVendorFop = HotelProductHelper.createFop(product, PaymentType.TICKET, filteredVendorTotalEquivalentFop, currency, contractType);
                    fops.add(ticketPaymentTypeVendorFop);
                } else {
                    Money money = new Money();
                    money.setValue(filteredVendorTotalEquivalentFop);
                    money.setCurrency(currency);
                    HotelProductFop ticketPaymentTypeVendorFop = ticketPaymentTypeFops.iterator().next();
                    ticketPaymentTypeVendorFop.setAmount(money);
                    fops.add(ticketPaymentTypeVendorFop);
                }
            }
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.hiddenCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (HotelProductFop productFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> productCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : productFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission productCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (productCommission == null) continue;
                    productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), MiscUtil.negate((BigDecimal)productCommission.getEquivalentAmount())}));
                    if (productFop.getAmount().getValue() != null && productFop.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                        productFop.getAmount().setValue(BigDecimal.ZERO);
                    }
                    productCommissions.add(productCommission);
                }
                productFop.getCommissions().clear();
                productFop.getCommissions().addAll(productCommissions);
            }
            HotelProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.productFopTypes, currency, contractType, null);
            for (HotelProductFop productFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(productFop.getCommissions());
                productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), commissionsEquivalentValue}));
            }
            BigDecimal difference = totalEquivalentFare;
            Collection<HotelProductFop> productFops = HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null);
            BigDecimal totalEquivalentFopValue = HotelProductHelper.calculateTotalEquivalentFop(productFops, currency, FinanceHelper.getCurrencyRateType(currency), product.currencyRateDate(), GeneralProductHelper.getSupplier((BaseProduct)product));
            if ((difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{difference, MiscUtil.negate((BigDecimal)(totalEquivalentFopValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFopValue, MiscUtil.negate((BigDecimal)HotelProductHelper.calculateHiddenFeesEquivalentValue(productFops))})))})).compareTo(BigDecimal.ZERO) == 0 && !HotelProductHelper.filterFopsByPaymentTypes(productFops, allPaymentTypesExceptTicket).isEmpty()) continue;
            Collection<HotelProductFop> cashPaymentTypeFops = HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.CASH), Collections.singleton(currency), null);
            if (!cashPaymentTypeFops.isEmpty()) {
                HotelProductFop cashPaymentTypeFop = cashPaymentTypeFops.iterator().next();
                cashPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{cashPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<HotelProductFop> invoicePaymentTypeFops = HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.INVOICE), Collections.singleton(currency), null);
            if (!invoicePaymentTypeFops.isEmpty()) {
                HotelProductFop invoicePaymentTypeFop = invoicePaymentTypeFops.iterator().next();
                invoicePaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{invoicePaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<HotelProductFop> anyPaymentTypeFops = HotelProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, allPaymentTypesExceptTicket, Collections.singleton(currency), null);
            if (!anyPaymentTypeFops.isEmpty()) {
                HotelProductFop anyPaymentTypeFop = anyPaymentTypeFops.iterator().next();
                anyPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{anyPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            fops.add(HotelProductHelper.createFop(product, PaymentType.CASH, difference, currency, contractType));
        }
        HotelProductHelper.updateByDepositCard(product);
    }

    public static boolean isPaymentInHotel(HotelProduct product) {
        Room room;
        boolean result = false;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && !(result = (room = (Room)iterator.next()).getAvailability() != null && room.getAvailability().getPayee() == HotelsPayee.HOTEL)) {
        }
        return result;
    }

    private static void updateFeeFops(HotelProduct product) {
        boolean separateSupplierFees = false;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            EntityContainer customerCtr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
        }
        HotelProductContractRelationData prevRelation = null;
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (HotelProductFop feeFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> feeCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : feeFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission feeCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (feeCommission == null) continue;
                    feeCommissions.add(feeCommission);
                }
                if (feeCommissions.isEmpty()) {
                    fops.remove(feeFop);
                    continue;
                }
                feeFop.getCommissions().clear();
                feeFop.getCommissions().addAll(feeCommissions);
            }
            if (separateSupplierFees && prevRelation != null && !unusedCommissions.isEmpty()) {
                List prevCommissions = prevRelation.getCommissions();
                List<GeneralProductCommission> addUnusedCommissions = unusedCommissions.stream().filter(c -> GeneralProductHelper.isSupplierFee(c, prevCommissions)).collect(Collectors.toList());
                unusedCommissions.removeAll(addUnusedCommissions);
                HotelProductHelper.distributeCommissionsToFops(product, fops, addUnusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, prevRelation.getCommissions());
            }
            HotelProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, separateSupplierFees && prevRelation != null ? prevRelation.getCommissions() : null);
            prevRelation = relation;
            HotelProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.paymentFeePropertyTypes, GeneralProductHelper.paymentFeeFopTypes, currency, contractType, null);
            for (HotelProductFop feeFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(feeFop.getCommissions());
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                feeFop.setAmount(money);
            }
        }
    }

    private static void updateDiscountFops(HotelProduct product) {
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.discountPropertyTypes, null, null);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (HotelProductFop discountFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> discountCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : discountFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission discountCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (discountCommission == null) continue;
                    discountCommissions.add(discountCommission);
                }
                if (discountCommissions.isEmpty()) {
                    fops.remove(discountFop);
                    continue;
                }
                discountFop.getCommissions().clear();
                discountFop.getCommissions().addAll(discountCommissions);
            }
            HotelProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.discountDiscountPropertyTypes, GeneralProductHelper.discountFopTypes, currency, contractType, null);
            for (HotelProductFop discountFop : HotelProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(discountFop.getCommissions());
                commissionsEquivalentValue = MiscUtil.negate((BigDecimal)commissionsEquivalentValue);
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                discountFop.setAmount(money);
            }
        }
    }

    private static void distributeCommissionsToFops(HotelProduct product, Collection<HotelProductFop> fops, Collection<GeneralProductCommission> commissions, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, String currency, ContractType contractType, Collection<GeneralProductCommission> prevCommissions) {
        Collection<GeneralProductCommission> filteredCommissions = GeneralProductHelper.filterCommissions(commissions, commissionProperties, null, null);
        if (filteredCommissions.isEmpty()) {
            return;
        }
        boolean done = HotelProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.CASH), commissionProperties, fopTypes, currency, prevCommissions);
        if (!done) {
            done = HotelProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.INVOICE), commissionProperties, fopTypes, currency, prevCommissions);
        }
        if (!done) {
            done = HotelProductHelper.distributeCommissionsToFops(fops, filteredCommissions, null, commissionProperties, fopTypes, currency, prevCommissions);
        }
        if (!done) {
            HotelProductFop cashPaymentTypeFop = HotelProductHelper.createFop(product, PaymentType.CASH, BigDecimal.ZERO, currency, contractType);
            cashPaymentTypeFop.getCommissions().addAll(filteredCommissions);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static boolean distributeCommissionsToFops(Collection<HotelProductFop> fops, Collection<GeneralProductCommission> commissions, Set<PaymentType> paymentTypes, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, String currency, Collection<GeneralProductCommission> prevCommissions) {
        Collection<HotelProductFop> filteredFops = HotelProductHelper.filterFops(fops, fopTypes, paymentTypes, Collections.singleton(currency), null);
        if (filteredFops.size() > 0) {
            HotelProductFop filteredFop;
            if (null == prevCommissions) {
                filteredFop = filteredFops.iterator().next();
            } else {
                boolean supplierFee = !commissions.isEmpty() && GeneralProductHelper.isSupplierFee(commissions.iterator().next(), prevCommissions);
                filteredFop = filteredFops.stream().filter(f -> (!f.getCommissions().isEmpty() && GeneralProductHelper.isSupplierFee((GeneralProductCommission)f.getCommissions().get(0), prevCommissions)) == supplierFee).findFirst().orElse(null);
                if (null == filteredFop) {
                    return false;
                }
            }
            filteredFop.getCommissions().addAll(commissions);
            return true;
        }
        return false;
    }

    private static HotelProductFop createFop(HotelProduct product, PaymentType paymentType, BigDecimal amount, String currency, ContractType contractType) {
        HotelProductFop fop = new HotelProductFop();
        fop.setType(paymentType);
        Money money = new Money();
        money.setValue(amount != null ? amount : BigDecimal.ZERO);
        money.setCurrency(currency);
        fop.setAmount(money);
        OnCreateFopListener.fire((BaseProduct)product, (Fop)fop, contractType);
        return fop;
    }

    private static BigDecimal calculateHiddenFeesEquivalentValue(Collection<HotelProductFop> fops) {
        BigDecimal result = BigDecimal.ZERO;
        for (HotelProductFop fop : fops) {
            result = result.add(GeneralProductHelper.calculateHiddenFeesEquivalentValue(fop.getCommissions()));
        }
        return result;
    }

    private static Collection<HotelProductFop> filterFops(Collection<HotelProductFop> fops, Set<FopType> fopTypes, Set<PaymentType> paymentTypes, Set<String> currencies, Set<Class<? extends BaseCommissionProperties>> properties) {
        return HotelProductHelper.filterFopsByFopTypes(HotelProductHelper.filterFopsByPaymentTypes(HotelProductHelper.filterFopsByCurrencies(HotelProductHelper.filterFopsByCommissionProperties(fops, properties), currencies), paymentTypes), fopTypes);
    }

    public static Collection<HotelProductFop> filterFopsByFopType(Collection<HotelProductFop> fops, FopType fopType) {
        return HotelProductHelper.filterFopsByFopTypes(fops, Collections.singleton(fopType));
    }

    public static Collection<HotelProductFop> filterFopsByFopTypes(Collection<HotelProductFop> fops, Set<FopType> fopTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopTypes == null) {
            return new ArrayList<HotelProductFop>(fops);
        }
        ArrayList<HotelProductFop> filteredFops = new ArrayList<HotelProductFop>();
        for (HotelProductFop fop : fops) {
            FopType fopType = HotelProductHelper.getFopType(fop);
            if (!fopTypes.contains(fopType)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    public static Collection<HotelProductFop> filterFopsByPaymentType(Collection<HotelProductFop> fops, PaymentType paymentType) {
        return HotelProductHelper.filterFopsByPaymentTypes(fops, Collections.singleton(paymentType));
    }

    public static Collection<HotelProductFop> filterFopsByPaymentTypes(Collection<HotelProductFop> fops, Set<PaymentType> paymentTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (paymentTypes == null) {
            return new ArrayList<HotelProductFop>(fops);
        }
        ArrayList<HotelProductFop> filteredFops = new ArrayList<HotelProductFop>();
        for (HotelProductFop fop : fops) {
            if (fop.getType() == null || !paymentTypes.contains(fop.getType())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    public static Collection<HotelProductFop> filterCommissionFops(Collection<HotelProductFop> fops) {
        return HotelProductHelper.filterFopsByCommissionProperties(fops, GeneralProductHelper.commissionPropertyTypes);
    }

    public static Collection<HotelProductFop> filterFeeFops(Collection<HotelProductFop> fops) {
        return HotelProductHelper.filterFopsByCommissionProperties(fops, GeneralProductHelper.feePropertyTypes);
    }

    public static Collection<HotelProductFop> filterFopsByCommissionProperties(Collection<HotelProductFop> fops, Class<? extends BaseCommissionProperties> properties) {
        return HotelProductHelper.filterFopsByCommissionProperties(fops, Collections.singleton(properties));
    }

    public static Collection<HotelProductFop> filterFopsByCommissionProperties(Collection<HotelProductFop> fops, Set<Class<? extends BaseCommissionProperties>> properties) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (properties == null) {
            return new ArrayList<HotelProductFop>(fops);
        }
        ArrayList<HotelProductFop> filteredFops = new ArrayList<HotelProductFop>();
        block0: for (HotelProductFop fop : fops) {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !properties.contains(commission.getCommissionProperties().getType())) continue;
                filteredFops.add(fop);
                continue block0;
            }
        }
        return filteredFops;
    }

    public static Collection<HotelProductFop> filterFopsByCurrency(Collection<HotelProductFop> fops, String currency) {
        return HotelProductHelper.filterFopsByCurrencies(fops, Collections.singleton(currency));
    }

    public static Collection<HotelProductFop> filterFopsByCurrencies(Collection<HotelProductFop> fops, Set<String> currencies) {
        if (currencies == null) {
            return HotelProductHelper.filterFopsByCurrencyCodes(fops, null);
        }
        HashSet<String> currencyCodes = new HashSet<String>(currencies);
        return HotelProductHelper.filterFopsByCurrencyCodes(fops, currencyCodes);
    }

    public static Collection<HotelProductFop> filterFopsByCurrencyCode(Collection<HotelProductFop> fops, String currencyCode) {
        return HotelProductHelper.filterFopsByCurrencyCodes(fops, Collections.singleton(currencyCode));
    }

    public static Collection<HotelProductFop> filterFopsByCurrencyCodes(Collection<HotelProductFop> fops, Set<String> currencyCodes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (currencyCodes == null) {
            return new ArrayList<HotelProductFop>(fops);
        }
        ArrayList<HotelProductFop> filteredFops = new ArrayList<HotelProductFop>();
        for (HotelProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getCurrency() == null || !currencyCodes.contains(fop.getAmount().getCurrency())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    public static FopType getFopType(HotelProductFop fop) {
        FopType fopType = null;
        if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            fopType = FopType.PRODUCT;
        } else {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (fopType == null && commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && GeneralProductHelper.serviceFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.SERVICE;
                }
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                fopType = FopType.PAYMENT;
                break;
            }
        }
        return fopType;
    }

    public static BigDecimal calculateTotalEquivalentFop(Collection<HotelProductFop> fops, String equivalentCurrencyCode, CurrencyRateType currencyRateType, Date date, EntityReference<Organization> supplier) {
        BigDecimal totalEquivalentFop = null;
        Collection<Money> totalFops = HotelProductHelper.calculateTotalFops(fops);
        for (Money money : totalFops) {
            BigDecimal amount = money.getValue();
            String currency = money.getCurrency();
            if (!TextUtil.isSame((String)currency, (String)equivalentCurrencyCode)) {
                CurrencyRate currencyRate = DictHelper.findCurrencyRate(currency, date, currencyRateType, null, supplier);
                if (currencyRate == null) continue;
                amount = amount.multiply(BigDecimal.valueOf(currencyRate.getRate()));
            }
            totalEquivalentFop = totalEquivalentFop != null ? totalEquivalentFop.add(amount) : amount;
        }
        return totalEquivalentFop;
    }

    public static Collection<Money> calculateTotalFops(Collection<HotelProductFop> fops) {
        HashMap<String, Money> totalFops = new HashMap<String, Money>();
        for (HotelProductFop fop : fops) {
            if (fop.getAmount() == null) continue;
            BigDecimal amount = fop.getAmount().getValue();
            String currency = fop.getAmount().getCurrency();
            if (amount == null || currency == null) continue;
            Money money = (Money)totalFops.get(currency);
            if (money == null) {
                money = new Money();
                totalFops.put(currency, money);
                money.setValue(amount);
                money.setCurrency(currency);
                continue;
            }
            money.setValue(money.getValue().add(amount));
        }
        return totalFops.values();
    }

    public static void updateFopsByDate(HotelProduct product, Date date) {
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(product)) {
            for (HotelProductFop fop : item.getFops()) {
                fop.setOperationDate(date);
            }
        }
    }

    public static void updateClientFop(HotelProduct product, Date operationDate, EntityReference<Person> agent) throws Exception {
        HotelProductContractRelationData clientContractRelation = HotelProductHelper.getClientContractRelation(product);
        if (clientContractRelation.getFops().isEmpty()) {
            for (HotelProductFop fop : HotelProductHelper.getVendorContractRelation(product).getFops()) {
                HotelProductFop copyFop = (HotelProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                clientContractRelation.getFops().add(copyFop);
            }
        }
        for (HotelProductFop fop : clientContractRelation.getFops()) {
            if ((operationDate != null || agent != null) && fop.getAgent() != null && fop.getOperationDate() != null) continue;
            fop.setAgent(agent);
            fop.setOperationDate(operationDate);
        }
    }

    public static GeneralProductFop toGeneralProductFop(HotelProductFop fop) {
        GeneralProductFop generalProductFop = new GeneralProductFop();
        generalProductFop.setUid(fop.getUid());
        generalProductFop.setType(fop.getType());
        generalProductFop.setCard(fop.getCard());
        generalProductFop.setPassengerStatus(fop.getPassengerStatus());
        generalProductFop.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        generalProductFop.setEquivalentAmount(fop.getAmount() != null ? fop.getAmount().getValue() : null);
        generalProductFop.setOperationDate(fop.getOperationDate());
        generalProductFop.setAgent(fop.getAgent());
        generalProductFop.setRefused(fop.isRefused());
        generalProductFop.setPayer(fop.getPayer());
        generalProductFop.getCommissions().clear();
        for (GeneralProductCommission commission : fop.getCommissions()) {
            generalProductFop.getCommissions().add(GeneralProductHelper.toGeneralProductCommission(commission));
        }
        return generalProductFop;
    }

    public static List<GeneralProductFop> toGeneralProductFops(List<HotelProductFop> fops) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (HotelProductFop fop : fops) {
            result.add(HotelProductHelper.toGeneralProductFop(fop));
        }
        return result;
    }

    public static GeneralProductTax toGeneralProductTax(HotelProductTax tax) {
        GeneralProductTax generalProductTax = new GeneralProductTax();
        generalProductTax.setUid(tax.getUid());
        generalProductTax.setCode(tax.getCode());
        generalProductTax.setAmount(tax.getAmount());
        generalProductTax.setEquivalentAmount(tax.getEquivalentAmount());
        return generalProductTax;
    }

    public static void updateTax(List<HotelProductTax> taxes, GeneralProductTax generalProductTax) {
        HotelProductTax tax = BookingHelper.findEntityByUid(taxes, generalProductTax.getUid());
        if (tax == null) {
            tax = new HotelProductTax();
            taxes.add(tax);
        }
        tax.setUid(generalProductTax.getUid());
        tax.setCode(generalProductTax.getCode());
        tax.setAmount(generalProductTax.getAmount());
        tax.setEquivalentAmount(generalProductTax.getEquivalentAmount());
    }

    public static TransportationType getTransportationType(HotelProduct product) {
        DictionaryReference hotelCountry;
        DictionaryReference location = product.getHotelLocation();
        String locationCode = location == null ? null : location.getCode();
        Country country = DictHelper.findCountry(locationCode);
        if (country == null && (hotelCountry = product.getHotelCountry()) != null) {
            country = (Country)DictionaryCache.get().resolveReference(hotelCountry);
        }
        if (country == null) {
            return null;
        }
        return country.isDomestic() ? TransportationType.DOMESTIC : TransportationType.INTERNATIONAL;
    }

    @Deprecated
    public static Date getFirstCheckinDate(HotelProduct prod) {
        Date result = null;
        for (Room room : prod.getRooms()) {
            result = MiscUtil.minimum((Date[])new Date[]{result, room.getCheckInDate()});
        }
        return result;
    }

    public static Date getLastCheckoutDate(HotelProduct prod) {
        Date result = null;
        for (Room room : prod.getRooms()) {
            result = MiscUtil.maximum((Date[])new Date[]{result, room.getCheckOutDate()});
        }
        return result;
    }

    public static SalesChain getSalesChain(HotelProduct product) {
        SalesChain salesChain = (SalesChain)product.getValue("salesChain");
        if (salesChain != null && salesChain.getDescription() != null) {
            return salesChain;
        }
        salesChain = new SalesChain();
        product.setValue("salesChain", (Object)salesChain);
        EntityReference<Organization> supplier = GeneralProductHelper.getOrganization((BaseProduct)product, "supplier");
        EntityReference<Organization> agency = GeneralProductHelper.getOrganization((BaseProduct)product, "agency");
        EntityReference<Organization> subagency = GeneralProductHelper.getOrganization((BaseProduct)product, "subagency");
        boolean ownSales = subagency == null || subagency.equals(agency);
        salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(ownSales ? PredefinedSalesChainType.OWN : PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.SUPPLIER, supplier));
        contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.AGENCY, agency));
        if (!ownSales) {
            contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.SUBAGENCY, subagency));
        }
        salesChain.getContractors().clear();
        salesChain.getContractors().addAll(contractors);
        return salesChain;
    }

    public static List<HotelProductContractRelationData> getContractRelations(HotelProduct prod) {
        List originalRelations = (List)prod.getValue("contractRelations");
        SalesChain salesChain = HotelProductHelper.getSalesChain(prod);
        ArrayList<HotelProductContractRelationData> subresult = new ArrayList<HotelProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        EntityContainer ctr = EntityStorage.get().resolve(salesChain.getDescription());
        List contractRelations = ctr != null ? ((SalesChainDescription)ctr.getEntity()).getContractRelations() : Collections.emptyList();
        for (EntityReference item : contractRelations) {
            HotelProductContractRelationData relation = HotelProductHelper.findContractRelation((List<HotelProductContractRelationData>)originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new HotelProductContractRelationData();
            relation.setDescription(item);
            HotelProductHelper.updateRelationFromOldFields(prod, relation);
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
            GeneralProductHelper.getCommissionsFromOldSourceByReflection((BaseProduct)prod).clear();
            HotelProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
            HotelProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
            HotelProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        }
        return originalRelations;
    }

    private static void updateRelationFromOldFields(HotelProduct prod, HotelProductContractRelationData relation) {
        relation.getCommissions().clear();
        relation.getFops().clear();
        switch (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription())) {
            case VENDOR: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, ContractType.VENDOR));
                relation.getFops().addAll(HotelProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR));
                break;
            }
            case SUBAGENCY: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, ContractType.SUBAGENCY));
                relation.getFops().addAll(HotelProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY));
                break;
            }
            case CLIENT: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, ContractType.CLIENT));
                relation.getFops().addAll(HotelProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT));
            }
        }
    }

    public static List<HotelProductFop> getFopsFromOldSource(HotelProduct prod, ContractType contractType) {
        String propertyName = null;
        switch (contractType) {
            case VENDOR: {
                propertyName = "vendorFops";
                break;
            }
            case SUBAGENCY: {
                propertyName = "subagentFops";
                break;
            }
            case CLIENT: {
                propertyName = "clientFops";
            }
        }
        return (List)prod.getValue(propertyName);
    }

    public static HotelProductContractRelationData findContractRelation(List<HotelProductContractRelationData> relations, EntityReference<ContractRelationDescription> descr) {
        for (HotelProductContractRelationData relation : relations) {
            if (!descr.equals((Object)relation.getDescription())) continue;
            return relation;
        }
        return null;
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(HotelProduct product, ContractType contractType) {
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(product)) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static HotelProductContractRelationData getContractRelation(HotelProduct prod, ContractType type) {
        HotelProductContractRelationData result;
        switch (type) {
            case CLIENT: {
                result = HotelProductHelper.getClientContractRelation(prod);
                break;
            }
            case SUBAGENCY: {
                result = HotelProductHelper.getSubagentContractRelation(prod, false);
                break;
            }
            case VENDOR: {
                result = HotelProductHelper.getVendorContractRelation(prod);
                break;
            }
            default: {
                throw new RuntimeException("unsupported contract type: " + type.name());
            }
        }
        return result;
    }

    public static HotelProductContractRelationData getVendorContractRelation(HotelProduct prod) {
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.VENDOR) continue;
            return relation;
        }
        if (Environment.isTest()) {
            return null;
        }
        throw new IllegalStateException("vendor contract relation is absent in product");
    }

    public static List<HotelProductFop> getVendorFops(HotelProduct prod) {
        return HotelProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<HotelProductFop> getSubagentFops(HotelProduct prod, boolean autoUpdateSalesChain) {
        HotelProductContractRelationData relation = HotelProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static HotelProductContractRelationData getClientContractRelation(HotelProduct prod) {
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.CLIENT) continue;
            return relation;
        }
        throw new IllegalStateException("client contract relation is absent in product");
    }

    public static ContractCustomerInfo getContractCustomerInfo(HotelProduct product) {
        HotelProductContractRelationData clientContractRelationData = HotelProductHelper.getClientContractRelation(product);
        NestedEntityReference contract = clientContractRelationData.getGeneralData().getContract();
        EntityContainer ctr = EntityStorage.get().resolve((EntityReference)contract);
        if (ctr == null) {
            return null;
        }
        return (ContractCustomerInfo)CollectionUtil.find((Iterable)((Contract)ctr.getEntity()).getCustomers(), (String)contract.getNestedEntityUid());
    }

    public static List<HotelProductFop> getClientFops(HotelProduct prod) {
        return HotelProductHelper.getClientContractRelation(prod).getFops();
    }

    public static HotelProductContractRelationData getSubagentContractRelation(HotelProduct prod, boolean autoUpdateSalesChain) {
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        SalesChain salesChain = HotelProductHelper.getSalesChain(prod);
        if (GeneralProductHelper.isOwnPredefinedSalesChainType(((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor(salesChain, PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(prod)) {
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static EntityReference<Organization> getSupplier(HotelProduct prod) {
        return GeneralProductHelper.getContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(HotelProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(HotelProduct prod) {
        return GeneralProductHelper.getContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(HotelProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(HotelProduct prod) {
        return GeneralProductHelper.getContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(HotelProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(HotelProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static void clearCommissions(HotelProduct prod) {
        GeneralProductHelper.getCommissionsFromOldSourceByReflection((BaseProduct)prod).clear();
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(prod)) {
            item.getCommissions().clear();
        }
    }

    public static void clearFops(HotelProduct prod) {
        HotelProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
        HotelProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
        HotelProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(prod)) {
            item.getFops().clear();
        }
    }

    private static HotelProductContractRelationData findContractRelation(List<HotelProductContractRelationData> relations, ContractType ct) {
        for (HotelProductContractRelationData relation : relations) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ct) continue;
            return relation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<HotelProductSettings> getSettings() throws Exception {
        EntityContainer<HotelProductSettings> result = EntityStorage.get().resolve(HOTEL_PRODUCT_SETTINGS_REF);
        if (result != null) {
            return result;
        }
        EntityReference<HotelProductSettings> entityReference = HOTEL_PRODUCT_SETTINGS_REF;
        synchronized (entityReference) {
            result = EntityStorage.get().resolve(HOTEL_PRODUCT_SETTINGS_REF);
            if (result != null) {
                return result;
            }
            result = HotelProductHelper.createSettingsWithoutSave();
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static EntityContainer<HotelProductSettings> createSettingsWithoutSave() {
        EntityContainer result = new EntityContainer(HotelProductSettings.class, HOTEL_PRODUCT_SETTINGS_REF.getUid());
        HotelProductSettings settings = (HotelProductSettings)result.getEntity();
        settings.setType(SystemSettingsType.OTHER);
        settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
        result.setCreatedBy("system");
        result.setModifiedBy("system");
        result.getVersionInfo().setVersionNotes("created automatically");
        return result;
    }

    public static EntityReference<Organization> getSupplierFor(HotelProvider provider, DictionaryReference<HotelSubProvider> subProvider) throws GetSupplierException {
        if (provider == null) {
            return null;
        }
        try {
            for (HotelProviderProfile pp : ((HotelProductSettings)HotelProductHelper.getSettings().getEntity()).getSuppliersMapping()) {
                if (pp.getProvider() != null && pp.getProvider() != provider || !Objects.equals(pp.getSubProvider(), subProvider)) continue;
                return pp.getProfile();
            }
            return null;
        }
        catch (Exception e) {
            throw new GetSupplierException(provider, e);
        }
    }

    public static EntityReference<Organization> getBlankOwnerFor(String blankOwnerCode, DictionaryReference<HotelSubProvider> subProvider) throws GetBlankOwnerException {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            return null;
        }
        try {
            for (HotelBlankOwnerProfile bop : ((HotelProductSettings)HotelProductHelper.getSettings().getEntity()).getBlankOwnersMapping()) {
                if (!TextUtil.isLike((String)blankOwnerCode, (String)bop.getCode(), (boolean)true, (boolean)true)) continue;
                return bop.getProfile();
            }
            return HotelProductHelper.getSupplierFor((HotelProvider)CollectionUtil.findEnumConstant(HotelProvider.class, (String)blankOwnerCode), subProvider);
        }
        catch (Exception e) {
            throw new GetBlankOwnerException(blankOwnerCode, e);
        }
    }

    public static String getBlankOwnerCode(EntityReference<Organization> blankOwnerRef) throws Exception {
        if (blankOwnerRef == null) {
            return null;
        }
        for (HotelBlankOwnerProfile bop : ((HotelProductSettings)HotelProductHelper.getSettings().getEntity()).getBlankOwnersMapping()) {
            if (!blankOwnerRef.equals((Object)bop.getProfile())) continue;
            return bop.getCode();
        }
        return ProfileHelper.findOrganizationCode(blankOwnerRef);
    }

    public static boolean isVendorCommissionProperties(EntityReference<? extends BaseCommissionProperties> props) {
        return MiscUtil.equals(props, VENDOR_COMMISSION_PROPERTIES_REF);
    }

    public static boolean isVendorFeeProperties(EntityReference<? extends BaseCommissionProperties> props) {
        return MiscUtil.equals(props, VENDOR_FEE_PROPERTIES_REF);
    }

    public static synchronized EntityContainer<CommissionProperties> getVendorCommissionProperties() {
        EntityContainer result = EntityStorage.get().resolve(VENDOR_COMMISSION_PROPERTIES_REF);
        if (result == null) {
            result = new EntityContainer(CommissionProperties.class, VENDOR_COMMISSION_PROPERTIES_REF.getUid());
            ((CommissionProperties)result.getEntity()).setDisplayName(VENDOR_COMMISSION_PROPERTIES_REF.getCaption());
            ((CommissionProperties)result.getEntity()).getProductTypes().add(ProductType.HOTEL_RESERVATION);
            ((CommissionProperties)result.getEntity()).setCategory((DictionaryReference)ProfileHelper.getSupplierCommissionCategory());
            ((CommissionProperties)result.getEntity()).setManuallyCalculated(true);
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static void removeVendorCommission(HotelProductContractRelationData vendorContractRelation) {
        vendorContractRelation.getCommissions().removeIf(gpc -> HotelProductHelper.isVendorCommissionProperties((EntityReference<? extends BaseCommissionProperties>)gpc.getCommissionProperties()));
    }

    public static GeneralProductCommission getVendorCommission(HotelProduct hp, ContractType ct) {
        HotelProductContractRelationData rel = HotelProductHelper.findContractRelation(HotelProductHelper.getContractRelations(hp), ct);
        if (rel != null) {
            for (GeneralProductCommission gpc : rel.getCommissions()) {
                if (!HotelProductHelper.isVendorCommissionProperties((EntityReference<? extends BaseCommissionProperties>)gpc.getCommissionProperties())) continue;
                return gpc;
            }
        }
        return null;
    }

    public static GeneralProductCommission getVendorFee(HotelProduct hp, ContractType ct) {
        HotelProductContractRelationData rel = HotelProductHelper.findContractRelation(HotelProductHelper.getContractRelations(hp), ct);
        if (rel != null) {
            for (GeneralProductCommission gpc : rel.getCommissions()) {
                if (!HotelProductHelper.isVendorFeeProperties((EntityReference<? extends BaseCommissionProperties>)gpc.getCommissionProperties())) continue;
                return gpc;
            }
        }
        return null;
    }

    public static synchronized EntityContainer<FeeProperties> getVendorFeeProperties() {
        EntityContainer result = EntityStorage.get().resolve(VENDOR_FEE_PROPERTIES_REF);
        if (result == null) {
            result = new EntityContainer(FeeProperties.class, VENDOR_FEE_PROPERTIES_REF.getUid());
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            FeeProperties feeProp = (FeeProperties)result.getEntity();
            feeProp.setDisplayName(VENDOR_FEE_PROPERTIES_REF.getCaption());
            feeProp.setRoundingMode(RoundingMode.NONE);
            feeProp.setRate(false);
            feeProp.setCalculationType(CalculationType.TICKET);
            feeProp.setOperation(Operation.SELL);
            feeProp.setType(FeeType.MANUALLY_CALCULATED);
            feeProp.getProductTypes().add(ProductType.HOTEL_RESERVATION);
            feeProp.getReturnCases().addAll(Arrays.asList(ReturnCase.REFUND, ReturnCase.FORCED_REFUND, ReturnCase.NO_PENALTIES_REFUND, ReturnCase.EXCHANGE, ReturnCase.FORCED_EXCHANGE));
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static void order(HotelProduct first, HotelProduct second) {
        first.setNextProduct(second);
        second.setPreviousProduct(first);
    }

    public static void setOnHold(HotelProduct hp, boolean newOnHold) {
        if (newOnHold) {
            hp.setUnholdDate(null);
        } else if (hp.getUnholdDate() == null) {
            hp.setUnholdDate(new Date());
        }
        hp.setOnHold(newOnHold);
    }

    @Deprecated
    public static boolean isOnHold(HotelProduct prod) {
        if (prod.getUnholdDate() != null) {
            return false;
        }
        return prod.isOnHold();
    }

    @Deprecated
    public static boolean isOnHoldLastSell(HotelProduct prod) {
        return prod.getStatus() == ProductStatus.SELL && prod.getNextProduct() == null && HotelProductHelper.isOnHold(prod);
    }

    public static boolean isOnHoldLastSell2(HotelProduct prod) {
        return prod.getStatus() == ProductStatus.SELL && prod.getNextProduct() == null && prod.getUnholdDate() == null;
    }

    public static boolean isServiceFop(HotelProductFop fop) {
        boolean hasNotHiddenFee = false;
        for (GeneralProductCommission comm : fop.getCommissions()) {
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
                hasNotHiddenFee = true;
                break;
            }
            FeeProperties feeProp = (FeeProperties)ctr.getEntity();
            if (feeProp.isHidden()) continue;
            hasNotHiddenFee = true;
        }
        return !hasNotHiddenFee;
    }

    public static boolean isHasVat(HotelProduct product) {
        Country country;
        if (product == null) {
            return false;
        }
        HotelProduct prod = product;
        if ((product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) && (prod = product.getPreviousProduct()) == null) {
            prod = product;
        }
        return (country = (Country)DictionaryCache.get().resolveReference(prod.getHotelCountry())) != null && country.isDomestic();
    }

    public static Collection<HotelProduct> freshestProducts(Collection<BaseProduct> products) {
        ArrayList<HotelProduct> result = new ArrayList<HotelProduct>();
        for (BaseProduct x : products) {
            HotelProduct hp;
            if (!(x instanceof HotelProduct) || (hp = (HotelProduct)x).getNextProduct() != null) continue;
            result.add(hp);
        }
        return result;
    }

    private static void clearCommissionsExceptManuallyCalculated(HotelProduct prod) {
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(prod)) {
            Iterator it = item.getCommissions().iterator();
            while (it.hasNext()) {
                GeneralProductCommission commission = (GeneralProductCommission)it.next();
                EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (ctr != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED || ctr != null && ctr.getEntity() instanceof CommissionProperties && ((CommissionProperties)ctr.getEntity()).isManuallyCalculated() || ctr != null && ctr.getEntity() instanceof DiscountProperties && ((DiscountProperties)ctr.getEntity()).getType() == DiscountType.MANUALLY_CALCULATED) continue;
                it.remove();
            }
        }
    }

    public static void copyManualCommissions(HotelProduct source, HotelProduct dest) {
        try {
            HotelProductHelper.clearCommissionsExceptManuallyCalculated(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations(source)) {
            HotelProductContractRelationData subagencyRelation;
            if (item == null) continue;
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) == ContractType.VENDOR) {
                HotelProductHelper.getVendorContractRelation(dest).getCommissions().addAll(item.getCommissions());
            }
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) == ContractType.SUBAGENCY && (subagencyRelation = HotelProductHelper.getSubagentContractRelation(dest, false)) != null) {
                subagencyRelation.getCommissions().addAll(item.getCommissions());
            }
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != ContractType.CLIENT) continue;
            HotelProductHelper.getClientContractRelation(dest).getCommissions().addAll(item.getCommissions());
        }
    }

    public static BigDecimal calculateFareRate(HotelProduct product) {
        BigDecimal result = BigDecimal.ZERO;
        Money baseFare = HotelProductHelper.calcBasePrice(product);
        BigDecimal equivalentFare = HotelProductHelper.getEquivalentFare(product);
        if (baseFare != null && equivalentFare != null && baseFare.getValue().compareTo(BigDecimal.ZERO) != 0) {
            result = equivalentFare.divide(baseFare.getValue(), 5, java.math.RoundingMode.HALF_UP);
            if (!baseFare.getCurrency().equals("USD") && !baseFare.getCurrency().equals("EUR")) {
                return result;
            }
        }
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            return result;
        }
        long round = Math.round(result.doubleValue());
        double delta = (double)round - result.doubleValue();
        if (Math.abs(delta) > (double)0.2f) {
            if (delta > 0.0) {
                return BigDecimal.valueOf((float)round - 0.5f);
            }
            if (delta < 0.0) {
                return BigDecimal.valueOf((float)round + 0.5f);
            }
        }
        return BigDecimal.valueOf(round);
    }

    public static boolean isFareFopsRelevant(HotelProduct product) {
        return GeneralProductHelper.getHandler(product).isFareFopsRelevant(product);
    }

    public static List<Traveller> travellers(Reservation reservation) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof HotelProduct)) continue;
            HotelProduct hp = (HotelProduct)bp;
            result.addAll(hp.getTravellers());
        }
        return result;
    }

    public static void setAdditionalServiceStatus(HotelProduct product, AdditionalServiceType type, AdditionalServiceStatus status) {
        for (AdditionalService x : product.getAdditionalServices()) {
            if (x.getType() != type) continue;
            x.setStatus(status);
            return;
        }
        throw new RuntimeException("there was no additional service of type " + type + " in hotel product");
    }

    public static boolean isAllowed(HotelProduct product, OfferOptionType optionType) {
        boolean result = false;
        block0: for (Room room : product.getRooms()) {
            for (AvailableOption option : room.getAvailableOptions()) {
                result = option.getOptionType() == optionType;
                if (!result) continue;
                break block0;
            }
        }
        return result;
    }

    public static Integer checkInTime(HotelProduct product) {
        Room room;
        Integer result = null;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && (result = (room = (Room)iterator.next()).getCheckInTime()) == null) {
        }
        return result;
    }

    public static Integer standardCheckInTime(HotelProduct product) {
        Room room;
        Integer result = null;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && (result = (room = (Room)iterator.next()).getStandardCheckInTime()) == null) {
        }
        return result;
    }

    public static Integer checkOutTime(HotelProduct product) {
        Room room;
        Integer result = null;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && (result = (room = (Room)iterator.next()).getCheckOutTime()) == null) {
        }
        return result;
    }

    public static Integer standardCheckOutTime(HotelProduct product) {
        Room room;
        Integer result = null;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && (result = (room = (Room)iterator.next()).getStandardCheckOutTime()) == null) {
        }
        return result;
    }

    public static Date checkOutDate(HotelProduct product) {
        Room room;
        Date result = null;
        Iterator iterator = product.getRooms().iterator();
        while (iterator.hasNext() && (result = (room = (Room)iterator.next()).getCheckOutDate()) == null) {
        }
        return result;
    }

    public static DictionaryReference<Country> getHotelCountry(HotelProduct product) {
        if (product.getHotelCountry() != null) {
            return product.getHotelCountry();
        }
        GeoLocation loc = HotelProductHelper.getGeoLocation(product);
        return loc == null ? null : loc.getCountry();
    }

    public static GeoLocation getGeoLocation(HotelProduct product) {
        return (GeoLocation)DictionaryCache.get().resolveReference(product.getHotelLocation());
    }

    public static Date getCheckInDate(HotelProduct product) {
        Room room = HotelProductHelper.room(product);
        return room != null ? room.getCheckInDate() : null;
    }

    public static Date getCheckOutDate(HotelProduct product) {
        Room room = HotelProductHelper.room(product);
        return room != null ? room.getCheckOutDate() : null;
    }

    public static Integer getCheckOutTime(HotelProduct product) {
        Room room = HotelProductHelper.room(product);
        return room != null ? room.getCheckOutTime() : null;
    }

    public static Money calculateRawPriceRatePerNight(Date checkInDate, Date checkOutDate, BigDecimal price, String currency) {
        int interval = HotelProductHelper.getDaysCountBetweenTwoDates(checkInDate, checkOutDate);
        return MoneyHelper.buildMoney(HotelProductHelper.calculateBigDecimalDividedByInteger(interval == 0 ? 1L : (long)interval, price), currency);
    }

    public static Money calculateRawPriceRatePerNight(Date checkInDate, Date checkOutDate, Money price) {
        int interval = HotelProductHelper.getDaysCountBetweenTwoDates(checkInDate, checkOutDate);
        return price != null ? MoneyHelper.buildMoney(HotelProductHelper.calculateBigDecimalDividedByInteger(interval == 0 ? 1L : (long)interval, price.getValue()), price.getCurrency()) : null;
    }

    public static Money calculateRawPriceRatePerNight(LocalDate checkInDate, LocalDate checkOutDate, Money price) {
        long interval = HotelProductHelper.getDaysCountBetweenTwoDates(checkInDate, checkOutDate);
        return price != null ? MoneyHelper.buildMoney(HotelProductHelper.calculateBigDecimalDividedByInteger(interval == 0L ? 1L : interval, price.getValue()), price.getCurrency()) : null;
    }

    public static Money calculateRawPriceRatePerNight(org.joda.time.LocalDate checkInDate, org.joda.time.LocalDate checkOutDate, Money price) {
        int interval = Days.daysBetween((ReadablePartial)checkInDate, (ReadablePartial)checkOutDate).getDays();
        return price != null ? MoneyHelper.buildMoney(HotelProductHelper.calculateBigDecimalDividedByInteger(interval == 0 ? 1L : (long)interval, price.getValue()), price.getCurrency()) : null;
    }

    public static int getDaysCountBetweenTwoDates(Date checkInDate, Date checkOutDate) {
        return checkInDate != null && checkOutDate != null ? Days.daysBetween((ReadablePartial)new org.joda.time.LocalDate(checkInDate.getTime()), (ReadablePartial)new org.joda.time.LocalDate(checkOutDate.getTime())).getDays() : 0;
    }

    private static long getDaysCountBetweenTwoDates(LocalDate checkInDate, LocalDate checkOutDate) {
        return checkInDate != null && checkOutDate != null ? ChronoUnit.DAYS.between(checkInDate, checkOutDate) : 0L;
    }

    private static BigDecimal calculateBigDecimalDividedByInteger(long intervalInDays, BigDecimal price) {
        return price != null && intervalInDays != 0L ? price.divide(new BigDecimal(intervalInDays), java.math.RoundingMode.HALF_UP) : null;
    }

    private static Room room(HotelProduct product) {
        List rooms = product.getRooms();
        return rooms.isEmpty() ? null : (Room)rooms.get(rooms.size() - 1);
    }

    public static String getBaseCurrency(HotelProduct product) {
        if (HotelProductHelper.isFareFopsRelevant(product)) {
            return (String)MiscUtil.guarded((Object)product.getGdsCurrency(), (Object)DictHelper.getLocalCurrency());
        }
        return product.getRooms().stream().filter(r -> r.getBasePrice() != null).map(r -> r.getBasePrice().getCurrency()).findFirst().orElse(null);
    }

    public static ContractsVatInfo getContractsVatInfo(HotelProduct product, ContractType contractType) {
        ContractsVatInfo result = new ContractsVatInfo();
        result.setContractType(contractType);
        HotelProductContractRelationData relation = HotelProductHelper.getContractRelationData(product, contractType);
        ContractRelationServiceData serviceData = relation.getServiceData();
        ContractRelationServiceDataDetalization detalization = serviceData.getDetalization();
        ContractRelationVatDetalization vatDetalization = detalization.getVat();
        result.setIncluded(vatDetalization != null && !vatDetalization.getComponents().isEmpty());
        return result;
    }

    public static Money calculatePrice(HotelProduct product, Money amount, ContractType contractType) {
        String baseCurrency = HotelProductHelper.getBaseCurrency(product);
        if (amount == null || amount.getValue() == null || !Objects.equals(amount.getCurrency(), baseCurrency)) {
            return null;
        }
        if (HotelProductHelper.isFareFopsRelevant(product)) {
            BigDecimal value = amount.getValue();
            for (HotelProductContractRelationData contractRelation : HotelProductHelper.getContractRelations(product)) {
                value = MulticurrencyHelper.convert(value, contractRelation.getGeneralData().getRate());
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelation.getDescription()) != contractType) continue;
                DictionaryReference currencyInfo = contractRelation.getGeneralData().getCurrency();
                String currency = currencyInfo != null ? currencyInfo.getCode() : DictHelper.getLocalCurrency();
                return SystemHelper.getMoney(value, currency);
            }
            return null;
        }
        HotelProductContractRelationData relation = null;
        HotelProductContractRelationData prevRelation = null;
        for (HotelProductContractRelationData contractRelation : HotelProductHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelation.getDescription()) == contractType) {
                relation = contractRelation;
                break;
            }
            prevRelation = contractRelation;
        }
        if (relation != null) {
            Money fare = HotelProductHelper.calcBasePrice(product);
            String prevRelationCurrency = prevRelation != null && prevRelation.getGeneralData().getCurrency() != null ? prevRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractRelationGeneralData generalData = relation.getGeneralData();
            ExchangeRateData rateData = generalData.getRate();
            if (!fare.getCurrency().equals(prevRelationCurrency)) {
                rateData = MulticurrencyHelper.buildExchangeRateData(fare.getCurrency(), generalData.getCurrency() != null ? generalData.getCurrency().getCode() : DictHelper.getLocalCurrency(), MulticurrencyHelper.buildExchangeRateCondition(rateData), GeneralProductHelper.getOperationDate(product), GeneralProductHelper.getSupplier((BaseProduct)product), false);
            }
            BigDecimal value = MulticurrencyHelper.convert(amount.getValue(), rateData);
            return SystemHelper.getMoney(value, relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency());
        }
        return null;
    }

    public static HotelProductContractRelationData getContractRelationData(HotelProduct product, ContractType contractType) {
        HotelProductContractRelationData result = null;
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != contractType) continue;
            result = relation;
            break;
        }
        return result;
    }

    public static void updateProductEquivalentFare(HotelProduct product, ExchangeRateData rateData) {
        if (rateData == null) {
            return;
        }
        String currency = rateData.getCurrency().getCode();
        product.setGdsCurrency(currency);
        for (Room room : product.getRooms()) {
            Money basePrice = room.getBasePrice();
            room.setEquivalentPrice(MulticurrencyHelper.convert(basePrice.getValue(), rateData));
            Money baseRate = room.getBaseRate();
            room.setEquivalentRate(baseRate != null ? MulticurrencyHelper.convert(baseRate.getValue(), rateData) : null);
            room.setEquivalentVatPrice(MulticurrencyHelper.convert(room.getVatAmount(), rateData));
        }
        product.setVendorCurrencyRate(Double.valueOf(rateData.getRateWithCoefficient()));
        for (CancellationCharge charge : product.getCancellationCharges()) {
            CancellationChargeHelper.removeVat(charge);
            RateMoney rateMoney = charge.getPenalty();
            Money money = rateMoney != null ? rateMoney.getMoney() : null;
            if (money == null) continue;
            charge.setPenaltyEquivalentAmount(MulticurrencyHelper.convert(money.getValue(), rateData));
        }
        for (Penalty penalty : product.getPenalties()) {
            Money baseAmount = penalty.getBaseAmount();
            if (penalty.getEquivalentAmount() == null || baseAmount == null) continue;
            penalty.setEquivalentAmount(MulticurrencyHelper.convert(baseAmount.getValue(), rateData));
            if (penalty.getEquivalentVatAmount() == null) continue;
            Money baseVatAmount = penalty.getBaseVatAmount();
            if (baseVatAmount != null) {
                penalty.setEquivalentVatAmount(MulticurrencyHelper.convert(baseVatAmount.getValue(), rateData));
                continue;
            }
            throw new RuntimeException(String.format("baseVatAmount is required in penalty of the hotel product %s in the order %s", product.getSystemNumber(), HotelProductHelper.getBookingFileNumber(product)));
        }
    }

    public static boolean includeVat(HotelProduct product) {
        boolean result = false;
        for (Room room : product.getRooms()) {
            result |= HotelProductHelper.includeVat(room);
        }
        return result;
    }

    public static boolean includeVat(Room room) {
        return BooleanUtils.isTrue((Boolean)room.getVat());
    }

    public static BigDecimal getEquivalentAmount(HotelProduct product, Money fare, String equivalentCurrency, Date date) {
        ExchangeRateCondition vendorRate = HotelProductHelper.getVendorRate(HotelProductHelper.getVendorContractRelation(product), equivalentCurrency);
        ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(fare.getCurrency(), equivalentCurrency, vendorRate, date, GeneralProductHelper.getSupplier((BaseProduct)product), false);
        return MulticurrencyHelper.convert(fare.getValue(), rateData);
    }

    private static ExchangeRateCondition getVendorRate(HotelProductContractRelationData vendorContractRelation, String currency) {
        ExchangeRateData rateData = vendorContractRelation.getGeneralData().getRate();
        if (null == rateData) {
            return null;
        }
        if (!Objects.equals(rateData.getCurrency() != null ? rateData.getCurrency().getCode() : null, currency)) {
            return null;
        }
        return MulticurrencyHelper.buildExchangeRateCondition(rateData);
    }

    public static void setDefaultVat(Room room, Date issueDate) {
        if (room.getEquivalentPrice() != null) {
            double defaultVat = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(issueDate)).doubleValue();
            VatAmount va = new VatAmount();
            va.setTotalVat(room.getEquivalentPrice(), defaultVat);
            room.setEquivalentVatPrice(va.getVatAmount());
            room.setEquivVatRate(Double.valueOf(defaultVat));
        }
    }

    public static void updateByDepositCard(HotelProduct product) {
        HotelDepositCard depositCard = product.getDepositCard();
        if (depositCard != null) {
            HotelProductHelper.getContractRelations(product).stream().flatMap(relation -> relation.getFops().stream()).forEach(fop -> {
                fop.setType(PaymentType.CREDIT_CARD);
                fop.setCard(HotelProductHelper.fromHotelDepositCard(depositCard));
            });
        }
    }

    public static Card fromHotelDepositCard(HotelDepositCard hotelDepositCard) {
        Card card = new Card();
        card.setVendor(hotelDepositCard.getCardVendor());
        card.setNumber(hotelDepositCard.getCardNumber());
        card.setExpiration(hotelDepositCard.getExpDate());
        return card;
    }

    public static int calculateNights(Date datetime1, Date datetime2) {
        Date date2;
        if (datetime1 == null || datetime2 == null) {
            return 0;
        }
        Date date1 = MiscUtil.clearTime((Date)datetime1);
        if (date1.before(date2 = MiscUtil.clearTime((Date)datetime2))) {
            return (int)((date2.getTime() - date1.getTime()) / 1000L / 24L / 60L / 60L);
        }
        if (MiscUtil.equals((Object)date1, (Object)date2)) {
            return 1;
        }
        return 0;
    }

    public static boolean isHotelProduct(BaseProduct product) {
        return product instanceof HotelProduct;
    }

    public static String getBookingFileNumber(HotelProduct product) {
        Reservation r = product != null ? product.getReservation() : null;
        BookingFile bf = r != null ? r.getBookingFile() : null;
        return bf != null ? bf.getNumber() : null;
    }

    public static String getGdsCurrency(Reservation reservation) {
        String result = null;
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof HotelProduct)) continue;
            HotelProduct hp = (HotelProduct)bp;
            if (result == null) {
                result = hp.getGdsCurrency();
                continue;
            }
            if (result.equals(hp.getGdsCurrency())) continue;
            throw new RuntimeException(String.format("different reservation system currencies (%s, %s) in the order %s", result, hp.getGdsCurrency(), HotelProductHelper.getBookingFileNumber(hp)));
        }
        return result;
    }

    public static void changeFopsPaymentTypes(List<HotelProductFop> fops, PaymentType newPaymentType, boolean updateOnlyFeeFops) {
        if (updateOnlyFeeFops) {
            fops.stream().filter(fop -> !HotelProductHelper.isServiceFop(fop)).forEach(fop -> fop.setType(newPaymentType));
        } else {
            fops.stream().filter(HotelProductHelper::isServiceFop).forEach(fop -> fop.setType(newPaymentType));
        }
    }

    public static Money penalty(GeneralProductContractRelationData contractRelationData, CancellationCharge charge) {
        try {
            Money result = null;
            ContractRelationPenaltiesDetalization detalization = contractRelationData.getServiceData().getDetalization().getPenalties();
            if (detalization != null) {
                List penalties = detalization.getCancellationPenalties();
                com.gridnine.xtrip.common.model.booking.Penalty penalty = null;
                for (com.gridnine.xtrip.common.model.booking.Penalty x : penalties) {
                    if (!x.getSource().equals(charge.getUid())) continue;
                    penalty = x;
                    break;
                }
                if (penalty != null) {
                    BigDecimal amount = penalty.getAmount();
                    ContractRelationGeneralData generalData = contractRelationData.getGeneralData();
                    String currency = ContractRelationHelper.currencyCode(generalData);
                    result = MoneyHelper.buildMoney(amount, currency);
                }
            }
            return result;
        }
        catch (Throwable t) {
            IncidentsLog.reportException((String)"failed to get penalty value", (Throwable)t);
            DumpUtil.dumpInvalidData("penalty", contractRelationData, charge);
            throw new RuntimeException(t);
        }
    }

    public static boolean removeProduct(HotelProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(HotelProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getCities(HotelProduct product, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)product.getHotelLocation()))).map(item -> item.toString(locale)).orElse("?");
    }

    public static String getCountries(HotelProduct product, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(product.getHotelCountry())).map(item -> item.toString(locale)).orElse("?");
    }

    public static String getAddresses(HotelProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        String country = Optional.ofNullable(DictionaryCache.get().resolveReference(product.getHotelCountry())).map(item -> item.toString(locale)).orElse(null);
        String city = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)product.getHotelLocation()))).map(item -> item.toString(locale)).orElse(null);
        String street = product.getHotelAddress();
        if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null))) {
            street = TranslitUtil.cyr2lat((String)street, (TranslitUtil.TranslitRules)translitRules);
        }
        RouteHelper.AddressData addressData = RouteHelper.AddressDataBuilder.get().country(country).city(city).street(street).build();
        return RouteHelper.getRoute(Collections.singletonList(addressData));
    }

    public static boolean isMealIncludedInTariff(HotelProduct product) {
        return product.getRooms().stream().anyMatch(room -> room.getMeal() != null && !WITHOUT_MEAL_BASE_CAPTION.equals(room.getMeal().getBaseCaption()));
    }

    public static ServiceLocationType getServiceLocationType(HotelProduct prod) {
        TransportationType transportationType = HotelProductHelper.getTransportationType(prod);
        if (transportationType == TransportationType.DOMESTIC) {
            return ServiceLocationType.DOMESTIC;
        }
        if (transportationType == TransportationType.INTERNATIONAL) {
            return ServiceLocationType.INTERNATIONAL;
        }
        return null;
    }

    public static boolean hasSameSystemNumbers(HotelProduct product) {
        ProductHandler<HotelProduct> handler = ProductHandler.of(product);
        List<String> systemNumbers = handler.getProductNumbers(product);
        if (CollectionUtil.isEmpty(systemNumbers)) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)MainHotelProductIndex.Property.productUid.name(), (Object)product.getUid()));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)MainHotelProductIndex.Property.systemNumber.name(), systemNumbers));
        ProductStatus status = handler.getStatus(product);
        if (status == ProductStatus.SELL || status == ProductStatus.VOID) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)MainHotelProductIndex.Property.status.name(), EnumSet.of(ProductStatus.SELL, ProductStatus.VOID)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MainHotelProductIndex.Property.status.name(), (Object)status));
        }
        TicketType ticketType = handler.getTicketType(product);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)MainHotelProductIndex.Property.ticketType.name(), Arrays.asList(ticketType, null)));
        Date issueDate = handler.findIssueDate(product);
        if (issueDate != null) {
            Date issueDateStart = MiscUtil.addYearsToDate((Date)issueDate, (int)-1);
            Date issueDateEnd = MiscUtil.addYearsToDate((Date)issueDate, (int)1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)MainHotelProductIndex.Property.issueDate.name(), (Object)issueDateStart));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)MainHotelProductIndex.Property.issueDate.name(), (Object)issueDateEnd));
        }
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)MainHotelProductIndex.Property.provider.name(), Arrays.asList(product.getProvider(), null)));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(MainHotelProductIndex.class, query).getTotalCount() > 0;
    }

    public static Double getHotelVatRate(HotelProduct product) {
        return product.getRooms().stream().map(Room::getEquivVatRate).filter(Objects::nonNull).findFirst().orElse(-1.0);
    }

    public static List<String> getEssentialInfoValues(HotelProduct product) {
        return product.getEssentialInfoData().stream().flatMap(data -> data.getInfoValue().stream()).filter(TextUtil::nonBlank).collect(Collectors.toList());
    }

    public static String getEssentialInfoString(HotelProduct product) {
        StringBuilder result = new StringBuilder();
        result.append(product.getEssentialInfoData().stream().filter(data -> data.getType() != EssentialInfoDataType.ROOM_AMENITIES).flatMap(data -> data.getInfoValue().stream()).collect(Collectors.joining("\n")));
        if (result.length() != 0) {
            result.append("\n");
        }
        result.append(product.getEssentialInfoData().stream().filter(data -> data.getType() == EssentialInfoDataType.ROOM_AMENITIES).flatMap(data -> data.getInfoValue().stream()).collect(Collectors.joining(", ")));
        if (result.length() != 0) {
            return result.toString();
        }
        return null;
    }

    public static EssentialInfoData getDefaultEssentialInfoData(List<String> values) {
        EssentialInfoData data = new EssentialInfoData();
        data.setType(EssentialInfoDataType.UNDEFINED);
        data.getInfoValue().addAll(values);
        return data;
    }

    public static String getSubProviderRecordLocator(Reservation reservation) {
        HotelProduct firstProduct = HotelProductHelper.findHotelProduct(reservation);
        return HotelProductHelper.getSubProviderRecordLocator(firstProduct);
    }

    public static String getSubProviderRecordLocator(HotelProduct hotelProduct) {
        if (hotelProduct == null) {
            return null;
        }
        HotelSubProvider subProvider = (HotelSubProvider)DictionaryCache.get().resolveReference(hotelProduct.getSubProvider());
        if (subProvider == null || subProvider.getGds() == null) {
            return null;
        }
        if (subProvider.getGds() == GdsName.HOTELSTAR) {
            return CommonReservationGdsNameInfoHelper.getRecordLocator(hotelProduct.getReservation(), subProvider.getGds(), RecordLocatorType.HOTELSTAR_PROVIDER_ORDER_ID);
        }
        return CommonReservationGdsNameInfoHelper.getRecordLocator(hotelProduct.getReservation(), subProvider.getGds(), RecordLocatorType.DEFAULT);
    }

    private static HotelProduct findHotelProduct(Reservation reservation) {
        HotelProduct result = null;
        for (BaseProduct product : reservation.getProducts()) {
            if (!(product instanceof HotelProduct)) continue;
            result = (HotelProduct)product;
            break;
        }
        return result;
    }

    public static final class GetBlankOwnerException
    extends RuntimeException {
        public final String blankOwnerCode;

        public GetBlankOwnerException(String blankOwnerCode, Exception e) {
            super("Error getting blank owner for code " + blankOwnerCode, e);
            this.blankOwnerCode = blankOwnerCode;
        }
    }

    public static final class GetSupplierException
    extends RuntimeException {
        public final HotelProvider provider;

        public GetSupplierException(HotelProvider provider, Exception e) {
            super("Error getting supplier for provider " + provider, e);
            this.provider = provider;
        }
    }

    private static class PriceWithVat {
        private final BigDecimal price;
        private final BigDecimal vat;
        private Money basePrice;

        PriceWithVat(BigDecimal p, BigDecimal v) {
            this.price = p;
            this.vat = v;
        }

        PriceWithVat(BigDecimal p, BigDecimal v, Money bp) {
            this(p, v);
            this.basePrice = bp;
        }

        public BigDecimal getPrice() {
            return this.price == null ? BigDecimal.ZERO : this.price;
        }

        public BigDecimal getVat() {
            return this.vat;
        }

        public Money getBasePrice() {
            return this.basePrice;
        }
    }
}

