/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class MessageBuilder {
    private final String key;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final MessageType type;
    private String details = null;
    private Locale locale = null;

    protected MessageBuilder(MessageType type, String key) {
        this.type = Objects.requireNonNull(type, "type");
        this.key = Objects.requireNonNull(key, "key");
    }

    public Message build() {
        Message result = new Message();
        HashMap replaceParameters = new HashMap();
        this.parameters.forEach((key, value) -> replaceParameters.put(key, String.valueOf(value)));
        result.setDetails(this.details);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)TextUtil.formatNamed((String)L10nResourcesManager.getStr((String)this.key, (Object[])new Object[0]), replaceParameters), (Object[])new Object[0]));
        result.setType(this.type);
        return result;
    }

    public MessageBuilder locale(Locale locale) {
        this.locale = locale;
        return null;
    }

    public MessageBuilder details(String details) {
        this.details = details;
        return this;
    }

    public MessageBuilder parameter(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    public static MessageBuilder error(String key) {
        return new MessageBuilder(MessageType.ERROR, key);
    }

    public static MessageBuilder info(String key) {
        return new MessageBuilder(MessageType.MESSAGE, key);
    }

    public static MessageBuilder warning(String key) {
        return new MessageBuilder(MessageType.WARNING, key);
    }
}

