/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.ObjectUtils;

public class MoneyHelper {
    public static final String RUB = "RUB";

    public static boolean lessThan(Money m1, Money m2) {
        boolean result = false;
        if (m1 != null && m2 != null) {
            BigDecimal v2;
            BigDecimal v1 = m1.getValue();
            BigDecimal bigDecimal = v2 = ObjectUtils.equals((Object)m1.getCurrency(), (Object)m2.getCurrency()) ? m2.getValue() : MoneyHelper.exchange(m2, m1.getCurrency());
            if (v1.scale() != v2.scale()) {
                if (v1.scale() < v2.scale()) {
                    v2 = v2.setScale(v1.scale(), RoundingMode.HALF_DOWN);
                } else {
                    v1 = v1.setScale(v2.scale(), RoundingMode.HALF_DOWN);
                }
            }
            result = v1.compareTo(v2) < 0;
        }
        return result;
    }

    public static int compare(Money m1, Money m2) {
        int result;
        if (m1 != null && m2 != null) {
            BigDecimal v2;
            BigDecimal v1 = m1.getValue();
            BigDecimal bigDecimal = v2 = ObjectUtils.equals((Object)m1.getCurrency(), (Object)m2.getCurrency()) ? m2.getValue() : MoneyHelper.exchange(m2, m1.getCurrency());
            if (v1.scale() != v2.scale()) {
                if (v1.scale() < v2.scale()) {
                    v2 = v2.setScale(v1.scale(), RoundingMode.HALF_DOWN);
                } else {
                    v1 = v1.setScale(v2.scale(), RoundingMode.HALF_DOWN);
                }
            }
            result = v1.compareTo(v2);
        } else if (m1 == null && m2 == null) {
            result = 0;
        } else {
            throw new IllegalArgumentException(m1 == null ? "first argument was null, but second wasn't" : "second argument was null, but first wasn't");
        }
        return result;
    }

    public static BigDecimal getEquivalentAmount(Money money) {
        if (money == null || money.getCurrency() == null) {
            return null;
        }
        String equivCurrCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
        if (equivCurrCode == null) {
            return null;
        }
        String currCode = money.getCurrency();
        if (equivCurrCode.equalsIgnoreCase(currCode)) {
            return money.getValue();
        }
        return MoneyHelper.exchange(money, equivCurrCode);
    }

    public static BigDecimal exchange(Money money, String targetCurrencyCode) {
        return MoneyHelper.exchange(money, targetCurrencyCode, null);
    }

    public static BigDecimal exchange(Money money, String targetCurrencyCode, Date date) {
        BigDecimal result = FinanceHelper.exchange(money.getValue(), money.getCurrency(), targetCurrencyCode, CurrencyRateType.CBR, null, date, null, true);
        result = result == null ? null : result.setScale(2, RoundingMode.HALF_UP);
        return result;
    }

    public static Money sum(Money ... summands) {
        return MoneyHelper.sum(Arrays.asList(summands));
    }

    public static Money sum(Collection<Money> summands) {
        BigDecimal value = null;
        String currency = null;
        for (Money summand : summands) {
            if (value == null) {
                value = summand.getValue();
                currency = summand.getCurrency();
                continue;
            }
            if (!currency.equals(summand.getCurrency())) {
                throw new RuntimeException(String.format("unexpected currency: %s instead of %s", summand.getCurrency(), currency));
            }
            value = value.add(summand.getValue());
        }
        return MoneyHelper.buildMoney(value, currency);
    }

    public static Money buildMoney(BigDecimal value, String currency) {
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(value);
        return result;
    }

    public static Money buildMoney(Double value, String currency) {
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(BigDecimal.valueOf(value));
        return result;
    }

    public static Money buildMoney(double value, String currencyCode) {
        return MoneyHelper.buildMoney(BigDecimal.valueOf(value), currencyCode);
    }

    public static Money buildMoney(String value, String currencyCode) {
        return MoneyHelper.buildMoney(new BigDecimal(value), currencyCode);
    }

    public static Money cloneMoney(Money money) {
        if (money == null) {
            return null;
        }
        Money newMoney = new Money();
        newMoney.setValue(money.getValue());
        newMoney.setCurrency(money.getCurrency());
        return newMoney;
    }

    public static Money moneyOrNull(BigDecimal value, String cur) {
        if (value == null || cur == null) {
            return null;
        }
        return MoneyHelper.buildMoney(value, cur);
    }

    public static boolean isSame(Money money1, Money money2) {
        if (money1 == null && money2 == null) {
            return true;
        }
        if (money1 == null || money2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)money1.getCurrency(), (Object)money2.getCurrency()) && MiscUtil.equals((Object)money1.getValue(), (Object)money2.getValue());
    }

    public static boolean isSame(RateMoney rm1, RateMoney rm2) {
        if (rm1 == null && rm2 == null) {
            return true;
        }
        if (rm1 == null || rm2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)rm1.getRate(), (Object)rm2.getRate()) && MoneyHelper.isSame(rm1.getMoney(), rm2.getMoney());
    }

    public static boolean isZero(Money money) {
        BigDecimal v;
        BigDecimal bigDecimal = v = money != null ? money.getValue() : null;
        if (money != null && money.getValue() != null) {
            BigDecimal zero = BigDecimal.ZERO;
            zero = zero.setScale(money.getValue().scale());
            return zero.equals(v);
        }
        return true;
    }

    public static boolean currencyMatches(String currency, Money money) {
        return currency == null || money == null || money.getCurrency() != null && Objects.equals(currency, money.getCurrency());
    }

    public static boolean sameCurrency(Money money1, Money money2) {
        String currency1 = money1 != null ? money1.getCurrency() : null;
        String currency2 = money2 != null ? money2.getCurrency() : null;
        return Objects.equals(currency1, currency2);
    }

    public static boolean isNullMoney(Money money) {
        return money == null || money.getValue() == null || money.getCurrency() == null;
    }

    public static Money negate(Money money) {
        if (money == null) {
            return null;
        }
        return MoneyHelper.buildMoney(MiscUtil.negate((BigDecimal)money.getValue()), money.getCurrency());
    }

    private MoneyHelper() {
    }
}

