/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.CurrencyRateData;
import com.gridnine.xtrip.common.model.profile.ExchangeIndirectRateRoundingType;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

public final class MulticurrencyHelper {
    private static ExchangeRateData getDefaultExchangeRateData(String currency, String paymentCurrency) {
        ExchangeRateData result = new ExchangeRateData();
        result.setRoundingMode(RoundingMode.MATH);
        if (Objects.equals(currency, paymentCurrency)) {
            result.setRoundingValue(RoundingValue.V_0_0_1);
        } else {
            result.setRoundingValue(RoundingValue.V_1);
        }
        result.setCoefficient(1.0);
        result.setRateType(null);
        result.setRateWithCoefficient(1.0);
        result.setRateRoundingMode(null);
        result.setRateRoundingValue(null);
        result.setIndirectRateFirst(false);
        result.setIndirectRateRoundingType(null);
        return result;
    }

    public static CurrencyRateType getCurrencyRateType(String currencyCode, boolean air) {
        if (TextUtil.isSame((String)"RUB", (String)currencyCode)) {
            return air ? CurrencyRateType.IATA : CurrencyRateType.CBR;
        }
        if (TextUtil.isSame((String)"UAH", (String)currencyCode)) {
            return CurrencyRateType.NBU;
        }
        return air ? CurrencyRateType.IATA : CurrencyRateType.CBR;
    }

    public static ExchangeRateData buildExchangeRateData(String currency, String paymentCurrency, ExchangeRateCondition exRateCondition, Date operationDate, EntityReference<Organization> supplier, boolean air) {
        ExchangeRateData result;
        EntityReference<Organization> requiredSupplier = null;
        if (exRateCondition != null) {
            result = new ExchangeRateData();
            result.setRoundingMode(exRateCondition.getRoundingMode());
            result.setRoundingValue(exRateCondition.getRoundingValue());
            result.setCoefficient(exRateCondition.getCoefficient());
            result.setRateType(exRateCondition.getRateType());
            result.setRateWithCoefficient(1.0);
            result.setRateRoundingMode(exRateCondition.getRateRoundingMode());
            result.setRateRoundingValue(exRateCondition.getRateRoundingValue());
            result.setIndirectRateFirst(exRateCondition.isIndirectRateFirst());
            result.setIndirectRateRoundingType(exRateCondition.getIndirectRateRoundingType());
        } else {
            result = MulticurrencyHelper.getDefaultExchangeRateData(currency, paymentCurrency);
        }
        result.setCurrency((DictionaryReference)new CurrencyInfoReference(paymentCurrency));
        if (MiscUtil.equals((Object)currency, (Object)paymentCurrency)) {
            result.setRoundingMode(RoundingMode.NONE);
            result.setRoundingValue(null);
        } else {
            CurrencyRateType rateType;
            result.setRateWithCoefficient(0.0);
            Date date = operationDate != null ? operationDate : new Date();
            CurrencyRateType currencyRateType = rateType = result.getRateType() != null ? result.getRateType() : MulticurrencyHelper.getCurrencyRateType(paymentCurrency, air);
            if (CurrencyRateType.VENDOR == result.getRateType()) {
                requiredSupplier = supplier;
            }
            while (!(result.isIndirectRateFirst() ? MulticurrencyHelper.findIndirectRate(currency, paymentCurrency, date, rateType, requiredSupplier, result) || MulticurrencyHelper.findDirectRate(currency, paymentCurrency, date, rateType, requiredSupplier, result) : MulticurrencyHelper.findDirectRate(currency, paymentCurrency, date, rateType, requiredSupplier, result) || MulticurrencyHelper.findIndirectRate(currency, paymentCurrency, date, rateType, requiredSupplier, result))) {
                if (result.getRateType() != null || rateType == CurrencyRateType.IATA) break;
                rateType = CurrencyRateType.IATA;
            }
        }
        return result;
    }

    public static void modifyExchangeRateData(ExchangeRateData rateData, double rate) {
        BigDecimal rateValue = BigDecimal.valueOf(rate);
        rateValue = MulticurrencyHelper.roundDouble(rateValue, rateData.getRateRoundingMode(), rateData.getRateRoundingValue());
        rateData.setRateWithCoefficient(BigDecimal.valueOf(rateData.getCoefficient()).multiply(rateValue).doubleValue());
        rateData.setIndirectRate(null);
        rateData.setCurrencyRateData(null);
    }

    private static boolean findDirectRate(String currency, String paymentCurrency, Date date, CurrencyRateType rateType, EntityReference<Organization> supplier, ExchangeRateData result) {
        CurrencyRate rate = DictHelper.findExactCurrencyRate(currency, paymentCurrency, date, rateType, null, supplier);
        if (null == rate) {
            return false;
        }
        BigDecimal rateValue = BigDecimal.valueOf(rate.getRate());
        rateValue = MulticurrencyHelper.roundDouble(rateValue, result.getRateRoundingMode(), result.getRateRoundingValue());
        result.setRateWithCoefficient(BigDecimal.valueOf(result.getCoefficient()).multiply(rateValue).doubleValue());
        result.setIndirectRate(Boolean.valueOf(false));
        MulticurrencyHelper.setRate(rate, result);
        return true;
    }

    private static boolean findIndirectRate(String currency, String paymentCurrency, Date date, CurrencyRateType rateType, EntityReference<Organization> supplier, ExchangeRateData result) {
        CurrencyRate rate = DictHelper.findExactCurrencyRate(paymentCurrency, currency, date, rateType, null, supplier);
        if (null == rate) {
            return false;
        }
        ExchangeIndirectRateRoundingType irrt = (ExchangeIndirectRateRoundingType)MiscUtil.guarded((Object)result.getIndirectRateRoundingType(), (Object)ExchangeIndirectRateRoundingType.CONVERTED_RATE);
        BigDecimal rateValue = BigDecimal.valueOf(rate.getRate());
        if (ExchangeIndirectRateRoundingType.INDIRECT_RATE == irrt || ExchangeIndirectRateRoundingType.INDIRECT_AND_CONVERTED_RATE == irrt) {
            rateValue = MulticurrencyHelper.roundDouble(rateValue, result.getRateRoundingMode(), result.getRateRoundingValue());
        }
        if (BigDecimal.ZERO.compareTo(rateValue) == 0) {
            return false;
        }
        rateValue = BigDecimal.ONE.divide(rateValue, 25, java.math.RoundingMode.HALF_UP);
        if (ExchangeIndirectRateRoundingType.CONVERTED_RATE == irrt || ExchangeIndirectRateRoundingType.INDIRECT_AND_CONVERTED_RATE == irrt) {
            rateValue = MulticurrencyHelper.roundDouble(rateValue, result.getRateRoundingMode(), result.getRateRoundingValue());
        }
        result.setRateWithCoefficient(BigDecimal.valueOf(result.getCoefficient()).multiply(rateValue).doubleValue());
        result.setIndirectRate(Boolean.valueOf(true));
        MulticurrencyHelper.setRate(rate, result);
        return true;
    }

    private static void setRate(CurrencyRate rate, ExchangeRateData result) {
        CurrencyRateData currencyRateData = new CurrencyRateData();
        currencyRateData.setCurrencyRate((DictionaryReference)rate.toReference());
        currencyRateData.setBaseCurrency(rate.getBaseCurrency());
        currencyRateData.setCurrency(rate.getCurrency());
        currencyRateData.setDate(rate.getDate());
        currencyRateData.setRate(rate.getRate());
        currencyRateData.setType(rate.getType());
        result.setCurrencyRateData(currencyRateData);
    }

    public static ExchangeRateCondition buildExchangeRateCondition(ExchangeRateData exchangeRateData) {
        if (null == exchangeRateData) {
            return null;
        }
        ExchangeRateCondition result = new ExchangeRateCondition();
        result.setRoundingMode(exchangeRateData.getRoundingMode());
        result.setRoundingValue(exchangeRateData.getRoundingValue());
        result.setCoefficient(exchangeRateData.getCoefficient());
        result.setRateType(exchangeRateData.getRateType());
        result.setRateRoundingMode(exchangeRateData.getRateRoundingMode());
        result.setRateRoundingValue(exchangeRateData.getRateRoundingValue());
        result.setIndirectRateFirst(exchangeRateData.isIndirectRateFirst());
        result.setIndirectRateRoundingType(exchangeRateData.getIndirectRateRoundingType());
        return result;
    }

    public static BigDecimal convert(BigDecimal equivalentAmount, ExchangeRateData data) {
        if (equivalentAmount == null || data == null) {
            return equivalentAmount;
        }
        double coeff = data.getRateWithCoefficient();
        return MulticurrencyHelper.roundDouble(coeff != 1.0 && coeff != 0.0 ? equivalentAmount.multiply(BigDecimal.valueOf(coeff)) : equivalentAmount, data.getRoundingMode(), data.getRoundingValue());
    }

    public static BigDecimal roundDouble(BigDecimal val, RoundingMode roundingMode, RoundingValue roundingValue) {
        double roundMax;
        double roundMin;
        if (roundingMode == null || roundingValue == null || roundingMode == RoundingMode.NONE) {
            return val;
        }
        double value = val.doubleValue();
        if (RoundingValue.V_50 == roundingValue) {
            roundMin = Math.floor(value / 50.0) * 50.0;
            roundMax = Math.ceil(value / 50.0) * 50.0;
        } else if (RoundingValue.V_10 == roundingValue) {
            roundMin = Math.floor(value / 10.0) * 10.0;
            roundMax = Math.ceil(value / 10.0) * 10.0;
        } else if (RoundingValue.V_5 == roundingValue) {
            roundMin = Math.floor(value / 10.0) * 10.0;
            if (value - roundMin > 5.0) {
                roundMin += 5.0;
            }
            roundMax = Math.abs(roundMin - value) > 0.001 ? roundMin + 5.0 : roundMin;
        } else if (RoundingValue.V_1 == roundingValue) {
            roundMin = Math.floor(value);
            roundMax = Math.ceil(value);
        } else if (RoundingValue.V_0_5 == roundingValue) {
            roundMin = Math.floor(value);
            if (value - roundMin > 0.5) {
                roundMin += 0.5;
            }
            roundMax = Math.abs(roundMin - value) > 0.001 ? roundMin + 0.5 : roundMin;
        } else if (RoundingValue.V_0_1 == roundingValue) {
            roundMin = Math.floor(value * 10.0) / 10.0;
            roundMax = Math.ceil(value * 10.0) / 10.0;
        } else if (RoundingValue.V_0_0_0_1 == roundingValue) {
            roundMin = Math.floor(value * 1000.0) / 1000.0;
            roundMax = Math.ceil(value * 1000.0) / 1000.0;
        } else if (RoundingValue.V_0_0_0_0_1 == roundingValue) {
            roundMin = Math.floor(value * 10000.0) / 10000.0;
            roundMax = Math.ceil(value * 10000.0) / 10000.0;
        } else {
            roundMin = Math.floor(value * 100.0) / 100.0;
            roundMax = Math.ceil(value * 100.0) / 100.0;
        }
        if (RoundingMode.DOWN == roundingMode) {
            return BigDecimal.valueOf(roundMin);
        }
        if (RoundingMode.UP == roundingMode) {
            return BigDecimal.valueOf(roundMax);
        }
        if (RoundingMode.MATH == roundingMode) {
            return BigDecimal.valueOf(roundMax + roundMin - 2.0 * value > 1.0E-5 ? roundMin : roundMax);
        }
        return val;
    }
}

