/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OrganizationLogotypeHelper {
    private static final String KEY_LOGOTYPE_PHONES = "LOGOTYPE_PHONES";
    private static final String KEY_LOGOTYPE_EMAILS = "LOGOTYPE_EMAILS";

    public static BinaryData getLogotype(BaseProduct product, Map<String, Object> parameters) {
        BinaryData logo = OrganizationLogotypeHelper.getClientLogotype(product, parameters);
        if (logo != null) {
            return logo;
        }
        logo = OrganizationLogotypeHelper.getSubagencyLogotype(product, parameters);
        if (logo != null) {
            return logo;
        }
        logo = OrganizationLogotypeHelper.getAgencyLogotype(product, parameters);
        return logo;
    }

    public static byte[] getLogoData(Organization organization) {
        if (organization.getLogo() == null || organization.getLogo().getData() == null || organization.getLogo().getData().length == 0) {
            return null;
        }
        return organization.getLogo().getData();
    }

    private static BinaryData getClientLogotype(BaseProduct product, Map<String, Object> parameters) {
        Reservation reservation = product.getReservation();
        if (reservation != null) {
            BinaryData logo;
            EntityReference customerRef = Optional.ofNullable(reservation.getBookingFile()).map(BookingFile::getCustomerProfile).orElse(null);
            EntityContainer customerCtr = EntityStorage.get().resolve(customerRef);
            if (customerCtr != null && (logo = ((Organization)customerCtr.getEntity()).getLogo()) != null) {
                parameters.put(KEY_LOGOTYPE_PHONES, OrganizationLogotypeHelper.getPhones(((Organization)customerCtr.getEntity()).getCommunications(), Collections.singletonList(CommunicationType.WORK_PHONE)));
                parameters.put(KEY_LOGOTYPE_EMAILS, OrganizationLogotypeHelper.getEmails(((Organization)customerCtr.getEntity()).getCommunications()));
                return logo;
            }
        }
        return null;
    }

    private static BinaryData getSubagencyLogotype(BaseProduct product, Map<String, Object> parameters) {
        BinaryData logo;
        EntityContainer subagencyCtr = EntityStorage.get().resolve(GeneralProductHelper.getSubagency(product));
        if (subagencyCtr != null && (logo = ((Organization)subagencyCtr.getEntity()).getLogo()) != null) {
            parameters.put(KEY_LOGOTYPE_PHONES, OrganizationLogotypeHelper.getPhones(((Organization)subagencyCtr.getEntity()).getCommunications(), Collections.singletonList(CommunicationType.WORK_PHONE)));
            parameters.put(KEY_LOGOTYPE_EMAILS, OrganizationLogotypeHelper.getEmails(((Organization)subagencyCtr.getEntity()).getCommunications()));
            return logo;
        }
        return null;
    }

    private static BinaryData getAgencyLogotype(BaseProduct product, Map<String, Object> parameters) {
        BinaryData logo;
        EntityContainer agencyCtr = EntityStorage.get().resolve(GeneralProductHelper.getAgency(product));
        if (agencyCtr != null && (logo = ((Organization)agencyCtr.getEntity()).getLogo()) != null) {
            parameters.put(KEY_LOGOTYPE_PHONES, OrganizationLogotypeHelper.getPhones(((Organization)agencyCtr.getEntity()).getCommunications(), Collections.singletonList(CommunicationType.WORK_PHONE)));
            parameters.put(KEY_LOGOTYPE_EMAILS, OrganizationLogotypeHelper.getEmails(((Organization)agencyCtr.getEntity()).getCommunications()));
            return logo;
        }
        return null;
    }

    private static List<String> getPhones(List<Communication> communications, List<CommunicationType> communicationTypes) {
        ArrayList<String> result = new ArrayList<String>();
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber(communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                result.add(phoneString.trim());
            }
        }
        return result;
    }

    private static List<String> getEmails(List<Communication> communications) {
        return communications.stream().filter(c -> c.getType() == CommunicationType.EMAIL).map(Communication::getSense).collect(Collectors.toList());
    }
}

